#!/bin/sh

#echo "######m mdev.sh Interface:$INTERFACE MDEV:$MDEV Action:$ACTION ################" >/dev/console

#INTERFACE="255/255/255" MDEV="1-1:1.0" ACTION="add" ./mdev.sh
#$DEVPATH $ACTION > /tmp/mdevsh.log

case $MDEV in
sda1)
	case $ACTION in
	remove)
		umount -f /mnt/usb
		;;
	add)
		mount /dev/sda1 /mnt/usb
		;;
	esac
	;;
mmcblk0p1)
	case $ACTION in
	remove)
		umount -f /mnt/sd
		;;
	add)
		mount -t vfat /dev/$MDEV /mnt/sd
		;;
	esac 
	;;
net:eth0)
	case $ACTION in
	remove)
	
		#echo "mdev.sh $INTERFACE remove"
		#Test dhcpc running
		if test -e "/var/run/udhcpc.$INTERFACE.pid"; then	
			echo "Downing /var/run/udhcpc.$INTERFACE.pid"
			#echo "Downing /var/service/dhcp_$1"			
			kill $(cat /var/run/udhcpc.eth0.pid)
#			killall udhcpc
			sleep 5
		fi
		ifconfig  eth0 0.0.0.0
		
		;;
	add)
		#echo "mdev.sh $INTERFACE add"
		#Test Hotplug
		if grep -q "^allow-hotplug[[:space:]]*$INTERFACE" /etc/network/interfaces; then			
			ifdown eth0
			sleep 3			
			ifup eth0	
		fi
		;;
	esac
	;;


#USB device
1-1:1.0)
	case $ACTION in
	remove)
		echo "mdev.sh vor lsmod $MDEV remove" >/dev/console
		case `cat /var/run/usb | grep -o "148f:[0-9][0-9][0-9][0-9]"` in
		148f:2070|148f:2770|148f:2870|148f:3070|148f:3071|148f:3072|148f:3370|148f:3572|148f:5370)
#		148f:.*)
			echo "mdev.sh $MDEV remove rt2800usb" >/dev/console
			modprobe -r rt2800usb
			echo "" >/var/run/usb
			;;
#		RTL8188EU
		esac
		
		#8188eu Realtek chipsets
		case `cat /var/run/usb | grep -o "0bda:[0-9][0-9][0-9][0-9]"` in
		0bda:8179)
#		0bda:8179 RTL8188EU
			echo "mdev.sh $MDEV remove 8188eu" >/dev/console
			modprobe -r 8188eu
			echo "" >/var/run/usb
			;;
		esac
		;;			
		
	add)
		echo "USB device $MDEV $INTERFACE" >/dev/console
		#rt2800usb Ralink chipsets (RT2070, RT2770, RT2870, RT3070, RT3071, RT3072, RT3370, RT3572, RT5370) 
		case `lsusb | grep -o "148f:[0-9][0-9][0-9][0-9]"` in
		148f:2070|148f:2770|148f:2870|148f:3070|148f:3071|148f:3072|148f:3370|148f:3572|148f:5370)
#		148f:.*)
			if [ "$INTERFACE" = "255/255/255" ]; then
#			if [ -z "$interface"]; then
				echo "mdev.sh $MDEV add rt2800usb" >/dev/console
				modprobe rt2800usb
				echo `lsusb | grep -o "148f:[0-9][0-9][0-9][0-9]"` >/var/run/usb
			fi
			;;
		esac
		
		case `lsusb | grep -o "0bda:[0-9][0-9][0-9][0-9]"` in
		0bda:8179)
#		0bda:8179 RTL8188EU
			if [ "$INTERFACE" = "255/255/255" ]; then
#			if [ -z "$interface"]; then
				echo "mdev.sh $MDEV add 8188eu" >/dev/console
				modprobe 8188eu
				echo `lsusb | grep -o "0bda:[0-9][0-9][0-9][0-9]"` >/var/run/usb
			fi
			;;
		esac
		;;		
	esac
	;;


#WLAN device
wlan0)

	case $ACTION in
	remove)
		#Test Hotplug
		if grep -q "^allow-hotplug[[:space:]]*$MDEV" /etc/network/interfaces; then		
			echo "mdev.sh $MDEV remove" >/dev/console
			kill $(cat /var/run/udhcpc.wlan0.pid)
			echo "mdev.sh $MDEV remove nach kill" >/dev/console
			ifdown wlan0
		fi
		;;
	add)
		#Test Hotplug
		if grep -q "^allow-hotplug[[:space:]]*$MDEV" /etc/network/interfaces; then
			echo "mdev.sh $MDEV add" >/dev/console

			killall wpa_supplicant
			/sbin/ifup wlan0 
		fi 	        	
		;;
	esac
	;;
esac


#echo "######m ENDE mdev.sh Interface:$INTERFACE MDEV:$MDEV Action:$ACTION ################" >/dev/console

exit 0
