/**********************************************************************************************

	AJAX functions

	Copyright (c) 2008 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.2	05/2009

***********************************************************************************************/



function Ajax() {
  //Eigenschaften deklarieren und initialisieren
  this.url="";
  this.params="";
  this.method="GET";
  this.onSuccess=null;
  this.onError=function (msg) {
    alert(msg)
  }
}
  

Ajax.prototype.doRequest=function() {
  // Ueberpruefen der Angaben
  if (!this.url) {
    this.onError("No URL was declared. The Request is broken off.");
    return false;
  }

  if (!this.method) {
    this.method="GET";
  } else {
    this.method=this.method.toUpperCase();
  }

  // Zugriff auf Klasse fr readyStateHandler ermoeglichen  
  var _this = this;
  
  // XMLHttpRequest-Objekt erstellen
  var xmlHttpRequest=getXMLHttpRequest();
  if (!xmlHttpRequest) {
    this.onError("No XMLHttpRequest-Objekt could be created.");
    return false;
  }
   
   
  // Fallunterscheidung nach Uebertragungsmethode
  switch (this.method) {
    case "GET": xmlHttpRequest.open(this.method, this.url+"?"+this.params, true);
                xmlHttpRequest.onreadystatechange = readyStateHandler;
                xmlHttpRequest.send(null);
                break;
    case "POST": xmlHttpRequest.open(this.method, this.url, true);
                 xmlHttpRequest.onreadystatechange = readyStateHandler;
                 xmlHttpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                 xmlHttpRequest.send(this.params);
                 break;
  }  

  // Private Methode zur Verarbeitung der erhaltenen Daten
  function readyStateHandler() 
  {
	// alert ("readyState:  "+xmlHttpRequest.readyState);
	if (xmlHttpRequest.readyState < 4) 
	{
      return false;
    }
	
	// alert ("status:  "+xmlHttpRequest.status);
    if (xmlHttpRequest.status == 200 || xmlHttpRequest.status==304) 
	{
  	  if (_this.onSuccess) 
	  {
		// alert ("response text:  "+xmlHttpRequest.responseText+"\nresponse xml:  "+xmlHttpRequest.responseXML);	
        _this.onSuccess(xmlHttpRequest.responseText, xmlHttpRequest.responseXML);
	  }
    } 
	else 
	{
      if (_this.onError) 
	  {
		_this.onError("["+xmlHttpRequest.status+" "+xmlHttpRequest.statusText+"] A mistake appeared with the data transmission.");
      }
    }
  }
}


//Gibt browserunabhaengig ein XMLHttpRequest-Objekt zurueck
function getXMLHttpRequest() 
{
	// Define a list of Microsoft XML HTTP ProgIDs.
	var XMLHTTPREQUEST_MS_PROGIDS = new Array
	(
	"Msxml2.XMLHTTP.7.0",
	"Msxml2.XMLHTTP.6.0",
	"Msxml2.XMLHTTP.5.0",
	"Msxml2.XMLHTTP.4.0",
	"MSXML2.XMLHTTP.3.0",
	"MSXML2.XMLHTTP",
	"Microsoft.XMLHTTP"
	);


  if (window.XMLHttpRequest) 
  {
    // XMLHttpRequest fr Firefox, Opera, Safari, ...
    return new XMLHttpRequest();
  } 
  else if (window.ActiveXObject) 
  {
	var httpRequest = null;

	// Must be IE, find the right ActiveXObject.
	var success = false;
	for (var i = 0;
		i < XMLHTTPREQUEST_MS_PROGIDS.length && !success;
		i++)
	{
		try
		{
			httpRequest = new ActiveXObject(XMLHTTPREQUEST_MS_PROGIDS[i]);
			// alert ("httpRequest mit "+XMLHTTPREQUEST_MS_PROGIDS[i]+"  i = "+i);
			success = true;
		}
		catch(e)
		{}
	}
	return httpRequest;
  }
  return false;
}








 
  

