/**********************************************************************************************
	JS functions for devicebase.htm

	Copyright (c) MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		08.2010

***********************************************************************************************/


// ********************************************************************************************

var DEBUG_DEVICE = 0;			// Ausgaben
var dev_localObject;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Namen der Page ermitteln
	document.getElementById("headLine").innerHTML = 
		top.getFilenameFromPath (top.frame_content.location.href);
		
	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Mehrsprachige Strings ersetzen
	initStrings ();

	// Steuerung Upload
	if (top.g_upload != "")
	{
		// wenn g_upload eine Kennung enthaelt, dann Installationsteil aufrufen
		updateInstall (top.g_upload);
		top.g_upload == "";
	}
}

// ********************************************************************************************

// Mehrsprachige Strings ersetzen
function initStrings ()
{
	document.f_devicename.devicename_1.value = ins("dev_devicename");
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO -> Browser)
function setObjectProperties (actObject)
{
	// Werte setzen	
	setData (actObject);
	
	// Objekt global speichern fuer getObjectProperties()
	dev_localObject = actObject;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// Werte ermitteln	
	if (typeof(dev_localObject) != "object")
		dev_localObject = new Object();
		
	// Bei aktiviertem reboot countdown anzeigen
	if (document.f_firmware.reboot.checked == true)
		reboot_setCountdown();

	// Timer beenden, falls er laeuft	
	clearInterval(int_id);

	// In Installationsphase Fortschritt abfragen
	if (top.g_upload != "")
	{
		// Timer starten
		// Aufruf einer Wartezeit zu Beginn der Installation, nachfolgend Aufruf der Statusabfrage
		int_id = setInterval ('waitOnStart()', 5000);

		// Ausgabe starten
		var str = "== Installation started ==\n";
		document.form_install.output.value = str;
	}

	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		var changedObject = getData(dev_localObject);	
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen (EWIO -> Browser)
function setData (jObject)
{
	// Einstellungen enstsprechend JSON- Objekt setzen
	document.f_devicename.devicename.value = jObject.devicename;
	document.f_hwbase.serialnumber.value = jObject.serialnumber;
	document.f_hwbase.macaddress.value = jObject.mac_address;
	document.f_firmware.version.value = jObject.package_version;
	document.f_firmware.kernel.value = jObject.v_kernel;
	document.f_firmware.rootfs.value = jObject.v_rootfs;
	document.f_firmware.userspace.value = jObject.v_userspace;
	document.f_firmware.reboot.checked = false;

}

// ********************************************************************************************
// Werte lesen (Browser -> EWIO)
function getData (jObject)	
{
	// Objekt-Elemente zuweisen
	// Einstellungen fuer update-Komponente wird im entsprechenden Popup-Dialog gelesen

	if (checkDevivcename() != 0)									// Plausibilitaets-Check
		return;	
	jObject.devicename = document.f_devicename.devicename.value;	// muss im tree gesetzt werden

	jObject.serialnumber = "";
	jObject.mac_address = "";
	jObject.v_kernel = "";
	jObject.v_rootfs = "";
	jObject.v_userspace = "";

	if (document.f_firmware.reboot.checked)		jObject.reboot = "true";
	else										jObject.reboot = "false";
	
	return (jObject);
}

// ********************************************************************************************

// Geraetenamen wurde geaendert
function changeDevicename()
{
	// Text anhaengen: reboot erforderlich
	document.f_devicename.devicename_1.style.display = "block";
}

// ********************************************************************************************

// Geraetenamen Input-Check
function checkDevivcename()
{
	// Regeln fuer Geraetenamen:
	// zulaessige Zeichen "A-Z a-z 0-9 _-"
	// Laenge 1 bis 255 Zeichen

	var muster = /^[A-Za-z0-9_-]{1,255}$/;
	var result = muster.test(document.f_devicename.devicename.value); 
	// alert (document.f_devicename.devicename.value+"   "+result);

	if (result == false)
	{
		top.messageBox (ins("dev_msg_head"), ins("dev_msg_nameErr"));		
		return (-1);
	}
	return (0);
}




// ********************************************************************************************
// UPDATE / File laden
// ********************************************************************************************

function fUpdate(type)
{

	if (top.g_username != "Administrator")
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;
	}

	var versionIs = dev_localObject.package_version.substring(5);		// M, MM, MB

	var file = " file";
	if (type == "kernel")		file = " uImage...";
	if (type == "rootfs")		file = " initrd.u-boot";
	if (type == "userspace")	file = " usrimage...";
	if (type == "package")		file = " package_ewiom_v-.--"+versionIs+".tar.bz2";

	var headline =  '<B>Firmware Update</B>';
	content =		 		
					'<form name="form_update" method="post" action="cgi-bin/setUpdateFileToServer.cgi" enctype="multipart/form-data" onsubmit="return startSending()">'+
					'<div class="pos x0301"> <input type="submit" class="textfield"> </div>'+
					'<div class="pos x0101 textfield">'+
						'<input type="text" name="username" class="hidden">'+		
						'<input type="text" name="password" class="hidden">'+
						'<input type="text" name="max_file_size" class="hidden">'+
						'<input type="text" name="text" class="hidden">'+ins("dev_file")+'<b>'+file+'</b>'+' ('+type+'):<br>'+	
						'<input type="file" name='+type+' accept="text/*" class="textfield" size="40"><br><br>'+
					'</div>'+
					'<div id="single_button_position">'+
						'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="cancelUpdate()">'+
					'</div>'+
					'</form>';


	guiPopup.Show ("message", headline, content, 'Tools', 450, 180, "window");

	// Nach dem Laden muss Installationsfenster aufgerufen werden
	top.g_upload = type;
}


// Timer- Variablen
var int_id = 0;


// Senden starten
function startSending()
{

	// Check Eingabe
	if (document.form_update.kernel !== undefined)
	{	
		if (document.form_update.kernel.value.indexOf("uImage") === -1)
		{		
			top.messageBox (ins("dev_msg_head"), ins("dev_msg_error"));
			return false;
		}	
	}
	if (document.form_update.rootfs !== undefined)
	{	
		if (document.form_update.rootfs.value.indexOf("initrd.u-boot") === -1)
		{		
			top.messageBox (ins("dev_msg_head"), ins("dev_msg_error"));
			return false;
		}	
	}
	if (document.form_update.userspace !== undefined)
	{	
		if (document.form_update.userspace.value.indexOf("usrimage") === -1)
		{		
			top.messageBox (ins("dev_msg_head"), ins("dev_msg_error"));
			return false;
		}	
	}
	if (document.form_update.package !== undefined)
	{	
		if (document.form_update.package.value.indexOf("package") === -1)
		{		
			top.messageBox (ins("dev_msg_head"), ins("dev_msg_error"));
			return false;
		}	
		
		// Aenderung 18.05.2017:
		// "package" wurde bereits abgeprueft, 
		// der vordere Teil war frueher nur "package", mit aktuellen Browsern "C:\fakepath\package"
		var error = 0;														// C:\fakepath\package_ewiom_v1.24M.tar.bz2
		var filePart = document.form_update.package.value.slice(0,-8);		// C:\fakepath\package_ewiom_v1.24M
		var fileArr = filePart.split("_");									// C:\fakepath\package, ewiom, v1.24M

		if (fileArr[1] != "ewiom")
			error = 1;	
		var versionFile = fileArr[2].substring(5);							// M
		var versionIs = dev_localObject.package_version.substring(5);		// M
		// alert ("is="+versionIs + "   soll=" + versionFile);	
		if (versionFile != versionIs)
			error = 1;
		if (error)
		{
			top.messageBox (ins("dev_msg_head"), ins("dev_msg_error"));
			return false;
		}
	}

	// username, password
	document.form_update.username.value = top.g_username;
	var pw = top.calculatePassword ();
	document.form_update.password.value = pw;

	// FileSize
	document.form_update.max_file_size.value = dev_localObject.flash_free;
	
	// text
	document.form_update.text.value = ins("dev_text");

	// Hinweis einfuegen
	addHTMLElement (document.form_update, "waitString", "pos x0401 textfield", ins("dev_waitsend")); 

	document.form_update.cancel.disabled = true;

	var blinkTimer = 'messageBlink("waitString")';
	int_id = setInterval (blinkTimer, 1000);

	// Senden starten ...
	// alert ("start sending ... ");

	return true;
}

// ********************************************************************************************

// Senden abbrechen
function cancelUpdate ()
{
	// Timer beenden	
	clearInterval(int_id);

	// pad schliessen
	guiPopup.CloseMe("message");
}

// ********************************************************************************************

// Dyn. Erzeugen eines HTML-Elements
function addHTMLElement (parent, id_value, class_value, content) 
{
	
	var newdiv = document.createElement("div");

	newdiv.setAttribute('id', id_value);			// id=
	newdiv.setAttribute('class', class_value);		// class=

	newdiv.innerHTML = content;	
	parent.appendChild (newdiv);

}

// ********************************************************************************************

// Dyn. entfernen eines HTML-Elements
function removeHTMLElement (parent, id_value) 
{

	var node = document.getElementById(id_value);
	parent.removeChild(node);

}

// ********************************************************************************************

// Message blinken lassen
function messageBlink (msgId)
{
	if (document.getElementById(msgId).style.display == "block")
		document.getElementById(msgId).style.display = "none";
	else
		document.getElementById(msgId).style.display = "block";
}

// ********************************************************************************************







// ********************************************************************************************
// UPDATE / File installieren
// ********************************************************************************************


// Messagebox fuer die Installation des Updates sichtbar machen
function updateInstall (type)
{

	var headline =  '<B>Firmware Installation</B>';
	content =		 		
					'<form name="form_install">'+
					'<div class="pos x0101 textfield">'+ins("dev_component")+'</div>'+
					'<div class="pos x0103">'+ 
					'<input type="text" name="update_component" class="textfield" size="20" readonly="readonly" value='+type+'>'+		
					'</div>'+
					'<div class="pos x0301 textfield">'+
					'<textarea id="input" name="output" class="textfield" cols="40" rows="4">'+
					'</textarea>'+
					'</div>'+
					'<div class="pos x0601">'+ 
					'<input type="text" name="installed_1" class="textfield_input" size="50" readonly="readonly" value='+ins("dev_install_1")+'>'+		
					'<input type="text" name="installed_2" class="textfield_input" size="50" readonly="readonly" value='+ins("dev_install_2")+'>'+		
					'</div>'+
					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="Install" onClick="installBox_OK()">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="installBox_Cancel()">'+
					'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'Tools', 420, 240, "window");

}

// ********************************************************************************************

// Installation starten / beenden
function installBox_OK()
{

	if (top.g_upload != "")
	{

		dev_localObject.install_component = document.form_install.update_component.value;
		top.setData();			// Installation starten
		
		// Button disabeln		
		document.form_install.ok.disabled = true;
		document.form_install.cancel.disabled = true;
	}
	else
		endProgress ();			// Installation beenden		
}

function installBox_Cancel()
{
	// alle Button enabeln
	document.f_firmware.update_kernel.style.display = "block";
	document.f_firmware.update_rootfs.style.display = "block";
	document.f_firmware.update_package.style.display = "block";
	document.f_firmware.reboot.disabled = false;

	// Mehrsprachige Strings ersetzen
	initStrings ();

	// Installationskomponente zuruecksetzen
	dev_localObject.install_component = document.form_install.update_component.value = "";

	// pad schliessen
	guiPopup.CloseMe("message");
}

// ********************************************************************************************

// Zu Beginn der Installation kopiert der EWIO benoetigte Programme (HW-nahe Routine);
// Waehrend des Kopierens gibt es keine Antwort auf Anfragen vom web-Client;
// daher wird diese Zeit grosszuegig mit 5s ueberbrueckt! 

function waitOnStart()
{

	clearInterval(int_id);
	
	// Aufruf der Routine zur Abfrage des Status
	var getProgressCall = 'top.getDataExtended ("devicebase", "values", "top.frame_content.getInstallProgress(actStr)")';
	int_id = setInterval (getProgressCall, 2000);
}


// Installations-Status abfragen, ausgeloest durch Timer (getProgressCall)
function getInstallProgress(actStr)
{
//	alert (actStr);

	if (actStr.indexOf('{') == -1)
		return;

	var content = "json = "+actStr;
	try
	{
		var json = eval (content);
	}
	catch(err)
	{
		return;	
	}
	
	if ((json.content !== undefined) && (json.state !== undefined))		
	{
		if ((json.state == "error") || (json.state == "end"))
		{
			if (json.state == "error")
			{
				// Error: keine Daten gelesen, ErrorString ausgeben
				document.form_install.output.value = json.content;

				document.form_install.installed_1.value = ins("dev_install_err");
				document.form_install.installed_2.value = "";
				// g_upload reset
				top.g_upload = "";			
			}
		
			if (json.state == "end")
			{
				// Installation regulaer beendet
				str = document.form_install.output.value;
				document.form_install.output.value = str + "\n" + json.content;
				document.form_install.output.value += "\n\n" + "== Installation finished ==";
				// g_upload reset
				top.g_upload = "";			

			}
				
			// Success-Elemente sichtbar			
			document.form_install.installed_1.style.display = "block";
			document.form_install.installed_2.style.display = "block";

			// Timer beenden
			clearInterval (int_id);	

			// Button
			document.form_install.ok.disabled = false;
			document.form_install.cancel.disabled = false;
			document.form_install.ok.value = "OK";
		}

		if (json.state == "run")
		{
			// Installation laeuft
			// String im Progressfenster ausgeben
			str = document.form_install.output.value;
			document.form_install.output.value = str + "\n" + json.content;
		}

		// Textarea nach unten scrollen
		document.form_install.output.scrollTop = document.form_install.output.scrollHeight;

	}
}

// ********************************************************************************************

// Progress-Box schliessen
function endProgress ()
{

	// Erfolgsmeldung entfernen		
	document.form_install.installed_1.style.display = "none";
	document.form_install.installed_2.style.display = "none";

	// alle Button enabeln
	document.f_firmware.update_kernel.style.display = "block";
	document.f_firmware.update_rootfs.style.display = "block";
	document.f_firmware.update_package.style.display = "block";
	document.f_firmware.reboot.disabled = false;

	// Mehrsprachige Strings ersetzen
	initStrings ();

	// Installationskomponente zuruecksetzen
	dev_localObject.install_component = document.form_install.update_component.value = "";

	// pad schliessen
	guiPopup.CloseMe("message");

	// Reboot-Countdown automatisch ausfuehren
	document.f_firmware.reboot.checked = true;
	top.setData();	
}

// ********************************************************************************************








// ********************************************************************************************
// REBOOT
// ********************************************************************************************

// Timer- Variablen
var id_reboot;
var reboot_counter = 65;		// Zeit fuer Reboot


// Countdown-Message anzeigen
function reboot_setCountdown ()
{

	var headline =  '<B>'+ins("dev_reboot")+'</B>';
	content =		'<form name="form_reboot">'+ 		
					'<div class="pos x0101 textfield">'+ins("dev_waitreboot")+'</div>'+
					'<div class="pos x0301">'+
					'<input type="text" name="countdown" class="textfield_show" size="30" readonly="readonly" value="">'+		
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Info', 400, 120, "window");

	// Countdown-String aktualisieren
	id_reboot = setInterval ('reboot_countDownCalculator()', 1000);
}

function reboot_countDownCalculator()
{

	var str = ""+ ins("dev_waitrebootinsec") + reboot_counter;
	document.form_reboot.countdown.value = str;

	reboot_counter--;
	if (reboot_counter < 0)
	{
		reboot_counter = 55;	
		clearInterval (id_reboot);
	
		// countdown-pad schliessen
		guiPopup.CloseMe("message");
		
		// Seite neu aufrufen	
		top.window.location.href = top.window.location.href;
	}
}

// ********************************************************************************************











