/**********************************************************************************************

	JS functions for dom manipulation

	Copyright (c) 2013 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.0	  03/2013

***********************************************************************************************/


// ********************************************************************************************
/*



*/

// ********************************************************************************************
// ********************************************************************************************
// Dyn. Erzeugen eines HTML-Elements "div"
function dom_addElement_div (parent_id, target_id, class_value) 
{
	// Element erzeugen
	var newdiv = document.createElement ("div");
	
	// Attribute setzen
	newdiv.setAttribute('id', target_id);			
	newdiv.setAttribute('class', class_value);		
		
	// Element in DOM einhaengen
	if (parent_id == "document")
		var parent = document.body;
	else
		var parent = document.getElementById (parent_id);
	
	// am Elternelement anfuegen (innerhalb des divs "parent")
	parent.appendChild (newdiv);						
}

// ********************************************************************************************
// Dyn. Erzeugen eines HTML-Elements vom Typ "input"
function dom_addElement_inp (parent_id, target_id, type, text, class_value, style) 
{
	// Element erzeugen
	var newdiv = document.createElement("input");

	// Attribute des Elements
	newdiv.setAttribute("type", type);
	newdiv.setAttribute("id", target_id);
	newdiv.setAttribute("value", text);		
	newdiv.setAttribute("class", class_value);
	newdiv.setAttribute("style", style);

	// Event
	newdiv.onchange=function(){setChangedValue(this)};

	// Element einhaengen
	document.getElementById(parent_id).appendChild (newdiv);	
	
	// alert (document.getElementById("content").innerHTML);
}

// ********************************************************************************************
// Dyn. Erzeugen eines HTML-Elements "textarea"
function dom_addElement_textarea (parent_id, target_id, class_value, text) 
{
	// Analyse text und Berechnung der Anzahl der Zeilen
	// Zur Strukturierung soll nach einem Punkt mit Leerzeichen ein CR folgen (ohne Pkt.)
	// (Firefox: \n, IE: \r\n)
	text = text.replace(/\. /g,"\r\n");

	// Wenn \n enthalten sind, dann sind diese relevant, sonst die Anzahl der Zeichen
	var textLine = 100;
	var arrCnt = text.split("\n");
	if (arrCnt.length > 0)
		var lineCnt = arrCnt.length;	
	else
	{
		var lineCnt = (text.length / textLine);
		lineCnt = Math.round(lineCnt);
	}

	// Achtung: Firefox zeigt eine Zeile mehr an als IE und Chrome !!! Deshalb ausgleichen !!
	if (getBrowserType() != "firefox")
		lineCnt += 1;
	
	// Element erzeugen
	var newdiv = document.createElement("textarea");

	// Attribute des Elements
	newdiv.setAttribute("id", target_id);		
	newdiv.setAttribute("class", class_value);
	newdiv.setAttribute("rows", lineCnt);
	newdiv.setAttribute("style", "resize:none;overflow:auto");	// feste Groesse

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Dyn. Erzeugen von Text, z.B. fuer die Verwendung vor / hinter einem Button oder einer Checkbox
function dom_add_text (parent_id, text, class_value, style)
{
	// Element erzeugen
	var textNode = document.createTextNode (text);

	// Attribute koennen nicht direkt auf einen Textknoten angewendet werden
	// -> span nutzen
	var span = document.createElement('span');
	span.style.fontSize = "20px";
	span.appendChild(textNode);
	
	span.setAttribute("class", class_value);
	span.setAttribute("style", style);
	
	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (span);
}

// ********************************************************************************************
// Dyn. Erzeugen eines HTML-Elements
function dom_add_htmlElement (parent_id, element)
{
	var newElement = document.createElement(element);
	document.getElementById(parent_id).appendChild (newElement);	
}

// ********************************************************************************************
// Dyn. Erzeugen einer Select-Box (ohne Eintraege)
function dom_addElement_select (parent_id, target_id, size, class_value, style) 
{
	// Element erzeugen
	var newdiv = document.createElement("select");

	// Attribute des Elements
	newdiv.setAttribute("id", target_id);	
	newdiv.setAttribute("size", size);	
	newdiv.setAttribute("class", class_value);		
	newdiv.setAttribute("style", style);		

	// Event
	newdiv.onchange=function(){content_setSelectValue(this)};
	
	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Hinzufuegen eines Eintrags innerhalb der Select-Box
function dom_addSelectOption (parent_id, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Erzeugen einer Checkbox, allg.
function dom_addCheckbox (parent_id, target_id, class_value, style, checked, func)
{
	// Element erzeugen
	var newdiv = document.createElement("input");

	// Attribute des Elements
	newdiv.setAttribute("type", "checkbox");		
	newdiv.setAttribute("id", target_id);	
	newdiv.setAttribute("class", class_value);		
	newdiv.setAttribute("style", style);		
	if (checked == true)
		newdiv.setAttribute("checked", "checked"); 

	// Event
	newdiv.onclick = func;					

	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Erzeugen einer Checkbox zur binaeren Darstellung
function dom_addCheckboxBin (parent_id, target_id, class_value, style, checked, value)
{
	// Element erzeugen
	var newdiv = document.createElement("input");

	// Attribute des Elements
	newdiv.setAttribute("type", "checkbox");		
	newdiv.setAttribute("id", target_id);	
	newdiv.setAttribute("class", class_value);		
	newdiv.setAttribute("style", style);		
	if (checked == true)
		newdiv.setAttribute("checked", "checked"); 
	newdiv.setAttribute("value", value);		

	// Event
	newdiv.onchange=function(){setCheckedValue(this)};

	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Erzeugen einer Checkbox zur boolschen Darstellung
function dom_addCheckboxBool (parent_id, target_id, class_value, style, checked)
{
	// Element erzeugen
	var newdiv = document.createElement("input");

	// Attribute des Elements
	newdiv.setAttribute("type", "checkbox");		
	newdiv.setAttribute("id", target_id);	
	newdiv.setAttribute("class", class_value);		
	newdiv.setAttribute("style", style);		
	if (checked == "true")
	{
		newdiv.setAttribute("checked", "checked"); 
		newdiv.setAttribute("value", "true");		
	}
	else
		newdiv.setAttribute("value", "false");		

	// Event
	newdiv.onchange=function(){setCheckedValueBool(this)};

	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Dyn. Erzeugen eines HTML-Elements "button"
function dom_addElement_button (parent_id, target_id, text, class_value, style, func) 
{
	// Element erzeugen
	var newdiv = document.createElement("input");

	// Attribute des Elements
	newdiv.setAttribute("type", "button");
	newdiv.setAttribute("id", target_id);
	newdiv.setAttribute("value", text);		
	newdiv.setAttribute("class", class_value);
	newdiv.setAttribute("style", style);

	// Event
	newdiv.onclick = func;					

	// Element einhaengen
	document.getElementById(parent_id).appendChild (newdiv);	
}

// ********************************************************************************************
/*
	Dyn. Erzeugen einer Tabelle
	Aufrufbeispiel (2 Reihen, 3 Spalten, keine css-class):
	addElement_tab ("L80", "L80_table", "2", "3", "");

	- css_vlaue ist optional (mittels th und tr in der css koennen auch verschiedene Formatierungen fuer 
	   header und body gemacht werden)
*/
function addElement_tab (parent_id, table_id, rows, cells, class_value)
{
	var i,j;

	// Tabellenobject erzeugen 
	var table = document.createElement ("table");

	// Attribute
	table.setAttribute ("id", table_id);	
	if (class_value.length > 0)
		table.setAttribute ("class", class_value);		
	
	// Header erzeugen
	var header = document.createElement ("tr");

	header.setAttribute ("id", table_id + "_head");	

	var hElement = new Array();
	for (i=0; i<cells; i++)
	{
		hElement[i] = document.createElement ("th");
		hElement[i].appendChild (document.createTextNode ("HEAD "+i));
		header.appendChild (hElement[i]);
	}
	table.appendChild (header);
	
	// Reihen und Spalten erzeugen
	for (i=0; i<rows; i++)
	{
		var row = document.createElement ("tr");
		table.appendChild (row);

		for (j=0; j<cells; j++)
		{
			var cell = document.createElement ("td");
			cell.appendChild (document.createTextNode (i+"/"+j));
			row.appendChild (cell);
		}
	}
	
	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (table);
}	

// ********************************************************************************************
/*
	Eine Zelle in der Tabelle setzen (row = 0 ist Header)
	Aufrufbeispiel (Setzen 2.Spalte im Header):
	setTableElement ("L80_table", 0, 2, "NEU");
*/
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************
/*
	Eine Zelle in der Tabelle lesen (row = 0 ist Header)
	Aufrufbeispiel (Lesen  2.Spalte in der 1. Reihe (Spalte 0 .. 2)):
	alert (getTableElement ("L80_table", 1, 2));
*/
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************
/*
	Dyn. Erzeugen einer Tabellenreihe und Anhaengen an eine vorhandene Tabelle
	Aufrufbeispiel (1 Reihe mit 3 Spalten anfuegen):
	addTableRow ("L80_table", "1", "3");
*/
function addTableRow (table_id, rows, cells)
{
	var i,j;

	// Tabelle ermitteln
	var table = document.getElementById (table_id);
	
	// Reihen und Spalten erzeugen
	for (i=0; i<rows; i++)
	{
		var row = document.createElement ("tr");
		table.appendChild (row);

		for (j=0; j<cells; j++)
		{
			var cell = document.createElement ("td");
			cell.appendChild (document.createTextNode (i+"/"+j));
			row.appendChild (cell);
		}
	}
}	

// ********************************************************************************************
// Dyn. Erzeugen einer Tabellenreihe ohne Spalten und Anhaengen an eine vorhandene Tabelle
function addTableRow_0 (table_id, row_id)
{
	var i,j;

	// Tabelle ermitteln
	var table = document.getElementById (table_id);
	
	// Reihe ohne Spalten erzeugen
	var row = document.createElement ("tr");
	row.setAttribute ("id", row_id);	
	table.appendChild (row);
}	

// ********************************************************************************************
/*
	Dyn. Anfuegen einer neuen Spalte an eine Tabelle (Erzeugen entsprechenden Tabellenkopf-Eintrag)
	Aufrufbeispiel (Setzen Neue Spalte "SPALTE" im Header):
	addTableCell ("tab_head", "SPALTE", "mbus", "width:100px");
	
	Beachten:
	Die ID muss im <tr> stehen: <tr id="tab_head">
*/
function addTableCell (table_id, cell_id, text, classVal, styleVal)
{
	var header = document.getElementById (table_id);
	var newElement = document.createElement ("th");
	newElement.appendChild (document.createTextNode (text));
	newElement.setAttribute ("id", cell_id);
	newElement.setAttribute ("class", classVal);
	newElement.setAttribute ("style", styleVal);
	header.appendChild (newElement);
}

// ********************************************************************************************













// ********************************************************************************************
// ********************************************************************************************
// Dyn. entfernen eines HTML-Elements 
function dom_removeHTMLElement (id) 
{
	var node = document.getElementById(id);
	node.parentNode.removeChild(node);
}

// ********************************************************************************************
// ID aus dem Path erzeugen
function makeIdFromPath (pre, path)
{
	var id = pre + path.replace(/,/g, "\/");
	// alert (id);
	return id;
}

// ********************************************************************************************
// Path aus der ID erzeugen
function makePathFromId (id)
{
	var path = id.replace(/\//g, ",");
	path = path.substring (4);
	// alert (path);
	return path;
}

// ********************************************************************************************
// Browser check
function getBrowserType ()
{
	var browser = "unknown";
	var userAgent = navigator.userAgent.toLowerCase();
	
	if (userAgent.indexOf("firefox") != -1)	browser = "firefox";
	if (userAgent.indexOf("msie") != -1)	browser = "ie";
	if (userAgent.indexOf("chrome") != -1)	browser = "chrome";

	return browser;
}

// ********************************************************************************************
// ********************************************************************************************







