/**********************************************************************************************
	JS functions for template JSON

	Copyright (c) 2009 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		02.2009


	Code borrowed from 
		http://www.webmasterworld.com/javascript/3647600.htm
		timur@creativecodedesign.com, http://www.creativecodedesign.com


    Script:         guiPopup.js
    Author:         Ralf Stiawa
    License:        LGPL
    Notes:          Displays a popup box via DHTML

    Usage:          guiPopup.Show("myID", "Title", "some text", "Warning", 400, 100, "window")  
					guiPopup.CloseMe("myID");                  

    Requirements:   include guiPopup.css and copy associated images into your projects


***********************************************************************************************/

// ********************************************************************************************
// ********************************************************************************************
/*
	- Soll nur jeweils eine Popup-Box aufgerufen werden koennen, dann muessen fuer alle in Frage 
	  kommenden Aufrufe die gleiche id verwendet werden.
	  Das Programm prueft, ob bereits ein DIV mit der uebergebenen ID exisitiert; wenn ja, 
	  wird der Aufruf beendet. 
	  (Kein Mehrfach-Ausloesen, auch nicht bei verschiedenen Popup-Boxen!)

	- Die Popup-Box kann feststehend oder beweglich erzeugt werden.
	  strDragBox = ""			Popup-Box unbeweglich
	  strDragBox = "window"		Popup-Box beweglich innerhalb des umgebenden Fensters
	  strDragBox = "xxx"		Popup-Box beweglich innerhalb eines mit xxx angegebenen DIVs
								(Grenzen mit CSS festlegen)
	  
	  Wenn die Popup-Box feststehend ist, koennen mehrere aufgerufen werden.
	  Wenn die Popup-Box beweglich ist, darf nur jeweils eine aufgerufen werden, da drag&drop z.Zt.
	  nur mit einem Objekt funktioniert.
*/


var guiPopup = new function() 
{
    // Show:        creates a displays a popup box with specified paramters

	// strDivID:	ID for the DIV that will be created
    // strTitle:    title of the popup box
    // strText:     HTML text that should be displayed
    // strType:     string representing the message type: "Info" or "Error" or "Warning"
    // iWidth:      width in pixels
    // iHeight:     height in pixels
    // strDragBox:  border for center popup-box or drag&drop 
	// 				("" = no drag / "window" = drag in window / "xxx" = drag in box)
	
	var self = this;
	var x; 			// The current x position of the user's mouse
	var y; 			// The current y position of the user's mouse
	var xOffSet; 	// The difference between where the x position of the user's mouse is and 
					// where the left side of the div is
	var yOffSet; 	// The difference between where the y position of the user's mouse is and 
					// where the top side of the div is

	var dragdrop = 0;	// drag&drop freigeben
	var testmode = 0;	// Ausgabe der x/y- Positionen bei drag&drop
	var oldIEComp = 1;	// workaround fuer IE6/IE7 (ab IE8 OK, Firefox etc sowieso)

	// --------------------------------------------------------------
	// Create Popup-Box	
    this.Show = function(strDivID, strTitle, strText, strType, iWidth, iHeight, strDragBox) 
	{

		// initial position
		var iScreenCenterX; 	
        var iScreenCenterY; 

		// Popup-Window
		this.width = iWidth;	
		this.height = iHeight;	

		// drag & drop
		this.dragbox = strDragBox;

		// Popupbox soll nur einmal gestartet werden
		if (document.getElementById(strDivID) != null)
		{
			return;
		}
		
        this.GetScreenCenter(this);						// populate browser-specific screen center coordinates
        var strStyle = "width: " + iWidth + "px; height: " + iHeight + "px;left: "
            + (this.iScreenCenterX - iWidth / 2) + "px;top: "								// place the box in
            + (this.iScreenCenterY - iHeight / 2) + "px;";									// the middle of the client region
		this.oPopupDiv = this.CreateDiv(strDivID, "ccPopup", strStyle, "");					// create the outer DIV
		
		var oCloseXDiv = this.CreateDiv(null, "ccPopupClose", null, null);					// add a 'X' button to title bars
		if (oldIEComp)
			oCloseXDiv.onclick = function() {guiPopup.CloseMe(strDivID);}	
		else
	        oCloseXDiv.setAttribute("onclick", "guiPopup.CloseMe('" + strDivID + "')");		// add the same onclick as the OK button

		// hover
		if (oldIEComp)
			oCloseXDiv.onmouseover = function() {this.style.backgroundImage='url(style/images/title_close_select.jpg)';}
		else
			oCloseXDiv.setAttribute("onMouseOver", "this.style.backgroundImage='url(style/images/title_close_select.jpg)';");

		if (oldIEComp)
			oCloseXDiv.onmouseout = function() {this.style.backgroundImage='url(style/images/title_close.jpg)';}
		else
			oCloseXDiv.setAttribute("onMouseOut", "this.style.backgroundImage='url(style/images/title_close.jpg)';");
	
		var oTitleDiv = this.CreateDiv(null, "ccPopupTitle", null, strTitle);				// add title
        var oIcondDiv = this.CreateDiv(null, "ccPopup" + strType + "Icon", null, "&nbsp");	// place the proper icon style
        var oMessageDiv = this.CreateDiv(null, "ccPopupMessage", null, strText);			// add message

		// Set up event handlers drag & drop
		if (dragdrop && (self.dragbox != ""))
		{
			oTitleDiv.onmousedown = this.drag;
			oTitleDiv.onmouseup = this.drop;
		}
			
        this.oPopupDiv.appendChild(oCloseXDiv);
        this.oPopupDiv.appendChild(oTitleDiv);
        this.oPopupDiv.appendChild(oIcondDiv);
        this.oPopupDiv.appendChild(oMessageDiv);
        document.body.appendChild(this.oPopupDiv);
        this.oPopupDiv.style.visibility = 'visible';	// make the outer DIV visible
	
		if (testmode)
			this.createTestDiv();

		// alert (document.body.innerHTML);
	}

	
	// --------------------------------------------------------------
    // CreateDiv:   creates and returns a DIV object with specified attributes
    // strDivID:    the ID of the DIV being created or null if none
    // strDivClass: the class of the DIV
    // strDivStyle: any addional styles for the DIV
    // strDivHTML:  the inner HTML     
    this.CreateDiv = function(strDivID, strDivClass, strDivStyle, strDivHTML) {
        var oReturnObject = document.createElement('div');
        if (strDivID != null)
		{
			if (oldIEComp)	
				this.SetAttribute (oReturnObject, 'id', strDivID);
			else
	            oReturnObject.setAttribute('id', strDivID);
    	}
	    if (strDivClass != null)
		{
			if (oldIEComp)	
				this.SetAttribute (oReturnObject, 'class', strDivClass);
			else
	            oReturnObject.setAttribute('class', strDivClass);
		}
        if (strDivStyle != null)
		{
			if (oldIEComp)	
				this.SetAttribute (oReturnObject, 'style', strDivStyle);
			else
	            oReturnObject.setAttribute('style', strDivStyle);
		}
        if (strDivHTML)
            oReturnObject.innerHTML = strDivHTML;
        return oReturnObject;
    }


	// --------------------------------------------------------------
    // SetAttribute:   workaround for setAttribute, that has no effect in IE6 / IE7
    this.SetAttribute = function(obj, attribute, value)
	{
		
		if (attribute == 'style') 
		{
			// special case 'style'
			if (obj.style.setAttribute)
				obj.style.setAttribute ('cssText', value);
			else
				obj.setAttribute (attribute, value);
		}
		else
		{
			// all other
			var newattr = document.createAttribute (attribute);
		    newattr.nodeValue = value;
			obj.setAttributeNode(newattr);
		}

		// alert (attribute+"   "+value);	
	}


    this.SetStyle = function(obj, attribute, value)
	{
		obj.style.setAttribute ('cssText', value);

	}

	// --------------------------------------------------------------
    // GetScreenCenter:     Code borrowed from http://www.webmasterworld.com/javascript/3647600.htm
    //                      Attempts to deremine the center of the visible browser area in an 
    //                      browser independ-ish fashion
    this.GetScreenCenter = function(oInstance) 
	{
		var centerX, centerY;			// get the client center
		
		if (oInstance.dragbox == "window") 
		{
			if (window.innerHeight) 
			{
				centerX = window.innerWidth;
				centerY = window.innerHeight;
			} 
			else if (document.documentElement && document.documentElement.clientHeight) 
			{
				centerX = document.documentElement.clientWidth;
				centerY = document.documentElement.clientHeight;
			} 
			else if (document.body) 
			{
				centerX = document.body.clientWidth;
				centerY = document.body.clientHeight;
			}                                                                                  
			oInstance.iScreenCenterX = (centerX / 2);
			oInstance.iScreenCenterY = (centerY / 2);
		}
		else
		{	
			// Bereichsgrenzen = DIV (in zugehoerigem style festgelegt)
			var border = document.getElementById(self.dragbox);
			var border_top = border.offsetTop;
			var border_left = border.offsetLeft;
			var border_bottom = border.offsetHeight + border_top;
			var border_right = border.offsetWidth + border_left;
		
			oInstance.iScreenCenterX = border_left + ((border_right - border_left) / 2);
			oInstance.iScreenCenterY = border_top + ((border_bottom - border_top) / 2);
		}
    }


	// --------------------------------------------------------------
	// close the PopupBox
	this.CloseMe = function (id)
	{
		if (document.getElementById(id))	// nicht null oder undefined
		{		
			document.getElementById(id).style.visibility = 'hidden'; 
			guiPopup.removeId(id);
		}	
	}


	// --------------------------------------------------------------
	// Mouse down: Startposition fuer drag
	this.drag = function(e) 
	{
		// move-cursor
		self.oPopupDiv.style.cursor = 'move';
		
		// event
		if (!e) var e = window.event;
		if (e.pageX) 			{ self.x = e.pageX;	self.y = e.pageY; }
		else if (e.clientX) 	{ self.x = e.clientX; self.y = e.clientY; }

		// Offset zwischen Anfasspunkt und linker oberer Ecke
		self.xOffSet = self.x - self.oPopupDiv.offsetLeft;
		self.yOffSet = self.y - self.oPopupDiv.offsetTop;

		// neue x/y-Koordinaten fuer CSS
		self.oPopupDiv.style.left = (self.x - self.xOffSet) + "px";
		self.oPopupDiv.style.top = (self.y - self.yOffSet) + "px";

		// move aktivieren
		document.onmousemove = self.move;
	}

	
	// --------------------------------------------------------------
	// Mouse up: ziehen beenden
	this.drop = function(e) 
	{
		// default-cursor
		self.oPopupDiv.style.cursor = 'default';
		
		// move deaktivieren
		document.onmousemove = function() { };
	}
	

	// --------------------------------------------------------------
	// Mouse move: Objekt ziehen
	this.move = function(e) 
	{

		// event
		if (!e) var e = window.event;
		if (e.pageX) 			{ self.x = e.pageX;	self.y = e.pageY; }
		else if (e.clientX) 	{ self.x = e.clientX; self.y = e.clientY; }


		if (self.dragbox == "window") 
		{
			// Bereichsgrenzen = Fenster
			var border_top = 0;
			var border_left = 0;
		
			if (window.innerHeight) 
			{
				var border_right = window.innerWidth;
				var border_bottom = window.innerHeight;
			} 
			else if (document.documentElement && document.documentElement.clientHeight) 
			{
				var border_right = document.documentElement.clientWidth;
				var border_bottom = document.documentElement.clientHeight;
			} 
			else if (document.body) 
			{
				var border_right = document.body.clientWidth;
				var border_bottom = document.body.clientHeight;
			}                               
		}
		else	
		{	
			// Bereichsgrenzen = DIV (in zugehoerigem style festgelegt)
			var border = document.getElementById(self.dragbox);
			var border_top = border.offsetTop;
			var border_left = border.offsetLeft;
			var border_bottom = border.offsetHeight + border_top;
			var border_right = border.offsetWidth + border_left;
		}

		// Objekt wird nur innerhalb der Begrenzung bewegt
		var left = self.x - self.xOffSet;
		if (left < border_left)			left = border_left;
		
		var top = self.y - self.yOffSet;
		if (top < border_top)			top = border_top;	

		var right = (self.x - self.xOffSet) + (self.width + 4);		// 4 = 2 x 2px border 
		if (right > border_right)		return;
			
		var bottom = (self.y - self.yOffSet) + (self.height + 4);	// 4 = 2 x 2px border
		if (bottom > border_bottom)		return;

		self.oPopupDiv.style.left = left + "px";
		self.oPopupDiv.style.top = top + "px";
		self.oPopupDiv.style.right = right + "px";
		self.oPopupDiv.style.bottom = bottom + "px";
	
		if (testmode)
		{
			document.testgroup.msgbox.value="x: "+self.x+"   y:"+self.y+"   x offs: "+self.xOffSet+"   y offs:"+self.yOffSet;
			document.testgroup.window.value="x: "+border_left+"   y: "+border_top+"   width: "+border_right+"   height: "+border_bottom;
			document.testgroup.result.value="x: "+left+"px   y: "+top+"px   width: "+right+"px   height: "+bottom+"px";
		}
	}


	// --------------------------------------------------------------
	// remove the div with its content (childs)
	this.removeId = function(id)
	{
		var node = document.getElementById(id);
		node.parentNode.removeChild(node);

		//alert (document.body.innerHTML);
	}

	
	// --------------------------------------------------------------
	// Anlegen von Textfeldern fuer die Ausgabe der Testinformatioen
	this.createTestDiv = function ()
	{
		// nur 1mal anlegen
		if (document.getElementById("test") != null)
			return;
			
		// Element erzeugen
		var newdiv = document.createElement ("div");

		if (oldIEComp)	
			this.SetAttribute (newdiv, 'id', "test");
		else
			newdiv.setAttribute('id', "test");			

		document.body.appendChild (newdiv);						

		newdiv.innerHTML = 	"<form name=testgroup>"+
							"<input type='text' value='' name='msgbox' size=50 > Koordinaten Popup-Box <br>"+
							"<input type='text' value='' name='window' size=50 > Koordinaten Fensterbereich <br>"+
							"<input type='text' value='' name='result' size=50 > Berechnete CSS-Werte"+
							"</form>";
			
		//alert (document.body.innerHTML);		
	}

	// --------------------------------------------------------------
	;
}

/*
// ******************************************************************
// Aufruf - Beispiel
// ******************************************************************

function fTest ()
{
	var content = 	'Hallo!'+
					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fMyFunction(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fMyFunction(0)">'+
					'</div>';
	
	guiPopup.Show ("myID", 'Titel', content, 'Info', 400, 100, "window");
	
}


function fMyFunction(value)
{
	if (value == "1")
		alert ("OK");
	else
		alert ("Cancel");

	// close
	guiPopup.CloseMe("myID");

}
*/
// ******************************************************************
// ******************************************************************






