/**********************************************************************************************

	JS functions for ip window

	Copyright (c) 2008 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		07.2010

***********************************************************************************************/

var localObject;
var DEBUG_IP = 0;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initIP()
{
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Namen der Page ermitteln
	document.getElementById("headLine").innerHTML = 
	getFilenameFromPath (top.frame_content.location.href);	

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO -> Browser)
function setObjectProperties (actObject)
{
	// Werte setzen	
	setIP (actObject);

	// Objekt global speichern fuer getObjectProperties()
	localObject = actObject;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		// Werte ermitteln	
		var changedObject = getIP(localObject);
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************
// Werte fuer IP entsprechend JSON-Objekt setzen
function setIP (json_ip)
{
	// Einstellungen enstsprechend JSON- Objekt setzen

	if (DEBUG_IP)
	{
		var objStr = JSON2.stringify (json_ip, null, 4);
		alert (objStr);
	}

	// RadioButton initialisieren
	if (json_ip.dhcp != "undefined")
	{
		if (json_ip.dhcp == true)
			document.form_type.type[1].checked = true;
		else
			document.form_type.type[0].checked = true;
	}

	// IP-Adressen setzen
	var arr_addr = json_ip.addr.split(".");
	var arr_subnet = json_ip.subnet.split(".");
	
	if (json_ip.gateway.length)
		var arr_gateway = json_ip.gateway.split(".");
	else
	{
		var arr_gateway = new Array();
		for (var i=0; i<4; i++)
			arr_gateway[i] = "";
	}

	if (json_ip.dnsServer.length)
		var arr_dnsServer = json_ip.dnsServer.split(".");
	else
	{
		var arr_dnsServer = new Array();
		for (var i=0; i<4; i++)
			arr_dnsServer[i] = "";
	}

	for (var i=0; i<4; i++)		// 4 IP-Segmente
	{
		document.form_man[i].value = arr_addr[i];
		document.form_man[i+4].value = arr_subnet[i];
		document.form_man[i+8].value = arr_gateway[i];
		document.form_man[i+12].value = arr_dnsServer[i];
	}

	// Host und Domaene setzen
	if (json_ip.hostname != "undefined")
		document.form_dhcp.host.value = json_ip.hostname;
	if (json_ip.domain != "undefined")
		document.form_dhcp.domain.value = json_ip.domain;

	// activState setzen
	if (json_ip.dhcp == true)
	{
		setActivState('form_dhcp', 1);
		setActivState('form_man', 0);
	}
	else
	{
		setActivState('form_dhcp', 0);
		setActivState('form_man', 1);
	}

}

// ********************************************************************************************
// Werte fuer IP ermitteln und in JSON-Objekt setzen
function getIP (json_ip)
{

	// DHCP
	if (document.form_type.type[0].checked == true)
	{
		json_ip.dhcp = false;

		// Plausibilitaets-Check
		if (checkIPInput() != 0)	
			return;
	}	
	else	
	{	
		json_ip.dhcp = true;

		// Plausibilitaets-Check
		if (checkDHCPInput() != 0)	
			return;
	}

	// IP-Adressen ermitteln
	json_ip.addr = 		document.form_man[0].value+"."+
						document.form_man[1].value+"."+
						document.form_man[2].value+"."+
						document.form_man[3].value;

	json_ip.subnet = 	document.form_man[4].value+"."+
						document.form_man[5].value+"."+
						document.form_man[6].value+"."+
						document.form_man[7].value;

	json_ip.gateway = 	checkForZero(
						document.form_man[8].value+"."+
						document.form_man[9].value+"."+
						document.form_man[10].value+"."+
						document.form_man[11].value );

	json_ip.dnsServer = checkForZero(
						document.form_man[12].value+"."+
						document.form_man[13].value+"."+
						document.form_man[14].value+"."+
						document.form_man[15].value );

	// Host und Domaene 
	json_ip.hostname = document.form_dhcp.host.value;
	json_ip.domain = document.form_dhcp.domain.value;

	if (DEBUG_IP)
	{
		var objStr = JSON2.stringify (json_ip, null, 4);
		alert (objStr);
	}

	return (json_ip);
}

// ********************************************************************************************

// Plausibilitaets-Check IP
function checkIPInput()
{
	var errStr = "";
	var networkaddr = new Array();
	var networkaddr_1 = new Array();

	// Eingabe fuehrender Nullen verhindern (wird als Oktal gewertet ...)
	for (var i=0; i<16; i++)
		document.form_man[i].value = Number(document.form_man[i].value);	

	// Pruefen, ob eins der folgenden Felder nicht eine Ziffer zwischen 0 und 255 hat
	// IP-Adresse
	for (var i=0; i<4; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		errStr = ins("ip_msg_err4");
	}		
	// Subnetzmaske
	for (var i=4; i<8; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		errStr = ins("ip_msg_err5");
	}		
	// DNS-Server	
	var testVal = 0;	
	for (var i=8; i<12; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		if (document.form_man[i].value.length == 0)
			testVal++;
		if (testVal == 4)
			return (0);	
		else					
			errStr = ins("ip_msg_err6");
	}		
	// Gateway
	var testVal = 0;	
	for (var i=12; i<16; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		if (document.form_man[i].value.length == 0)
			testVal++;
		if (testVal == 4)
			return (0);	
		else					
			errStr = ins("ip_msg_err7");
	}

/*
	// Auf Anforderung von ES entfernt (ab v2.07):
	// Einstelllungen in Firmen oft nicht mit IPv4-Einstellungen konform.	

	// check IP-Adresse und Gateway fuer alle 4 Segmente 
	for (var i=0; i<4; i++)
	{
		// Netzwerkadresse = IP-Adresse & Maske
		networkaddr[i] = parseInt(document.form_man[i].value) & parseInt(document.form_man[i+4].value);

		// Netzwerkadresse = Gateway-Adr. & Maske
		networkaddr_1[i] = parseInt(document.form_man[i+8].value) & parseInt(document.form_man[i+4].value);

		if (networkaddr[i] != networkaddr_1[i])
			errStr = ins("ip_msg_err1");
	}

	// Netzwerk-Adr.(erste Adr., meist 0) und Broadcast-Adr.(letzte Adr., meist 255) duerfen nicht gleich gateway sein
	if (parseInt(document.form_man[8+3].value) == networkaddr[3])
		errStr = ins("ip_msg_err2");

	if (parseInt(document.form_man[8+3].value) == (networkaddr[3] | (parseInt(document.form_man[4+3].value) ^ 255)))
		errStr = ins("ip_msg_err3");
*/

	// Ausgabe Fehlermeldung
	if (errStr.length > 0)
	{
		//alert (errStr)
		top.messageBox (ins("ip_msg_head"), errStr);		
		return (-1);
	}
	
	return (0);
}

// ********************************************************************************************

// Plausibilitaets-Check DHCP
function checkDHCPInput()
{

	// Regeln fuer den Hostname (RFC 952, 1123):
	// Laenge 1 bis 63 Zeichen (realisiert 2-63)
	// zulaessige Zeichen "A-Z a-z 0-9 -"
	// Einschränkungen: "-" nicht als erstes oder letztes Zeichen	

	var muster = /^[A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9]$/;
	var result = muster.test(document.form_dhcp.host.value); 
	// alert (document.form_dhcp.host.value+"   "+result);

	if (result == false)
	{
		top.messageBox (ins("ip_msg_head"), ins("ip_msg_err8"));		
		return (-1);
	}

	// Regeln fuer Domain
	// Laenge zusammen mit Hostname <= 255 Zeichen
	var length = document.form_dhcp.host.value.length + document.form_dhcp.domain.value.length;
	if (length > 255)
	{
		top.messageBox (ins("ip_msg_head"), ins("ip_msg_err9"));		
		return (-1);
	}

	return (0);
}

// ********************************************************************************************

// Wenn 4 x nichts eingegeben wurde, dann die verbliebenen 3 Punkte entfernen (-> Leerstring)
function checkForZero (inStr)
{

	var outStr;

	if (inStr == "...")
		outStr = "";
	else
		outStr = inStr;

	return (outStr);
}

// ********************************************************************************************
// Bereiche activ / deactiv
// ********************************************************************************************
// Alle Elemente, welche in einer angegebenen Form gruppiert sind, werden aktiv oder deaktiv dargestellt
function setActivState (form, activ)
{

	// alert (form + "   " + activ);

	// Bereich
	if (activ)
	{
		document[form].style.opacity = 1;
		document[form].style.filter = 'alpha(opacity=100)';
	}
	else
	{
		document[form].style.opacity = 0.4
		document[form].style.filter = 'alpha(opacity=40)';
	}

	// Elemente
	if (activ)
	{	
		// alle Elemente enabeln
		for (var i=0; i<document[form].length; i++)
			document[form][i].disabled = false;
	}
	else
	{
		// alle Elemente disabeln
		for (var i=0; i<document[form].length; i++) 
			document[form][i].disabled = true;
	}
}

// ********************************************************************************************
// ********************************************************************************************

function dhcp_details()
{


}

// ********************************************************************************************
// ********************************************************************************************


