/**********************************************************************************************
	
	JS functions for languages

	Copyright (c) 2008 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		08.2010

***********************************************************************************************/

// =====  language = ENGLISH  ===== 

/*
	Anmerkungen:
	Diese Datei wird als Sprachdatei eingebunden.
	Fuer jede Sprache wird die jeweilige language.js benoetigt. Sie gilt fuer alle pages.
	
	Konventionen:
	HTML
	- diese Datei muss im Haeder jeder betroffenen HTML-Datei eingebunden werden
	- jedem key wird die Bezeichnung der page vorangestellt (Bsp.: ip_xxx)
	- an Stelle des Textes im HTML wird "<script>lang("ip_key");</script>" eingefuegt, wobei in diesem
	  Beispiel "ip_" fuer die page und "key" fuer den Bezeichner steht.
	
	JS
	- statt dem Text wird die Funnktion 	ins("key");   eingefuegt
	- key dient dabei als Kennung fuer den eigentlichen Text
	- jedem key wird die Bezeichnung der page vorangestellt (Bsp.: ip_xxx)
	
*/



// ********************************************************************************************
// ********************************************************************************************

// Funktion, die waehrend des Parsens der HTML-Seite aufgerufen wird.
// Sie fuegt an den entsprechenden, durch Bezeichner (key)  identifizierten Stellen, den festgelegten Text ein.
function lang(key)
{
	var substitute;

	switch (key)
	{
		// page "start"
		case "start_text":	substitute =
			"Welcome at EWIO!<br><br>"+
			"Please login.<br>"+	
			"Depending on your login status you will receive different access rights to the system.<br>";
			break;
		case "start_login": substitute = "LogIn-State:";	break;
		case "start_pw": 	substitute = "Password:";		break;


		// page "info"
		case "info_text":	substitute =
			"To use the webpage a modern browser is required. 	<br><br>"+		
			"You can use one of the browsers listed below to use the webpage: <br>"+
			"- Firefox version 3.0 or better <br>"+
			"- Internet Explorer 7.0 or better <br>"+
			"- Google Chrome 6.0 (6.0.472.55) or better <br>"+
			"- Iceweasel (Linux) 3.0.6 or better <br><br>"+
			"This browsers were be tested for compatibility with EWIO. <br>"+
			"Using browsers different from the ones listed above may affect the functionality.<br><br>"+
			"It is necessary to activate the following settings if you want to use the Internet Explorer: <br>"+
			"\"Search for latest version of the previously saved page: at every access to the page.\". <br><br>"+
			"You will find the setting mentioned above under:  <br>"+			
			"Extras / Internetoptions / General / Browser History - Settings<br>";
			break;


		// page "devicebase"
		case "dev_name":	substitute = "Device Name:";	break;
		case "dev_hw":		substitute = "HW-Basics";	break;
		case "dev_number":	substitute = "Serial Number";	break;
		case "dev_mac":		substitute = "MAC-Address";	break;
		case "dev_fw":		substitute = "Firmware version";	break;
		case "dev_reboot":	substitute = "Reboot device";	break;
		case "dev_install":	substitute = "Install";		break;
		case "dev_file":	substitute = "File";		break;
		case "dev_update":	substitute = "Update is running ... ";		break; 		
		case "dev_installstate":	substitute = "State of installation:";		break; 		
		case "dev_comment":	substitute = "Please be careful making changes on this site.";
			break;


		// page "memory"
		case "mem_drive":	substitute = "Drives";		break;
		case "mem_operations":	substitute = "Operations";		break;
		case "mem_data":	substitute = "Data: ";		break;
		case "mem_sd_format":	substitute = "SD card formatting with ext2";		break;
		case "mem_sd_copy_to_sd":	substitute = "Copy UserSpace from Flash to SD card";		break;
		case "mem_sd_copy_to_flash":	substitute = "Copy UserSpace from SD card to Flash";		break;
		case "mem_sd_boot":	substitute = "In the future, boot from SD card";		break;
		case "mem_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Query current data from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Perform operations on EWIO";		
			break;



		// page "pw"
		case "pw_select":	substitute = "Change password for:";	break;
		case "pw_pw0":		substitute = "New password:";	break;
		case "pw_pw1":		substitute = "Password again:";		break;
		case "pw_pw_old":		substitute = "Previous password:";	break;
		case "pw_comment":	substitute = 
			"New passwords will only become valid after sending them to EWIO.";
			break;

		
		// page "ip"
		case "ip_mode_0":	substitute = "get IP-Address manually"; break;
		case "ip_mode_1":	substitute = "get IP-Address automatically (DHCP)"; break;
		
		case "ip_addr":		substitute = "IP-Address"; 			break;
		case "ip_subnet":	substitute = "Subnet-Mask"; 		break;
		case "ip_gateway":	substitute = "Standard-Gateway";	break;
		case "ip_dns":		substitute = "DNS-Server";			break;
		case "ip_host":		substitute = "Host-Name";			break;
		case "ip_domain":	substitute = "Domaine";				break;
		case "ip_warning":	substitute = 
			"<B>Warning: When changing the IP-settings you may loose the connection to the EWIO.<br>"+ 
			"In that case you will have to login again with new settings!</B>";	
			break;
		case "ip_comment":	substitute = 
			"Please contact your administrator if you have any questions about the settings.";
			break;


		// page "wlan"
		case "wlan_config":	substitute = "Configuration:"; 	break;
		case "wlan_auto":	substitute = "automatic"; 	break;
		case "wlan_man":	substitute = "manually"; 	break;
		case "wlan_scan":	substitute = "WLAN-Networks scan"; 	break;
		case "wlan_name":	substitute = "Network name:"; 	break;
		case "wlan_coding":	substitute = "Coding:"; 	break;
		case "wlan_key":	substitute = "Key:"; 	break;
		case "wlan_comment":	substitute = 
			"Changes on this page are effective after a reboot only.";	
			break;

			
		// page "time"
		case "time_local":	substitute = "local time:";		break;
		case "time_cmt":	substitute = 
			"This time is the current time on EWIO.<br>"+
			"Setting time via timeserver:<br>"+
			"If using names instead of ip-addresses \"DHCP\" must be activate in IP-Configuration";		
			break;
		case "time_set":	substitute = "Time set:";	break;
		case "time_man":	substitute = "manually";		break;
		case "time_PC":		substitute = "via PC";		break;
		case "time_server":	substitute = "via timeserver";		break;
		case "time_tformat":	substitute = "Format: dd.mm.yy hh:mm:ss";		break;
		case "time_tserver":	substitute = "Time-Server:";		break;
		case "time_bserver":	substitute = "Backup-Server:";		break;
		case "time_scall":	substitute = "Daily access time: ";		break;
		case "time_sformat":	substitute = "Format: hh:mm";		break;
		case "time_ipformat":	substitute = 
			"Format: name or IP-address, time protocol (TP/NTP)<br>"+
			"Max. 8 entries";		break;
		case "checkTimeServer":	substitute = "get time from timeserver now";	break;		

		
		// page "links"
		case "links_list":	substitute = "List of known links:<br><br>";		break;
		case "links_format":	substitute = 
			"Format: EWIO name,hostname or IP-address <br>" +
			"Example 1: EWIO_1,http://10.22.0.215 <br>" +
			"Example 2: EWIO_2,http://EWIO-3f47f5 <br>";		break;
		case "links_auto":	substitute = "Automatic search of neighbouring EWIOs:";	break;
		case "links_disabel":	substitute = "Switch off";	break;
		case "links_now":	substitute = "Starts now";	break;
		case "links_daily":	substitute = "Starts daily (at 02:00:00 hour)";	break;
		case "links_cmt":	substitute = 
			"Edit links to other EWIOs.";		
			break;

	
		// page "application"
		case "app_change_name":		substitute = "Change name";		break;
		case "app_appl_delete":		substitute = "Delete application";		break;
		case "app_tools_io":		substitute = "IOs";		break;
		case "app_tools_cycle":		substitute = "Cycle";		break;
		case "app_cmt":				substitute = 
			"Create your own application by completing this template.";
			break;


		//page "log"
		case "log_start_hw":		substitute = "HW latest start:";	break;
		case "log_start_sw":		substitute = "SW latest start:";	break;
		case "log_start_link":		substitute = "Eth-Link stable since:";	break;
		case "log_send_mail":		substitute = "send eMail";	break;
		case "log_last_entry":		substitute = "(last entries)";	break;
		case "log_send_ftp":		substitute = "Send logfile to FTP-server";	break;
		case "log_delete_now":		substitute = "Delete logfile now";		break;
		case "log_cmt":				substitute =
			"Complete syslog-file you can read with SSH/SCP on '/config/usr/messages'.<br>"+
			"All time messages on this side represented as GMT (UTC).";			
			break;


		// page "mbus_add_auto"
		case "mbus_add_searchAdr":		substitute = "Search Address";		break;
		case "mbus_add_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Query MBus-IDs from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Add marked counters to navigation.";		
			break;


		// page "mbus_remove"
		case "mbus_remove_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reading counter from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Remove marked counter";		
			break;


		// page "mbus_counter_secAddress"
		case "mbus_counter_secAddress_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reading counter from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> No Function";		
			break;


		// page "mbus_counter_primAddress"
		case "mbus_counter_primAddress_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reading counter from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> No Function";		
			break;


		// page "mbus_counterlist"
		case "mbus_counterlist_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reading current processing position from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Sending changed processing position back to EWIO";		
			break;


		// page "mbus_sync"
		case "mbus_sync_puls":		substitute = "Use Sync Pulse";		break;
		case "mbus_sync_signal":	substitute = "Signal source";		break;
		case "mbus_sync_contact":	substitute = "Type of contact";		break;
		case "mbus_sync_contact_0":	substitute = "open -> close";		break;
		case "mbus_sync_contact_1":	substitute = "close -> open";		break;
		case "mbus_sync_poll":		substitute = "Sampling";		break;
		case "mbus_sync_grid":		substitute = "Sync Pulse grid";		break;
		case "mbus_sync_warning":	substitute = 
			"<B>Warning: To use the synchronous pulse, you have to set in menu <br>"+
			"\"device/configuration/IO/mct_pin_di_x\" (x=0..3) the mode to \"direct\"!</B>";
			break;
		case "mbus_sync_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Read Sync Pulse settings from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Send Sync-Pulse settings to EWIO";		
			break;


		// page "mbus_output"
		case "mbus_output_counter":		substitute = "Counter Name:";		break;
		case "mbus_output_param":		substitute = "Parameter:";		break;
		case "mbus_output_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reading parameter for selected counter <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Download parameter file to your PC";		
			break;


		// page "mbus_config"
		case "mbus_config_timestamp":		substitute = "Time stamp:";		break;
		case "mbus_config_requests":		substitute = "Requests:";		break;
		case "mbus_config_freeze":		substitute = "Frozen value available.";		break;
		case "mbus_config_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Query configuration of the counter <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Send configuration of the counter ";		
			break;


		// page "mbus_presence"
		case "mbus_presence_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reading the configured meter from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> No function";		
			break;


		// page "mbus_messages"
		case "mbus_messages_delete":		substitute = "Delete file";		break;
		case "mbus_messages_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Issue update <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Delete file(s), if marked";		
			break;

		
		// page "mbus_data"
		case "mbus_data_current":		substitute = "Current data";		break;
		case "mbus_data_stored":		substitute = "Stored data";		break;
		case "mbus_data_timestamp":		substitute = "Timestamp:";		break;
		case "mbus_data_access":		substitute = "Accesses:";		break;
		case "mbus_data_status":		substitute = "Status:";		break;
		case "mbus_data_save":			substitute = "Save in database";		break;
		case "mbus_data_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Query measured values of the counter<BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> No Function";		
			break;


		//page server_format
		case "format_headarea":		substitute = "Head area";		break;
		case "format_dataarea":		substitute = "Data area";		break;
		case "format_timestamp":	substitute = "Timestamp";		break;
		case "format_delimiter":	substitute = "List delimiter";		break;
		case "format_decimal":	substitute = "Decimal delimeter";		break;
		case "format_line":		substitute = "Line ";		break;
		case "mbus_format_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Read configured output format from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Write the changed output format to EWIO";		
			break;


		//page server_cyclic_type
		case "cyclic_type_supply":		substitute = "Supply type";		break;
		case "cyclic_type_time":		substitute = "Period of time";		break;
		case "cyclic_type_push":		substitute = "Push operation";		break;
		case "cyclic_type_poll":		substitute = "Poll operation (FTP)";		break;
		case "cyclic_type_variant":		substitute = "Send variant:";		break;
		case "cyclic_type_single":		substitute = "File for each data point";		break;
		case "cyclic_type_packed":		substitute = "Packed files (tar.bz2)";		break;
		case "cyclic_type_delay":		substitute = "Transmission delay FTP:";		break;
		case "cyclic_type_delaycontent":	substitute = "Minutes after interval expires (1 .. 59)";		break;
		case "cyclic_type_select":	substitute = "Select interval:";		break;
		case "cyclic_type_select_quarthour":	substitute = "1/4 hour";		break;
		case "cyclic_type_select_hour":	substitute = "hour";		break;
		case "cyclic_type_select_day":	substitute = "day";		break;
		case "cyclic_type_select_week":	substitute = "week";		break;
		case "cyclic_type_select_month":	substitute = "month";		break;
		case "cyclic_type_select_quarter":	substitute = "quarter";		break;
		case "cyclic_type_select_half":	substitute = "half-year";		break;
		case "cyclic_type_select_year":	substitute = "year";		break;
		case "cyclic_type_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Read configured output method from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Write the changed output method to EWIO";		
			break;


		//page mbus_config_datapoints
		case "mbus_datapoints_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Read configured data points from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> No function";		
			break;


		// page server_man_download
		case "man_download_datapoint":		substitute = "Data point:";		break;
		case "man_download_select":		substitute = "Selection";		break;
		case "man_download_all":		substitute = "all";		break;
		case "man_download_from":		substitute = "Data from:";		break;
		case "man_download_to":		substitute = "Data to:";		break;
		case "man_download_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reload configuration page <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Produce the measured value file for download";		
			break;


		// page param_config
		case "param_config_device":		substitute = "Device-<br>Settings";		break;
		case "param_config_app":		substitute = "Applications";		break;
		case "param_config_mbus":		substitute = "MBus-/Modbus-<br>Configuration";		break;
		case "param_config_info":		substitute = "Changed settings only take effect after reboot!";		break;
		case "param_config_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Read current data from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> No function";		
			break;


		// page param_data
		case "param_data_store":	substitute = "Memory location";		break;
		case "param_data_fill":		substitute = "Overall level";		break;
		case "param_data_back":		substitute = "Back File";		break;
		case "param_data_value":	substitute = "Reading File";		break;
		case "param_data_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Read current data from EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> No function";		
			break;


		// page modbus_rs485
		case "modbus_rs485_param":	substitute = "Please enter parameters of the interface:";		break;
		case "modbus_rs485_bitrate":	substitute = "Bit rate:";		break;
		case "modbus_rs485_parity":		substitute = "Parity:";		break;
		case "modbus_rs485_repeat":		substitute = "Repeat max.:";		break;
		case "modbus_rs485_timeout_frame":	substitute = "Timeout Frame / ms:";		break;
		case "modbus_rs485_timeout_byte":	substitute = "Timeout Byte / ms:";		break;
		case "modbus_rs485_io":		substitute = "Check internal IOs by Modbus";		break;
		case "modbus_rs485_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Query parameters of the interface <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Send parameters of the interface";			break;


		// page modbus_add
		case "modbus_add_param":	substitute = "Please enter parameters of the modbus device:";		break;
		case "modbus_add_address":	substitute = "Address:";		break;
		case "modbus_add_type":	substitute = "Device type:";		break;
		case "modbus_add_name":	substitute = "Device name:";	break;
		case "modbus_add_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Reset all settiungs. <br>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Insert device into the navigation.";		
			break;


		// page bacnet
		case "bacnet_active":	substitute = "BACnet active";		break;
		case "bacnet_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Get parameter from EWIO. <br>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Send parameter to EWIO.";		
			break;

		// weitere ...
		
	}

	document.write(substitute);
}
// ********************************************************************************************
// ********************************************************************************************


// Funktion, die aus JavaScript heraus aufgerufen wird.
// Sie fuegt an den entsprechenden, durch Bezeichner (key)  identifizierten Stellen, den festgelegten Text ein.
function ins(key)
{
	var substitute;

	switch (key)
	{
		// tree
		case "tree_config":		substitute = "Configuration";		break;
		case "tree_log":		substitute = "System State";		break;
		case "tree_pw":			substitute = "Password";			break;
		case "tree_ip":			substitute = "LAN";					break;
		case "tree_time":		substitute = "Time Management";		break;
		case "tree_email":		substitute = "E-Mail";				break;
		case "tree_data":		substitute = "Data";				break;
		case "tree_app":		substitute = "Applications";		break;
		case "tree_device":		substitute = "Device";				break;		

		case "tree_devicebase":	substitute = "Device Base";			break;
		case "tree_memory":		substitute = "Memory";				break;
		case "tree_general":	substitute = "General";				break;		
		case "tree_counter":	substitute = "Counter";				break;		
		case "tree_connect":	substitute = "Link To";				break;		
		case "tree_new":		substitute = "New";					break;		
		case "tree_consisting":	substitute = "Consisting";			break;		
		case "tree_io_extended":	substitute = "IO Extended";		break;		

		case "tree_add_counter":	substitute = "Add Counter";		break;
		case "tree_remove_counter":	substitute = "Remove Counter";	break;
		case "tree_counter_secAddress":	substitute = "Counter Secondary Address";	break;
		case "tree_counter_primAddress":	substitute = "Counter Primary Address";	break;
		case "tree_counterlist":	substitute = "Counter List";	break;
		case "tree_sync_pulse":	substitute = "Sync Pulse";			break;
		case "tree_param_output":	substitute = "Parameter Output";	break;
		case "tree_tariffs":	substitute = "Tariffs HT/NT";		break;
		case "tree_hallo":		substitute = "Hello";				break;
		case "tree_messages":	substitute = "Messages";			break;
		case "tree_hallo":	substitute = "Hello";					break;
		case "tree_messages":	substitute = "Messages";			break;

		case "tree_data_server":	substitute = "Data Server";		break;
		case "tree_data_server_cyclic":	substitute = "cyclic";		break;
		case "tree_data_server_man":	substitute = "manually";	break;
		case "tree_format":	substitute = "Query Format";			break;
		case "tree_type":	substitute = "Query Type";				break;
		case "tree_datapoints":	substitute = "Data Points";			break;
		case "tree_file_transfer":	substitute = "File Transfer";	break;

		case "tree_bacnet_conf":  substitute = "BACnet Configuration";  	break;

		
		// AJAX
		case "ajax_getData":	substitute = "Get data from server ...";	break;	
		case "ajax_noData":		substitute = "No data available.";		break;	
		case "ajax_getDataReady":	substitute = "Data received.";		break;	
		case "ajax_sendData":	substitute = "Sending data to EWIO ...";	break;	
		case "ajax_sendDataReady":	substitute = "Data sended.";	break;	

		
		// page "main"
		case "main_mb_login":	substitute = "LogIn - State not enough";		break;
		case "main_mb_admin":	substitute = 
			"To make changes on EWIO you have to login as ";		break;											
		case "main_mb_errMsg":	substitute = "Message from EWIO";		break;
		case "main_mb_errLogin":	substitute = 
			"Login Error <br>"+
			"You have been logged out by the system.<br>"
			"Please log in again.";		break;
		case "main_mb_wait":	substitute = "Please wait ...";   	break; 
		case "main_mb_waittext":	substitute = 
			"<br>"+ 	
			"Data will be transceived from / to EWIO.<br>"+
			"This process may take several seconds.";   	
			break; 
		case "main_mb_waitlist":	substitute = 
			"<br>"+ 	
			"File / file list will be created.<br>"+
			"This process may take several seconds.";   	
			break; 
		case "main_input_length":	substitute = 
			"Input incorrectly.<br>"+ 	
			"Exact number of characters be typed: ";
			break; 
		case "main_input_minlength":	substitute = 
			"Input incorrectly.<br>"+ 	
			"Minimum number of characters be typed: ";
			break; 
		case "main_input_maxlength":	substitute = 
			"Input incorrectly.<br>"+ 	
			"Maximum number of characters be typed: ";
			break; 
		case "main_input_char":	substitute = 
			"Input incorrectly.<br>"+ 	
			"Only following characters can be typed: <br>";
			break; 
		case "main_input_char_fail":	substitute = 
			"Input incorrectly.<br>"+ 	
			"You entered an invalid character.";
			break; 
		case "main_input_timeformat":	substitute = 
			"Input incorrectly.<br>"+ 	
			"Entry has correspond exactly to the DB time format: yyyy-mm-dd HH:MM:SS <br><br>"+
			"Example: <br>"+
			"2012-06-01 10:15:00 = 1. Juni 2012, 10.15 Uhr";	
			break; 
		case "main_error_abort":	substitute = 
			"The connection to EWIO-M is brocken. <br>" +
			"Please login again.";	
			break; 



		// page "start"
		case "start_standard":	substitute =
			"Status 'Standard':<br>"+
			"Using that status allows only the reading of settings and data.";
			break;
		case "start_operator":	substitute = 
			"Status 'Operator': <br>"+
			"The operator has limited rights of access."; 
			break;
		case "start_admin":		substitute = 
			"Status 'Administrator': <br>"+
			"Using that status allows unlimited access to the settings.";
			break;
		case "start_login_s":	substitute = "LogIn successful";	break;
		case "start_login_e":	substitute = "Password incorrect";	break;
	

		// page "browser"
		case "browser_check":	substitute =
			"The review of your browser shows:\n\n";
			break;
		case "browser_unknown":	substitute =
			"You are using an unsupported browser.\n"+
			"Therefore, the functionality of the websites are not guaranteed.\n\n";
			break;
		case "browser_ie_old":	substitute =
			"You are using an outdated browser.\n"+
			"You need version 7.0 or better from Internet Explorer.\n\n";
			break;
		case "browser_ff_old":	substitute =
			"You are using an outdated browser.\n"+
			"You need version 3.0 or better from Firefox.\n\n";
			break;
		case "browser_no_dom":	substitute =
			"DOM is not supportet.\n"+
			"Please use a current browser. \n\n";
			break;
		case "browser_no_ajax":	substitute =
			"AJAX is not supportet.\n"+
			"Please use a current browser. \n\n";
			break;
	
	
		// page "devicebase"
		case "dev_devicename":	substitute = "New name will only be effective after reboot.";		break;
		case "dev_msg_nameErr":	substitute = 
			"Only alphanumeric characters and '_' valid. <br>"+
			"Amount of characters max. 255.";	break;
		case "dev_cancel":		substitute = "Cancel";		break;
		case "dev_install_1":	substitute = '"Installation is done."';		break;
		case "dev_install_2":	substitute = '"It will be only effective after reboot."';		break;
		case "dev_install_err":	substitute = "Could not install update.";		break;
		case "dev_waitsend":	substitute = "Please wait ...  Loading selected file.";		break;
		case "dev_text":		substitute = 
			"File is loaded successfull.<br>"+
			"After Click on button update has to be installed.<br>";		break;
		case "dev_reboot":			substitute = "Reboot is running ...";		break; 		
		case "dev_waitreboot":		substitute = 
			"Please wait... <br>"+
			"You will get a new connection.";		break; 		
		case "dev_waitrebootinsec":	substitute = "Wait time in seconds: ";		break;
		case "dev_copy_SD":			substitute = "Selection in progress ...";		break; 		
		case "dev_wait_copy":		substitute = 
			"Please wait ... <br>"+
			"File formatting or data copy can take up to two minutes. <br><br>"+
			"Changes will be valid only after a reboot.";	break;		
		case "dev_file":	substitute = "File";		break;
		case "dev_component":	substitute = "Component:";		break;
		case "dev_sd_options":	substitute = "SD-Card Options";		break;
		case "dev_sd_available":	substitute = "SD-Card available: ";		break;
		case "dev_sd_formatted":	substitute = "SD-Card formatted: ";		break;
		case "dev_sd_bootmedium":	substitute = "Bootet from: ";		break;
		case "dev_sd_config":	substitute = "Progr.-Data on SD-Card: ";		break;
		case "dev_sd_boot":		substitute = "Boot from SD-Card in the future";		break;
		case "dev_sd_copy":		substitute = "Copy now progr.-data from Flash to SD-Card";		break;
		case "dev_sd_format":	substitute = "Format now SD-Card"; 	break;
		case "dev_sd_attention":	substitute = "Attention: Stored data will be overwritten!"; 	break;
		case "dev_no":		substitute = "no";		break;
		case "dev_yes":		substitute = "yes";		break;
		case "dev_update_error":	substitute = "Error: You need an installed sd-card to realize update!"; 	break;
		case "dev_msg_head":	substitute = "Input Error";	break; 
		case "dev_msg_error":	substitute = 
			"There was select none or false file.<br>"+
			"Please select a file with requested name!";	break;


		// page "memory"
		case "mem_bootmedia":	substitute = "boot media: ";		break;
		case "mem_sdcard":	substitute = "not available";		break;
		case "mem_userspace":	substitute = "UserSpace available";		break;
		case "mem_no_userspace":	substitute = "no UserSpace available";		break;
		case "mem_all":		substitute = "Total: ";		break;
		case "mem_used":	substitute = " / Used: ";		break;
		case "mem_sd_memory":	substitute = "Memory: -";		break;
		case "mem_note":	substitute = "Note";		break;
		case "mem_mess_no_sd":	substitute = "Break:<BR> No SD card available.";		break;
		case "mem_mess_overwrite":	substitute = "Attention:<BR> Any stored data will be overwritten.";		break;
		case "mem_mess_sd_used":	substitute = "Break:<BR> You can't copy to SD card because it is in use.";		break;
		case "mem_mess_sd_free":	substitute = "Break:<BR> Free memory on SD card is not sufficient.";		break;
		case "mem_mess_sd_format":	substitute = "Break:<BR> SD card not formatted with ext2.";		break;
		case "mem_mess_sd_stored":	substitute = "Attention:<BR> Any stored data will be overwritten.";		break;
		case "mem_mess_flash_used":	substitute = "Break:<BR> You can't copy to Flash because it is in use.";		break;
		case "mem_mess_flash_free":	substitute = "Break:<BR> Free memory on Flash is not sufficient.";		break;
		case "mem_mess_flash_format":	substitute = "Break:<BR> SD card not formatted.";		break;
		case "mem_mess_flash_stored":	substitute = "Attention:<BR> Any stored data will be overwritten.";		break;
		case "mem_mess_sd_no_userspace":	substitute = "Not boot from SD card. <BR>No UserSpace available.";		break;
		case "mem_mess_wait":	substitute = "Please wait ...";		break;
		case "mem_mess_countdown":	substitute = 
				"Changes are executed.<br><br>"+
				"After time expires, current state will be displayed automatically.<br>";			
				break;
		case "mem_mess_waittime":	substitute = "Waiting period in seconds: ";		break;


		// page "pw"
		case "pw":			substitute = "Password";	break;
		case "pw_OK":		substitute = "Input OK";	break;
		case "pw_error_again":	substitute = "Error: password repeat";	break;
		case "pw_error_min":	substitute = "Error: min. 2 charcters";	break;
		case "pw_error_max":	substitute = "Error: max. 16 characters";	break;
		case "pw_error_char":	substitute = "Error: only alphanumerics and '_'";	break;
		case "pw_error_old":	substitute = "Error: previous password is missing";	break;


		// page "ip"
		case "ip_msg_head":		substitute = "Input Error";	break;
		case "ip_msg_err1":		substitute = "Gateway address not fit in with network.";	break;
		case "ip_msg_err2":		substitute = "Gateway address must not the same as network address.";	break;
		case "ip_msg_err3":		substitute = "Gateway address must not the same as broadcast address.";	break;
		case "ip_msg_err4":		substitute = "All segments of IP-Address have to be digits in a range from 0 to 255.";	break;
		case "ip_msg_err5":		substitute = "All segments of Subnet-Mask have to be digits in a range from 0 to 255.";	break;
		case "ip_msg_err6":		substitute = 
			"All segments of DNS-Server-Address have to be digits in a range from 0 to 255.<br>"+
			"No DNS-Server: leave all segments blank.";	break;
		case "ip_msg_err7":		substitute = 
			"Alle Segmente des Standard-Gateway m&uuml;essen Ziffern im Bereich zwischen 0 und 255 enthalten.<br>"+
			"No Standard-Gateway: leave all segments blank.";	break;
		case "ip_msg_err8":		substitute = 
			"Valid characters: 'A-Z', 'a-z', '0-9', '-'<br>"+
			"Length of hostname max. 63 characters, '-' not at begin or end.";	break;
		case "ip_msg_err9":		substitute = 
			"Length of hostname + domaine must not more than 255 characters.";	break;


		// page "wlan"
		case "wlan_ssid":		substitute = "Network name:";	break;
		case "wlan_coding":		substitute = "Coding:";	break;
		case "wlan_key":		substitute = "Key:";	break;
		case "wlan_man":		substitute = "get IP-Address manually";	break;
		case "wlan_auto":		substitute = "get IP-Address automatically (DHCP)";	break;
		case "wlan_addr":		substitute = "IP-Address:";	break;
		case "wlan_subnet":		substitute = "Subnet-Mask:";	break;
		case "wlan_scan_running":	substitute = "Scan running";	break;
		case "wlan_scan_finished":	substitute = "Scan finished";	break;
		case "wlan_info_auto_head":	substitute = "CONFIGURATION AUTOMATICALLY";	break; 
		case "wlan_info_auto":		substitute = 
			"There successive connection attempts are made:"+
			"1. Connecting to a wireless network with DHCP and with SSID \"ewio_m_d\" <br>"+
			"2. Connecting to a wireless network with static IP-Address and with SSID \"ewio_m_s\" <br>"+
			"3. Connecting to a PC as ad-hoc-connection with SSID \"ewio_m\" (Client) <br> "+
			"4. Create an ad hoc network with SSID \"ewio-m\" (Host) <br><br>"+
			"The key in each case \"riabtrmcqtech\" is set.<br>"+
			"Push button \"BROWSER->EWIO\" to save configuration in EWIO.<br>"+
			"Configuration will be valid after next reboot.";
			break;
		case "wlan_info_man_head":	substitute = "CONFIGURATION MANUALLY";	break; 
		case "wlan_info_man":		substitute = 
			"Push button \"START\" to scan available wireless networks.<br>"+
			"Networks with low level of quality may not be detected in every scan. "+
			"In this case, the scanning should be repeated.<br>"+
			"EWIO-M can be added to networks which operate in master mode and are WPA encrypted. <br>"+
			"With \"select\" you select a network and add the IP configuration. <br><br>"+
			"Push button \"OK\" and then \"BROWSER->EWIO\" to save configuration in EWIO.<br>"+
			"Configuration will be valid after next reboot.";
			break;
 
			
		// page "time"
		case "time_newtime":	substitute = "Set time";	break;
		case "time_newlist":	substitute = "Edit server list";	break;
		case "time_tz":		substitute = "Set timezone";	break;
		case "time_hd_setTime":	substitute = "Set time in progress ... ";	break;
		case "time_wait_setTime":	substitute = "Please wait ... <br>"+
			"Taking a while for set time in EWIO.";	break;  	
		case "time_wait_setTimeInSec":	substitute = "Wait time in seconds: ";		break;


		// page "links"
		case "dev_links_head":	substitute = "Input Error EWIO-Name";	break; 
		case "dev_links_nameErr":	substitute = 
			"Only alphanumeric characters and '_' valid. <br>"+
			"Incorrect name: ";		break;


		// page "application"
		case "app_config":		substitute = "Change Configuration";	break;
		case "app_cancel":		substitute = "Cancel";		break;
		case "app_mb_name":		substitute = "Name of application faulty";	break;
		case "app_mb_othername":	substitute = 
			"Name \"newApplication\" is only a template.\n"+
			"Please choose your own name.";			break;											
		case "app_mb_char":		substitute = 
			"Only the following characters must included in name:\n"+
			"A-Z, a-z, 0-9, _";			break;											
		case "app_mb_login":	substitute = "LogIn - State not enough";		break;
		case "app_mb_admin":	substitute = 
			"To start or stop EWIO you have to login as Administrator or Operator.";		break;											
	
		case "app_change_cycle":	substitute = "Change cycle";	break;
		case "app_cycle_time":		substitute = "Cycle time in ms";	break;
		case "app_port_rw":			substitute = "IO-Port read or write";		break;
		case "app_out_console":		substitute = "Output";	break;
		case "app_port_type":		substitute = "Port type";		break;
		case "app_read":			substitute = "read";		break;
		case "app_write":			substitute = "write";		break;
		case "app_port_select":		substitute = "IO-Port";		break;
				
		case "app_sensor":			substitute = "Convert sensor values";	break;
		case "app_sensor_type":		substitute = "Sensor type";	break;
		case "app_sensor_temp":		substitute = "Temperature";	break;
		case "app_sensor_out":		substitute = "Output";	break;

		case "app_email_from":		substitute = "From";	break;
		case "app_email_to":		substitute = "To";	break;
		case "app_email_user":		substitute = "Username";	break;
		case "app_email_pass":		substitute = "Password";	break;
		case "app_email_subject":	substitute = "Subject";		break;
		case "app_email_text":		substitute = "Text";		break;

	
		//page "log"
		case "log_email_from":		substitute = "From";	break;
		case "log_email_to":		substitute = "To";	break;
		case "log_email_user":		substitute = "Username";	break;
		case "log_email_pass":		substitute = "Password";	break;
		case "log_email_subject":	substitute = "Subject";		break;
		case "log_email_text":		substitute = "Text";		break;
		case "log_email_head":		substitute = "Content Alarm-eMail ";		break;
		case "log_ftp_sendnow":		substitute = "send now";		break;
		case "log_ftp_senddaily":	substitute = "send daily";		break;
		case "log_button_content":		substitute = "Content";	break;
		case "log_button_config_mail":		substitute = "Configuration eMail";	break;
		case "log_button_config_ftp":		substitute = "Configuration FTP";	break;
		case "log_delete_after_send":		substitute = "Delete logfile after sending";	break;
		case "log_ftp_wait":		substitute = "The waiting time is about 5s.";	break;


		//page io
		case "io_hd_setConf":	substitute = "Set configuration in progress ... ";	break;
		case "io_wait_setConf":	substitute = "Please wait ... <br>"+
			"Taking a while for set configuration in EWIO.";		break;  	
		case "io_wait_setTimeInSec":	substitute = "Waiting period in Seconds: ";		break;
		case "io_restart_desc":  substitute =
			"Before making any physical changes to modules, you have to stop this.<br>"+
			"After this change, you start again.";	break;
		case "io_restart_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> No function<br>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Execute selected function.";		break;
		case "io_info_restart_head":	substitute = "IO-DRIVER RESTART";		break;
		case "io_info_restart":	substitute = 
			"Changes to extension modules may not be made during operation. <br>"+
			"Therefor, it is absolutely necessary to stop driver before making changes to the number or address of modules.<br>"+
			"After execution of the work, the driver must be restarted.<br>"+
			"To do this, please press button \"BROWSER -> EWIO\".<br>"+
			"The process takes ca. 20s.";		break;


		//page io_data
		case "io_data_err":	substitute = 
			"Driver is stopped. Please check configuration.";		break;


		// page "mbus_remove"
		case "mbus_remove_mb_waitlist":	substitute = "Counter with following addresses were deleted:";	break; 

	
		// page "mbus_counter_secAddress"
		case "mbus_counter_secAdr_old":	substitute = "Previous Secondary Address: ";	break; 
		case "mbus_counter_secAdr_new":	substitute = "New Secondary Address: ";	break; 
		case "mbus_counter_secAdr_invalid":	substitute = "Secondary address invalid.";	break; 
		case "mbus_counter_secAdr_exist":	substitute = 
			"Seconadry address already exists.<br>Continue anyway?";	break; 


		// page "mbus_counter_primAddress"
		case "mbus_counter_primAdr_old":	substitute = "Previous Primary Address: ";	break; 
		case "mbus_counter_primAdr_new":	substitute = "New Primary Address: ";	break; 
		case "mbus_counter_primAdr_valid":	substitute = "Allowed Characters are 1 ... 249.";	break; 
		case "mbus_counter_primAdr_exist":	substitute = 
			"Primary address already exists.<br>Please select a different address.";	break; 

	
		// page "mbus_add_auto"
		case "mbus_add_breakSearch":	substitute = "Break Searching";		break;
		case "mbus_add_searchOn":	substitute = "Searching";		break;
		case "mbus_add_searchOff":	substitute = "Search completed";		break;
		case "mbus_add_searchBreak":	substitute = "Search canceled";		break;
		case "mbus_add_mess_prim":	substitute = "Primary Addresses of unused counters wil be reset.";		break;
		case "mbus_add_mess_prim_of":	substitute = "Reset Primary Address of <br><b>";		break;
		case "mbus_add_info_bus":	substitute = 
			"For Devices that are connected drectly to the bus, please choose \"MBus\".<br><br>"+
			"If IOs should be used as MBus-Devices, please choose \"System\" "+
			"and the associated driver. <br>"+
			"Please note that the driver must be started before. "; 
			break;


		// page "mbus_counterlist"
		case "mbus_counterlist_error":	substitute = "Input Error";		break;
		case "mbus_counterlist_number":	substitute = 
			" is invalid.<br>"+
			"Position have to be a number between 1 und 250 or void.";		break;
		case "mbus_counterlist_multiple":	substitute = 
			" is included in the list several times.<br>"+
			"It must be unique.";		break;
		case "mbus_counterlist_note_head":		substitute = "NOTE";	break; 
		case "mbus_counterlist_no":		substitute = "There are no counter.";	break; 
		case "mbus_counterlist_info_position":	substitute = 
			"It is determined by the position in wich order counter will be read out at the cyclic query.<br>"+
			"Order can be changed by changing assignment of the position to a bus address.<br><br>"+
 			"The value of the position have to be in a range of 1 ... 250 and must be unique.<br><br>"+
			"If input field is empty, this counter is not queried.";
			break;


		// page "mbus_sync"
		case "mbus_sync_info_head_sync":		substitute = "SYNC-PULSE";	break; 
		case "mbus_sync_info_sync":		substitute = 
			"When using a Sync Pulse, the measured value query no longer triggered by timing, but by this Sync Pulse.<br><br>"+
			"Precondition: <br> "+
			"In menu item \"Device/Configuration/IO/mct_pin_di_x\" (x=0..3) mode have to set to \"direct\". <br><br> "+
			"Changes on this page will not take effect until after a reboot. ";	 
			break;
		case "mbus_sync_info_head_polling":		substitute = "SAMPLING";	break; 
		case "mbus_sync_info_polling":		substitute = 
			"Setting sampling for detection of Sync Pulse. <br><br>"+
			"The sampling rate must be chosen so that the Sync Pulse is detected reliably. <br>"+
			"For this purpose it should be graeter then half length of the Sync Pulse. <br>"+
			"It should also not less then necessary to avoid unnecassary load on the system. <br><br>"+
			"Example: <br>"+
			"Pulse = 9s requires sampling of 4.5s ";
			break;


		// page "mbus_output"
		case "mbus_output_info_head":	substitute = "PARAMETER OUTPUT";	break; 
		case "mbus_output_info":		substitute = 
			"Summary of parameters of a counter in the form of text. <br><br>"+
			"Parameters can be downloaded as a file on the PC. <br>"+
			"This can be opened with an editor program like Notepad++ and printed out.";			
			break;

	
		// page "mbus_config"
		case "mbus_config_counter":	substitute = "Configuration Counter";	break;
		case "mbus_config_error":	substitute = "Configuration Error";	break;
		case "mbus_config_error_no_br":	substitute = "There was no baudrate selected.";	break;
		case "mbus_config_error_no_bus":	substitute = "There was no bus selected.";	break;
		case "mbus_config_error_sync":	substitute = "Der ausgew&auml;hlte Port wird bereits als Synchronpuls-Eingang verwendet";		break;
		case "mbus_config_error_sync":	substitute = "Selected port is already used as input for Sync Pulse.";		break;
		case "mbus_config_err":	substitute = "Error";	break;
		case "mbus_config_err_noanswer":	substitute = "Counter has not responded.";	break;
		case "mbus_config_err_invalid":		substitute = "Invalid response from counter.<br>" +
														 "(excessive cable length, same primary addresses, ...)";	break;
		case "mbus_config_err_unknown":	substitute = "An unknown error has occurred.";		break;
		case "mbus_config_standard":	substitute = "Standard MBus-Counter";		break;
		case "mbus_config_extended_info":	substitute = "Extended informations";		break;

		case "mbus_config_meas_point":	substitute = "MeasurPoint";		break;
		case "mbus_config_counter_type":	substitute = "Counter type:";		break;
		case "mbus_config_addr_primary":	substitute = "Primary addressing";		break;
		case "mbus_config_counter_nr":	substitute = "Counter number";		break;
		case "mbus_config_counter_client":	substitute = "Client";		break;
		case "mbus_config_counter_customer":	substitute = "Customer number";		break;
		case "mbus_config_counter_optional":	substitute = "The information on this register tab is optional.";		break;
		case "mbus_config_counter_country":	substitute = "Country";		break;
		case "mbus_config_counter_plz":	substitute = "Zip code";		break;
		case "mbus_config_counter_operator":	substitute = "Operator";		break;
		case "mbus_config_counter_meas_id":	substitute = "Measuring point ID";		break;

		case "mbus_config_channel_interval":	substitute = "Interval:";		break;
		case "mbus_config_channel_readout":		substitute = "Readout from";		break;
		case "mbus_config_channel_factor":	substitute = "Factor U, I";		break;
		case "mbus_config_channel_app":		substitute = "Application:";		break;
		case "mbus_config_channel_mtype":			substitute = "Measurement type";		break;
		case "mbus_config_channel_mtype_normal":	substitute = "Normal";		break;
		case "mbus_config_channel_mtype_average":	substitute = "Average";		break;
		case "mbus_config_channel_initial_count":	substitute = "Initial count";		break;
		case "mbus_config_channel_initial_pulse":	substitute = "Initial pulse";		break;
		case "mbus_config_channel_pulsperunit":		substitute = "Pulse / unit";		break;
		case "mbus_config_channel_edit_unit":		substitute = "Unit";		break;
		case "mbus_config_channel_edit_factor":		substitute = "Factor";		break;
		case "mbus_config_channel_primaer":		substitute = "Prim. Counter:";		break;
		case "mbus_config_channel_primaer_yes":		substitute = "yes";		break;
		case "mbus_config_channel_primaer_no":		substitute = "no";	break;
		case "mbus_config_channel_sensor":		substitute = "Sensor type:";		break;
		case "mbus_config_channel_resistor":		substitute = "Resistance value";		break;
		case "mbus_config_channel_offset":		substitute = "Temp. Offset";		break;
		case "mbus_config_channel_obis":		substitute = "OBIS code";		break;
		case "mbus_config_channel_description":		substitute = "Description";		break;
		case "mbus_config_channel_no_param":	substitute = "No more parameter.";   	break; 
		case "mbus_config_channel_input_error":	substitute = "Input error";   	break; 
		case "mbus_config_channel_config_error":	substitute = "Configuration error";   	break; 
		case "mbus_config_channel_input_country":	substitute = "Land has to contain 2 characters.";   	break; 
		case "mbus_config_channel_input_operator":	substitute = "Operator has to contain 6 numbers.";   	break; 
		case "mbus_config_channel_input_plz":	substitute = "Zip code has to contain 5 numbers.";   	break; 
		case "mbus_config_channel_input_meas_id":	substitute = "Measuring point ID has to contain 20 characters.";   	break; 
		case "mbus_config_channel_input_delimeter":	substitute = "Decimal seperator must be specified as point.";   	break; 
		case "mbus_config_channel_input_startpuls":	substitute = "Warning: Button on S0/M-Converter was not pressed. "+
			 "Therefore the initial pulse state may not be correct.";		break;

		case "mbus_config_message_note":	substitute = "NOTE";   	break; 
		case "mbus_config_message_mp":		substitute = 
			"You don't have edit data for measurement points <br>" +
			"(Button: EWIO -> BROWSER). <br><br>" +
			"If you go on, possibly stored measurement points will be deleted.";		
			break;
		case "mbus_config_message_wait":	substitute = "Please wait ...";   	break; 
		case "mbus_config_message_wait_EWIO":	substitute = "Waiting for response from EWIO, a max. of ";   	break; 
		case "mbus_config_message_wait_MBus":	substitute = "Waiting for response from MBus, a max. of ";   	break; 
		case "mbus_config_message_counter_store":	substitute = "Counter parameter will be stored";   	break; 
		case "mbus_config_message_counter_channel":	substitute = ". data point will be stored.";   	break; 
		case "mbus_config_message_counter_primary":	substitute = "Primary address will be set.";   	break; 
		case "mbus_config_message_counter_set_prim":	substitute = "Primary address will be set.";   	break; 
		case "mbus_config_message_counter_reset_prim":	substitute = "Primary address will be reset.";   	break; 

		case "mbus_config_info_bus":		substitute = 
			"For devices directly connected to the MBus, please select \"MBus\". <br><br>"+
			"If IOs of EWIO-M should be used as MBus devices, please select \"System\" "+
			"and the relevant driver for this port. <br>"+
			"Please note that the driver must be started before using.";
			break;
		case "mbus_config_info_devicename_head":	substitute = "DEVICE NAME";	break; 
		case "mbus_config_info_devicename":	substitute = 
			"Definition of the name with wich counter is stored in the system. <br>"+
			"As default name the bus ID will be used. <br><br>"+					
			"Please note following conditions if changing the name: <br>"+					
			"Only characters in the range of A...Z, a...z, 0...9 ,-_ may be used.";	
			break; 
		case "mbus_config_info_mbusid_head":	substitute = "MBUS-ID";	break; 
		case "mbus_config_info_mbusid":	substitute = 
			"The MBus-ID is an unique address of a counter or module on MBus. <br>"+
			"It is assigned by the manufacturer and can (usually) not be changed.";
			break; 
		case "mbus_config_info_devicetype_head":	substitute = "DEVICE TYPE";	break; 
		case "mbus_config_info_devicetype":	substitute = 
			"Set by default is \"Standard MBus Counter\". <br><br>"+
			"However, where the device is a 4xS0/M-Converter made by BTR or internal S0-Input (S01-S04), "+
			"so set \"4xS0/M-Converter, DIx/S0x\".<br><br>"+
			"Is the device a 4xT/M-Converter made by BTR or internal analog input (AI1, AI2), so set \"4xT/M-Converter, AIx\". <br>";
			break; 
		case "mbus_config_info_primary_head":	substitute = "PRIMARY ADDRESSING";	break; 
		case "mbus_config_info_primary":	substitute = 
			"The counter can be assigned a primary address. <br>"+
			"Thus, the readout of the counter will be speeded up because of less telegramms per request."; 					
			break; 
		case "mbus_config_info_client_head":	substitute = "CLIENT";	break; 
		case "mbus_config_info_client":	substitute = 
			"Here is a distinction possible between different aspects, for example, different customers."; 
			break; 
		case "mbus_config_info_counternr_head":	substitute = "COUNTER NUMBER";	break; 
		case "mbus_config_info_counternr":	substitute = 
			"Here, the registration number of counter can be signed in.";					
			break; 
		case "mbus_config_info_customernr_head":	substitute = "CUSTOMER NUMBER";	break; 
		case "mbus_config_info_customernr":	substitute = 
			"Here is a distinction possible between different organizationals aspects, for example, different data evaluator.";
			break; 
		case "mbus_config_info_meteringcode_head":	substitute = "METERING CODE";	break; 
		case "mbus_config_info_meteringcode":	substitute = 
			"The Metering Code is a world wide unambiguous identification of a measuring point. <br>"+
			"It is used to uniquely identify in large networks and is made up of different components: <br>"+ 
			"Country = for example DE for Germany (2 alphanumeric characters) <br>"+
			"Zip code (5 numbers) <br>"+
			"Operator = Network Operator Identification (6 numbers) <br>"+ 
			"Measuring Point ID - Identification (20 alphanumeric characters)"; 
			break; 
		case "mbus_config_info_interval_head":	substitute = "INTERVAL";	break; 
		case "mbus_config_info_interval":	substitute = 
			"Determining time interval in which counters are readed out. <br><br>"+			
			"Following values available: <br>"+
			"1 min <br>"+					
			"5 min (00:00, 00:05, 00:10, ... ) <br>"+					
			"15 min (00:00, 00:15, 00:30, 00:45, 01:00, ... ) <br>"+					
			"30 min (00:00, 00:30, 01:00, ... ) <br>"+
			"1 h (00:00, 01:00, 02:00, ... ) <br>"+
			"2 h (00:00, 02:00, 04:00, ... ) <br>"+
			"4 h (00:00, 04:00, 08:00, ... ) <br>"+
			"6 h (00:00, 06:00, 12:00, ... ) <br>"+
			"12 h (00:00, 12:00, ... ) <br>"+
			"daily (00:00) <br>"+
			"weekly (Montags 00:00) <br>"+
			"monthly (1.1. 00:00, 1.2. 00:00, ...) <br>"+
			"quarterly (1.1. 00:00, 1.4. 00:00, ...) <br>"+
			"half-yearly (1.1. 00:00, 1.7. 00:00, ...) <br>"+
			"yearly (1.1.2000 00:00, 1.1.2001 00:00, ...) <br>"+
			"none (no cyclic read out) <br>";
			break;
		case "mbus_config_info_readout_head":	substitute = "READOUT FROM";	break; 
		case "mbus_config_info_readout":	substitute = 
			"The counter will not be readed out before the registered date.<br><br>"+			
			"The first real read out date apend from configuration of parameter \"Interval\".";
			break;
		case "mbus_config_info_factor_head":	substitute = "FACTOR";	break; 
		case "mbus_config_info_factor":	substitute = 
			"In some cases measurement value have to multiplied by a factor, "+
			"for example if connected a prescaler with the counter. <br><br>"+
			"In this case please specify factor U (voltage divider) respectively I (current divider). <br>"+
			"From the two factors and the measured value then the final value will be calculated and written to the database. <br><br>"+			
			"In all other cases leave the factors to 1.";
 			break;
		case "mbus_config_info_app_head":	substitute = "APPLICATION";	break; 
		case "mbus_config_info_app":	substitute = 
			"Selection of the application which is to be applied to the readed data. <br>"+
			"If you select \"none\", no application will be used. <br><br>"+		
			"Please note: <br>"+
			"For an application to be executed, ist must have been started in the folder \"Application\". <br><br>"+
			"Details: <br>"+	
			"The application receives as parameter the name of the file that contains the measured values "+
			"and the number of required data point. <br>"+
			"After processing by the application modified MBus file is read again and the measured value will be stored "+
			"in data base. "; 
			break;
		case "mbus_config_info_mtype_head":	substitute = "MEASUREMENT TYPE";	break; 
		case "mbus_config_info_mtype":	substitute = 
			"Select the type of measurement. <br>"+
			"The following types are possible: <br><br>"+
			"\"Normal\" - <br>"+
			"The original measured value is used. <br><br>"+					
			"\"Average\" - <br>"+
			"The measured value is checked every minute. <br>"+
			"After intervall has expired, a mean value is calculated from the sampled measured values and this is stored in the database.";
			break;
		case "mbus_config_info_counterstart_head":	substitute = "INITIAL COUNT";	break; 
		case "mbus_config_info_counterstart":	substitute = 
			"Please enter the counter read showing on the counter. <br>"+
			"The number of entered decimal places will be taken into account. <br><br> "+
			"Background: <br>"+
			"To get identity between stored data an shown data on the counter this value have to be added on calculation: <br><br> "+
			"counter read = <br>"+
			"((total pulse state - start puls state) / puls per unit) + start counter state ";
			break;
		case "mbus_config_info_pulsstart_head":	substitute = "INITIAL PULS";	break; 
		case "mbus_config_info_pulsstart":	substitute = 
			"This field is automatically filled. It can not be changed. <br><br> "+
			"Background: <br>"+
			"This value is the puls state, which had already stored the S0/M-Converter during installation. "+ 
			"Because of security reasons S0/M-Converter can not be reset. <br>"+	
			"Therefore, this amount must be deducted from the new coming pulses. <br>"+
			"If \"Check !!\" is displayed, then the installation button of S0/M-Converter was not pressed. <br>" +
			"In this case, check whether the initial pulse is still correct."; 
			break;
		case "mbus_config_info_pulsperunit_head":	substitute = "PULSE / UNIT";	break; 
		case "mbus_config_info_pulsperunit":	substitute = 
			"Enter here the amount of pulse/unit the counter outputs on his S0 interface. "; 
			break;
		case "mbus_config_info_factorEdit_head":	substitute = "FACTOR";	break; 
		case "mbus_config_info_factorEdit":	substitute = 
			"Enter here the factor of measurement, the stored values to be multiplied. <br> "+
			"Initial value is the factor in parameter \"UNIT\" supplied by MBus. <br>"+
			"If the measured value, multiplied by this factor, should be stored in database, "+
			"the corresponding application (\"factor_include\") must be selected.";
			break;
		case "mbus_config_info_unit_head":	substitute = "UNIT";	break; 
		case "mbus_config_info_unit":	substitute = 
			"Enter here the unit of measurement, the stored values to be assigned. <br> "+
			"This can be kWh, m3 or an any other unit. <br> "+
			"Initial value is the unit in parameter \"UNIT\" supplied by MBus. <br>"+
			"Since especially S0/M-Converters measures only pulses, the unit must be entered manually.";
			break;
		case "mbus_config_info_primaer_head":	substitute = "PRIMARY COUNTER";	break; 
		case "mbus_config_info_primaer":	substitute = 
			"Selection whether it is at the relevant counter by a primary counter. <br> "+
			"Primary counter are electronic meters, which include presentation of count with conversion factors. <br><br>"+
			"no: Display meter reading without conversion factors <br>"+
			"yes: Display meter reading involving conversion factors <br><br>"+
			"Presentation of the count you will find in \"MBus/data/counter\", <br>\"Current data\"."; 
			break;
		case "mbus_config_info_sensor_head":	substitute = "SENSOR TYPE";	break; 
		case "mbus_config_info_sensor":	substitute = 
			"Listbox contains all connectable temperature sensors. <br>"+
			"Please select those who were connected at the input. <br>"+
			"Alternatively, the resisitance value can be selected. <br><br>"+
			"So selected measurement value will be shown in Tele 1, Rec 3. <br>"+	
			"Selected list number will be shown (started with 0) in Tele 1, Rec 4. <br><br>"+	
			"Background: <br>"+
			"The T/M-Converter measures the resistance value of the sensors and converts these "+
			"selected according to the characteristic curve into a temperature value.";
			break;
		case "mbus_config_info_offset_head":	substitute = "TEMPERATURE OFFSET";	break; 
		case "mbus_config_info_offset":	substitute = 
			"Input of an offset value in steps of 1/10&deg;C. <br> "+
			"This makes it possible to correct the measured value by a small amont.	<br><br> "+			
			"The corrected value will be shown after configuration in Tele 1, Rec 5. <br> "+	
			"Example: <br>"+
			"Input: 0.5 -> measured value + 0.5 &deg;C <br> "+
			"Input: -0.5 -> measured value - 0.5 &deg;C <br><br> "+
			"Regardless, it is also the possibility of automatic cable length compensation. <br>"+		
			"(See also the leaflets to the Converter.) <br>"+
			"A value there is set will be shown in Tele 1, Rec 2. <br><br> "+
			"Background: <br>"+
			"The correction value is added in the T/M-Converter to the measured value.";
			break;
		case "mbus_config_info_obis_head":	substitute = "OBIS CODE";	break; 
		case "mbus_config_info_obis":	substitute = 
			"About OBIS Code a measurement value can be identified. <br>"+
			"If necessary, you would enter the appropiate OBIS Code to the measurement value. <br><br>"+
			"Example: 1-0:1.8.0*255";
			break;
		case "mbus_config_info_description_head":	substitute = "DESCRIPTION";	break; 
		case "mbus_config_info_description":	substitute = 
			"Using this entry, the function of data point can be descripted in more detail.<br>"+
			"Initial value is the parameter \"DESCRIPTION\" supplied by MBus.";
			break;
		case "mbus_config_info_freeze_head":	substitute = "FREEZE";	break; 
		case "mbus_config_info_freeze_0":	substitute = "Current value: ";	break;
		case "mbus_config_info_freeze_1":	substitute = "Freeze value: ";	break;
		case "mbus_config_info_freeze_2":	substitute = 
			"Background: <br>"+
			"A Freeze Value is a value which is \"frozen\" at a particular time. <br><br>"+
			"Example: <br>"+
 			"At a given point in time (interval time), all counters are queried. <br>"+ 
			"Because the counters are queried one after the other, is the actuel date of reading more or less behind the time-interval.<br>"+
			"To avoid this delay, the interval time a \"Freeze\" command is sent. "+
			"Then save all counters with this feature the measured value exactly at this time. ";
			break;
		case "mbus_dp_1":	substitute = "The total number of data points is limited to: ";	break;
		case "mbus_dp_2":	substitute = "Data points already saved: ";	break;
		case "mbus_dp_3":	substitute = 
			"The storage of the now selected points would exceed the total number of data points.<br><br>"+
			"Please reduce the selected data points by ";	break;


		// page "mbus_presence"
		case "mbus_presence_button_head":	substitute = "NOTE";	break; 
		case "mbus_presence_button_content":		substitute = 
			"Button \"BROWSER -> EWIO\" has no function.";		break; 
		case "mbus_presence_error_head":	substitute = "ERROR";	break; 
		case "mbus_presence_error_content":		substitute = 
			"The counter has not responded.";		break; 


		// page "mbus_data"
		case "mbus_data_note_head":		substitute = "NOTE";	break; 
		case "mbus_data_error_head":	substitute = "ERROR";	break; 
		case "mbus_data_button_content":		substitute = 
			"Button \"BROWSER -> EWIO\" has no function.";		break; 
		case "mbus_data_point":	substitute = "Data point";	break;
		case "mbus_data_first":	substitute = "First data";	break;
		case "mbus_data_last":	substitute = "Last data";	break;
		case "mbus_data_from":	substitute = "Data from ";	break;
		case "mbus_data_format":	substitute = "Format: yyyy-mm-dd HH:MM";	break;
		case "mbus_data_maxvalue":	substitute = "There are a max. of 24 values/db are output.";	break;
		case "mbus_data_time_error":	substitute = "time input error: ";	break;
		case "mbus_data_counter_error":	substitute = "Counter has not responded.";	break;
		case "mbus_data_no_answer":	substitute = "No answer from EWIO.";	break;
		case "mbus_data_error_answer":	substitute = 
			"Response from meter incorrectly <br> "+
			"(cable length too high, same primary addresses).";	break;
		case "mbus_data_unknown_error":	substitute = "An unknown error has occured";	break;
		case "mbus_data_parameter":	substitute = "Please first select parameters.";	break;
		case "mbus_data_no":	substitute = "There are no data.";	break;

		case "mbus_data_digits_year":	substitute = "Number of digits / year";	break;
		case "mbus_data_digits_month":	substitute = "Number of digits / month";	break;
		case "mbus_data_digits_day":	substitute = "Number of digits / day";	break;
		case "mbus_data_digits_hour":	substitute = "Number of digits / hour";	break;
		case "mbus_data_digits_minute":	substitute = "Number of digits / minute";	break;
		case "mbus_data_time_format":	substitute = "Formatfehler";	break;
		case "mbus_data_time_year":	substitute = "year";	break;
		case "mbus_data_time_month":	substitute = "month";	break;
		case "mbus_data_time_day":	substitute = "day";	break;
		case "mbus_data_time_hour":	substitute = "hour";	break;
		case "mbus_data_time_minute":	substitute = "minute";	break;
		case "mbus_data_time_second":	substitute = "second";	break;
		case "mbus_data_time_process":	substitute = "Data are processed.";	break;

		case "mbus_data_info_currentData_head":	substitute = "CURRENT DATA";	break; 
		case "mbus_data_info_currentData":	substitute = 
			"Reading the latest information directly fom MBus. <br><br>"+
			"In column \"VALUE\" of the MBus readed measurement value is displayed. <br>"+
			"if the corresponding counter is a primary counter (\"PRIM CTR\" = yes), "+
			"measurement value contains transducer factors, if any. <br> "+
			"So \"VALUE\" corresponds to the display of the counter. <br><br> "+
			"If the corresponding counter is not a primary counter (\"PRIM CTR\" = no), "+
			"\"VALUE\" will not calculated with transducer factors. <br> "+
			"In column \"CALCULATE\" is displayed calculated measurement value (included transducer factors and application), "+
			"how will be storaged in database (with button \"SAFE\"). "; 
			break;

		// page server_format
		case "format_head_metering_point":	substitute = "Metering Code";	break;
		case "format_head_counter_number":	substitute = "Counter Number";	break;
		case "format_head_client":	substitute = "Client";	break;
		case "format_head_customer_number":	substitute = "Customer Number";	break;
		case "format_head_counter_name":	substitute = "Counter Name";	break;
		case "format_head_obis_code":	substitute = "OBIS Code";	break;
		case "format_head_data_point":	substitute = "Data Point";	break;
		case "format_head_unit":	substitute = "Unit (MBUS)";	break;
		case "format_head_mbusid":	substitute = "MBus-ID";	break;
		case "format_head_prim_counter":	substitute = "Primary Cntr";	break;
		case "format_head_factor_u":	substitute = "Factor U";	break;
		case "format_head_factor_i":	substitute = "Factor I";	break;
		case "format_head_s0m_start_counter":	substitute = "S0/M-initial count";	break;
		case "format_head_s0m_start_impuls":	substitute = "S0/M-initial puls";	break;
		case "format_head_s0m_pulsPerUnit":	substitute = "S0/M-Puls/Unit";	break;
		case "format_head_change":	substitute = "Last change";	break;
		case "format_head_description":	substitute = "Description";	break;
		case "format_head_factor_edit":	substitute = "Factor (EDIT)";	break;
		case "format_head_unit_edit":	substitute = "Unit (EDIT)";	break;
		case "format_head_application":	substitute = "Application";	break;
		case "format_data_timestamp":	substitute = "Timestamp";	break;
		case "format_data_value":	substitute = "Value";	break;
		case "format_data_flags":	substitute = "Flags";	break;
		case "format_timestamp_one":	substitute = "Date/Time together";	break;
		case "format_timestamp_two":	substitute = "Date/Time divided";	break;
		case "format_sep_semicolon":	substitute = "Semicolon";	break;
		case "format_sep_comma":	substitute = "Comma";	break;
		case "format_sep_space":	substitute = "Space";	break;
		case "format_sep_tab":	substitute = "Tabulator";	break;
		case "format_sep_cat":	substitute = "Concatenation";	break;
		case "format_sep_point":	substitute = "Point";	break;
		case "format_time_date":	substitute = "Date";	break;
		case "format_time_time":	substitute = "Time";	break;


		// page server_cyclic_type
		case "cyclic_type_config":		substitute = "Configuration";		break;
		case "cyclic_type_descr_0":		substitute = "last quarter of an hour, i.e. 00:01 - 00:15";		break;
		case "cyclic_type_descr_1":		substitute = "last hour, 00:01 - current hour, 00:00";		break;
		case "cyclic_type_descr_2":		substitute = "yesterday, 00:01 - today, 00:00";		break;
		case "cyclic_type_descr_3":		substitute = "Mo last week, 00:01 - Mo current week, 00:00";		break;
		case "cyclic_type_descr_4":		substitute = "1. day of last month, 00:01 - 1. day of current month, 00:00";		break;
		case "cyclic_type_descr_5":		substitute = "1. day of last quarter, 00:01 - 1. day of current quarter, 00:00";		break;
		case "cyclic_type_descr_6":		substitute = "1. day of last half-year, 00:01 - 1. day of current half-year, 00:00";		break;
		case "cyclic_type_descr_7":		substitute = "1.1. of last year, 00:01 - 1.1. of current year, 00:00";		break;
	
		case "cyclic_type_ftp_server":		substitute = "Server";		break;
		case "cyclic_type_ftp_username":	substitute = "Username";	break;
		case "cyclic_type_ftp_password":	substitute = "Password";	break;
		case "cyclic_type_ftp_port":		substitute = "Port";		break;
		case "cyclic_type_ftp_wait":		substitute = "The waiting time is about 10s.";	break;

		case "cyclic_type_info_push_head":	substitute = "PUSH MODE";	break; 
		case "cyclic_type_info_push":	substitute = 
			"In Push Mode EWIO transmitted by its own reading files to one or two FTP server. <br>"+	
			"In addition, reading files are also sent to up to two e-mail addresses. <br>"+			
			"Here, both the files from individual data points (.cvs) as well as a packed file (.tar.bz2) are sent. <br>"+
			"Packed file contains individual cvs files. <br>"+
			"The tar format can be decompressed with a common program like \"7-Zip\". <br>"+
			"After decompression data files are available in cvs format again. <br><br>"+			
			"Name convention: <br>"+
			"name_dpx_yymmdd.csv, where \"name\" stands for the devicename, x for the data point and yymmdd_hhmm for end date.";		
			break;

		case "cyclic_type_info_poll_head":	substitute = "POLL MODE";	break; 
		case "cyclic_type_info_poll":	substitute = 
			"In Poll Mode data files can be fetched from the EWIO via FTP client. <br>"+
			"As client you can use a special program like \"Filezilla\"	or also a web-browser (\"ftp://(ip-adr)/usr/database/interval\"). <br>"+		
			"As login parameters have to be used: <br>"+
			"Username: root <br>"+
			"Password: (Password for the Linux-System on EWIO) <br><br>"+
			"The path to reading files is \"(config)/usr/database/interval\". <br>"+
			"Here, both the files from individual data points (.cvs) as well as a packed file (.tar.bz2) are sent. <br>"+
			"Packed file contains individual cvs files. <br>"+
			"The tar format can be decompressed with a common program like \"7-Zip\". <br>"+
			"After decompression data files are available in cvs format again. <br><br>"+			
			"Name convention: <br>"+
			"name_dpx_yymmdd_hhmm.csv, where \"name\" stands for the devicename, x for the data point and yymmdd_hhmm for end date. <br>"+	
			"The files are generated after each interval expired. They are available till beginning of the next interval. "+
			"They are after then deleted. ";
			break;


		// page mbus_config_datapoints
		case "mbus_datapoints_note_head":		substitute = "NOTE";	break; 
		case "mbus_datapoints_no":		substitute = "There are no data points.";	break; 
		case "mbus_datapoints_button_content":		substitute = 
			"Button \"BROWSER -> EWIO\" has no function.";		break; 
		case "mbus_datapoints_info_head":	substitute = "DATA POINT LIST";		break; 
		case "mbus_datapoints_info":	substitute = 
			"This list gives an overview of all available data points. <br>"+ 
			"The data points addressing the configured measurement values. <br> "+
			"By their specification is an assignment of the output files to the measured values possible. <br><br> "+
			"By specifying a data point also values can be set or read over the counter API. ";
			break;


		// page server_man_download
		case "man_download_download":	substitute = 
			"The reading file was created with the specified parameters. <br> "+
			"It can now be accessed via download.";
			break;
		case "man_download_info":	substitute = 
			"Data files to any or even all data points can be stored on the PC via download. <br>"+
			"The used data format is csv (\"comma separated values\"), "+
			"which can be directly evaluated by spreadsheet programs. <br><br>"+
			"Possibly need to change the format can be made with \"Data Server/manually/Query Format\". <br><br>"+	
			"If all files are selected, download will be done as packed file in tar format. <br>"+
			"The tar format can be decompressed with a common program like \"7-Zip\". <br>"+
			"After decompression data files are available in cvs format again. <br><br>"+			
			"Name convention: <br>"+
			"name_dpx_yymmdd_hhmm.csv, where \"name\" stands for the devicename, x for the data point and yymmdd_hhmm for end date.";	
			break;


		// page calendar
		case "calendar_month":	substitute = 
			['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
			break;
		case "calendar_days":	substitute = 
			['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'];
			break;
		case "calendar_note_head":		substitute = "NOTE";	break; 
		case "calendar_error_input":	substitute = "Time input errors: ";	break; 
		case "calendar_error_incomplete_date":	substitute = "Date incomplete";	break; 
		case "calendar_error_digits_day":	substitute = "Number of digits / day";	break; 
		case "calendar_error_digits_month":	substitute = "Number of digits / month";	break; 
		case "calendar_error_digits_year":	substitute = "Number of digits / year";	break; 
		case "calendar_error_incomplete_time":	substitute = "Time incomplete";	break; 
		case "calendar_error_digits_hour":	substitute = "Number of digits / hour";	break; 
		case "calendar_error_digits_minute":	substitute = "Number of digits / minute";	break; 
		case "calendar_error_year":	substitute = "year";	break; 
		case "calendar_error_month":	substitute = "month";	break; 
		case "calendar_error_day":	substitute = "day";	break; 
		case "calendar_error_hour":	substitute = "hour";	break; 
		case "calendar_error_minute":	substitute = "minute";	break; 
		case "calendar_error_second":	substitute = "second";	break; 


		// page param_config
		case "param_config_note_head":		substitute = "NOTE";	break; 
		case "param_config_button_content":		substitute = 
			"Button \"BROWSER -> EWIO\" has no function.";		break; 
		case "param_config_download":		substitute = "With click to DOWNLOAD the selected file is copied from the EWIO.";	break; 
		case "param_config_download_mbus":		substitute = "With click to DOWNLOAD the MBus/Modbus configuration file is copied from the EWIO.";	break; 
		case "param_config_upload_conf":	substitute = "With click to UPLOAD the selected configuration file is copied to the EWIO.";	break; 
		case "param_config_upload_app":	substitute = "With click to UPLOAD the selected application file is copied to the EWIO.";	break; 
		case "param_config_upload_mbus":	substitute = "With click to UPLOAD the selected MBus/Modbus configuration file is copied to the EWIO.";	break; 


		// page param_data
		case "param_data_note_head":		substitute = "NOTE";	break; 
		case "param_data_button_content":		substitute = 
			"Button \"BROWSER -> EWIO\" has no function.";		break; 
		case "param_data_all":		substitute = "Total: ";		break;
		case "param_data_used":	substitute = " / Used: ";		break;
		case "param_data_comp":	substitute = " (compressed)";		break;
		case "param_data_download_back":	substitute = "With click to DOWNLOAD the Back File is copied from the EWIO.";	break; 
		case "param_data_download_value":	substitute = "With click to DOWNLOAD the Reading File is copied from the EWIO.";	break; 
		case "param_data_upload_back":	substitute = "With click to UPLOAD the selected Back File is copied to the EWIO.";	break; 
		case "param_data_upload_value":	substitute = "With click to UPLOAD the selected Reading File is copied to the EWIO.";	break; 
		case "param_data_info_head":	substitute = "MEMORY LEVEL";		break; 
		case "param_data_info":	substitute = 
			"Indication of the level of database in the selected memory area. <br> "+			
			"If the Reading File filled, it is automatically converted to Back File. <br>"+
			"An existing Back File will be overwritten.";
			break;


		// page modbus_rs485
		case "modbus_rs485_repeat":	substitute = "Repeat";	break; 
		case "modbus_rs485_timeout_frame":	substitute = "Timeout Frame";	break; 
		case "modbus_rs485_timeout_byte":	substitute = "Timeout Byte";	break; 
		case "modbus_rs485_error_min": 	substitute = 
			"Entry is incorrect.<br>"+
			"The entered value must not be less than: <br>";		break; 
		case "modbus_rs485_error_max": 	substitute = 
			"Entry is incorrect.<br>"+
			"The entered value must not be greater than: <br>";		break; 
		case "modbus_rs485_info_repeat_head":	substitute = "REPEAT";	break; 
		case "modbus_rs485_info_repeat":	substitute = 
			"Number of repetitions, if a device does not respond to the frames. <br><br>"+
			"The range of values is 0 ... 10. <br>"+
			"The basic setting is 2 (for a total of up to 3 attempts).";	break;			
		case "modbus_rs485_info_timeout_frame_head":	substitute = "TIMEOUT FRAME";	break; 
		case "modbus_rs485_info_timeout_frame":	substitute = 
			"Timeout in milliseconds, which is provided at the Modbus/RTU interface for the response of Modbus device. <br>"+
			"It includes the time from the end of a command to the beginning of the response from Modbus device. <br><br>"+
			"The range of values is 0 ... 400 ms. <br>"+
			"The basic setting is 100 ms.";	break;			
		case "modbus_rs485_info_timeout_byte_head":	substitute = "TIMEOUT BYTE";	break; 
		case "modbus_rs485_info_timeout_byte":	substitute = 
			"Timeout in milliseconds, which is provided at the Modbus/RTU interface for the bytes inside response of Modbus device. <br>"+
			"It includes delays between bytes, caused by the Modbus device or Operating System. <br><br>"+
			"The range of values is 0 ... 400 ms. <br>"+
			"The basic setting is 100 ms.";	break;			
		case "modbus_rs485_info_io_head":	substitute = "CHECK INTERNAL IOS";	break; 
		case "modbus_rs485_info_io":	substitute = 
			"With the IOs in EWIO-M and in the extended modules may be connected can be communicated through Modbus/TCP. <br>"+
			"By activating the checkbox, modbus gateways will be started for these IOs. <br>"+
			"The ports for addressing are composed of the port numbers of these modules for Modbus/RTU + 8000. <br><br>"+
			"Assignment:<br>"+
			"mct_pin_di_0: port = 8200 <br>"+
			"mct_pin_di_1: port = 8201 <br>"+
			"mct_pin_di_2: port = 8202 <br>"+
			"mct_pin_di_3: port = 8203 <br>"+
			"mct_spi_dio: port = 8210 <br>"+
			"mct_spi_aio: port = 8220 <br>"+
			"mct_paa_di4: port = 81[slot]3 <br>"+
			"mct_paa_di10: port = 81[slot]4 <br>"+
			"mct_paa_do4: port = 81[slot]5 <br>"+
			"mct_paa_dio42: port = 81[slot]6 <br>"+
			"mct_paa_ai8: port = 81[slot]7 <br>"+
			"mct_paa_ao4: port = 81[slot]8 <br><br>"+
			"Note: [slot] = address of slot";		break;


		// page modbus_config
		case "modbus_config_info_description_head":	substitute = "Description";	break; 
		case "modbus_config_info_description":	substitute = 
			"With this entry, the function of a data point can be described in more detail.";			
			break;
		case "modbus_config_info_unit_head":	substitute = "UNIT";	break; 
		case "modbus_config_info_unit":	substitute = 
			"Here, you enter the unit, which should be assigned to the stored value. <br>"+
			"This can be kWh, m3 or any other unit of measurement."; 			
			break;
		case "modbus_config_info_interval_head":	substitute = "INTERVAL";	break; 
		case "modbus_config_info_interval":	substitute = 
			"Determining time interval in which counters are readed out. <br><br>"+			
			"Following values available: <br>"+
			"5 min (00:00, 00:05, 00:10, ... ) <br>"+					
			"15 min (00:00, 00:15, 00:30, 00:45, 01:00, ... ) <br>"+					
			"30 min (00:00, 00:30, 01:00, ... ) <br>"+
			"1 h (00:00, 01:00, 02:00, ... ) <br>"+
			"2 h (00:00, 02:00, 04:00, ... ) <br>"+
			"4 h (00:00, 04:00, 08:00, ... ) <br>"+
			"6 h (00:00, 06:00, 12:00, ... ) <br>"+
			"12 h (00:00, 12:00, ... ) <br>"+
			"daily (00:00) <br>"+
			"weekly (Montags 00:00) <br>"+
			"monthly (1.1. 00:00, 1.2. 00:00, ...) <br>"+
			"quarterly (1.1. 00:00, 1.4. 00:00, ...) <br>"+
			"half-yearly (1.1. 00:00, 1.7. 00:00, ...) <br>"+
			"yearly (1.1.2000 00:00, 1.1.2001 00:00, ...) <br>"+
			"none (no cyclic read out) <br>";
			break;


		// weitere ...
	}		
	
	return (substitute);	
}

// ********************************************************************************************
// ********************************************************************************************





