/**********************************************************************************************
	show system state

	Copyright (c) 2009 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		08.2010

***********************************************************************************************/


// ********************************************************************************************

var DEBUG_LOG = 0;			// Ausgaben
var log_localObject;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Namen der Page ermitteln
	document.getElementById("headLine").innerHTML = 
	getFilenameFromPath (top.frame_content.location.href);
	
	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Mehrsprachige Strings ersetzen
	initStrings ();
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO -> Browser)
function setObjectProperties (actObject)
{
	// Werte setzen	
	setData (actObject);
	
	// Objekt global speichern fuer getObjectProperties()
	log_localObject = actObject;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		// MessageBox fuer Wartezeit
		top.messageBox_Wait_ext (ins("log_ftp_wait"));
		setTimeout ("top.hideMessageBox()", 5000);

		// Werte ermitteln		
		if (typeof(log_localObject) != "object")
			log_localObject = new Object();
	
		var changedObject = getData(log_localObject);
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen (EWIO -> Browser)
function setData (obj)
{
	// Einstellungen enstsprechend JSON- Objekt setzen
	// email-und FTP-Parameter werden in den jeweiligen Konfig-Funktionen gesetzt

	// Date
	document.form_state.hw_start.value = obj.hw_start;
	document.form_state.sw_start.value = obj.sw_start;
	document.form_state.link_start.value = obj.link_start;

	// e-mail start
	if (obj.hw_start_mail == "true")
		document.form_state.hw_start_mail.checked = true;
	else
		document.form_state.hw_start_mail.checked = false;

	if (obj.sw_start_mail == "true")
		document.form_state.sw_start_mail.checked = true;
	else
		document.form_state.sw_start_mail.checked = false;

	if (obj.link_start_mail == "true")
		document.form_state.link_start_mail.checked = true;
	else
		document.form_state.link_start_mail.checked = false;

	// FTP start
	if (obj.ftp.send_enable == "true")
		document.form_state.send_enable.checked = true;

	// syslog
	obj.syslog = obj.syslog.replace (/\\n/g,"\n");		// newline konvertieren
	document.form_state.content.value = obj.syslog;

	// zum Ende des Textfeldes scrollen
	var textarea = document.form_state.content;
	textarea.scrollTop = textarea.scrollHeight; 
}

// ********************************************************************************************
// Werte lesen (Browser -> EWIO)
function getData (obj)	
{
	// Objekt-Elemente zuweisen
	// email-und FTP-Parameter werden in den jeweiligen Konfig-Funktionen gefuellt

	// e-mail start
	if (document.form_state.hw_start_mail.checked == true)
		obj.hw_start_mail = "true";
	else
		obj.hw_start_mail = "false";
	if (document.form_state.sw_start_mail.checked == true)
		obj.sw_start_mail = "true";
	else
		obj.sw_start_mail = "false";
	if (document.form_state.link_start_mail.checked == true)
		obj.link_start_mail = "true";
	else
		obj.link_start_mail = "false";

	// FTP start
	if (document.form_state.send_enable.checked == true)
		obj.ftp.send_enable = "true";
	else
		obj.ftp.send_enable = "false";

	// syslog
	if (document.form_state.log_delete_now.checked == true)
		obj.delete_syslog_now = "true";
	else
		obj.delete_syslog_now = "false";
 	obj.syslog = "";

	return (obj);
}

// ********************************************************************************************
// ********************************************************************************************

// Konfiguration eMail-Parameter oeffnen
function openPad_mail()
{
	var headline =  '<B>eMail</B>';
	content =		'<form name="form_email">'+ 		
					'<div class="pos x0101 textfield">'+ins("log_email_from")+'</div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="from@mailserver.de" name="from"> </div>'+
					'<div class="pos x0201 textfield">'+ins("log_email_to")+'</div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="to@somewhere.de" name="to"> </div>'+
					'<div class="pos x0301 textfield"> SSL </div>'+
					'<div class="pos x0303"> <input type="checkbox" name="ssl"> </div>'+
					'<div class="pos x0401 textfield"> MailServer </div>'+
					'<div class="pos x0403"> <input type="text" class="textfield long_200" value="post.strato.de" name="mailserver"> </div>'+
					'<div class="pos x0501 textfield">'+ins("log_email_user")+'</div>'+
					'<div class="pos x0503"> <input type="text" class="textfield long_200" value="from@mailserver.de" name="username"> </div>'+
					'<div class="pos x0601 textfield">'+ins("log_email_pass")+'</div>'+
					'<div class="pos x0603"> <input type="password" class="textfield long_200" value="" name="password"> </div>'+

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="closePad_mail()">'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Tools', 400, 250, "window");

	// Werte setzen: e-mail-Parameter
	document.form_email.from.value = log_localObject.mail.from;
	document.form_email.to.value = log_localObject.mail.to;
	document.form_email.mailserver.value = log_localObject.mail.server;
	document.form_email.username.value = log_localObject.mail.username;
	document.form_email.password.value = log_localObject.mail.password;
	document.form_email.ssl.checked = log_localObject.mail.ssl;					// true / false

}

// ********************************************************************************************

// Konfiguration eMail-Parameter schliessen
function closePad_mail ()
{
	// Eingaben pruefen
	var ret = top.checkInputString (ins("log_email_from"), document.form_email.from.value, "^[A-Za-z0-9@_\.-]{0,50}$"); 	// 6 - 50 Zeichen, alphanum.+_.-@
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("log_email_to"), document.form_email.to.value, "^[A-Za-z0-9@_\.-]{0,50}$"); 	// 6 - 50 Zeichen, alphanum.+_.-@
	if (ret == -1)
		return;
	var ret = top.checkInputString ("MailServer", document.form_email.mailserver.value, "^[A-Za-z0-9\:_\.-]{0,50}$"); 	// 1 - 50 Zeichen, alphanum.+_.-:
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("log_email_user"), document.form_email.username.value, "^[A-Za-z0-9@_\.-]{0,50}$"); 	// 6 - 50 Zeichen, alphanum.+_.-@
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("log_email_pass"), document.form_email.password.value, "^[A-Za-z0-9_\.\/\=?\!\%-]{0,50}$"); 	// 0 - 50 Zeichen, alphanum.+_./=?!%-
	if (ret == -1)
		return;

	// Einstellungen uebernehmen: e-mail-Parameter
	log_localObject.mail.from = document.form_email.from.value;
	log_localObject.mail.to = document.form_email.to.value;
	log_localObject.mail.server = document.form_email.mailserver.value;
	log_localObject.mail.username = document.form_email.username.value;
	log_localObject.mail.password = document.form_email.password.value;
	log_localObject.mail.ssl = document.form_email.ssl.checked;					// true / false

	// pad schliessen
	guiPopup.CloseMe("message");
}


// ********************************************************************************************

// Konfiguration eMail-Inhalte oeffnen
function openPad_mailContent (type)
{
	var formName = "form_email_content_"+type;
	var functionName = "closePad_mailContent('"+type+"')";

	var headline =  '<B>'+ins("log_email_head")+type+'</B>';
	content =		'<form name='+formName+ '>' + 		
					'<div class="pos x0101 textfield">'+ins("log_email_subject")+'</div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="" name="subject"> </div>'+
					'<div class="pos x0201 textfield">'+ins("log_email_text")+'</div>'+
					'<div class="pos x0203"> <textarea name="content" class="textfield long_200" rows="5"></textarea></div>'+

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick='+functionName+'>'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Email', 400, 200, "window");


	// Einstellungen setzen: e-mail-Content
	switch (type)
	{
		case "HW":
			document.form_email_content_HW.subject.value = log_localObject.mail.hw_start_text.subject;
			document.form_email_content_HW.content.value = log_localObject.mail.hw_start_text.content;
			break;

		case "SW":	
			document.form_email_content_SW.subject.value = log_localObject.mail.sw_start_text.subject;
			document.form_email_content_SW.content.value = log_localObject.mail.sw_start_text.content;
			break;	
			
		case "LINK":
			document.form_email_content_LINK.subject.value = log_localObject.mail.link_start_text.subject;
			document.form_email_content_LINK.content.value = log_localObject.mail.link_start_text.content;
			break;
	}
}

// ********************************************************************************************

// Konfiguration eMail-Inhalte schliessen
function closePad_mailContent (type)
{
	// Einstellungen uebernehmen: e-mail-content
	switch (type)
	{
		case "HW":
			log_localObject.mail.hw_start_text.subject = document.form_email_content_HW.subject.value;
			log_localObject.mail.hw_start_text.content = document.form_email_content_HW.content.value;
			break;

		case "SW":	
			log_localObject.mail.sw_start_text.subject = document.form_email_content_SW.subject.value;
			log_localObject.mail.sw_start_text.content = document.form_email_content_SW.content.value;
			break;	
			
		case "LINK":
			log_localObject.mail.link_start_text.subject = document.form_email_content_LINK.subject.value;
			log_localObject.mail.link_start_text.content = document.form_email_content_LINK.content.value;
			break;
	}

	// pad schliessen
	guiPopup.CloseMe("message");

}

// ********************************************************************************************
// ********************************************************************************************

// Konfiguration FTP-Parameter oeffnen
function openPad_ftp()
{

	var headline =  '<B>Konfiguration FTP</B>';
	content =		'<form name="form_ftp">'+ 		
					'<div class="pos x0101 textfield">Server</div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="" name="server"> </div>'+

					'<div class="pos x0201 textfield">Username</div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="" name="username"> </div>'+
					'<div class="pos x0301 textfield">' + ins("cyclic_type_ftp_password") + '</div>'+
					'<div class="pos x0303"> <input type="password" class="textfield long_200" value="" name="password"> </div>'+
					'<div class="pos x0401 textfield">Port</div>'+
					'<div class="pos x0403"> <input type="text" class="textfield long_50" value="" name="port"> </div>'+

					'<div class="pos x0501 textfield"> <input type="checkbox" name="start_now">'+ins("log_ftp_sendnow")+'</div>'+
					'<div class="pos x0601 textfield"> <input type="checkbox" name="start_daily">'+ins("log_ftp_senddaily")+'</div>'+
					'<div class="pos x0603 textfield">'+  
						'<input type="text" class="textfield" value="" name="hours" size="2" maxlength="2">:'+
						'<input type="text" class="textfield" value="" name="minutes" size="2" maxlength="2">'+
						'(hh:mm)</div>'+
					'<div class="pos x0701 textfield"> <input type="checkbox" name="log_delete_after_send">'+ins("log_delete_after_send")+'</div>'+
					'<div id="button_position">'+
						'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="closePad_ftp()">'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Tools', 400, 260, "window");


	// Einstellungen setzen: ftp
	document.form_ftp.server.value = log_localObject.ftp.server;
	document.form_ftp.username.value = log_localObject.ftp.username;
	document.form_ftp.password.value = log_localObject.ftp.password;
	document.form_ftp.port.value = log_localObject.ftp.port;
	if (log_localObject.ftp.start_now == "true")
		document.form_ftp.start_now.checked = true;
	if (log_localObject.ftp.start_daily == "true")
		document.form_ftp.start_daily.checked = true;

	// Server-Sendezeit
	var st_arr = log_localObject.ftp.start_time.split(" ");
	var time_arr = st_arr[1].split(":");
	document.form_ftp.hours.value = time_arr[0];
	document.form_ftp.minutes.value = time_arr[1];
	// Nach dem Senden Loeschen
	if (log_localObject.ftp.delete_syslog_after_send == "true")
		document.form_ftp.log_delete_after_send.checked = true;

}

// ********************************************************************************************

// Konfiguration FTP-Parameter schliessen
function closePad_ftp ()
{
	// Eingaben pruefen
	var ret = top.checkInputString ("Server", document.form_ftp.server.value, "^[A-Za-z0-9_\.\/-]{0,250}$"); 	// 0 - 250 Zeichen, alphanum.+_./-
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("cyclic_type_ftp_username"), document.form_ftp.username.value, "^[A-Za-z0-9_\.\/-]{0,250}$"); 	// 0 - 250 Zeichen, alphanum.+_./-
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("cyclic_type_ftp_password"), document.form_ftp.password.value, "^[A-Za-z0-9_\.\/\=?\!\%-]{0,50}$"); 	// 0 - 50 Zeichen, alphanum.+_./=?!%-
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("cyclic_type_ftp_port"), document.form_ftp.port.value, "^[0-9]{1,5}$"); 	// 1 - 5 Zeichen, Ziffern
	if (ret == -1)
		return;

	// Einstellungen uebernehmen: ftp
	log_localObject.ftp.server = document.form_ftp.server.value;
	log_localObject.ftp.username = document.form_ftp.username.value;
	log_localObject.ftp.password = document.form_ftp.password.value;
	log_localObject.ftp.port = document.form_ftp.port.value;
	if (document.form_ftp.start_now.checked == true)
		log_localObject.ftp.start_now = "true";
	else
		log_localObject.ftp.start_now = "false";
	if (document.form_ftp.start_daily.checked == true)
		log_localObject.ftp.start_daily = "true";
	else
		log_localObject.ftp.start_daily = "false";

	// Server-Sendezeit
	var hours = setLeadNull (document.form_ftp.hours.value-0);
	var minutes = setLeadNull (document.form_ftp.minutes.value-0);

	// Eingaben checken
	var ret = checkTimeComponents (hours, "hours");
	ret |= checkTimeComponents (minutes, "minutes");
	if (ret != -1)
		log_localObject.ftp.start_time = "01.01.01 "+hours+":"+minutes+":"+"00";

	// Nach dem Senden Loeschen
	if (document.form_ftp.log_delete_after_send.checked == true)
		log_localObject.ftp.delete_syslog_after_send = "true";
	else
		log_localObject.ftp.delete_syslog_after_send = "false";


	// pad schliessen
	guiPopup.CloseMe("message");
}

// ********************************************************************************************
// ********************************************************************************************

// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************

// Zeiteingaben ueberpruefen
function checkTimeComponents (timeComp, check)
{
	var type = "";

	switch (check)
	{
		case "year":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 38))
							type = "Jahr"; 
						break;
		case "month":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 12))
							type = "Monat"; 
						break;
		case "day":		if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 31))
							type = "Tag"; 
						break;
		case "hours":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 24))
							type = "Stunde"; 
						break;
		case "minutes":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							type = "Minute"; 
						break;
		case "seconds":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							type = "Sekunde"; 
						break;
	}

	if (type != "")
	{
		alert ("Zeiteingabe fehlerhaft: "+type);
		return (-1);	
	}

	return (0);
}

// ********************************************************************************************

// Mehrsprachige Strings ersetzen
function initStrings ()
{
	document.form_state.content_hw.value = ins("log_button_content");
	document.form_state.content_sw.value = ins("log_button_content");
	document.form_state.content_link.value = ins("log_button_content");

	document.form_state.config_mail.value = ins("log_button_config_mail");
	document.form_state.config_ftp.value = ins("log_button_config_ftp");

}

// ********************************************************************************************



