/**********************************************************************************************
	JS functions for mbus_config

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		05.2011

***********************************************************************************************/


/*
	Anmerkungen:
	Um eine Aenderung der Baudrate zu ermoeglichen, ist das Laden der Konfiguration zweigeteilt:
	1. Mit dem Aufruf der Seite wird das Konfigurationsfile geladen
	2. Durch Betaetigen "BROWSER <- EWIO" werden die Daten vom MBus geladen

*/

// ********************************************************************************************

var DEBUG_CONFIG = 0;
var DEBUG_MBUS = 0;

var moduleId;				// mbus-id des Geraetes
var moduleName;				// Name des Geraetes
var tele_id;				// ID zur Zuordnung MBus Anfrage / Antwort
var counterObj;				// lokales Objekt (Zaehler-Konfiguration)
var mbusResponseObj;		// lokales Objekt (Antwort vom MBus)
var response_counter = 0;	// Empfangszaehler

var appObject;				// lokales Objekt (verfuegbare Applikationen)
var busPath;

var channelCntObj;			// Objekt fuer Anzahl der channel
var channel_cnt;			// aktueller channel-Index
var channelArr;				// Array mit allen channel-Objekten
var channelWait;

var mbus_time;
var mbus_objStr;
var mbus_index;

var sensType;
var tempOffset;

var conf_state = 0;

var oStr;					// Aktualisierung Tree
var msgChannel;				// Channel fuer Messagebox-Anzeige
var interval_timeout;		// Timeout fuer Messagebox-Anzeige

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Namen im Header anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Messagebox
	top.messageBox_Wait();

	// Initialisierung
	channelArr = new Array();
	document.form_specialConfig.style.visibility ="hidden";	
	var buttontext = ins("mbus_config_counter");
	document.form_conf.conf.value = unescape(ins("mbus_config_counter")); //ins("mbus_config_counter");

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;
	document.form_conf.conf.disabled = true;

	// Ablauf Konfiguration starten: Busliste einlesen
	mbus_getBusList();
}

// ********************************************************************************************
// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Channel einlesen
	moduleId = top.tree_getPageName()[1];
	top.getDataExtended (moduleId, "channels", "top.frame_content.mbus_getChannels_answer(actStr)");

	// Messagebox
	top.messageBox_Wait();

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;
	document.form_conf.conf.disabled = true;
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;
	document.form_conf.conf.disabled = true;

	// Zaehlerkonfiguration speichern
	// wenn keine Kanaele ausgewaehlt wurden, dann Warnung
	if (channelArr.length == 0)	
		warning_show();
	else
	{
		// wenn Tabelle geloescht wurde, dann keine erneute Speicherung 
		var tbody = document.getElementById("tab_mbus_id");
		if (tbody.rows.length > 0)
		{
			// Anzahl DP abfragen, anschliessend Zaehlerkonfiguration abfragen
			top.getDataExtended ('mbus_config', 'db_max', 'top.frame_content.mbus_getDPMax(actStr)');
		}
	}
}

// ********************************************************************************************
// Pruefen, ob die max. Anzahl DP erreicht ist, wenn ja, keine Speicherung!
function mbus_getDPMax (actStr)
{
	// alert (actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// state der checkboxen ermitteln (wieviele aktiv?) = Anzahl neuer channel
	var selectCnt = 0;
	var table = document.getElementById ("tab_mbus_id");
	for (var i=0; i<table.rows.length; i++)
	{	
		// Checkbox aktiv?	
		var check = eval ('document.getElementsByName("check_'+i+'")');
		if (check[0] === undefined)
			continue;					// checkbox nicht vorhanden
		else
		{
			if 	(check[0].checked == true)
				selectCnt++;
		}
	}

	// Differenz zwischen Anzahl der bisherigen und neuer channel ermitteln
	var channelCnt = selectCnt - channelCntObj;	
	// alert ("channelCnt = " + channelCnt + "   channelCntObj = " + channelCntObj + "   selectCnt = " + selectCnt);

	// channelCnt = Anzahl jetzt zu speichernder DP
	// jObject.channel.count = Anzahl bisher gespeicherter DP
	// jObject.channel.max = max. Anzahl DP gesamt

	// alert ("channel bisher = " + jObject.channel.count + "   channel neu = " + channelCnt + "   channel max = " + jObject.channel.max);

	var new_DP = jObject.channel.count + channelCnt;
	if ((new_DP > jObject.channel.max) && (jObject.channel.max > 0))
	{
		var diff = new_DP - jObject.channel.max;
		var text = 	ins("mbus_dp_1") + "<B>" + jObject.channel.max + " </B><br>"+
					ins("mbus_dp_2") + "<B>" + jObject.channel.count + " </B><br>"+
					ins("mbus_dp_3") + "<B>" + diff + " </B>!";

		dp_messageBox (ins("mbus_config_error"), text);

		// Button freigeben
		releaseButton();
	}	
	else
	{
		// Zaehlerkonfiguration speichern
		mbus_setConfiguration();
	}
}

// ********************************************************************************************
// MessageBox fuer DP-Abfrage
function dp_messageBox(head, text)
{
	var headline =  '<B> '+head+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+text+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 160, "window");
}




// ********************************************************************************************
// ********************************************************************************************






// ********************************************************************************************
// Konfiguration einlesen
// ********************************************************************************************
// verfuegbare Busse auflisten
function mbus_getBusList ()
{
	top.getDataExtended ("mbus_config", "bus_list", "top.frame_content.mbus_getBusList_answer(actStr)");
}

// ********************************************************************************************
// Antwort
function mbus_getBusList_answer(actStr)
{
	if (DEBUG_CONFIG)	
		alert ("mbus_getBusList_answer: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);
	
	for (var i=0; i<jObject.bus_driver.length; i++)
	{
		// Namen zerlegen
		var nameArr = jObject.bus_driver[i].split('.');

		// filtern Bus = 2 (MBus)
		if (nameArr[2].slice(0,1) != 2)	
			continue;

		// Bus-Namen ermitteln
		var busname="";		
		switch (nameArr[2].slice(2,3))		
		{
			case "0":	busname = "mct_pin_di_";		break;
			case "1":	busname = "mct_spi_dio";		break;
			case "2":	busname = "mct_spi_aio";		break;
			case "3":	busname = "mct_paa_di4_";		break;
			case "4":	busname = "mct_paa_di10_";		break;
			case "5":	busname = "mct_paa_do4/to4_";	break;
			case "6":	busname = "mct_paa_dio42_";		break;
			case "7":	busname = "mct_paa_ai8_";		break;
			case "8":	busname = "mct_paa_ao4_";		break;
			case "9":   busname = "mct_paa_ai4_";		break;
		}

		// Slotplatz ermitteln
		if (busname.lastIndexOf("_") == (busname.length-1))		
			busname += nameArr[2].slice(4,5)

		// Instanz ermitteln
		if (nameArr[3] != "0")		
			busname += " " + nameArr[3]

		// Eintrag in Liste
		addSelectOption (document.form_bus.subBus, jObject.bus_path+"/"+jObject.bus_driver[i]+"/mbus", busname);
		// alert (jObject.bus_driver[i]+"   "+busname);
	}	

	// Ablauf fortsetzen: Applikationsliste einlesen
	mbus_getAppList();
}

// ********************************************************************************************
// Applikationsliste einlesen
function mbus_getAppList ()
{
	top.getDataExtended ("application", "application_list", "top.frame_content.mbus_getAppList_answer(actStr)");
}

// ********************************************************************************************
// Antwort
function mbus_getAppList_answer(actStr)
{
	if (DEBUG_CONFIG)	
		alert ("mbus_getAppList_answer: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	appObject = JSON2.parse(actStr);

	// Ablauf fortsetzen: Zaehler einlesen
	mbus_getCounter();

}

// ********************************************************************************************



// ********************************************************************************************
// ********************************************************************************************
// Eingetragene Zaehlwerkskonfiguration ermitteln
function mbus_getCounter()
{
	// MBUS-ID aus tree ermitteln
	moduleId = top.tree_getPageName()[1];

	if (DEBUG_CONFIG)	
		alert (moduleId);
	
	// bei internen Zaehlern pruefen, ob er schon als Synchronpuls-Eingang verwendet wird
	// (check SYS fuer intern und Position 5 auf 0 fuer DI)	
	var typeArr = moduleId.split("-");
	if ((typeArr[1] == "SYS") && (moduleId.charAt(5) == "0"))
		top.getDataExtended ("mbus_sync", "configuration", "top.frame_content.mbus_getSync_answer(actStr)");
	else
		top.getDataExtended (moduleId, "counter", "top.frame_content.mbus_getCounter_answer(actStr)");
}

// ********************************************************************************************

// Antwort bei SYS
// Wenn der ausgewaehlte interne S0-Eingang bereits als Synchronpuls-Eingang verwendet wird, dann keine
// Konfiguration als Zaehler
function mbus_getSync_answer(actStr)
{
	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	var match = 0;

	// JSON-String in Objekt wandeln
	var oSync = JSON2.parse(actStr);

	// Darstellung aktualisieren
	if (oSync.sync)	
	{
		moduleId = top.tree_getPageName()[1];
		var index = moduleId.charAt(6);

		if ((oSync.source == "DI1") && (index == "0")) 
			match = 1;
		if ((oSync.source == "DI2") && (index == "1")) 
			match = 1;
		if ((oSync.source == "DI3") && (index == "2")) 
			match = 1;
		if ((oSync.source == "DI4") && (index == "3")) 
			match = 1;
	}
	// alert (oSync.sync + "   " + oSync.source + "   " + index + "   " + match);

	if (match)
	{
		top.hideMessageBox();
		top.messageBox (ins("mbus_config_error"), ins("mbus_config_error_sync")); 	// "Es wurde keine Baudrate ausgewaehlt."
	}	
	else
		top.getDataExtended (moduleId, "counter", "top.frame_content.mbus_getCounter_answer(actStr)");
}

// ********************************************************************************************
// Antwort
function mbus_getCounter_answer(actStr)
{
	if (DEBUG_CONFIG)	
		alert (actStr);

	// gibt es noch kein Konfigurationsfile, muss ein template erzeugt werden
	if (actStr.indexOf("{") == -1)
	{	
		var source = "mbus_getCounter / create";

		// Erzeugen eines JSON-Konfigurationstemplates
		var actObject = new Object();

		// Gibt es kein Konfigurationsfile,  
		// werden Name, MBusId, Bus und Baudrate aus der automatischen Suche voreingestellt

		// Bustyp
		var bType = top.tree_getPageName()[2];
		for (var i=0; i<document.form_bus.bus.length; i++)
		{
			if (document.form_bus.bus[i].text == bType)
				document.form_bus.bus.selectedIndex = i;
		}
		var subBType = top.tree_getPageName()[3];
		for (var i=0; i<document.form_bus.subBus.length; i++)
		{
			if (document.form_bus.subBus[i].text == subBType)
				document.form_bus.subBus.selectedIndex = i;
		}
		checkBusSelection();

		// Baudrate
		var baudrateSet = top.tree_getPageName()[4];

		// zusaetzliche Baudraten auf Standardbaudraten mappen
		if ((baudrateSet == "600") || (baudrateSet == 1200))
			baudrateSet = 300;
		if (baudrateSet == "4800")
			baudrateSet = 2400;
		if ((baudrateSet == "19200") || (baudrateSet == 38400))
			baudrateSet = 9600;

		// Radiobutton setzen
		if (baudrateSet == "300")
			document.form_baudrate.rBr[0].checked = true;
		if (baudrateSet == "2400")
			document.form_baudrate.rBr[1].checked = true;
		if (baudrateSet == "9600")
			document.form_baudrate.rBr[2].checked = true;

		// Objekt fuellen
		actObject.ID = 0;								// Zaehler default
		actObject.BusAdr = top.tree_getPageName()[1];
		actObject.BR = parseInt(baudrateSet);
		actObject.ZNummer = "";
		actObject.Mandant = "";
		actObject.AbnNr = "";
		actObject.Name = top.tree_getPageName()[0];		
		actObject.Sort = 0;	

		actObject.ztype = new Object();					// Zaehlertyp
		actObject.ZTyp_ID = 1;		
		actObject.ztype.Kinds = "Normal";
		actObject.btype = new Object();					// Bustyp
		actObject.btype.Kinds = bType;		
		switch (bType)
		{
			case "MBus":	actObject.BTyp_ID = 1;		break;
			case "System":	actObject.BTyp_ID = 2;		break;
		}
		
		actObject.busdetails = new Object();			// Busdetails
		actObject.busdetails.Zaehler_ID = 0;
		actObject.busdetails.Text_1 = "";				// busPath 
		actObject.busdetails.Text_2 = ""; 				// subBus
		actObject.busdetails.Text_3 = "true";			// primAdr (bool als string)

		actObject.meteringcode = new Object();			// Meteringcode
		actObject.meteringcode.Zaehler_ID = 0;
		actObject.meteringcode.Kanal_ID = 0;
		actObject.meteringcode.Land = "DE";
		actObject.meteringcode.Betreiber = 123456;
		actObject.meteringcode.Plz = 12345;
		actObject.meteringcode.MePuId = "EXAMPLE0123456789012";
	}
	else
	{
		var source = "mbus_getCounter / load";

		// JSON-String in Objekt wandeln
		var actObject = JSON2.parse(actStr);

		// Gibt es ein Konfigurationsfile, wird die Baudrate durch den parameter br
		// bestimmt
		// Radiobutton setzen
		if (actObject.BR == 300)
			document.form_baudrate.rBr[0].checked = true;
		if (actObject.BR == 2400)
			document.form_baudrate.rBr[1].checked = true;
		if (actObject.BR == 9600)
			document.form_baudrate.rBr[2].checked = true;

		// Bus setzen
		for (var i=0; i<document.form_bus.bus.length; i++)
		{
			if (document.form_bus.bus[i].text == actObject.btype.Kinds)
				document.form_bus.bus.selectedIndex = i;
		}
		// Bus subType setzen
		for (var i=0; i<document.form_bus.subBus.length; i++)
		{
			if (document.form_bus.subBus[i].text == actObject.busdetails.Text_2)
				document.form_bus.subBus.selectedIndex = i;
		}
		checkBusSelection();	
	}

	// Objekt lokal fuer andere Funktionen speichern
	counterObj = actObject;


	if (DEBUG_CONFIG)	
	{
		var actStr = JSON2.stringify (actObject, null, 4);
	 	alert (source + "\n" + actStr);
	}

	// Messagebox schliessen
	top.hideMessageBox();

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
	document.form_conf.conf.disabled = false;
}

// ********************************************************************************************

// Antwort: channel einlesen
function mbus_getChannels_answer(actStr)
{
	if (actStr.indexOf("{") == -1)
	{
		// Messagebox schliessen
		top.hideMessageBox();
		return;
	}	

	if (checkLoginError (actStr))
		return;

	if (DEBUG_CONFIG)	
		alert ("mbus_getChannels_answer: \n"+actStr);

	// Objekt im channelArr speichern
	var actObj = JSON2.parse(actStr);
	channelArr = actObj.channel;

	// Anzahl eingelesener channel merken
	channelCntObj = channelArr.length;

	// Daten vom Mbus abfragen
	mbus_getData();

}

// ********************************************************************************************
// ********************************************************************************************







// ********************************************************************************************
// Daten vom MBUS
// ********************************************************************************************

// Baudraten setzen, Parameter vorbereiten
// Daten vom MBUS abrufen
// Die Abfragen muessen zeitversetzt erfolgen!
function mbus_getData()
{
	// special configuration disabel
	document.form_specialConfig.style.visibility ="hidden";	

	// Message, wenn keine Baudrate ausgwaehlt ist
	if (!counterObj.BR)
	{
		top.messageBox (ins("mbus_config_error"), ins("mbus_config_error_no_br")); 	// "Es wurde keine Baudrate ausgewaehlt."
		return;
	}

	var i = document.form_bus.bus.selectedIndex;
	var bus = document.form_bus.bus[i].value;	
	if (bus == "MBus")	
		busPath = top.mbus_path;	
	if (bus == "System")	
	{
		var i = document.form_bus.subBus.selectedIndex;
		busPath = document.form_bus.subBus[i].value;	
	}

	// Message, wenn kein Bus ausgwaehlt ist
	if (!busPath)
	{
		top.messageBox (ins("mbus_config_error"), ins("mbus_config_error_no_bus"));	// "Es wurde kein Bus ausgewaehlt."
		return;
	}

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);
	
	// Kopfangaben loeschen
	document.form_counter_head.timestamp.value = "";
	document.form_counter_head.mbus_id.value = "";
	document.form_counter_head.access.value = "";
	document.form_counter_head.status.value = "";

	// auf allen Baudraten "SET_BAUDRATE" mit br als Parameter senden, um den Zaehler auf br zu stellen
	// (mit Pause zwischen den Aufrufen, um AJAX Zeit zu geben)
	// Nicht bei internen Zaehlern!
	if	(counterObj.BusAdr.indexOf("SYS") == -1)	
	{
		setTimeout ("setBaudrate (busPath, counterObj.BusAdr, 300, counterObj.BR)",400);
		setTimeout ("setBaudrate (busPath, counterObj.BusAdr, 2400, counterObj.BR)", 800);
		setTimeout ("setBaudrate (busPath, counterObj.BusAdr, 9600, counterObj.BR)", 1200);

		// Telegramm "GET_DATA" Master -> Slave
		setTimeout ("mbus_request ()", 2000);
	}
	else
	{
		// Telegramm "GET_DATA" Master -> Slave
		mbus_request();
	}
}

// ********************************************************************************************

// Daten-Telegramm Master -> Slave 
function mbus_request ()
{

	// Zusammenstellen des MBus-Objekts
	mbusRequestObj = new Object();
	// bus
	var i = document.form_bus.bus.selectedIndex;
	var bus = document.form_bus.bus[i].value;	
	if (bus == "MBus")	
		busPath = top.mbus_path;
	if (bus == "System")	
	{
		var i = document.form_bus.subBus.selectedIndex;
		busPath = document.form_bus.subBus[i].value;	
	}
	mbusRequestObj.bus = busPath;
	// id
	tele_id = top.calculateRandom (1, 10000);
	mbusRequestObj.id = tele_id.toString();	
	// br
	mbusRequestObj.br = counterObj.BR+"";
	// secAdr
	mbusRequestObj.secAdr = counterObj.BusAdr;
	// command
	mbusRequestObj.command = "GET_DATA";
	// param
	mbusRequestObj.param = "0";

	var actStr = JSON2.stringify (mbusRequestObj, null, 4);	// Object -> String

	if (DEBUG_MBUS)	
		alert ("mbus_request: \n"+actStr);

	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

	if	(counterObj.BusAdr.indexOf("SYS") == -1)	
	{
		// Empfangstelegramm(e) Slave -> Master lesen, Daten anfordern via mbus_response()
		setTimeout ("top.getDataExtended ('mbus_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 10000);
	}
	else
	{
		// ohne Wartezeit, weil SYS
		top.getDataExtended ('mbus_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)');
	}
}

// ********************************************************************************************
// Antworttelegramme  Slave -> Master
function mbus_response(actStr)
{
	//alert (actStr);

	// eine Zeitlang Telegramm pollen
	if (counterObj.BR >= 9600)			var timeout = 30;
	else if	(counterObj.BR >= 2400)		var timeout = 50;
	else								var timeout = 60; 	

	
	// Message (text) oder Daten (JSON)
	if (actStr.indexOf('{') == -1)
	{	
		// Message
		// alert (actStr);
		actStr = top.getMessage (actStr);

		// keine Antwort vom mbus_controller
		var wait_time = timeout-response_counter;

		if (response_counter < timeout)		
		{	
			top.hideMessageBox();
			top.messageBox_Wait_ext (ins("mbus_config_message_wait_EWIO") + "<B>" + wait_time.toString() + "</B> sec.");
			setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 1000);	
			response_counter++;			// 1 Sekunde vergangen
			return;			
		}

		// MBus-Zaehler hat nicht oder fehlerhaft geantwortet 
		top.hideMessageBox();
		top.messageBox (ins("mbus_data_error_head"), actStr);

		// Ergebnisfile loeschen
		mbus_removeFile();

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		top.document.getElementById("button_2").disabled = false;
		document.form_conf.conf.disabled = false;
		return;
	}
	
	// JSON-String in Objekt wandeln
	try
	{
		actObject = JSON.parse(actStr);
	}
	catch(err)
	{
		var txt = "Error on navigation data occured.\n";
		txt += "Error description: " + err.message + "\n";
		alert (txt);

		//document.write(actStr);	
		return;	
	}

	// Test auf Fehlermeldungen von GET_DATA
	if (actObject.data_response)
	{
		if (actObject.data_response == "No Answer")
		{
			top.hideMessageBox();
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_noanswer"));	// "Der Zaehler hat nicht geantwortet."
	
			// Ergebnisfile loeschen
			mbus_removeFile();

			// Button freigeben
			top.document.getElementById("button_1").disabled = false;
			top.document.getElementById("button_2").disabled = false;
			return;
		}

		else if (actObject.data_response == "Telegram Invalid")
		{
			top.hideMessageBox();
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_invalid")); 	// "Antwort vom Zaehler fehlerhaft."

			// Ergebnisfile loeschen
			mbus_removeFile();

			// Button freigeben
			top.document.getElementById("button_1").disabled = false;
			top.document.getElementById("button_2").disabled = false;
			return;
		}
		else if (actObject.data_response.indexOf("Receive More") != -1)
		{
			top.hideMessageBox();
			top.messageBox_Wait_ext (actObject.data_response);
			setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 1000);	
			return;
		}
		else
		{
			top.hideMessageBox();
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_unknown"));	// "Ein unbekannter Fehler ist aufgetreten."

			// Ergebnisfile loeschen
			mbus_removeFile();

			// Button freigeben
			top.document.getElementById("button_1").disabled = false;
			top.document.getElementById("button_2").disabled = false;
			return;
		}
	}


	// Message schliessen
	top.hideMessageBox();

	// Test auf Fehlermeldungen von ACK
	if (actObject.ack_response)
	{
		switch (actObject.ack_response)
		{
			case "No Answer":
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_noanswer"));	// "Der Zaehler hat nicht geantwortet."
			return;

			case "Collision":
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_invalid")); 	// "Antwort vom Zaehler fehlerhaft."
			return;

			case "Unknown":
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_unknown"));	// "Ein unbekannter Fehler ist aufgetreten."
			return;
		}
	}

	// Felder fuellen
	// Kopfangaben
	document.getElementById("counter_head").style.color = "#046AAC";
	document.form_counter_head.timestamp.value = actObject.timestamp;
	document.form_counter_head.mbus_id.value = actObject.mbus_id;
	document.form_counter_head.access.value = actObject.access;
	document.form_counter_head.status.value = actObject.status;

	// Freeze verfuegbar?
	if (checkForFreeze(actObject))
		document.form_freeze.style.display = "block";

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	// evtl. bereits vorhandene Zeilen loeschen
	while (tbody.rows.length > 0)
		tbody.deleteRow(0);


	// Anzahl Telegramme
	for (var i=0; i<250; i++)
	{
		// Abbruch, wenn kein Telegramm mehr
		if (actObject.records[i] === undefined)
			break;	
	
		// Anzahl Records
		for (var j=0; j<250; j++)
		{			   
			// Abbruch, wenn kein Record mehr
			if (actObject.records[i][j] === undefined)
				break;	

			// neue Zeile
			tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

			// jede 2. Reihe andersfarbig ("Zebratabelle")
			if (tbody.rows.length % 2 == 0)	
				tr.setAttribute ("class", "row_color_odd");
			else
				tr.setAttribute ("class", "row_color_even");

			// 1. Spalte Telegramm-Nr.
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = actObject.records[i][j].tel;
			td.setAttribute ("class", "td_50");

			// 2. Spalte Record-Nr.
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = actObject.records[i][j].rec;
			td.setAttribute ("class", "td_50");

			// 3. Spalte Beschreiber
			td = tr.insertCell(tr.cells.length);
			if (actObject.records[i][j].descriptor == "telegram end")
				td.innerHTML = actObject.records[i][j].descriptor; 
			else
			{			
				var extText = actObject.records[i][j].extended;
				td.innerHTML = actObject.records[i][j].descriptor + 
							'<br> <input type="button" class="textfield_small" value="more" onclick="extended_information('+i+','+j+')">';
			}
			td.setAttribute ("class", "td_150");

			// 4. Spalte Wert
			td = tr.insertCell(tr.cells.length);
			td.setAttribute ("class", "td_80");
			td.innerHTML = actObject.records[i][j].value;
			if (actObject.records[i][j].descriptor == "manufacturer-specific")
			{	
				// manufacturer-specific Bytefolge drehen
				var reverse = "";	
				var reverseArr = actObject.records[i][j].value.split(" ");
				for (var k=0; k<reverseArr.length; k++)
					reverse += reverseArr[reverseArr.length - k - 1] + " ";
				td.innerHTML = reverse;
				td.setAttribute ("style", "font-style: italic;");
			}

			// 5. Spalte Einheit
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = actObject.records[i][j].unit;
			td.setAttribute ("class", "td_80");

			// 6. Spalte Checkbox 
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = '<input name="check_'+(tbody.rows.length-1)+'" type="checkbox" onchange="changeCheckbox('+(tbody.rows.length-1)+')">'; 	// default

			for (var x=0; x<channelArr.length; x++)
			{
				var tel = channelArr[x].Tele - 1;
				var rec = channelArr[x].Rec - 1;
	
				// alert (i+" "+tel+"     "+j+" "+rec);


				if ((i == tel) && (j == rec))		
				{
					// Checkbox zuweisen
					td.innerHTML = '<input name="check_'+(tbody.rows.length-1)+'" type="checkbox" checked="checked" onchange="changeCheckbox('+(tbody.rows.length-1)+')">';
				}
			}
			td.setAttribute ("class", "td_80");
			td.setAttribute ("style", "text-align:center;");

			// special configuration
			// S0-records ermitteln, nur diese sollen als S0/M behandelt werden
			if (counterObj.ztype.Kinds == "S0")
			{
				if (actObject.records[i][j].descriptor == "Cumulation Counter")	
				{
					td.innerHTML +=	"*";
					document.form_specialConfig.style.visibility ="visible";	
				}
			} 
	
			// TM-records ermitteln, nur diese sollen als T/M behandelt werden
			if (counterObj.ztype.Kinds == "Temp")
			{
				if ((i == 0) && (j == 2))
				{
					td.innerHTML +=	"*";
					document.form_specialConfig.style.visibility ="visible";	
				}
			}

			// wenn telegram end, Checkbox nicht darstellen
			if (actObject.records[i][j].descriptor == "telegram end")
				td.setAttribute ("style", "visibility:hidden;");


			// 7. Spalte CONFIG
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = '<input type="button" name="config_'+(tbody.rows.length-1)+'" class="textfield_small" value="more" onclick="channel_configuration('+i+','+j+')">';
			td.setAttribute ("class", "td_80");
			td.setAttribute ("style", "text-align:center;");
			changeCheckbox(tbody.rows.length-1);		// Button sichtbar/unsichtbar in Abhaengigkeit von checkbox
		}
	}

	// Objekt lokal fuer andere Funktionen speichern
	mbusResponseObj = actObject;

	// Ablauf fortsetzen: Ergebnisfile loeschen
	mbus_removeFile();

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;

	// alert (document.getElementById("tab_mbus_id").innerHTML);
}

// ********************************************************************************************

// ErgebnisFile loeschen
function mbus_removeFile()
{

	// MBus-Empfangsfile auf dem Server loeschen
	actStr = '{"id":"'+tele_id+'"}';
	top.setDataExtended ("mbus", "mbus_remove", actStr);		// Daten zum EWIO senden

}

// ********************************************************************************************

// Ausgabe zusaetzlicher Informationen
function extended_information (i,j)
{
	top.messageBox (ins("mbus_config_extended_info"), mbusResponseObj.records[i][j].extended)
}

// ********************************************************************************************

// In Abhaengigkeit vom Zustand der Checkbox soll der config-Button ein- oder ausgeblendet werden
function changeCheckbox (row)
{
	// Checkbox aktiv?	
	var check = eval ('document.getElementsByName("check_'+row+'")');
	var config = eval ('document.getElementsByName("config_'+row+'")');

	if 	(check[0].checked == true)
		config[0].style.visibility ="visible";
	else
		config[0].style.visibility ="hidden";


	// channel-configuration bereits vorhanden?
	if 	(check[0].checked == true)
	{
		// tel und rec ermitteln
		var t_tel = getTableElement ("tab_mbus_id", row, 0);
		var t_rec = getTableElement ("tab_mbus_id", row, 1);
		// alert ("t_tel = "+t_tel+"     t_rec = "+ t_rec);

		for (var x=0; x<channelArr.length; x++)
		{
			var tel = channelArr[x].Tele;
			var rec = channelArr[x].Rec;
			// alert ("tel = "+tel+"     rec = "+ rec);

			if ((t_tel == tel) && (t_rec == rec))	
			{	
				return;
			}
		}	
	
		// keine channel-Konfiguration vorhanden, daher anlegen
		var defObj = new Object();

		defObj.ID = 0;
		defObj.Zaehler_ID = counterObj.ID;
		defObj.Obis_ID = "";
		defObj.Tele = t_tel;
		defObj.Rec = t_rec;
		defObj.DIF = "";
		defObj.VIF = "";
		defObj.Faktor_U = 1;
		defObj.Faktor_I = 1;
		defObj.EAblesung = "";
		defObj.Intervall = 15;
		defObj.ZwTyp = mbusResponseObj.records[t_tel-1][t_rec-1].descriptor;
		defObj.MEinheit = mbusResponseObj.records[t_tel-1][t_rec-1].unit;
		defObj.MessTyp = "normal";
		defObj.Primaer = 0;
		defObj.Format = "";
		defObj.App = "none";
		defObj.Aenderung = "";
		defObj.Faktor_edit = 0;
		defObj.Einheit_edit = "";

		// S0
		defObj.S0 = new Object();
		defObj.S0.Kanal_ID = counterObj.ID; 
		defObj.S0.AZStand = 0;
		defObj.S0.AImpulse = -1;
		defObj.S0.ImpProEinheit = 1;

		// T/M
		defObj.Temp = new Object();
		defObj.Temp.Kanal_ID = counterObj.ID;
		
		defObj.Temp.SensTyp = 0;	// default
		if (mbusResponseObj.records[0][3] != undefined)
		{
			if (mbusResponseObj.records[0][3].descriptor == "Typ")
				defObj.Temp.SensTyp = mbusResponseObj.records[0][3].value - 0;		
		}
		defObj.Temp.Offset = 0;

		var len = channelArr.length;
		channelArr[len] = defObj;

		// alert ("configuration "+len+ " angelegt");

		var actStr = JSON2.stringify (defObj, null, 4);	// Object -> String
		// alert (actStr);
	}
	else
	{
		// channel-Konfiguration wird geloescht
		// tel und rec ermitteln
		var t_tel = getTableElement ("tab_mbus_id", row, 0);
		var t_rec = getTableElement ("tab_mbus_id", row, 1);
		// alert ("t_tel = "+t_tel+"     t_rec = "+ t_rec);

		for (var x=0; x<channelArr.length; x++)
		{
			var tel = channelArr[x].Tele;
			var rec = channelArr[x].Rec;
			// alert ("tel = "+tel+"     rec = "+ rec);

			if ((t_tel == tel) && (t_rec == rec))	
			{	
				channelArr.splice (x,1);	// Loesche Element aus dem Array				
				return;
			}
		}	
	}
}

// ********************************************************************************************

// channel konfigurieren
function channel_configuration (t_tel, t_rec)
{
	// alert ("channel_configuration, tel "+t_tel+" rec "+t_rec);

	for (var x=0; x<channelArr.length; x++)
	{
		var tel = channelArr[x].Tele - 1;
		var rec = channelArr[x].Rec - 1;
	
		if ((t_tel == tel) && (t_rec == rec))		
		{
			 // alert (channelArr[x].ID);

			// Konfiguration aus channelArr an Masken zuweisen
			channel_tabsOpen (x);
			channel_cnt = x;	
			return;
		}
	}
}

// ********************************************************************************************
// ********************************************************************************************












// ********************************************************************************************
// Konfiguration counter
// ********************************************************************************************

// Counter-Konfiguration: Registerkarten (tabs) oeffnen
// Da tabs und content gleichen z-Index haben, muessen die tabs hinter dem content angelegt werden!
// (Gleicher z-index noetig, um Info darueber legen zu koennen)
function counter_tabsOpen ()
{

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab0	
	var config_0 = 	
					'<form name="form_tab0">'+ 		

					'<div class="pos x0101 textfield"> Name: </div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="" name="name"> </div> '+
					'<div class="pos p0103"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Name()"> </a> </div>'+

					'<div class="pos x0201 textfield"> MBus-ID: </div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="" name="mbus_id" readonly="readonly"> </div> '+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_MBusID()"> </a> </div>'+

					'<div class="pos x0301"> '+ins("mbus_config_counter_type")+' </div>'+
					'<div class="pos x0303">'+
					'<select name="ztype" size="1" class="combobox long_200">'+
						'<option value="Normal"> '+ins("mbus_config_standard")+'</option>'+
						'<option value="S0"> 4xS0/M-Converter (BTR), DIx/S0x </option>'+
						'<option value="Temp">4xT/M-Converter (BTR), AIx </option>'+
						'</select>'+
					'</div>'+
					'<div class="pos p0303">'+
						'<a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_ztype()"> </a>'+
					'</div>'+

					'<div class="pos x0401"> <input type="checkbox" name="primAdr" checked="checked"> '+ins("mbus_config_addr_primary")+' </div>'+
					'<div class="pos p0403"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_primAdr()"> </a> </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="counter_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="counter_tabsClose(0)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab1	
	var config_1 = 	
					'<form name="form_tab1">'+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_config_counter_nr")+': </div>'+
					'<div class="pos x0104"> <input type="text" class="textfield long_200" value="" name="ZNummer"> </div> '+
					'<div class="pos p0103"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_ZNummer()"> </a> </div>'+

					'<div class="pos x0201 textfield"> '+ins("mbus_config_counter_client")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield long_200" value="" name="Mandant"> </div> '+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Mandant()"> </a> </div>'+

					'<div class="pos x0301 textfield"> '+ins("mbus_config_counter_customer")+': </div>'+
					'<div class="pos x0304"> <input type="text" class="textfield long_200" value="" name="AbnNr"> </div> '+
					'<div class="pos p0303"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_AbnNr()"> </a> </div>'+

					'<div class="pos x0501 comment"> '+ins("mbus_config_counter_optional")+' </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="counter_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="counter_tabsClose(0)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab2	
	var config_2 = 	
					'<form name="form_tab2">'+ 		

					'<div class="pos p0003"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_MeteringCode()"> </a> </div>'+
					'<div class="pos x0101 textfield"> '+ins("mbus_config_counter_country")+': </div>'+
					'<div class="pos x0104"> <input type="text" class="textfield long_200" value="" name="Land"> </div> '+
					'<div class="pos x0201 textfield"> '+ins("mbus_config_counter_operator")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield long_200" value="" name="Betreiber"> </div> '+
					'<div class="pos x0301 textfield"> '+ins("mbus_config_counter_plz")+': </div>'+
					'<div class="pos x0304"> <input type="text" class="textfield long_200" value="" name="Plz"> </div> '+
					'<div class="pos x0401 textfield"> '+ins("mbus_config_counter_meas_id")+': </div>'+
					'<div class="pos x0404"> <input type="text" class="textfield long_200" value="" name="MePuId"> </div> '+
					'<div class="pos x0501 comment"> '+ins("mbus_config_counter_optional")+' </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="counter_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="counter_tabsClose(0)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Register anlegen	

	// erst content anlegen	
	var tabContent = new Array();
	tabContent[0] = config_0;
	tabContent[1] = config_1;
	tabContent[2] = config_2;
	guiTabs.Content ("config_box", tabContent, tabContent.length, 'Tools', 500, 200, "window", true);
	
	// dann tabs anlegen
	var tabText = new Array();
	tabText[0] = "Parameter";
	tabText[1] = ins("mbus_config_meas_point");		// "Messpunkt"
	tabText[2] = "Meter.-Code";
	guiTabs.Create ("tab", tabText, tabText.length, 'Tools', 500, 200, "window");

	// default-Tab setzen
	guiTabs.Select (0);

	// ---------------------------------------------------------------------------------------
	// Felder aus Konfig-File aktualisieren, wenn vorhanden
	// tab0
	if (counterObj)
	{
		// tab0
		// Name
		document.form_tab0.name.value = counterObj.Name;

		// MBus-ID
		document.form_tab0.mbus_id.value = counterObj.BusAdr;
	
		// ztype
		for (var i=0; i<document.form_tab0.ztype.length; i++)
		{
			if (document.form_tab0.ztype[i].value == counterObj.ztype.Kinds)
				document.form_tab0.ztype.selectedIndex = i;
		}

		// primAdr
		if (counterObj.busdetails.Text_3 == "true")		document.form_tab0.primAdr.checked = true;
		else											document.form_tab0.primAdr.checked = false;

		// tab1
		document.form_tab1.ZNummer.value = counterObj.ZNummer;
		document.form_tab1.Mandant.value = counterObj.Mandant;
		document.form_tab1.AbnNr.value = counterObj.AbnNr;

		// tab2
		document.form_tab2.Land.value = counterObj.meteringcode.Land;
		document.form_tab2.Betreiber.value = addLeadingZeros (counterObj.meteringcode.Betreiber, 6); 
		document.form_tab2.Plz.value = addLeadingZeros (counterObj.meteringcode.Plz, 5);
		document.form_tab2.MePuId.value = counterObj.meteringcode.MePuId;
	}
}

// ********************************************************************************************

function counter_tabsClose (valid)
{

	top.hideMessageBox();

	if (valid)
	{
		// alert ("Eingaben werden gespeichert ... ");
		// aktualisierte Felder speichern
		
		// tab0
		// Pruefen Namen Eingabe
		var ret = top.checkInputString ("Name", document.form_tab0.name.value, "^[A-Za-z0-9 _-]{1,50}$"); 	// Name, 1 - 50 Zeichen, alphanum.+ _-
		if (ret == -1)
			return;

		// Name	
		counterObj.Name = document.form_tab0.name.value;
		// ztype
		var i = document.form_tab0.ztype.selectedIndex;
		counterObj.ztype.Kinds = document.form_tab0.ztype[i].value;
		switch (counterObj.ztype.Kinds)
		{
			case "Normal":	counterObj.ZTyp_ID = 1;		break;
			case "S0":		counterObj.ZTyp_ID = 2;		break;
			case "Temp":	counterObj.ZTyp_ID = 3;		break;
		}
		// primAdr
		if (document.form_tab0.primAdr.checked == true)		counterObj.busdetails.Text_3 = "true";
		else												counterObj.busdetails.Text_3 = "false";

		// tab1
		// Pruefen Messpunkt Eingaben (Zaehler-Nummer, Mandant, Abnehmer-Nummer)	
		var ret = top.checkInputString (ins("mbus_config_counter_nr"), document.form_tab1.ZNummer.value, "^[A-Za-z0-9_]{0,50}$"); 	// Zaehler-Nummer, max.50 Zeichen, alphanum.+_
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_client"), document.form_tab1.Mandant.value, "^[A-Za-z0-9_ ,]{0,50}$"); 	// Mandant, max.50 Zeichen, alphanum.+_ ,
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_customer"), document.form_tab1.AbnNr.value, "^[A-Za-z0-9_]{0,50}$"); 	// Abn.-Nummer, max.50 Zeichen, alphanum.+_
		if (ret == -1)
			return;

		counterObj.ZNummer = document.form_tab1.ZNummer.value;
		counterObj.Mandant = document.form_tab1.Mandant.value;
		counterObj.AbnNr = document.form_tab1.AbnNr.value;

		// tab2
		// Pruefen Metring-Code Eingaben	
		var ret = top.checkInputString (ins("mbus_config_counter_country"), document.form_tab2.Land.value, "^[A-Z]{2}$"); 	// Land, 2 Zeichen, Grossbuchstaben
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_operator"), document.form_tab2.Betreiber.value, "^[0-9]{6}$"); 	// Betreiber, 6 Ziffern
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_plz"), document.form_tab2.Plz.value, "^[0-9]{5}$"); 	// PLZ, 5 Ziffern
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_meas_id"), document.form_tab2.MePuId.value, "^[A-Za-z0-9]{20}$"); 	// Messpunkt-ID, 20 Zeichen
		if (ret == -1)
			return;

		counterObj.meteringcode.Land = document.form_tab2.Land.value;
		counterObj.meteringcode.Betreiber = addLeadingZeros (parseInt(document.form_tab2.Betreiber.value), 6);
		counterObj.meteringcode.Plz = addLeadingZeros (parseInt(document.form_tab2.Plz.value), 5);
		counterObj.meteringcode.MePuId = document.form_tab2.MePuId.value;

		// Merker fuer Aenderungsdatum
		conf_state = 1;
	}

	// Tabs schliessen	
	guiTabs.CloseTabs ("tab");
	guiTabs.CloseTabs ("config_box");
}

// ********************************************************************************************
// fuehrende Nullen auffuellen
function addLeadingZeros (number, length)
{
	var num = '' + number;
	while (num.length < length)
		num = '0' + num;
	return num;
}

// ********************************************************************************************
// ********************************************************************************************








// ********************************************************************************************
// Konfiguration channel
// ********************************************************************************************

// Konfiguration: Registerkarten (tabs) oeffnen
// Da tabs und content gleichen z-Index haben, muessen die tabs hinter dem content angelegt werden!
// (Gleicher z-index noetig, um Info darueber legen zu koennen)
function channel_tabsOpen (channel)
{

	var str = JSON2.stringify (channelArr[channel], null, 4);
	// alert ("channelArr "+channel+"\n"+str);

		
	// Unterscheidung Spezialkonfigurationen
	var ztype = "Normal";
	var tel = channelArr[channel].Tele;
	var rec = channelArr[channel].Rec;

	// S0-records ermitteln, nur diese sollen als S0/M behandelt werden
	if (counterObj.ztype.Kinds == "S0")
	{
		if (mbusResponseObj.records[tel-1][rec-1].descriptor == "Cumulation Counter")	
			ztype = "S0";
	} 
	
	// TM-records ermitteln, nur diese sollen als T/M behandelt werden
	if (counterObj.ztype.Kinds == "Temp")
	{
		if ((tel == 1) && (rec == 3))
			ztype = "Temp";
	}

	// Pruefen, ob S0- oder Temp-Objekte vorhanden sind
	if ((ztype == "S0") && (channelArr[channel].S0 == undefined))
	{
		// S0 anlegen
		channelArr[channel].S0 = new Object();
		channelArr[channel].S0.Kanal_ID = counterObj.ID;
		channelArr[channel].S0.AZStand = 0;
		channelArr[channel].S0.AImpulse = -1;
		channelArr[channel].S0.ImpProEinheit = 1;
	}	

	if ((ztype == "Temp") && (channelArr[channel].Temp == undefined))
	{
		// Temp anlegen
		channelArr[channel].Temp = new Object();
		channelArr[channel].Temp.Kanal_ID = counterObj.ID;
		channelArr[channel].Temp.SensTyp = 0;
		channelArr[channel].Temp.Offset = 0;
	}	

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab0	
	var config_0 = 	'<form name="form_tab0">'+ 		
					'<div class="pos x0101"> '+ins("mbus_config_channel_interval")+' </div>'+
					'<div class="pos x0103">'+
						'<select name="interval" size="1" class="combobox long_100">'+
							'<option value="1"> 1 min </option>'+
							'<option value="5"> 5 min </option>'+
							'<option value="15"> 15 min </option>'+
							'<option value="30"> 30 min </option>'+
							'<option value="60"> 1 h </option>'+
							'<option value="120"> 2 h </option>'+
							'<option value="240"> 4 h </option>'+
							'<option value="360"> 6 h </option>'+
							'<option value="720"> 12 h </option>'+
							'<option value="day"> daily </option>'+
							'<option value="week"> weekly </option>'+
							'<option value="month"> monthly </option>'+
							'<option value="quart"> quarterly </option>'+
							'<option value="half"> half-yearly </option>'+
							'<option value="year"> yearly </option>'+
							'<option value="none"> none </option>'+
							'</select>'+
					'</div>'+
					'<div class="pos p0103">'+
							'<a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_interval()"> </a>'+
					'</div>'+
					
					'<div class="pos x0201 textfield"> '+ins("mbus_config_channel_readout")+': </div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="" name="EAblesung"> </div> '+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_EAblesung()"> </a> </div>'+

					'<div class="pos x0301 textfield"> '+ins("mbus_config_channel_factor")+': </div>'+
					'<div class="pos x0303"> <input type="text" class="textfield long_50" value="" name="Faktor_U"> </div> '+
					'<div class="pos x0305"> <input type="text" class="textfield long_50" value="" name="Faktor_I"> </div> '+
					'<div class="pos p0303"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Faktor()"> </a> </div>'+

					'<div class="pos x0401 textfield"> '+ins("mbus_config_channel_primaer")+' </div>'+
					'<div class="pos x0403">'+
					'<select name="Primaer" size="1" class="combobox long_100">'+
						'<option value=0> '+ins("mbus_config_channel_primaer_no")+'</option>'+
						'<option value=1> '+ins("mbus_config_channel_primaer_yes")+'</option>'+
						'</select>'+
					'</div>'+
					'<div class="pos p0403"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Primaer()"> </a> </div>'+

					'<div class="pos x0501"> '+ins("mbus_config_channel_app")+' </div>'+
					'<div class="pos x0503">'+
						'<select name="App" size="1" class="combobox long_200">'+
							'</select>'+
					'</div>'+
					'<div class="pos p0503">'+
						'<a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_app()"> </a>'+
					'</div>'+

					'<div class="pos x0601"> '+ins("mbus_config_channel_mtype")+' </div>'+
					'<div class="pos x0603">'+
						'<select name="MType" size="1" class="combobox long_100">'+
							'<option value="normal"> '+ins("mbus_config_channel_mtype_normal")+'</option>'+
							'<option value="average"> '+ins("mbus_config_channel_mtype_average")+'</option>'+
							'</select>'+
					'</div>'+
					'<div class="pos p0603">'+
						'<a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_mtype()"> </a>'+
					'</div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="channel_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="channel_tabsClose(0)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab1	
	// abhaengig vom Parameter ztype, aber nur fuer entsprechende records
	switch (ztype)
	{
		case "Normal":	
			var config_1 = 	
					'<form name="form_tab1">'+ 		
					'<div class="pos x0101"> '+ins("mbus_config_channel_no_param")+' </div>'+
					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="channel_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="channel_tabsClose(0)">'+
					'</div>';
					'</form>';
			break;

		case "S0":
			var config_1 =
					'<form name="form_tab1">'+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_config_channel_initial_count")+': </div>'+
					'<div class="pos x0104"> <input type="text" class="textfield long_100" value="" name="AZStand"> </div> '+
					'<div class="pos p0103"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_AZStand()"> </a> </div>'+

					'<div class="pos x0201 textfield"> '+ins("mbus_config_channel_initial_pulse")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield long_100" value="" name="AImpulse" readonly="readonly"> </div>'+
					'<div class="pos x0207"> <input type="text" class="textfield_show" style="color:#f80007; width:50px" value="" name="checkValue"> </div>'+   
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_AImpulse()"> </a> </div>'+

					'<div class="pos x0301 textfield"> '+ins("mbus_config_channel_pulsperunit")+': </div>'+
					'<div class="pos x0304"> <input type="text" class="textfield long_100" value="" name="ImpProEinheit"> </div>'+
					'<div class="pos p0303"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_ImpProEinheit()"> </a> </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="channel_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="channel_tabsClose(0)">'+
					'</div>';
					'</form>';
			break;


		case "Temp":
			var config_1 =
					'<form name="form_tab1">'+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_config_channel_sensor")+' </div>'+
					'<div class="pos x0104"> '+ 
						'<select name="SensTyp" size="1" class="combobox long_150"> '+
						'<option value = 0> '+ins("mbus_config_channel_resistor")+' </option> '+
						'<option value = 1> PT100 (-30 .. +130 &deg;C) </option> '+
						'<option value = 2> PT500 (-30 .. +130 &deg;C) </option> '+
						'<option value = 3> PT1000 (-30 .. +130 &deg;C) </option> '+
						'<option value = 4> NI100 (-30 .. +130 &deg;C) </option> '+
						'<option value = 5> NI1000 (-30 .. +130 &deg;C) </option> '+
						'<option value = 6> NTC1k8 (-30 .. +130 &deg;C) </option> '+
						'<option value = 7> NTC10k (-30 .. +130 &deg;C) </option> '+
						'<option value = 8> NTC20k (-30 .. +130 &deg;C) </option> '+
						'<option value = 9> KTY10 (-30 .. +130 &deg;C) </option> '+
						'<option value = 10> PT100 (0 .. +400 &deg;C) </option> '+
						'<option value = 11> PT1000 (0 .. +400 &deg;C) </option> '+
						'</select> '+
					'</div> '+
					'<div class="pos p0103"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_SensTyp()"> </a> </div>'+

					'<div class="pos x0201 textfield"> '+ins("mbus_config_channel_offset")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield" size="4" maxlength="4" value="0" name="Offset"> </div>'+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Offset()"> </a> </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="channel_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="channel_tabsClose(0)">'+
					'</div>';
					'</form>';
			break;
	}

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab2	
	var config_2 = 	
					'<form name="form_tab2">'+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_config_channel_obis")+': </div>'+
					'<div class="pos x0104"> <input type="text" class="textfield long_200" value="" name="Obis_ID"> </div> '+
					'<div class="pos p0103"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Obis()"> </a> </div>'+

					'<div class="pos x0201 textfield"> '+ins("mbus_config_channel_description")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield long_200" value="" name="description"> </div> '+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_description()"> </a> </div>'+


					'<div class="pos x0301 textfield"> '+ins("mbus_config_channel_edit_factor")+': </div>'+
					'<div class="pos x0304"> <input type="text" class="textfield long_100" value="" name="Faktor_edit"> </div>'+
					'<div class="pos p0303"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_FaktorEdit()"> </a> </div>'+

					'<div class="pos x0401 textfield"> '+ins("mbus_config_channel_edit_unit")+': </div>'+
					'<div class="pos x0404"> <input type="text" class="textfield long_100" value="" name="Einheit_edit"> </div>'+
					'<div class="pos p0403"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_MEinheit()"> </a> </div>'+


					'<div class="pos x0501 comment"> '+ins("mbus_config_counter_optional")+' </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="channel_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="channel_tabsClose(0)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Register anlegen	

	// erst content anlegen	
	var tabContent = new Array();
	tabContent[0] = config_0;
	tabContent[1] = config_1;
	tabContent[2] = config_2;
	guiTabs.Content ("config_box", tabContent, tabContent.length, 'Tools', 500, 230, "window", true);

	// dann tabs anlegen
	var tabText = new Array();
	tabText[0] = "Parameter";
	switch (ztype)
	{
		case "Normal": 	
			tabText[1] = "-";	
			break;
		case "S0":
			tabText[1] = "S0/M";		
			break;
		case "Temp":		
			tabText[1] = "T/M";		
			break;
	}
	tabText[2] = "Options";
	guiTabs.Create ("tab", tabText, tabText.length, 'Tools', 500, 230, "window");

	// default-Tab setzen
	guiTabs.Select (0);

	// ---------------------------------------------------------------------------------------
	// Felder aus Konfig-File aktualisieren, wenn vorhanden
	// tab0

	if (channelArr[channel])
	{
		// tab0
		// Intervall
		for (var i=0; i<document.form_tab0.interval.length; i++)
		{
			if (document.form_tab0.interval[i].value == channelArr[channel].Intervall)
				document.form_tab0.interval.selectedIndex = i;
		}

		// Termin Erstablesung
		if (channelArr[channel].EAblesung == "")
		{
			// Intervall auf naechste 15-Minuten-Grenze setzen
//			var interval = document.form_tab0.interval[i].value;			
			var time = setTimeToNextInterval (5);		
			document.form_tab0.EAblesung.value = getTimeInSQLFormat (time);		
		}		
		else
			document.form_tab0.EAblesung.value = channelArr[channel].EAblesung;
		
		// Faktor
		document.form_tab0.Faktor_U.value = channelArr[channel].Faktor_U;
		document.form_tab0.Faktor_I.value = channelArr[channel].Faktor_I;

		// Primaerzaehler
		for (var i=0; i<document.form_tab0.Primaer.length; i++)
		{
			if (document.form_tab0.Primaer[i].value == channelArr[channel].Primaer)
				document.form_tab0.Primaer.selectedIndex = i;
		}

		// Applikationen
		addSelectOption (document.form_tab0.App, "none", "none");
		if (document.form_tab0.App[0].value == channelArr[channel].App)
			document.form_tab0.App.selectedIndex = 0;
		for (var i=0; i<appObject.app.length; i++)
		{
			addSelectOption (document.form_tab0.App, appObject.app[i], appObject.app[i]);
			if (document.form_tab0.App[i+1].value == channelArr[channel].App)
				document.form_tab0.App.selectedIndex = i+1;
		}

		// Messtyp
		if (channelArr[channel].MessTyp == "")
		{
			// default = "normal"
			document.form_tab0.MType.selectedIndex = 0;
		}
		else
		{
			for (var i=0; i<document.form_tab0.MType.length; i++)
			{
				if (document.form_tab0.MType[i].value == channelArr[channel].MessTyp)
					document.form_tab0.MType.selectedIndex = i;
			}
		}


		// tab1
		switch (ztype)
		{
			case "Normal":	
				break;

			case "S0":
				// S0 / Anfangszaehlerstand
				document.form_tab1.AZStand.value = channelArr[channel].S0.AZStand;			

				// 3 verschiedene Typen S0/M-Konverter: S0/M 1x alt, S0/M 1x neu, S0/M 4x
				switch (checkConverterType())
				{
					case "S0/M 1x old":		
					case "S0/M 1x new":		
						// S0 / Anfangsimpulsstand ermitteln, falls Feld noch leer
						if (mbusResponseObj && (channelArr[channel].S0.AImpulse == -1))
							document.form_tab1.AImpulse.value = parseInt(mbusResponseObj.records[0][2].value);
						else
							document.form_tab1.AImpulse.value = channelArr[channel].S0.AImpulse;
						break;

					// ab v1.17, geaendert 27.02.2013:
					// wenn am S0/M-Konverter der Einmann-Inbetriebnahme-Knopf nicht gedrueckt wurde, soll der 
					// aktuelle Wert gespeichert werden und eine Warnung ausgegeben werden
					case "S0/M 4x":		
						if (mbusResponseObj && (channelArr[channel].S0.AImpulse == -1))
						{
							document.form_tab1.AImpulse.value = parseInt(mbusResponseObj.records[0][2].value);
							if (mbusResponseObj.records[0][3].value == 0)
							{
								// Warnung: Taster am S0/M-Converter nicht gedrueckt !!
								document.form_tab1.checkValue.value = "Check !!";
							}							
						}
						else
							document.form_tab1.AImpulse.value = channelArr[channel].S0.AImpulse;
						break;
				}

				// S0 / Impulse pro Einheit		
				document.form_tab1.ImpProEinheit.value = channelArr[channel].S0.ImpProEinheit;
				break;

			case "Temp":
				// Temp / SensorTyp
				for (var i=0; i<document.form_tab1.SensTyp.length; i++)
				{
					if (document.form_tab1.SensTyp[i].value == channelArr[channel].Temp.SensTyp)
						document.form_tab1.SensTyp.selectedIndex = i;
				}
				// Temp / Offset
				document.form_tab1.Offset.value = channelArr[channel].Temp.Offset;
				break;
		}	

		// tab2
		document.form_tab2.Obis_ID.value = channelArr[channel].Obis_ID;			
		document.form_tab2.description.value = channelArr[channel].ZwTyp;			

		// Faktor_edit, Einheit_edit
		if (channelArr[channel].Faktor_edit == 0)
		{
			// neu installiert, Werte vom MBus/unit uebernehmen
			// unit aufsplitten in Faktor und Einheit;
			// wird ein arr zurueckgegeben, dann ist arr[0] = Faktor und arr[1] = Einheit;
			// wird ein string zurueckgegeben, dann enhaelt unit keinen Faktor
			var arrUnit = splitUpUnit (channelArr[channel].MEinheit);
			if (isArray(arrUnit))
			{	
				document.form_tab2.Faktor_edit.value = arrUnit[0];
				document.form_tab2.Einheit_edit.value = arrUnit[1]; 
			}
			else
			{
				document.form_tab2.Faktor_edit.value = "1";
				document.form_tab2.Einheit_edit.value = arrUnit; 
			}
		}
		else
		{
			// bereits editiert, gespeicherte Werte aus DB uebernehmen
			document.form_tab2.Faktor_edit.value = channelArr[channel].Faktor_edit;
			document.form_tab2.Einheit_edit.value = channelArr[channel].Einheit_edit;
		}
	}
}

// ********************************************************************************************

function channel_tabsClose (valid)
{
	top.hideMessageBox();

	if (valid)
	{
		// alert ("Eingaben werden gespeichert ... ");
		// Aenderungen werden in channelArr[x] zurueckgeschrieben	

		// Unetrscheidung Spezialkonfigurationen
		var ztype = counterObj.ztype.Kinds;

		var tel = channelArr[channel_cnt].Tele;	
		var rec = channelArr[channel_cnt].Rec;

		// S0-records ermitteln, nur diese sollen als S0/M behandelt werden
		if (counterObj.ztype.Kinds == "S0")
		{
			if (mbusResponseObj.records[tel-1][rec-1].descriptor == "Cumulation Counter")	
				ztype = "S0";
			else								
				ztype = "Normal" 
		} 	
		// TM-records ermitteln, nur diese sollen als T/M behandelt werden
		if (counterObj.ztype.Kinds == "Temp")
		{
			if ((tel == 1) && (rec == 3))
				ztype = "Temp";
			else
				ztype = "Normal";
		}

		
		// aktualisierte Felder speichern

		// tab0
		// Pruefen Eingaben	
		// Faktor U,I
		var ret = top.checkInputString (ins("mbus_config_channel_factor"), document.form_tab0.Faktor_U.value, "^[0-9]{1,50}$"); 	// Faktor_U, 1 - 50 Zeichen, Ziffern
		ret |= top.checkInputString (ins("mbus_config_channel_factor"), document.form_tab0.Faktor_I.value, "^[0-9]{1,50}$"); 		// Faktor_I, 1 - 50 Zeichen, Ziffern
		if (ret == -1)
			return;
		// EAblesung
		ret = top.checkDBTimeFormat (ins("mbus_config_channel_readout"), document.form_tab0.EAblesung.value);
		if (ret == -1)
			return;

		// Intervall
		var i = document.form_tab0.interval.selectedIndex;
		channelArr[channel_cnt].Intervall = document.form_tab0.interval[i].value;

		// EAblesung
		channelArr[channel_cnt].EAblesung = document.form_tab0.EAblesung.value;

		// Faktor
		channelArr[channel_cnt].Faktor_U = document.form_tab0.Faktor_U.value; 
		channelArr[channel_cnt].Faktor_I = document.form_tab0.Faktor_I.value; 

		// Primaerzaehler
		var i = document.form_tab0.Primaer.selectedIndex;
		channelArr[channel_cnt].Primaer = document.form_tab0.Primaer[i].value;

		// Applikation
		var i = document.form_tab0.App.selectedIndex;
		channelArr[channel_cnt].App = document.form_tab0.App[i].value;	

		// MessTyp
		var i = document.form_tab0.MType.selectedIndex;
		channelArr[channel_cnt].MessTyp = document.form_tab0.MType[i].value;	

		// tab1
		switch (ztype)
		{
			case "Normal":	
				break;

			case "S0":
				// Pruefen Eingaben	
				if (document.form_tab1.AZStand.value.indexOf(",") != -1)
				{	
					// "Dezimaltrenner muss als Punkt angegeben werden."
					top.messageBox (ins("mbus_config_channel_input_error"), ins("mbus_config_channel_input_delimeter"));
					return;	
				}

				var ret = top.checkInputString (ins("mbus_config_channel_initial_count"), document.form_tab1.AZStand.value, "^[0-9\.]{1,50}$"); 	// AZStand, 1 - 50 Zeichen, Ziffern+.
				if (ret == -1)
					return;
		
				var ret = top.checkInputString (ins("mbus_config_channel_pulsperunit"), document.form_tab1.ImpProEinheit.value, "^[0-9]{1,50}$"); 	// ImpProEinheit, 1 - 50 Zeichen, Ziffern
				if (ret == -1)
					return;

				// S0 / Kanal_ID
				channelArr[channel_cnt].S0.Kanal_ID = channelArr[channel_cnt].ID;
				// S0 / Anfangsimpulsstand 
				channelArr[channel_cnt].S0.AImpulse = document.form_tab1.AImpulse.value;
				// S0 / Anfangszaehlerstand
				channelArr[channel_cnt].S0.AZStand = document.form_tab1.AZStand.value;
				// S0 / Impulse/Einheit		
				channelArr[channel_cnt].S0.ImpProEinheit = document.form_tab1.ImpProEinheit.value;
				break;

			case "Temp":
				// Pruefen Eingabe Offset	
				var ret = top.checkInputString (ins("mbus_config_channel_offset"), document.form_tab1.Offset.value, "^[0-9\-.]{1,4}$"); 	// Offset, 1-4 Zeichen, Ziffern und -.
				if (ret == -1)
					return;

				// Temp / SensorTyp
				var i = document.form_tab1.SensTyp.selectedIndex;
				channelArr[channel_cnt].Temp.SensTyp = document.form_tab1.SensTyp[i].value;	
				// Temp / Offset
				channelArr[channel_cnt].Temp.Offset = document.form_tab1.Offset.value;
				break;
		}	

		// tab2
		// Pruefen Eingaben 	
		var ret = top.checkInputString (ins("mbus_config_channel_obis"), document.form_tab2.Obis_ID.value, "^[0-9\.\:\*\-]{0,50}$"); 	// OBIS, 1 - 50 Zeichen, Ziffern+.:*-
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_channel_description"), document.form_tab2.description.value, "^[A-Za-z0-9_\ \.\/\=?\!\%-:,]{0,50}$"); 	// 0 - 50 Zeichen, alphanum.+_./=?!%-:,
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_channel_edit_factor"), document.form_tab2.Faktor_edit.value, "^[0-9-\.]{1,50}$"); 	// 1 - 50 Zeichen, Ziffern+.-
		if (ret == -1)
			return;
		// Eingabe "Einheit" wird auf Grund der vielen Optionen nicht ueberprueft

		channelArr[channel_cnt].Obis_ID = document.form_tab2.Obis_ID.value;	
		channelArr[channel_cnt].ZwTyp = document.form_tab2.description.value;	

		// Aenderungszeit schreiben (DB-Format)
		var time = new Date();	
		channelArr[channel_cnt].Aenderung = getTimeInSQLFormat (time);	
		
		// Faktor, Einheit editiert
		channelArr[channel_cnt].Faktor_edit = document.form_tab2.Faktor_edit.value;			// editierter Faktor
		channelArr[channel_cnt].Einheit_edit = document.form_tab2.Einheit_edit.value;		// editierte Einheit
	}
		
	// Tabs schliessen	
	guiTabs.CloseTabs ("tab");
	guiTabs.CloseTabs ("config_box");
}

// ********************************************************************************************
// ********************************************************************************************

// Warnhinweis anzeigen
function warning_show ()
{

	var headline =  '<B>'+ins("mbus_config_message_note")+'</B>';
	var content =	'<div class="pos x0101 textfield">' +ins("mbus_config_message_mp")+ 
					'</div>' +

					'<div id="button_position">' +
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="warning_result (1)">' +
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="warning_result (0)">' +
					'</div>';
	
	guiPopup.Show ("message", headline, content, 'Info', 500, 150, "window");
}

// ********************************************************************************************

// Warnhinweis auswerten
function warning_result (result)
{
	// Auswertung
	if (result)
	{
		// Zaehlerkonfiguration speichern
		mbus_setConfiguration();
	}

	// SD-Card_Box schliessen
	guiPopup.CloseMe("message");

	// Button freigeben
	releaseButton();
}

// ********************************************************************************************

// S0/M-Konvertertyp ermitteln
function checkConverterType ()
{
	if (mbusResponseObj.records[0][3] == undefined)
		return "S0/M 1x old";

	if (mbusResponseObj.records[0][4] == undefined)
		return "S0/M 1x new";
	
	return "S0/M 4x";
}

// ********************************************************************************************
// ********************************************************************************************









// ********************************************************************************************
// Konfiguration zum EWIO senden
// ********************************************************************************************

// Konfiguration speichern und MBus-Telegramme versenden
function mbus_setConfiguration()
{
	// Messagebox
	top.messageBox_Wait_ext (ins("mbus_config_message_counter_store"));

	// counter in DB speichern
	mbus_setCounter();

	// Wartezeit berechnen
	channelWait = 6000 + (channelArr.length * 2000);

	// channel in DB speichern
	setTimeout ("mbus_setChannels()", 6000);

	// S0 / Temp
	if (counterObj.ZTyp_ID == 2)
	{
		// wenn Taster gedrueckt war (Installations-Flag gesetzt), dann Flag zuruecksetzen
		if (mbusResponseObj.records[0][3].value == 1)
			setTimeout ("setControl (busPath, counterObj.BusAdr, 0xE6)", channelWait+500);
	}

	if (counterObj.ZTyp_ID == 3)
	{
		getTempValues();
		// alert (sensType+"   "+tempOffset);
		setTimeout ("setSensor (busPath, counterObj.BusAdr, sensType)",channelWait);
		setTimeout ("setTempOffset (busPath, counterObj.BusAdr, tempOffset)",channelWait+500);
	}

	// Primaeradressen setzen oder loeschen ensprechend Konfiguration
	if (counterObj.busdetails.Text_3 == "true")	
		setTimeout ("setPrimaryAdress()", channelWait+1000);
	else
		setTimeout ("resetPrimaryAddress (busPath, moduleId)", channelWait+1000);


	// ----------------------------------------------------------------------------------------
	// tree aktualisieren
	var newTreeObj = mbus_setTreeData (top.frame_tree.treeDataObj);
	top.frame_tree.treeDataObj = newTreeObj;
	oStr = JSON2.stringify (newTreeObj, null, 0);	// Object -> String

	// neuen tree zum EWIO senden
	setTimeout ("top.frame_tree.shadeTree (1)", channelWait+1000);
	setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", channelWait+2000);

	// Navigation refresh
	setTimeout ("top.frame_tree.tree_getData_mbusConfiguration(oStr)", channelWait+2000);

	// primary.json aktualisieren
	setTimeout ("top.getDataExtended ('/config/configbase/primary.json', 'fileload', 'top.frame_content.mbus_modifyPrimaryAdr(actStr)')", channelWait+3000);

	// Button freigeben
	setTimeout ("releaseButton()", channelWait+4000);
}

// ********************************************************************************************

// counter in DB speichern
function mbus_setCounter()
{
	// die meisten Properties wurden bereits bei tabsClose() gespeichert;
	// es fehlen Bus und BR

	// Bus einlesen
	var i = document.form_bus.bus.selectedIndex;
	counterObj.btype.Kinds = document.form_bus.bus[i].text;	
	switch (counterObj.btype.Kinds)
	{
		case "MBus":	counterObj.BTyp_ID = 1;		break;
		case "System":	counterObj.BTyp_ID = 2;		break;
	}

	// Busdetails einlesen (Pfad)
	var i = document.form_bus.bus.selectedIndex;
	var bus = document.form_bus.bus[i].value;	
	if (bus == "MBus")	
		busPath = top.mbus_path;	
	if (bus == "System")	
	{
		var i = document.form_bus.subBus.selectedIndex;
		busPath = document.form_bus.subBus[i].value;	
		var subType = document.form_bus.subBus[i].text;	
	}
	counterObj.busdetails.Text_1 = busPath;
	counterObj.busdetails.Text_2 = subType;

	// BR einlesen
	for (var i=0; i<document.form_baudrate.rBr.length; i++)
	{
		if (document.form_baudrate.rBr[i].checked == true)
			counterObj.BR = parseInt (document.form_baudrate.rBr[i].value);
	}

	// Namen merken
	moduleName = counterObj.Name;

	var objStr = JSON2.stringify (counterObj, null, 4);
	// alert (objStr);

	// Konfigurationsfile schreiben
	moduleId = top.tree_getPageName()[1];
	top.setDataExtended (moduleId, "counter", objStr);


	// in alle channel Aenderungszeit schreiben, wenn Aenderungen in der counter_config
	if (conf_state)
	{
		var time = new Date();	
		for (var i=0; i<channelArr.length; i++)
			channelArr[i].Aenderung = getTimeInSQLFormat (time);	
	}
}

// ********************************************************************************************

// channel in DB speichern
function mbus_setChannels ()
{
	// Messagebox Channels
	msgChannel = 0;
	interval_timeout = setInterval ("messageChannel()", 2000);

	var outObj = new Object();
	outObj.channel = new Array();

	var j=0;
	for (var i=0; i<channelArr.length; i++)
	{
		// S0/Temp ?
		if (counterObj.ZTyp_ID == 1)
		{
			// alert ("Normal");
			delete channelArr[i].S0; 
			delete channelArr[i].Temp; 
		}
		if (counterObj.ZTyp_ID == 2)
		{
			// alert ("S0");
			delete channelArr[i].Temp; 
		}
		if (counterObj.ZTyp_ID == 3)
		{
			// alert ("Temp");
			delete channelArr[i].S0; 
		}

		// Ausgabe zusammenstellen, nur markierte channel
		if (getChannelState (channelArr[i]) == 1)
			outObj.channel[j++] = channelArr[i];	
	}

	outStr = JSON2.stringify (outObj, null, 4);	// Object -> String					
	// alert (outStr);

	top.setDataExtended (moduleId, "channels", outStr);

	// Sind channels ausgewaehlt worden?
	// wenn nicht, dann channelArr zuruecksetzen, damit korrekte Anzeige im Tree
	if (j == 0)
		channelArr.length = 0;

	// Tabelle loeschen, damit fuer Aenderungen die channel neu abgerufen werden muessen (ID!)
	var tbody = document.getElementById("tab_mbus_id");
	while (tbody.rows.length > 0)
		tbody.deleteRow(0);

}

// ********************************************************************************************

// Pruefen, ob ein konfigurierter channel aktiv gesetzt ist oder nicht
function getChannelState (channel)
{
	// Durch alle Reihen der Tabelle greppen und tel/rec vergleichen
	var table = document.getElementById ("tab_mbus_id");
	for (var i=0; i<table.rows.length; i++)
	{	
		// Checkbox aktiv?	
		var check = eval ('document.getElementsByName("check_'+i+'")');
		if (check[0] === undefined)
			continue;					// checkbox nicht vorhanden
		else
		{
			if 	(check[0].checked == true)
			{
				// tel und rec ermitteln
				var t_tel = getTableElement ("tab_mbus_id", i, 0);
				var t_rec = getTableElement ("tab_mbus_id", i, 1);
				t_tel = parseInt(t_tel); 
				t_rec = parseInt(t_rec); 

				// alert ("channel t_tel "+t_tel+"    t_rec "+t_rec);

				// channel-Konfiguration ermitteln
				var tel = channel.Tele;
				var rec = channel.Rec;

//				 alert ("channel tel "+tel+"    rec "+rec);
	
				if ((t_tel == tel) && (t_rec == rec))		
				{
					// alert ("channel "+start+" speichern: "+tel+" "+rec);
					return 1;
				}
			}
			else
			{
				continue;
			}
		}
	}		

	return 0;
}

// ********************************************************************************************
// ********************************************************************************************

// Antwort
function mbus_setTreeData (treeObj)
{
	var page = top.tree_getPageName(); 	
	var mbus_id = page[1];

	// configuration aktualisieren
	for (var i=0; i<treeObj.MBus.configuration.counter.length; i++)
	{
		//alert (mbus_id + "   " + treeObj.MBus.configuration.counter[i].info);

		if (treeObj.MBus.configuration.counter[i].info == mbus_id)
		{		
			// Name aktualisieren
			treeObj.MBus.configuration.counter[i].text = moduleName;

			// Icons
			if (channelArr.length < 1)
			{
				// Icon gelb fuer konfigurierten Zaehler ohne channel
				treeObj.MBus.configuration.counter[i].icon = "tools_yellow.gif";
			}
			else
			{
				// Icon gruen fuer konfigurierten Zaehler mit channel
				treeObj.MBus.configuration.counter[i].icon = "tools_green.gif";
			}		
			break;
		}	
	}

	// neuen Zaehler einfuegen in data, wenn er noch nicht existiert
	var match = 0;	
	for (var i=0; i<treeObj.MBus.data.counter.length; i++)
	{
		if (treeObj.MBus.data.counter[i].info == mbus_id)
		{		
			match = 1;	
			break;
		}
	}
	if (match == 0)
	{
		var length = treeObj.MBus.data.counter.length;
		treeObj.MBus.data.counter[length] = new Object();
		treeObj.MBus.data.counter[length].icon = "outbox.gif"; 
		treeObj.MBus.data.counter[length].text = mbus_id;
		treeObj.MBus.data.counter[length].info = mbus_id;
		treeObj.MBus.data.counter[length].target = "mbus_data.htm";
	}

	// data aktualisieren
	for (var i=0; i<treeObj.MBus.data.counter.length; i++)
	{
		if (treeObj.MBus.data.counter[i].info == mbus_id)
		{		
			// Name aktualisieren
			treeObj.MBus.data.counter[i].text = moduleName;
			// alert ("gefunden: " + moduleName);

			// hat ein Zaehler keine channel, dann Eintrag bei data entfernen
			if (channelArr.length < 1)
				treeObj.MBus.data.counter.splice(i, 1);				
		}
	}



	// bei data evtl. vorhandenen "no entry" entfernen, falls Zaehler gefunden wurden
	var length = treeObj.MBus.data.counter.length;
	if (length > 1)
	{	
		if (treeObj.MBus.data.counter[0].text == "no entry")
		{
			// Eintrag "no entry" entfernen					
			treeObj.MBus.data.counter.splice(0, 1);				
		}
	}
	else if (length == 0)
	{
		// Eintrag "no entry" einfuegen
		var length = treeObj.MBus.data.counter.length;
		treeObj.MBus.data.counter[length] = new Object();
		treeObj.MBus.data.counter[length].icon = "page.gif"; 
		treeObj.MBus.data.counter[length].text = "no entry";
		treeObj.MBus.data.counter[length].info = "no entry";
		treeObj.MBus.data.counter[length].target = "";
	}

	// Eintraege alphabetisch sortieren
	treeObj.MBus.configuration.counter = sortEntries (treeObj.MBus.configuration.counter, "text");
	treeObj.MBus.data.counter = sortEntries (treeObj.MBus.data.counter, "text");
	//var oStr = JSON2.stringify (treeObj.MBus.data.counter, null, 4);	// Object -> String
	//alert (oStr);

	return treeObj;
}

// ********************************************************************************************

// Anzeige Fortschritt bei Parameterspeicherung
function messageChannel ()
{
	top.hideMessageBox();
	top.messageBox_Wait_ext ((msgChannel+1)+ins("mbus_config_message_counter_channel"));

	if (msgChannel == (channelArr.length))
	{
		// Messagebox schliessen
		top.hideMessageBox();
		top.messageBox_Wait_ext ("");

		// Anzeige beenden
		clearTimeout (interval_timeout);
	}

	msgChannel += 1;
}	

// ********************************************************************************************

// Button freigeben
function releaseButton ()
{
	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
	document.form_conf.conf.disabled = false;
}
// ********************************************************************************************
// ********************************************************************************************














// ********************************************************************************************
// Funktionen fuer MBus - Kommunikation
// ********************************************************************************************

// Baudrate auf den angegebenen Wert setzen
function setBaudrate (bus, mbus_id, br, newBr)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = br+"";					// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "SET_BAUDRATE";
	actObject.param = newBr+"";				// Ziel-Baudrate

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	//alert (actStr);

	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)
}

// ********************************************************************************************

// Steuerkommando senden
function setControl (bus, mbus_id, param)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = counterObj.BR+"";		// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "SND_UD_RESET_CTRL";
	actObject.param = param+"";				// 0xe2 = Neustart, 0xe6 = Einmann-Inbetriebnahme

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

}

// ********************************************************************************************

// Application-Reset senden
function setAppReset (bus, mbus_id, param)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = counterObj.BR+"";		// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "SND_UD_APPL_RESET";
	actObject.param = param+"";				// 0x80 = Neustart, 0xA0 = Kalibrierung

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

}

// ********************************************************************************************

// T/M: Sensorkurve senden
function setSensor (bus, mbus_id, param)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = counterObj.BR+"";					// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "SND_UD_SET_SENSOR";
	actObject.param = param+"";							// 0 ... 11

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

}


// ********************************************************************************************

// T/M: Temp.-Offset senden
function setTempOffset (bus, mbus_id, param)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = counterObj.BR+"";					// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "SND_UD_SET_TEMP";
	actObject.param = param+"";							// 

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

//	alert ("setTempOffset  "+actObject.param);
}

// ********************************************************************************************

// Primaeradresse ruecksetzen
function resetPrimaryAddress (bus, mbus_id)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = counterObj.BR+"";					// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "RESET_PRIMARY_ADDRESS";
	actObject.param = "0";							 

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

	// Anzeige
	top.hideMessageBox();
	top.messageBox_Wait_ext (ins("mbus_config_message_counter_reset_prim"));
	setTimeout ("top.hideMessageBox()", 2000);

}

// ********************************************************************************************

// ermitteln der Spezial-Parameter fuer T/M-Converter
function getTempValues ()
{	
	for (var i=0; i<channelArr.length; i++)
	{
		// Temp muss vorhanden sein
		if (channelArr[i].Temp != undefined)
		{
			// nur Tele 1/Rec 3 auswerten
			if ((channelArr[i].Tele == 1) && (channelArr[i].Rec == 3))
			{
				sensType = channelArr[i].Temp.SensTyp;
				tempOffset = channelArr[i].Temp.Offset * 10;		// ganze Zahl an Converter
				return;			
			}		
		}
	}
}

// ********************************************************************************************
// ********************************************************************************************












// ********************************************************************************************
// Funktionen allg.
// ********************************************************************************************

// PC- Datum ausgeben
function getTimeInSQLFormat (datum)
{
	var time = new Object();
	
	time.year = setLeadNull (datum.getFullYear()-0);		// Jahreszahl 4-stellig
	time.month = setLeadNull (datum.getMonth()+1-0);		// getMonth() von 0 ... 11
	time.date = setLeadNull (datum.getDate()-0);
	time.hours = setLeadNull (datum.getHours()-0);
	time.minutes = setLeadNull (datum.getMinutes()-0);
	time.seconds = setLeadNull (datum.getSeconds()-0);

	var output = time.year + "-" + time.month + "-" + time.date + " " + 
				 time.hours + ":" + time.minutes + ":" + time.seconds;
	return output;
}

// ********************************************************************************************

// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************

// den naechsten regulaeren Ablesetermin suchen			!!! NUR 15 MIN - 12 H realisiert !!!
function setTimeToNextInterval (interval)
{

	var time = new Date();				// aktuelle Zeit
	var time_ms = time.getTime();		// aktuelle Zeit in Millisekunden

	var interval_ms = interval * 60 * 1000;		// Intervall in ms

	// Berechnung
	var t1 = parseInt (time_ms/interval_ms);
	var t2 = (t1 + 1) * interval_ms;

	var newTime = new Date(t2);	
	// alert ("old = " + getTimeInSQLFormat (time) + "\n" + "new = " + getTimeInSQLFormat (newTime));

	return (newTime);
}

// ********************************************************************************************

// neue Baudrate wurde vom Nutzer ausgewaehlt
function setNewBaudrate (newBaudrate)
{
	counterObj.BR = newBaudrate;	
}

// ********************************************************************************************

// Pruefen, ob Zaehler Freezefaehig ist
function checkForFreeze(actObject)
{
	var ret = 0;

	if (actObject.records[0].length < 3) 
		return false;		// kein Freeze

	if (actObject.records[0][0].descriptor == "Cumulation Counter")
		ret++;
	if (actObject.records[0][1].descriptor == "Time Point")
		ret++;
	if (actObject.records[0][2].descriptor == "Cumulation Counter")
		ret++;

	if (ret == 3)
		return true;		// Freeze
	return false;			// kein Freeze
}

// ********************************************************************************************

// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************

// Primaeradresse setzen
function setPrimaryAdress ()
{

	var page = top.tree_getPageName(); 	
	var mbus_id = page[1];

	top.setDataExtended (mbus_id, "mbus_primary", "");		// Daten zum EWIO senden

	// Anzeige
	top.hideMessageBox();
	top.messageBox_Wait_ext (ins("mbus_config_message_counter_set_prim"));
	setTimeout ("top.hideMessageBox()", 2000);
}

// ********************************************************************************************

// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************

// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************

// checken, welcher bus ausgewaehlt wurde; 
// wenn mbus gewaehlt wurde, dann subbus-Selection deaktivieren
function checkBusSelection()
{
	var i = document.form_bus.bus.selectedIndex;
	var bus = document.form_bus.bus[i].value;
	if (bus == "MBus")
	{
		document.form_bus.subBus.style.visibility ="hidden";	
		document.form_baudrate.style.visibility ="visible";	
	}
	else
	{
		document.form_bus.subBus.style.visibility ="visible";	
		document.form_baudrate.style.visibility ="hidden";	
	}
}

// ********************************************************************************************

// Check Antwort auf Login-Error
function checkLoginError (actString)
{
	if (actString.indexOf("LOGIN ERROR") != -1)	
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		top.hideMessageBox();		
		top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		return 1;	
	}
	
	return 0;
}

// ********************************************************************************************

// Trennen von Faktor und Einheit in Mbus-Record "unit"
function splitUpUnit (unit)
{
	// Aufsplitten in 2 Teile, getrennt durch Leerzeichen
	var arr = unit.split(" ", 2);

	// Test, ob der erste Teil eine Zahl ist (Faktor)
	if (!isNaN(parseFloat(arr[0]))) 
	{
		// Zahl
		return arr;
	}
	else
	{
		// keine Zahl
		return unit;
	}
}

// ********************************************************************************************

// Pruefen, ob ein Element ein Array ist
function isArray (obj)
{
	return obj.constructor == Array;
}

// ********************************************************************************************

// Array mit jeweils mehreren Objekten pro Eintrag nach einem Objekt sortieren;
// der Sortierungswert darf nur jeweils einmal vorkommen oder muss 0 sein (diese Eintrage werden nur angehaengt)
function sortEntries (arr, key)
{

	// Um die Eintraege sortiert abzuspeichern, werden die keys in ein Array gepackt und
	// dort sortiert
	var newArr = new Array();
	for (var i=0; i<arr.length; i++)
	{
		// nur Eintraege sortieren, die konfiguriert sind (Icon != rot)
		if (arr[i].icon != "tools_red.gif")
			newArr[newArr.length] = arr[i][key];
	}

	// key alphabetisch sortieren (aufsteigend)
	newArr.sort();

	// entsprechend der Sortierung Eintraege zuweisen
	for (var i=0; i<arr.length; i++)
	{
		for (var j=0; j<arr.length; j++)
		{	
			if (newArr[i] == arr[j][key])
			{
				newArr[i] = arr[j];
				break;
			}
		}
	}	

	// nichtkonfigurierte Eintraege anfuegen (Icon == rot)
	for (var i=0; i<arr.length; i++)
	{
		if (arr[i].icon == "tools_red.gif")
			newArr[newArr.length] = arr[i];
	}

	// sortiertes Array zurueckliefern
	return newArr;
}



// ********************************************************************************************
// ********************************************************************************************

// ********************************************************************************************
// configbase/primary.json aktualisieren

// Ist "Primaeradressierung" ausgewaehlt, dann ggf. Eintrag erzeugen (wenn nicht vorhanden),
// sonst ggf. Eintrag loeschen (wenn vorhanden);
// Wird Eintrag erzeugt, dann erhaelt Primaeradresse einen leeren String, 
// weil Primaeradresse vom mbus_controller gesetzt wird

function mbus_modifyPrimaryAdr(actStr)
{
	// neue Daten hinzufuegen
	var actObject = JSON2.parse(actStr);
	var cnt = actObject.counter.length;

	// wenn Eintrag schon existiert
	for (var i=0; i<cnt; i++)
	{
		if (actObject.counter[i].secAdr == counterObj.BusAdr)
		{
			if (counterObj.busdetails.Text_3 == "true")		
			{
				// leeren Eintrag erzeugen			
				actObject.counter[i].primAdr = "";
			}			
			else
			{
				// Eintrag loeschen
				actObject.counter.splice(i, 1);					
			}

			// neue Daten senden
			actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
			top.setDataExtended ('/config/configbase/primary.json', 'fileload', actStr);
			return;
		}
	}

	// neuen Eintrag setzen
	if (counterObj.busdetails.Text_3 == "true")
	{	
		actObject.counter[cnt] = new Object();	
		actObject.counter[cnt].secAdr = counterObj.BusAdr;
		actObject.counter[cnt].primAdr = "";
	}

	// neue Daten senden
	actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ('/config/configbase/primary.json', 'fileload', actStr);
}



// ********************************************************************************************
// INFO
// ********************************************************************************************

// INFO
// counter

function info_bus()
{
	var headline =  '<B>INFO: BUS </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_bus")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 160, "window");
}


function info_Name()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_devicename_head")+'</B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_devicename")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_MBusID()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_mbusid_head")+'</B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_mbusid")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_ztype()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_devicetype_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_devicetype")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_primAdr()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_primary_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_primary")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_Mandant()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_client_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_client")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_ZNummer()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_counternr_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_counternr")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_AbnNr()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_customernr_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_customernr")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_MeteringCode()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_meteringcode_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_meteringcode")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}


// ********************************************************************************************
// channel

function info_interval()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_interval_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_interval")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 370, "window");
}

function info_EAblesung()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_readout_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_readout")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_Faktor()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_factor_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_factor")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 230, "window");
}

function info_app()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_app_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_app")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 300, "window");
}

function info_mtype()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_mtype_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_mtype")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 220, "window");
}

//

function info_AZStand()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_counterstart_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_counterstart")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 250, "window");
}

function info_AImpulse()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_pulsstart_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_pulsstart")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 530, 300, "window");
}

function info_ImpProEinheit()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_pulsperunit_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_pulsperunit")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_MEinheit()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_unit_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_unit")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_FaktorEdit()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_factorEdit_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_factorEdit")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_Primaer()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_primaer_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_primaer")+
 					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 250, "window");
}

//

function info_SensTyp()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_sensor_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_sensor")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 250, "window");
}

function info_Offset()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_offset_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_offset")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 300, "window");
}

//

function info_Obis()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_obis_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_obis")+
 					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_description()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_description_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_description")+
 					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

//

function info_freeze()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_freeze_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_freeze_0") +'</div> <div class="pos x0103 textfield"> Tele 1, Rec 1 </div> '+
					'<div class="pos x0201 textfield"> '+ins("mbus_config_info_freeze_1") +'</div> <div class="pos x0203 textfield"> Tele 1, Rec 3 </div> '+
					'<div class="pos x0301 textfield"> '+ins("mbus_config_info_freeze_2")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 350, "window");
}


// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************


