/**********************************************************************************************
	JS functions for mbus_counterlist

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		07.2011

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;

var deviceObj;
var listObj;
var mbusObj;
var modbusObj;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Messagebox
	top.messageBox_Wait();

	// modbus counter-Liste lesen
	top.getDataExtended ("modbus_counterlist", "counter_list", "top.frame_content.modbus_getCounterList(actStr)");
}

// Antwort
function modbus_getCounterList(actStr)
{
	// Messagebox schliessen
	top.hideMessageBox();

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	modbusObj = JSON2.parse(actStr);
/*
	// Abbruch, wenn keine Eintraege vorhanden
	if (jObject.counter[0].BusAdr == undefined)
	{
		// keine Zaehler vorhanden
		// "Hinweis", "Es wurden keine Zaehler gefunden."
		top.messageBox (ins("mbus_counterlist_note_head"), ins("mbus_counterlist_no"));	

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		top.document.getElementById("button_2").disabled = false;
		return;
	}	
*/

	// mbus counter-Liste lesen
	top.getDataExtended ("mbus_counterlist", "counter_list", "top.frame_content.mbus_getCounterList(actStr)");
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nur Administrator/Operator darf Liste aendern
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button fuer 5s disabeln
	top.document.getElementById("button_2").disabled = true;
	setTimeout ('top.buttonRelease("button_2")', 10000); 	
	top.document.getElementById("button_1").disabled = true;
	setTimeout ('top.buttonRelease("button_1")', 10000); 	

	// Liste zum EWIO senden
	mbus_setCounterList();
}

// ********************************************************************************************
// ********************************************************************************************

// Antwort
function mbus_getCounterList(actStr)
{
	// Messagebox schliessen
	top.hideMessageBox();

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	mbusObj = JSON2.parse(actStr);

	// Abbruch, wenn keine Eintraege vorhanden
	if ((mbusObj.counter[0].BusAdr == undefined) && (modbusObj.counter[0].BusAdr == undefined))
	{
		// keine Zaehler vorhanden
		// "Hinweis", "Es wurden keine Zaehler gefunden."
		top.messageBox (ins("mbus_counterlist_note_head"), ins("mbus_counterlist_no"));	

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		top.document.getElementById("button_2").disabled = false;
		return;
	}	

	// Counter mbus/modbus zusammenfuehren
	var jObject = {};
	jObject.counter = [];

	if (modbusObj.counter[0].BusAdr != undefined)
	{
		for (var i=0; i<modbusObj.counter.length; i++)
			jObject.counter[jObject.counter.length] = modbusObj.counter[i];
	}

	if (mbusObj.counter[0].BusAdr != undefined)
	{
		for (var i=0; i<mbusObj.counter.length; i++)
			jObject.counter[jObject.counter.length] = mbusObj.counter[i];	
	}
	
	// Eintraege aufsteigend sortieren
	jObject.counter = sortEntries (jObject.counter, "Sort");

	// lokal speichern
	deviceObj = jObject;

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	for (var i=0; i<1000; i++)
	{			   
		// Abbruch, wenn kein Eintrag mehr
		if (jObject.counter[i] === undefined)
			break;	

		var cnt = i+1;
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte Position
		if (jObject.counter[i].Sort == 0)
			jObject.counter[i].Sort = "";
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = '<input type="text" class="textfield" value="'+jObject.counter[i].Sort+'" name="device_'+cnt+'" size="3" maxlength="3" style="text-align:center">';
		td.setAttribute ("class", "td_100");
		td.setAttribute ("style", "text-align:center;");

		// 2. Spalte Bus-ID
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.counter[i].BusAdr;
		td.setAttribute ("class", "td_200");
		if (jObject.counter[i].Sort == 0)
			td.setAttribute ("style", "color:red");

		// 3. Spalte Name
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.counter[i].Name;
		td.setAttribute ("class", "td_200");
		if (jObject.counter[i].Sort == 0)
			td.setAttribute ("style", "color:red");
	}

	// Liste fertig, Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}


// ********************************************************************************************

// Array mit jeweils mehreren Objekten pro Eintrag nach einem Objekt sortieren;
// der Sortierungswert darf nur jeweils einmal vorkommen oder muss 0 sein (diese Eintrage werden nur angehaengt)
function sortEntries (arr, key)
{

	// Um die Eintraege sortiert abzuspeichern, werden die keys in ein Array gepackt und
	// dort sortiert
	var newArr = new Array();
	for (var i=0; i<arr.length; i++)
	{
		// nur Eintraege ungleich 0 sortieren
		if (arr[i][key] != 0)
			newArr[newArr.length] = arr[i][key];
	}

	// key numerisch sortieren (aufsteigend)
	newArr.sort(function(a,b){return a-b;});

	// entsprechend der Sortierung Eintraege zuweisen
	for (var i=0; i<arr.length; i++)
	{
		for (var j=0; j<arr.length; j++)
		{	
			if (newArr[i] == arr[j][key])
			{
				newArr[i] = arr[j];
				break;
			}
		}
	}	

	// Eintraege mit 0 anfuegen
	for (var i=0; i<arr.length; i++)
	{
		if (arr[i][key] == 0)
			newArr[newArr.length] = arr[i];
	}

	// sortiertes Array zurueckliefern
	return newArr;
}

// ********************************************************************************************

// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// Den Value einer Zelle in der Tabelle setzen
function setTableElementValue (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].value = value;
}

// ********************************************************************************************

// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// Den Value einer Zelle in der Tabelle lesen
function getTableElementValue (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].value;
	return (result);
}

// ********************************************************************************************
// ********************************************************************************************








// ********************************************************************************************

// Tabelle in Json-Struktur wandeln und zum EWIO senden
function mbus_setCounterList()
{

	// JSON fuer device-list zusammenstellen
	var lastSort = 0;	
	var actObject = new Object();
	actObject.counter = new Array(); 

	var tbody = document.getElementById("tab_mbus_id");
	for (var i=0; i<tbody.rows.length; i++)
	{
		// position ermitteln (kann veraendert worden sein)
		var pos = eval ('document.getElementsByName("device_'+(i+1)+'")');
		if (pos[0].value != "")
			var sort = parseInt (pos[0].value);	
		else
			var sort = 0;

		// check: position muss eine Zahl zwischen 0 und 250 sein
		if ( (isNaN(sort)) || (sort < 0) || (sort > 250) )
		{
			top.messageBox (ins("mbus_counterlist_error"), "Position "+pos[0].value + ins("mbus_counterlist_number")); 
			return;	
		}	

		// check: position darf jeweils nur einmal vorkommen
		if ((lastSort == sort) && (sort != 0))
		{
			top.messageBox (ins("mbus_counterlist_error"), "Position "+sort+ ins("mbus_counterlist_multiple")); 
			return;	
		}

		lastSort = sort;		

		// mbus_id ermitteln
		var busAdr = getTableElement ("tab_mbus_id", i, 1);
		
		// Namen ermitteln
		var name = getTableElement ("tab_mbus_id", i, 2);								
	
		// Werte speichern
		actObject.counter[i] = new Object();
		actObject.counter[i].Sort = sort;
		actObject.counter[i].BusAdr = busAdr;
		actObject.counter[i].Name = name;
	}	
	// lokal speichern fuer update Tree
	//listObj = actObject;

	var objStr = JSON2.stringify (actObject, null, 0);	// Object -> String
	
	if (DEBUG_DATA)	
		alert (objStr);

	// Daten senden
	top.setDataExtended ("mbus_counterlist", "counter_list", objStr);

	// Messagebox
	top.messageBox_Wait();
	setTimeout ("top.hideMessageBox();", 10000);
}

// ********************************************************************************************





// ********************************************************************************************
// ********************************************************************************************

// Info
function info_position()
{
	var headline =  '<B>INFO: POSITION</B>';
	content =		'<div class="pos x0101 textfield"> '+ins("mbus_counterlist_info_position")+
					'</div>' +

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}


// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************

