/**********************************************************************************************
	JS functions for mbus_data

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		05.2011

***********************************************************************************************/


/*
	Anmerkungen:
	Das Laden der Konfiguration ist zweigeteilt:
	1. Mit dem Aufruf der Seite wird das Konfigurationsfile geladen
	2. Durch Betaetigen "BROWSER <- EWIO" werden die Daten vom MBus geladen

*/

// ********************************************************************************************

var DEBUG_DATA = 0;

var tele_id;						// ID zur Zuordnung MBus Anfrage / Antwort
var counterObj;						// lokales Objekt (Zaehler-Konfiguration)
var response_counter = 0;			// Empfangszaehler
var dataSource = "current";			// Datenquelle (aktuell oder gespeichert)

var channelArr;						// Array mit allen channel-Objekten
var channel_cnt;					// aktueller channel

var channelId = 0;					// aktuelle Channel-ID fuer DB
var date = -1;						// aktuelles Datum fuer DB
var paramValid = 0;					// Parameter fuer DB gueltig

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Namen im Header anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Messagebox
	top.messageBox_Wait ();

	// Tabelle MBus anzeigen
	document.getElementById("tab_mbus").style.visibility = "visible";
	document.getElementById("tab_db").style.visibility = "hidden";
	document.getElementById("counter_head").style.visibility = "visible";

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	document.form_save.save.disabled = true;

	// Konfiguration einlesen
	var moduleId = top.tree_getPageName()[1];
	top.getDataExtended (moduleId, "counter", "top.frame_content.mbus_getCounter_answer(actStr)");


//	setFlags ();

}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	document.form_save.save.disabled = true;

	if (dataSource == "current")
	{
		// Daten vom Mbus abfragen
		mbus_getData();
	}
	else
	{
		// gespeicherte Daten abfragen
		db_getData();
	}
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."	
	top.messageBox (ins("mbus_data_button_head"), ins("mbus_data_button_content")); 	
}

// ********************************************************************************************
// ********************************************************************************************

// Auswahl Datenquelle (aktuell / gespeichert)
function setDataSource (source)
{
	// Datenquelle global speichern
	dataSource = source;

	if (source == "current")
	{
		// zusaetzliche Angaben loeschen 
		document.form_stored.style.display = "none";
		
		// Tabellen umschalten
		document.getElementById("tab_mbus").style.visibility = "visible";
		document.getElementById("tab_db").style.visibility = "hidden";
		document.getElementById("counter_head").style.visibility = "visible";

		// Button SAVE
		document.form_save.style.display = "block";
	}

	if (source == "stored")
	{
		// Parameter einblenden
		document.form_stored.style.display = "block";

		// Tabellen umschalten
		document.getElementById("tab_db").style.visibility = "visible";
		document.getElementById("tab_mbus").style.visibility = "hidden";
		document.getElementById("counter_head").style.visibility = "hidden";

		// Button SAVE
		document.form_save.style.display = "none";
	}
}

// ********************************************************************************************

// Aufruf der Datenbank-Parametrierung
function setParameter()
{
	// kein Calendar-Module, weil dieses nur aus HTML heraus aufrufbar

	var headline =  '<B>PARAMETER</B>';
	var content =	'<form name="form_param"> '+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_data_point")+' </div>'+
					'<div class="pos x0103">'+
					'<select name="selectDataPoint" size=1 class="combobox long_200"></select><br>'+
					'</div>'+

					'<div class="pos x0201 textfield"> '+
					'<input type="radio" name="r0" value="0" onclick="showDate(0)"> '+ins("mbus_data_first")+' <br> '+
					'<input type="radio" name="r0" value="-1" checked="checked" onclick="showDate(0)"> '+ins("mbus_data_last")+' <br> '+
					'<input type="radio" name="r0" value="1" onclick="showDate(1)"> '+ins("mbus_data_from")+' '+
					'</div>'+

					'<div class="pos x0403 textfield"> '+
					'<input type="text" class="textfield" value="" name="year" size="4" maxlength="4" style="text-align:center;">-'+
					'<input type="text" class="textfield" value="" name="month" size="2" maxlength="2" style="text-align:center;">-'+
					'<input type="text" class="textfield" value="" name="day" size="2" maxlength="2" style="text-align:center;"> '+
					'<input type="text" class="textfield" value="" name="hours" size="2" maxlength="2" style="text-align:center;">:'+
					'<input type="text" class="textfield" value="" name="minutes" size="2" maxlength="2" style="text-align:center;"> <br> '+
					''+ins("mbus_data_format")+
					'</div>'+

					'<div class="pos x0601 comment"> '+ins("mbus_data_maxvalue")+
					'</div>'+

					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetParam(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetParam(0)">'+
					'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'IO', 450, 230, "window");

	// Controls fuellen
	for (var i=0; i<channelArr.length; i++)
	{
		var str = "Tele "+channelArr[i].Tele+", Rec "+channelArr[i].Rec+": "+channelArr[i].ZwTyp;
		addSelectOption (document.form_param.selectDataPoint, channelArr[i].ID, str);
	}
	
	// Voreinstellungen
	for (var i=0;  i<document.form_param.selectDataPoint.length; i++)
	{
		if (document.form_param.selectDataPoint[i].value == channelId)
			document.form_param.selectDataPoint.selectedIndex = i;
	}

	// alert (date);
	
	if (date == 0)
		document.form_param.r0[0].checked = true;
	else if (date == -1)
		document.form_param.r0[1].checked = true;
	else
	{
		document.form_param.r0[2].checked = true;

		var timestampArr = date.split("|");
		if (timestampArr.length == 2)
		{
			var dateArr = timestampArr[0].split("-");
			if (dateArr.length == 3)
			{
				document.form_param.year.value = dateArr[0];;	
				document.form_param.month.value = dateArr[1];	
				document.form_param.day.value = dateArr[2];	
			}
			var timeArr = timestampArr[1].split(":");
			if (timeArr.length == 3)
			{		
				document.form_param.hours.value = timeArr[0];	
				document.form_param.minutes.value = timeArr[1];	
			}		
		}	
	}

}

// ********************************************************************************************

// Einstellung Datenbank-Parameter auswerten
function fSetParam (valid)
{
	if (valid)
	{
		// Parameter sind gueltig, Variablen global speichern
		// Kanal_ID
		var i = document.form_param.selectDataPoint.selectedIndex;
		channelId = document.form_param.selectDataPoint[i].value;
		var channelText = document.form_param.selectDataPoint[i].text;

		// Zeitpunkt
		for (var i=0; i<document.form_param.r0.length; i++)
		{
			if (document.form_param.r0[i].checked == true)		
				date = parseInt (document.form_param.r0[i].value);
		}
		if (date == 1)
		{
			// Auswerten Zeitfeld		
			var year = document.form_param.year.value;	
			var month = document.form_param.month.value;	
			var day = document.form_param.day.value;	
			var hours = document.form_param.hours.value;	
			var minutes = document.form_param.minutes.value;	

			date = 	year+'-'+month+'-'+day+'|'+hours+':'+minutes+':00';
			var err = checkTimeInput(date);	
			if (err != 0)			
			{	
				// "Hinweis", "Zeiteingabe fehlerhaft: "
				top.messageBox (ins("mbus_data_note_head"), ins("mbus_data_time_error") + err);	
				return;			
			}
		}
	
		// Ueberschrift Tabelle
		// alert ("ID = "+channelId+" date = "+date);
		document.getElementById("channel_param").innerHTML = channelText+"<br>";
		if (date == 0)
			document.getElementById("channel_param").innerHTML += ins("mbus_data_first"); 	// Erste Daten
		else if (date == -1)
			document.getElementById("channel_param").innerHTML += ins("mbus_data_last"); 	// Letzte Daten
		else
		{
			document.getElementById("channel_param").innerHTML += ins("mbus_data_from")+date.split("|"); 	// Daten ab
		}

		paramValid = 1;		// Parameter gueltig	
	}
	
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************







// ********************************************************************************************
// Konfiguration
// ********************************************************************************************

// Antwort auf mbus_getCounter
function mbus_getCounter_answer(actStr)
{
	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		top.hideMessageBox();
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	// JSON-String in Objekt wandeln
	counterObj = JSON2.parse(actStr);

	// Ablauf fortsetzen: Channel einlesen
	var moduleId = top.tree_getPageName()[1];
	top.getDataExtended (moduleId, "channels", "top.frame_content.mbus_getChannel_answer(actStr)");

}

// ********************************************************************************************
// Antwort: Alle channel einlesen
function mbus_getChannel_answer(actStr)
{
	if (DEBUG_DATA)
		alert (actStr);

	// Objekt im channelArr speichern
	var actObj = JSON2.parse(actStr);
	channelArr = actObj.channel;

	// Messagebox schliessen
	top.hideMessageBox();

	// Liste fertig, Button freigeben
	top.document.getElementById("button_1").disabled = false;
}

// ********************************************************************************************







// ********************************************************************************************
// Kommunikation MBus
// ********************************************************************************************

// Daten vom MBUS abrufen
// Die Abfragen muessen zeitversetzt erfolgen!
function mbus_getData()
{
	// Messagebox
	top.messageBox_Wait ();

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_body");
	while (tab.rows.length > 0)
		tab.deleteRow(0);
	
	// Kopfangaben loeschen
	document.form_counter_head.timestamp.value = "";
	document.form_counter_head.mbus_id.value = "";
	document.form_counter_head.access.value = "";
	document.form_counter_head.status.value = "";

	// Freeze-Kommando senden
	setFreeze (counterObj.busdetails.Text_1, counterObj.BusAdr, 0);

	// Daten abfragen
	setTimeout ("mbus_request ()", 1000);

}

// ********************************************************************************************

// Daten-Telegramm Master -> Slave 
function mbus_request ()
{

	// Zusammenstellen des MBus-Objekts
	mbusRequestObj = new Object();

	// bus
	mbusRequestObj.bus = counterObj.busdetails.Text_1; 
	// id
	tele_id = top.calculateRandom (1, 10000);
	mbusRequestObj.id = tele_id.toString();	
	// br
	mbusRequestObj.br = counterObj.BR + "";
	// secAdr
	mbusRequestObj.secAdr = counterObj.BusAdr;
	// command
	mbusRequestObj.command = "GET_DATA";
	// param
	var teleMax = getTeleMax ();
	mbusRequestObj.param = teleMax.toString();

	var actStr = JSON2.stringify (mbusRequestObj, null, 4);	// Object -> String
	// alert ("mbus_request " + actStr);

	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

	// Empfangstelegramm(e) Slave -> Master lesen, Daten anfordern via mbus_response()
	setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 2000);

}

// ********************************************************************************************

// Antworttelegramme  Slave -> Master
function mbus_response(actStr)
{
	// eine Zeitlang Telegramm pollen
	if (counterObj.BR >= 9600)			var timeout = 5;
	else if	(counterObj.BR >= 2400)		var timeout = 10;
	else								var timeout = 25; 	


	// Fehlermeldungen vom webGate
	if (actStr.indexOf('{') == -1)
	{
		// Message filtern		
		actStr = top.getMessage (actStr);

		// keine Antwort vom mbus_controller
		var wait_time = timeout-response_counter;
		if (response_counter < timeout)		
		{	
			top.hideMessageBox();
			top.messageBox_Wait_ext (ins("mbus_config_message_wait_EWIO") + "<B>" + wait_time.toString() + "</B> sec.");
			setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 1000);	
			response_counter++;			// 1 Sekunde vergangen
			return;			
		}

		// MBus-Zaehler hat nicht oder fehlerhaft geantwortet 
		top.hideMessageBox();
		top.messageBox (ins("mbus_data_error_head"), actStr);

		// Ergebnisfile loeschen
		setTimeout ("removeResponseFile()", 500);
		return;
	}

	// JSON-String in Objekt wandeln
	try
	{
		actObject = JSON.parse(actStr);
	}
	catch(err)
	{
		var txt = "Error on navigation data occured.\n";
		txt += "Error description: " + err.message + "\n";
		alert (txt);

		//document.write(actStr);	
		return;	
	}


	// Test auf Fehlermeldungen von GET_DATA
	if (actObject.data_response)
	{
		if (actObject.data_response == "No Answer")
		{
			top.hideMessageBox();
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_noanswer"));	// "Der Zaehler hat nicht geantwortet."
	
			// Ergebnisfile loeschen
			setTimeout ("removeResponseFile()", 500);
			return;
		}

		else if (actObject.data_response == "Telegram Invalid")
		{
			top.hideMessageBox();
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_invalid")); 	// "Antwort vom Zaehler fehlerhaft."

			// Ergebnisfile loeschen
			setTimeout ("removeResponseFile()", 500);
			return;
		}
		else if (actObject.data_response.indexOf("Receive More") != -1)
		{
			top.hideMessageBox();
			top.messageBox_Wait_ext (actObject.data_response);
			setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 1000);	
			return;
		}
		else
		{
			top.hideMessageBox();
			top.messageBox (ins("mbus_config_err"), ins("mbus_config_err_unknown"));	// "Ein unbekannter Fehler ist aufgetreten."

			// Ergebnisfile loeschen
			setTimeout ("removeResponseFile()", 500);
			return;
		}
	}

	// JSON-Daten empfangen
	response_counter = 0;
	top.hideMessageBox();

	// Message fuer Berechnung einblenden
	top.messageBox_Wait_ext (ins("mbus_data_time_process"));

	// Felder fuellen
	// Kopfangaben
	document.getElementById("counter_head").style.color = "#046AAC";
	document.form_counter_head.timestamp.value = actObject.timestamp;
	document.form_counter_head.mbus_id.value = actObject.mbus_id;
	document.form_counter_head.access.value = actObject.access;
	document.form_counter_head.status.value = actObject.status;

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_body");

	// evtl. bereits vorhandene Zeilen loeschen
	while (tbody.rows.length > 0)
		tbody.deleteRow(0);

	// Anzahl Telegramme
	var teleMax = getTeleMax ();
	for (var i=0; i<teleMax; i++)
	{
		// Abbruch, wenn kein Telegramm mehr
		if (actObject.records === undefined)
			break;	
		if (actObject.records[i] === undefined)
			break;	
	
		// Anzahl Records
		for (var j=0; j<250; j++)
		{			   
			// Abbruch, wenn kein Record mehr
			if (actObject.records[i][j] === undefined)
				break;	

			// Nur Daten fuer konfiguerierte Channel anzeigen
			var match = 0;
			for (var z=0; z<channelArr.length; z++)
			{
				var tel = channelArr[z].Tele - 1;
				var rec = channelArr[z].Rec - 1;

				if ((i == tel) && (j == rec))		
				{
					match = 1;
					break;			
				}
			}

			if (match)
			{
				// neue Zeile
				tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

				// jede 2. Reihe andersfarbig ("Zebratabelle")
				if (tbody.rows.length % 2 == 0)	
					tr.setAttribute ("class", "row_color_odd");
				else
					tr.setAttribute ("class", "row_color_even");

				// 1. Spalte Telegramm-Nr.
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = actObject.records[i][j].tel;
				td.setAttribute ("class", "td_50");

				// 2. Spalte Record-Nr.
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = actObject.records[i][j].rec;
				td.setAttribute ("class", "td_50");

				// 3. Spalte Beschreiber
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = actObject.records[i][j].descriptor; 
				td.setAttribute ("class", "td_150");

				// 4. Spalte Wert
				td = tr.insertCell(tr.cells.length);
				// wenn Wert binaer, dann binaere Darstellung
				if (actObject.records[i][j].descriptor.indexOf("binary") != -1)
				{
					var binVal = parseInt(actObject.records[i][j].value);		// string -> zahl
					td.innerHTML = "0b"+ binVal.toString(2);					// zahl -> bin string
				}				
				else
				{
					// Ausgabe des value mit (wenn Primaerzaehler) oder ohne Wandlerfaktor
					if (channelArr[z].Primary == 1)				
					{
						// mit Faktoren multiplizieren
						var primValue = actObject.records[i][j].value * channelArr[z].Faktor_U * channelArr[z].Faktor_I;
					 	actObject.records[i][j].value = primValue;
					}
					td.innerHTML = actObject.records[i][j].value;
				}
				td.setAttribute ("class", "td_80");

				// 5. Spalte Safe
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = "";
				td.setAttribute ("class", "td_80");

				// 6. Spalte Einheit
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = actObject.records[i][j].unit;
				td.setAttribute ("class", "td_80");

				// 7. Spalte Primaerzaehler
				td = tr.insertCell(tr.cells.length);
				if (channelArr[z].Primaer == 1)				
					td.innerHTML = ins("mbus_config_channel_primaer_yes");
				else
					td.innerHTML = ins("mbus_config_channel_primaer_no");
				td.setAttribute ("class", "td_80");
			}
		}
	}

	// Antwortfile mit Beruecksichtigung von Applikation und Wandlerfaktoren anfordern
	setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'modify', 'top.frame_content.mbus_responseModify(actStr)')", 500);
}

// ********************************************************************************************

// Antwortfile mit Beruecksichtigung von Applikation und Wandlerfaktoren
function mbus_responseModify(actStr)
{
	// alert (actStr);

	// JSON-String in Objekt wandeln
	var actObject = JSON2.parse(actStr);

	// Berechnete Werte in die Tabelle einfuegen
	// Zeilenzaehler, um die berechneten Werte in die zugehoerigen Zeilen zu setzen
	var lineCounter = 0;

	// Anzahl Telegramme
	var teleMax = getTeleMax ();
	for (var i=0; i<teleMax; i++)
	{
		// Abbruch, wenn kein Telegramm mehr
		if (actObject.records === undefined)
			break;	
		if (actObject.records[i] === undefined)
			break;	

		// Anzahl Records
		for (var j=0; j<250; j++)
		{			   
			// Abbruch, wenn kein Record mehr
			if (actObject.records[i][j] === undefined)
				break;	

			// Nur Daten fuer konfiguerierte Channel anzeigen
			var match = 0;
			for (var z=0; z<channelArr.length; z++)
			{
				var tel = channelArr[z].Tele - 1;
				var rec = channelArr[z].Rec - 1;

				if ((i == tel) && (j == rec))		
				{
					match = 1;
					break;			
				}
			}

			if (match)
			{
				// Berechneten Wert einfuegen				
				setTableElement ("tab_mbus_body", lineCounter, 4, actObject.records[i][j].value);
			
				// Einheit ueberschreiben (kann durch Applikation veraendert worden sein)
				setTableElement ("tab_mbus_body", lineCounter, 5, actObject.records[i][j].unit);
	
				// Zeilenzaehler erhoehen
				lineCounter++;			
			}		
		}
	}

	// Messagebox schliessen
	top.hideMessageBox();

	// Ablauf fortsetzen: Ergebnisfile loeschen
	setTimeout ("removeResponseFile()", 500);
}

// ********************************************************************************************

// Ergebnisfile loeschen
function removeResponseFile()
{
	actStr = '{"id":"'+tele_id+'"}';
	top.setDataExtended ("mbus", "mbus_remove", actStr);		// Daten zum EWIO senden

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	document.form_save.save.disabled = false;
}

// ********************************************************************************************

// Freezekommando senden
function setFreeze (bus, mbus_id, param)
{
	var actObject = new Object();

	actObject.bus = bus+"";
	actObject.id = "0";
	actObject.br = counterObj.BR+"";		// Baudrate, auf welcher gesendet wird
	actObject.secAdr = mbus_id;
	actObject.command = "FREEZE_DATA";
	actObject.param = param+"";					

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

}

// ********************************************************************************************
// Kommunikation Datenbank
// ********************************************************************************************

// Daten von der Datenbank holen
function db_getData()
{
	// gueltige Parameter?
	if (!paramValid)
	{
		// "Hinweis", "Bitte waehlen Sie zuerst die Parameter aus."
		top.messageBox (ins("mbus_data_note_head"), ins("mbus_data_parameter"));	
		top.document.getElementById("button_1").disabled = false;
		return;
	}

	// evtl. bereits vorhandene Zeilen in der Tabelle loeschen
	var tbody = document.getElementById("tab_db_body");
	while (tbody.rows.length > 0)
		tbody.deleteRow(0);

	// Anforderung absenden	
	top.getDataExtended (channelId+'_'+date, 'db_data', 'top.frame_content.db_response(actStr)');

	// Messagebox
	top.messageBox_Wait ();

}

// ********************************************************************************************

// Antwort von Datenbank
function db_response(actStr)
{
	var len;

	// alert (actStr);

	// Messagebox schliessen
	top.hideMessageBox();

	if (actStr.indexOf("{") == -1)
		return;	

	// JSON-String in Objekt wandeln
	var actObject = JSON2.parse(actStr);

	// Daten vorhanden?
	var valid = 0;
	if ((actObject.data.channelData.length > 0) && (actObject.data.channelData[0].Kanal_ID != undefined))
		valid = 1;
	if ((actObject.back.channelData.length > 0) && (actObject.back.channelData[0].Kanal_ID != undefined))
		valid = 1;
	if (!valid)
	{
		// "Hinweis", "Es wurden keine Daten gefunden."	
		top.messageBox (ins("mbus_data_note_head"), ins("mbus_data_no"));

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		return;	
	}

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_db_body");

	// back
	for (var i=0; i<actObject.back.channelData.length; i++)
	{
		// neue Zeile
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte lfd Nr.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = i+1;
		td.setAttribute ("class", "td_30");

		// 2. Spalte Kanal_ID.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.back.channelData[i].Kanal_ID;
		td.setAttribute ("class", "td_100");

		// 3. Spalte Zeit	setTableElement ("tab_mbus_id", cnt, 5, jObject.primAdr);

		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.back.channelData[i].Zeit;
		td.setAttribute ("class", "td_180");

		// 4. Spalte Wert
		td = tr.insertCell(tr.cells.length);
		if (checkForDecimalPlaces (actObject.back.channelData[i].Werte))
			td.innerHTML = actObject.back.channelData[i].Werte.toFixed(3);
		else		
			td.innerHTML = actObject.back.channelData[i].Werte;
		td.setAttribute ("class", "td_100");

		// 5. Spalte Flags
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.back.channelData[i].Flags;
		td.setAttribute ("class", "td_100");

		// 6. Spalte DB
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = "back";
		td.setAttribute ("class", "td_60");

		if (date == -1)
		{		
			// scrolle zur letzten eingefuegten Reihe
			var tElement   = tbody.getElementsByTagName("tbody")[0]; 
			var scroll_area = document.getElementById('scroll_1');
			scroll_area.scrollTop = tElement.clientHeight;
		}
	}
	len = i;

	// data
	for (var i=0; i<actObject.data.channelData.length; i++)
	{
		// neue Zeile
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte lfd Nr.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = len+i+1;
		td.setAttribute ("class", "td_30");

		// 2. Spalte Kanal_ID.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.data.channelData[i].Kanal_ID;
		td.setAttribute ("class", "td_100");

		// 3. Spalte Zeit
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.data.channelData[i].Zeit;
		td.setAttribute ("class", "td_180");

		// 4. Spalte Wert
		td = tr.insertCell(tr.cells.length);
		if (checkForDecimalPlaces (actObject.data.channelData[i].Werte))
			td.innerHTML = actObject.data.channelData[i].Werte.toFixed(3);
		else		
			td.innerHTML = actObject.data.channelData[i].Werte;
		td.setAttribute ("class", "td_100");

		// 5. Spalte Flags
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.data.channelData[i].Flags;
		td.setAttribute ("class", "td_100");

		// 6. Spalte DB
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = "data";
		td.setAttribute ("class", "td_60");

		if (date == -1)
		{		
			// scrolle zur letzten eingefuegten Reihe
			var tElement   = tbody.getElementsByTagName("tbody")[0]; 
			var scroll_area = document.getElementById('scroll_2');
			scroll_area.scrollTop = tElement.clientHeight;
		}
	}

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;

}

// ********************************************************************************************
// In DB Speichern
// ********************************************************************************************

// Messwerte in DB speichern, Format:
// {"channelData":[{"Kanal_ID":2,"Zeit":"2012-08-07 12:20:00","Werte":116.000000,"Flags":"S;A;P;G;H;I;T"}, ... ]}

function saveValueInDB()
{

	var dbObject = new Object();
	dbObject.channelData = new Array();

	var tbody = document.getElementById("tab_mbus_body");
	for (var i=0; i<tbody.rows.length; i++)
	{
		var mbus_tele = getTableElement ("tab_mbus_body", i, 0);
		var mbus_rec = getTableElement ("tab_mbus_body", i, 1);

		var match = 0;
		var z = 0;	
		for (z=0; z<channelArr.length; z++)
		{
			var db_tele = channelArr[z].Tele;
			var db_rec = channelArr[z].Rec ;

			if ((mbus_tele == db_tele) && (mbus_rec == db_rec))		
			{
				match = 1;
				break;			
			}
		}
		
		if (match)
		{
			//alert (z + "   " + channelArr[z].ID + "   " + db_tele + "   " + db_rec);

			// Object zusammenbauen
			var index = dbObject.channelData.length;
			dbObject.channelData[index] = new Object();

			dbObject.channelData[index].ID = 0;													// ID (Autoincrement)
			dbObject.channelData[index].Kanal_ID = channelArr[z].ID;							// Kanal-ID
			var timestamp = getSQLTimestampFromMbus (document.form_counter_head.timestamp.value);
			dbObject.channelData[index].Zeit = timestamp;										// Zeitstempel
			dbObject.channelData[index].Werte = getTableElement ("tab_mbus_body", i, 4);		// Messwert
			dbObject.channelData[index].Flags_ID = setFlags();									// Flags

		}
	}

	var actStr = JSON2.stringify (dbObject, null, 0);	// Object -> String
	// alert (actStr);

	// Anforderung absenden	
	top.setDataExtended ("mbus", "db_send", actStr);		// Modul, Typ, Daten
}

// ********************************************************************************************
// ********************************************************************************************








// ********************************************************************************************
// Hilfs-Funktionen
// ********************************************************************************************

// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************
// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************

// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************

// Zeiteingabe ueberpruefen
function checkTimeInput(date)
{
	var err = 0;
	var ret = 0;

	var timestampArr = date.split("|");
	if (timestampArr.length == 2)
	{
		// Laengen
		var dateArr = timestampArr[0].split("-");
		if (dateArr.length == 3)
		{
			if (dateArr[0].length != 4)		err = ins("mbus_data_digits_year"); 	// "Anzahl Ziffern / Jahr";	
			if (dateArr[1].length != 2)		err = ins("mbus_data_digits_month");	// "Anzahl Ziffern / Monat";
			if (dateArr[2].length != 2)		err = ins("mbus_data_digits_day");   	// "Anzahl Ziffern / Tag";
		}
		var timeArr = timestampArr[1].split(":");
		if (timeArr.length == 3)
		{		
			if (timeArr[0].length != 2)		err = ins("mbus_data_digits_hour");		// "Anzahl Ziffern / Stunde";
			if (timeArr[1].length != 2)		err = ins("mbus_data_digits_minute");	// "Anzahl Ziffern / Minute";
		}		

		// Inhalt
		ret = checkTimeComponents (dateArr[0], "year");		if (ret) err = ret;
		ret = checkTimeComponents (dateArr[1], "month");	if (ret) err = ret;
		ret = checkTimeComponents (dateArr[2], "day");		if (ret) err = ret;
		ret = checkTimeComponents (timeArr[0], "hours");	if (ret) err = ret;
		ret = checkTimeComponents (timeArr[1], "minutes");	if (ret) err = ret;
	}	

	return err;
}

// ********************************************************************************************

// Zeitkomponenten ueberpruefen
function checkTimeComponents (timeComp, check)
{
	var err = 0;
	switch (check)
	{
		case "year":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1900) || (timeComp-0 > 2100))
							err = "Jahr"; 
						break;
		case "month":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 12))
							err = "Monat"; 
						break;
		case "day":		if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 31))
							err = "Tag"; 
						break;
		case "hours":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 24))
							err = "Stunde"; 
						break;
		case "minutes":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							err = "Minute"; 
						break;
		case "seconds":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							err = "Sekunde"; 
						break;
	}
	return err;
}

// ********************************************************************************************

// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************

// aktuelle Datum ermitteln
function getDate ()
{
	var datum = new Date();
	var y = setLeadNull (datum.getFullYear()-0);		// Jahreszahl 4stellig
	var m = setLeadNull (datum.getMonth()+1);			// getMonth() von 0 ... 11
	var d = setLeadNull (datum.getDate()-0);			// Tag 1 ... 31
	var date_now = 	y+"-"+m+"-"+d+"|00:00:00";
	return date_now;
}

// ********************************************************************************************

// Datum sichtbar oder unsichtbar
function showDate (show)
{

	if (show)
	{
		// Datum sichtbar
		if (date <= 0)
		{
			// Datum nicht vorhanden, vom PC einlesen	
			var datum = new Date();
			document.form_param.year.value = setLeadNull (datum.getFullYear()-0);	// Jahreszahl 4stellig
			document.form_param.month.value = setLeadNull (datum.getMonth()+1);		// getMonth() von 0 ... 11
			document.form_param.day.value = setLeadNull (datum.getDate()-0);		// Tag 1 ... 31

			document.form_param.hours.value = "00";		
			document.form_param.minutes.value = "00";	
		}
		else
		{
			// Datum vorhanden, aus date ermitteln
			var timestampArr = date.split("|");
			if (timestampArr.length == 2)
			{
				var dateArr = timestampArr[0].split("-");
				if (dateArr.length == 3)
				{
					document.form_param.year.value = dateArr[0];;	
					document.form_param.month.value = dateArr[1];	
					document.form_param.day.value = dateArr[2];	
				}
				var timeArr = timestampArr[1].split(":");
				if (timeArr.length == 3)
				{		
					document.form_param.hours.value = timeArr[0];	
					document.form_param.minutes.value = timeArr[1];	
				}		
			}	
		}
	}	
	else
	{
		// Datum unsichtbar
		document.form_param.year.value = "";
		document.form_param.month.value = "";
		document.form_param.day.value = "";
		document.form_param.hours.value = "";
		document.form_param.minutes.value = "";
	}
}

// ********************************************************************************************

// Check Antwort auf Login-Error
function checkLoginError (actString)
{
	if (actString.indexOf("LOGIN ERROR") != -1)	
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		top.hideMessageBox();		
		top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		return 1;	
	}
	
	return 0;
}

// ********************************************************************************************

// Erzeuge SQL-Timestamp aus MBus-Datum (09.08.12 16:41:47 -> 2012-08-09 16:41:47)
function getSQLTimestampFromMbus (mbus_timestamp)
{
	var db_timestamp = 0;
	var timestampArr = mbus_timestamp.split(" ");
	if (timestampArr.length == 2)
	{
		var dateArr = timestampArr[0].split(".");
		if (dateArr.length == 3)
		{
			db_timestamp = "20"+dateArr[2]+"-"+dateArr[1]+"-"+dateArr[0]+" "+timestampArr[1];
		}
	}
	return db_timestamp;
}

// ********************************************************************************************

// Ermitteln, ob aktuell Sommerzeit ist
function isSummertime ()
{
	var summertime = 0;

	// Feststellung, ob aktuell Sommer-oder Winterzeit ist, erfolgt ueber einen Vergleich der
	// Offsets zu UTC;
	// dazu wird der Offset mit dem eines Monats verglichen, von dem bekannt ist, dass er 
	// Sommer-oder Winterzeit hat 

	// Offset zu UTC vom Januar
	var jan = new Date(2012, 0, 1, 2, 0, 0);	// Datum in Normalzeit
	var offs_winter = jan.getTimezoneOffset();	// Offset zu UTC bei Winterzeit

	// Vergleich des aktuellen Offsets zu UTC mit dem bekannten Offset
	var today = new Date();
	var offs_actual = today.getTimezoneOffset();

	if (offs_actual == offs_winter)		summertime = 0;
	else								summertime = 1;			

	return summertime;
}

// ********************************************************************************************

// Setzen Flags (Standard, nur S/W ermitteln)
// Flags werden auf Standardwerte gesetzt (ausser S/W): S/W A N G N I T

function setFlags ()
{
	// Sommerzeit:  Flags = SANGNIT		Flag-ID = 124
	// Winterzeit:  Flags = WANGNIT		Flag-ID = 60

	if (isSummertime())	flags = 124;
	else				flags = 60;

	return flags;
}

// ********************************************************************************************
// Pruefen, ob eine Zahl Nachkommastellen > 0 hat (1.000 -> 0, 1.123 -> 1)
function checkForDecimalPlaces (num)
{
	var str = num.toString();
	var strArr = str.split(".");
	var nc = parseInt(strArr[1]);
	if (isNaN(nc) || (nc == 0))
		return 0;
	return 1;	
}

// ********************************************************************************************
// maximal erforderliche Anzahl an Telegrammen ermitteln
function getTeleMax ()
{
	var teleMax = 0;
	

	for (var z=0; z<channelArr.length; z++)
	{
		var tele = channelArr[z].Tele - 1;
		if (tele > teleMax)
			teleMax = tele;	
	}

	return teleMax+1;
}

// ********************************************************************************************
// ********************************************************************************************



// ********************************************************************************************
// INFO
// ********************************************************************************************

// INFO
// Aktuelle Daten
function info_currentData()
{
	var headline =  '<B>INFO: '+ins("mbus_data_info_currentData_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_data_info_currentData")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 250, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



