/**********************************************************************************************
	JS functions for mbus_remove

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		05.2011
	Version 0.2		11.2015

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;

var counterObj;			// lokales Objekt zur Speicherung der zu loeschenden Zaehler
var oStr;				// Objekt zur Aktualisierung Tree


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Konfigurierte und Nicht-Konfigurierte Zaehler aus der Navigation ermitteln
	mbus_getCounterFromTree ();
}

// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nur Administrator/Operator darf Zaehler loeschen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button disabel
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;

	// markierte Zaehler aus der configbase loeschen
	mbus_setCounterList ();	
}


// ********************************************************************************************
// ********************************************************************************************
// Konfigurierte und Nicht-Konfigurierte Zaehler aus der Navigation ermitteln
function mbus_getCounterFromTree ()
{
	var counter = top.frame_tree.treeDataObj.MBus.configuration.counter;

	var list = {};
	list.counter = [];	

	for (var i=0; i<counter.length; i++)
	{
		list.counter[i] = {};
		list.counter[i].Icon = counter[i].icon; 
		list.counter[i].BusAdr = counter[i].info; 
		list.counter[i].Name = counter[i].text; 
	}

	// var objStr = JSON2.stringify (list, null, 4);	// Object -> String
	// alert (objStr);

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");
	var jObject = list;

	for (var i=0; i<1000; i++)
	{			   
		// Abbruch, wenn kein Eintrag mehr
		if (jObject.counter[i] === undefined)
			break;	

		var cnt = i+1;
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte Name
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.counter[i].Name;
		td.setAttribute ("class", "td_200");
		// Schriftfarbe blau (gespeichert) oder rot (ungespeichert)
		if (jObject.counter[i].Icon == "tools_red.gif")
			td.setAttribute ("style", "Color:#FF0000;");

		// 2. Spalte Bus-ID
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.counter[i].BusAdr;
		td.setAttribute ("class", "td_200");
		// Schriftfarbe blau (gespeichert) oder rot (ungespeichert)
		if (jObject.counter[i].Icon == "tools_red.gif")
			td.setAttribute ("style", "Color:#FF0000;");

		// 3. Spalte Checkbox
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = '<input name="check_'+i+'" type="checkbox">'; 
		td.setAttribute ("class", "td_100");
		td.setAttribute ("style", "text-align:center;");
	}
}

// ********************************************************************************************
// ********************************************************************************************
// markierte Eintraege aus der counter.json loeschen
function mbus_setCounterList ()
{
	counterObj = new Object();
	counterObj.counter = new Array();
	cntToRemove = 0;

	for (var i=0; i<255; i++)
	{	
		// Eintrag vorhanden?
		var table = document.getElementById ("tab_mbus_id");
		if (table.rows[i] === undefined)
			break;					

		// Checkbox aktiv?	
		var check = eval ('document.getElementsByName("check_'+i+'")');
		if ((check[0] !== undefined) && (check[0].checked == true))
		{
			// alert ("entry "+ i +" checked");
			
			// keine roten (nichtkonfigurierten) Eintraege listen
			var color = getTableElementColor ("tab_mbus_id", i, 0);
			// alert (color);			
			if (color == "Color:#FF0000;")
				continue;

			// MBus-ID ermitteln
			var mbus_id = getTableElement ("tab_mbus_id", i, 1);
			counterObj.counter[counterObj.counter.length] = mbus_id;
		
			cntToRemove++;
		}		
	}

	var objStr = JSON2.stringify (counterObj, null, 4);	// Object -> String
	// alert (objStr);

	// counter.json senden
	top.setDataExtended ("mbus_remove", "counter_remove", objStr);	

	// Zählerliste anfordern, um Fortschritt zu ermitteln
	setTimeout ("top.getDataExtended ('mbus_remove', 'counter_list', 'top.frame_content.getChangedCounterList(actStr)')", 1000);

	// Messagebox
	top.messageBox_Wait();
}

// ********************************************************************************************
// Ermitteln, welche Zaehler aktuell bereits geloescht worden sind
function getChangedCounterList(actStr)
{
	//	alert (actStr);

	// Anzahl zu loeschender Eintraege
	var cntToRemove = counterObj.counter.length;

	// Geloeschte Eintraege
	var cntIsRemoved = 0;

	// Liste fuer die Ausgabe erstellen
	var listReady = false;
	var list = "";	
	var oChangedList = JSON2.parse(actStr);

	for (var i=0; i<counterObj.counter.length; i++)
	{
		if (actStr.indexOf (counterObj.counter[i]) == -1)
		{
			list += counterObj.counter[i] + " \n";
			cntIsRemoved++;			
		}
	}

	if (cntToRemove == cntIsRemoved)	
		listReady = true;

	top.hideMessageBox();
	messageBox_wait_remove (list);

	if (!listReady)	
		setTimeout ("top.getDataExtended ('mbus_remove', 'counter_list', 'top.frame_content.getChangedCounterList(actStr)')", 2000);
	else
		setTimeout ("modifyNavigation()", 3000);			// fertig, Navigation aktualisieren	
}

// ********************************************************************************************
// tree aktualisieren
function modifyNavigation ()
{

		top.hideMessageBox();

		// ----------------------------------------------------------------------------------------
		// tree aktualisieren
		// tree lesen 
		var module = "/config/www/tree/treeData.js";
		top.getDataExtended (module, "fileload", "top.frame_content.mbus_getTreeData(actStr)");
}

// ********************************************************************************************
// tree aktualisieren - Antwort
function mbus_getTreeData(actStr)
{

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var treeObj = JSON2.parse(actStr);


	for (var i=0; i<255; i++)
	{	
		// Eintrag vorhanden?
		var table = document.getElementById ("tab_mbus_id");
		if (table.rows[i] === undefined)
			break;					

		// Checkbox aktiv?	
		var check = eval ('document.getElementsByName("check_'+i+'")');
		if ((check[0] !== undefined) && (check[0].checked == true))
		{
			// alert ("entry "+ i +" checked");

			// MBus-ID ermitteln
			var mbus_id = getTableElement ("tab_mbus_id", i, 1);

			// den Eintrag mit dieser mbus-id aus configuration loeschen
			for (var j=0; j<treeObj.MBus.configuration.counter.length; j++)
			{
				if (treeObj.MBus.configuration.counter[j].info == mbus_id)
				{
					// Eintrag in configuration entfernen
					// alert ("entfernt aus configuration: " + mbus_id);
					treeObj.MBus.configuration.counter.splice(j, 1);					
					break;
				}
			}

			// den Eintrag mit dieser mbus-id aus data loeschen
			for (var j=0; j<treeObj.MBus.data.counter.length; j++)
			{
				if (treeObj.MBus.data.counter[j].info == mbus_id)
				{
					// Eintrag in data entfernen					
					// alert ("entfernt aus data: " + mbus_id);
					treeObj.MBus.data.counter.splice(j, 1);					
					break;
				}
			}

		}		
	}

	// wenn kein Eintrag mehr im Segment vorhanden ist, dann einen dummy-Eintrag erzeugen
	if (treeObj.MBus.configuration.counter.length == 0)	
	{
		treeObj.MBus.configuration.counter[0] = new Object();
		treeObj.MBus.configuration.counter[0].icon = "page.gif"; 
		treeObj.MBus.configuration.counter[0].text = "no entry";
		treeObj.MBus.configuration.counter[0].info = "no entry";
		treeObj.MBus.configuration.counter[0].target = "";
	}
	if (treeObj.MBus.data.counter.length == 0)	
	{
		treeObj.MBus.data.counter[0] = new Object();
		treeObj.MBus.data.counter[0].icon = "page.gif"; 
		treeObj.MBus.data.counter[0].text = "no entry";
		treeObj.MBus.data.counter[0].info = "no entry";
		treeObj.MBus.data.counter[0].target = "";
	}

	// tree aktualisieren
	top.frame_tree.treeDataObj = treeObj;


	// neuen tree zum EWIO senden
	top.frame_tree.shadeTree (1);
	oStr = JSON2.stringify (treeObj, null, 0);	// Object -> String
	setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", 1000);

	// Navigation refresh
	setTimeout ("top.frame_tree.tree_getData_mbusConfiguration(oStr)", 1000);

	// Button enabel
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;

}

// ********************************************************************************************
// ********************************************************************************************
// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************
// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************
// Die Textfarbe einer Zelle in der Tabelle lesen
function getTableElementColor (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].getAttribute ("style", "Color");
	return (result);
}

// ********************************************************************************************
// ********************************************************************************************
// Messagebox "Bitte warten ..." mit Fileliste und Loeschen-Text
function messageBox_wait_remove (text)
{
	var headline = ins("main_mb_wait");
	var content = ins("mbus_remove_mb_waitlist") + '<br><br>' + 	
		'<textarea id="scroll_1" class="textfield long_250" rows="5">'+text+'</textarea>';

	top.guiPopup.Show ("login_message", headline, content, 'Loading', 400, 200, "popup_area");

	// scrolle zur letzten eingefuegten Reihe
	var scroll_area = document.getElementById('scroll_1');
	scroll_area.scrollTop = scroll_area.scrollHeight;
}

// ********************************************************************************************


