/**********************************************************************************************
	JS functions for mbus_sync

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		11.2011

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_SYNC = 0;
var oSync;				// lokales Objekt

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Button enabeln
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return 0;	
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Button fuer 1s disabeln
	top.document.getElementById("button_1").disabled = true;
	setTimeout ('top.buttonRelease("button_1")', 1000); 	

	// Konfiguration anfordern
	top.getDataExtended ("mbus_sync", "configuration", "top.frame_content.mbus_getSync(actStr)");
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button fuer 1s disabeln
	top.document.getElementById("button_2").disabled = true;
	setTimeout ('top.buttonRelease("button_2")', 1000); 	

	oSync = mbus_setSync();

	var sync_available = checkSyncAvailable();	
	if (sync_available == false)
	{		
		top.hideMessageBox();
		// "Die gew&auml;hlte Signalquelle ist bereits als Z&auml;hler-Eingang konfiguriert."		
		top.messageBox (ins("mbus_sync_error"), ins("mbus_sync_error_config")); 
		return;
	}

	var objStr = JSON2.stringify (oSync, null, 4);	// Object -> String
	if (DEBUG_SYNC)	
		alert (objStr);

	// Daten senden
	top.setDataExtended ("mbus_sync", "configuration", objStr);
}


// ********************************************************************************************
// ********************************************************************************************

function mbus_getSync(actStr)
{
	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	oSync = JSON2.parse(actStr);

	// Darstellung aktualisieren
	document.getElementById("use_sync").checked = oSync.sync;	

	if (oSync.source == "DI1")
		document.form_sync.radio_0[0].checked = true;
	else if (oSync.source == "DI2")
		document.form_sync.radio_0[1].checked = true;
	else if (oSync.source == "DI3")
		document.form_sync.radio_0[2].checked = true;
	else if (oSync.source == "DI4")
		document.form_sync.radio_0[3].checked = true;

	if (oSync.contact == "closer")
		document.form_sync.radio_1[0].checked = true;
	else if (oSync.contact == "opener")
		document.form_sync.radio_1[1].checked = true;

	// setSelectValue ("form_sync", "selectPoll", oSync.polling);
	
	setSelectValue ("form_sync", "selectGrid", oSync.grid);

	// Konfigurationsbereich aktivieren / deaktivieren	
	setActivState ("form_sync", document.getElementById("use_sync").checked);
}

// ********************************************************************************************

function mbus_setSync()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		// Werte ermitteln	
		oSync.sync = document.getElementById("use_sync").checked;

		for (var i=0; i<document.form_sync.radio_0.length; i++)
		{
			if (document.form_sync.radio_0[i].checked == true)
				oSync.source = document.form_sync.radio_0[i].value;
		}

		for (var i=0; i<document.form_sync.radio_1.length; i++)
		{
			if (document.form_sync.radio_1[i].checked == true)
				oSync.contact = document.form_sync.radio_1[i].value;
		}

	 	oSync.grid = getSelectValue ("form_sync", "selectGrid");

	 	// oSync.polling = getSelectValue ("form_sync", "selectPoll");
		return (oSync);
	}
	else
	{
		top.messageBox_Login ("Administrator");
		return 0;	
	}
}

// ********************************************************************************************

// check, ob ein als sync-Eingang vorgesehener input bereits als S0-Zaehler konfiguriert wurde 
function checkSyncAvailable()
{

	if (oSync.sync == false)
		return true;	

	var match = 0;

	var oCounterTree = top.frame_tree.treeDataObj.MBus.data.counter;
	for (var i=0; i<oCounterTree.length; i++)
	{
		// alert (oCounterTree[i].info);

		var typeArr = oCounterTree[i].info.split("-");
		if ((typeArr[1] == "SYS") && (oCounterTree[i].info.charAt(5) == "0"))
		{
			var index = oCounterTree[i].info.charAt(6);
			if ((oSync.source == "DI1") && (index == "0")) 
				match = 1;
			if ((oSync.source == "DI2") && (index == "1")) 
				match = 1;
			if ((oSync.source == "DI3") && (index == "2")) 
				match = 1;
			if ((oSync.source == "DI4") && (index == "3")) 
				match = 1;
		}

		// alert (oSync.sync + "   " + oSync.source + "   " + index + "   " + match);
		if (match)		
			return false;
	}

	return true;
}

// ********************************************************************************************
// Bereiche activ / deactiv
// ********************************************************************************************
// Alle Elemente, welche in einer angegebenen Form gruppiert sind, werden aktiv oder deaktiv dargestellt
function setActivState (form, activ)
{
	// Bereich
	if (activ)
	{
		document[form].style.opacity = 1;
		document[form].style.filter = 'alpha(opacity=100)';
	}
	else
	{
		document[form].style.opacity = 0.4
		document[form].style.filter = 'alpha(opacity=40)';
	}

	// Elemente
	if (activ)
	{	
		for (var i=0; i<document[form].length; i++)
			document[form][i].disabled = false;
	}
	else
	{
		for (var i=0; i<document[form].length; i++) 
			document[form][i].disabled = true;
	}
}

// ********************************************************************************************
// Select-Box
// ********************************************************************************************
// Setzen SelectBox auf Value
function setSelectValue (form, element, value)
{
	// Vergleich des value ueber die Anzahl der Eintraege auf Uebereinstimmung
	for (var i=0; i<document[form][element].length; i++)
	{
		if (document[form][element][i].value == value)
			document[form][element].selectedIndex = i;
	}
}

// ********************************************************************************************
// Value aus SelectBox ermitteln
function getSelectValue (form, element)
{
	var i = document[form][element].selectedIndex;
	var value = document[form][element][i].value;		
	return (value);
}

// ********************************************************************************************





// ********************************************************************************************
// Info
// ********************************************************************************************

function info_sync()
{
	var headline =  '<B>INFO: '+ins("mbus_sync_info_head_sync")+'</B>';
	content =		'<div class="pos x0101 textfield"> '+ins("mbus_sync_info_sync")+
					'</div>' +

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 400, 220, "window");
}

// ********************************************************************************************

function info_polling()
{
	var headline =  '<B>INFO: '+ins("mbus_sync_info_head_polling")+'</B>';
	content =		'<div class="pos x0101 textfield"> '+ins("mbus_sync_info_polling")+
					'</div>' +

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 400, 240, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************







