/**********************************************************************************************
	JS functions for memory.htm

	Copyright (c) MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.0		03.2012

***********************************************************************************************/


// ********************************************************************************************

var DEBUG_MEMORY = 0;			// Ausgaben
var oMemory;					// lokales Objekt


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Namen der Page ermitteln
	document.getElementById("headLine").innerHTML = 
	getFilenameFromPath (top.frame_content.location.href);
		
	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];
}

// ********************************************************************************************
// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO -> Browser)
function setObjectProperties (actObject)
{
	// Werte setzen	
	setData (actObject);
	
	// Objekt lokal speichern
	oMemory = actObject;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// Werte ermitteln	
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		var changedObject = getData(oMemory);	
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************

// Werte setzen (EWIO -> Browser)
function setData (jObject)
{
	// Einstellungen enstsprechend JSON- Objekt setzen
	// Bootmedium
	document.getElementById("bootmedium").innerHTML = "<B>" + ins("mem_bootmedia") + jObject.boot_medium + "</B>";

	// Flash
	setProgressValue ("form_flashDrive", jObject.flash_size, jObject.flash_size-jObject.flash_free);

	
	// SD-Card
	// vorhanden
	if (jObject.sdcard_available == "false")
	{
		document.getElementById("SDDrive_no").innerHTML = ins("mem_sdcard");
		document.form_SDDrive.size.value = ins("mem_sd_memory");
		setFormState ("form_sdcard", 0);	
	}	
	else
	{	
		document.getElementById("SDDrive").style.visibility = "visible";
		document.getElementById("SDDrive_no").style.visibility = "hidden";

		setProgressValue ("form_SDDrive", jObject.sd_size, jObject.sd_size-jObject.sd_free);
		setFormState ("form_sdcard", 1);	
	}

	// Formatiert mit 
	document.form_SDDrive.format.value = jObject.sdcard_format;

	// Userspace vorhanden
	if (jObject.sdcard_config == "true")
		document.form_SDDrive.data.value = ins("mem_userspace");
	else
		document.form_SDDrive.data.value = ins("mem_no_userspace");

	// kuenftig von SD-Card booten
	if ((jObject.sdcard_config == "true") && (jObject.do_boot_sdcard == "true"))
		document.form_sdcard.sd_boot.checked = true;
	else	
		document.form_sdcard.sd_boot.checked = false;

	// alle anderen Aktionen default unchecked
	document.form_sdcard.format_sd.checked = false;
	document.form_sdcard.cp_flash_sd.checked = false;
	document.form_sdcard.cp_sd_flash.checked = false;


	// ungueltige Aktionen sperren
	// SD-Card nur formatieren, wenn SD-Card vorhanden
	if (jObject.sdcard_available == "false")
		setElementState ("form_sdcard", "format_sd", 0);

	// Kopieren UserSpace von Flash auf SD-Card nur, wenn Bootmedium = Flash und SD-Card formatiert ist
	if ((jObject.boot_medium != "Flash") || (jObject.sdcard_format != "ext2"))
		setElementState ("form_sdcard", "cp_flash_sd", 0);
	else
		setElementState ("form_sdcard", "cp_flash_sd", 1);

	// Kopieren UserSpace von SD-Card auf Flash nur, wenn Bootmedium = SD-Card
	if (jObject.boot_medium != "SD-Card")
		setElementState ("form_sdcard", "cp_sd_flash", 0);
	else
		setElementState ("form_sdcard", "cp_sd_flash", 1);

	// Kuenftig von SD-Card booten nur, wenn SD-Card vorhanden und UserSpace enthaelt
	if ((jObject.sdcard_available == "false") || (jObject.sdcard_config == "false"))
		setElementState ("form_sdcard", "sd_boot", 0);
	else
		setElementState ("form_sdcard", "sd_boot", 1);
}

// ********************************************************************************************

// Progressbar setzen
function setProgressValue (name, all, used)
{
	
	var relUsed = (used * 100) / all;		// prozentualen Anteil berechnen
	relUsed = Math.round(relUsed);			// auf ganze Zahl runden

	// bar
	document.getElementById(name+"_graph").style.width = relUsed + "%";
	document.getElementById(name+"_text").innerHTML = relUsed + "%";

	// text
	all = getHumanReadableValue (all);
	used = getHumanReadableValue (used);

	document[name].size.value = ins("mem_all") +all+ ins("mem_used") +used;
}

// ********************************************************************************************

// Umwandeln von Speichergroessen (kB nach MB und GB)
function getHumanReadableValue (val)
{
	if (val > 1048576)		val = roundCommercial(val/1048576) + "GB";
	else if (val > 1024)	val = roundCommercial(val/1024) + "MB";
	else					val = val + "kB"
	return val;
}

// ********************************************************************************************

// Kaufmaennisches Runden (2 Stellen hinter dem Komma)
function roundCommercial (x)
{
	var k = (Math.round(x*100) / 100).toString();
	k += (k.indexOf('.') == -1)? '.00' : '00';
	var out = k.substring(0, k.indexOf('.') + 3);
	return out;
}

// ********************************************************************************************

// Klick auf eine Checkbox
function sd_action (num)
{
	// es darf immer nur eine Checkbox aktiv sein, daher alle anderen deaktivieren;
	// Abhaengigkeiten (Vorraussetzungen) pruefen;
	// Groesse des Speicherbedarfs bei copy-Funktionen pruefen	
	switch (num)
	{
		case 0:		// format SD
			if (document.form_sdcard.format_sd.checked == true)
			{
				if (oMemory.sdcard_available == "false")
				{
					document.form_sdcard.format_sd.checked = false;
					top.messageBox (ins("mem_note"), ins("mem_mess_no_sd"));	
				}				
				else
					top.messageBox (ins("mem_note"), ins("mem_mess_overwrite"));	
			}
			document.form_sdcard.cp_flash_sd.checked = false;
			document.form_sdcard.cp_sd_flash.checked = false;
			break;

		case 1:		// copy flash -> sd	
			if (document.form_sdcard.cp_flash_sd.checked == true)
			{
				if (oMemory.boot_medium != "Flash")
				{				
					document.form_sdcard.cp_flash_sd.checked = false;
					top.messageBox (ins("mem_note"), ins("mem_mess_sd_used"));	
				}	
				else if (!checkMemory())
				{				
					document.form_sdcard.cp_flash_sd.checked = false;
					top.messageBox (ins("mem_note"), ins("mem_mess_sd_free"));	
				}	
				else if ((oMemory.sdcard_format == "none") || (oMemory.sdcard_format == "vfat"))	
				{				
					document.form_sdcard.cp_flash_sd.checked = false;
					top.messageBox (ins("mem_note"), ins("mem_mess_sd_format"));	
				}	
				else					
					top.messageBox (ins("mem_note"), ins("mem_mess_sd_stored"));	
			}
			document.form_sdcard.format_sd.checked = false;
			document.form_sdcard.cp_sd_flash.checked = false;
			break;

		case 2:		// copy sd -> flash	
			if (document.form_sdcard.cp_sd_flash.checked == true)
			{
				if (oMemory.boot_medium != "SD-Card")
				{				
					document.form_sdcard.cp_sd_flash.checked = false;
					top.messageBox (ins("mem_note"), ins("mem_mess_flash_used"));	
				}	
				else if (!checkMemory())
				{				
					document.form_sdcard.cp_sd_flash.checked = false;
					top.messageBox (ins("mem_note"), ins("mem_mess_flash_free"));	
				}	
				else if (oMemory.sdcard_format == "none")
				{
					document.form_sdcard.cp_sd_flash.checked = false;
					top.messageBox (ins("mem_note"), ins("mem_mess_flash_format"));	
				}
				else
					top.messageBox (ins("mem_note"), ins("mem_mess_flash_stored"));	
			}
			document.form_sdcard.format_sd.checked = false;
			document.form_sdcard.cp_flash_sd.checked = false;
			break;
	}
}

// ********************************************************************************************

// Klick auf "von SD-Card booten"
function sd_bootCheck ()
{
	// Pruefen, ob die SD-Karte bereit zum Booten ist
	if (oMemory.sdcard_config == "false")
	{	
//		"HINWEIS", 	"Booten von SD-Card nicht moeglich. <BR>" +
//					"Kein UserSpace vorhanden.");
		top.messageBox (ins("mem_note"), ins("mem_mess_sd_no_userspace"));	
		document.form_sdcard.sd_boot.checked = false;
	}
}

// ********************************************************************************************

// Pruefen, ob genuegend freier Speicher fuer eine Kopierfunktion vorhanden ist
function checkMemory ()
{
	var result = 0;

	if (oMemory.flash_free > (oMemory.sd_size - oMemory.sd_free))	
		result = 1;

	if (oMemory.sd_free > (oMemory.flash_size - oMemory.flash_free))
		result &= 1;

	return result;
}

// ********************************************************************************************
// Bereiche activ / deactiv
// ********************************************************************************************
// Alle Elemente, welche in einer angegebenen Form gruppiert sind, werden aktiv oder deaktiv dargestellt
function setFormState (form, activ)
{
	// Bereich
	if (activ)
	{
		document[form].style.opacity = 1;
		document[form].style.filter = 'alpha(opacity=100)';
	}
	else
	{
		document[form].style.opacity = 0.4;
		document[form].style.filter = 'alpha(opacity=40)';
	}

	// Elemente
	if (activ)
	{	
		// Checkboxen enabeln
		// Button abhaengig von ihrem vorherigen Zustand setzen
		for (var i=0; i<4; i++)
			document[form][i].disabled = false;
	}
	else
	{
		// alle Elemente disabeln
		for (var i=0; i<document[form].length; i++) 
			document[form][i].disabled = true;
	}
}

// ********************************************************************************************

// Einzelnes Element aktiv oder deaktiv darstellen 
// (id und Name des Elements muessen gleich sein!)
function setElementState (form, id, activ)
{
	if (activ)
	{
		document.getElementById(id).style.opacity = 1;
		document.getElementById(id).style.filter = 'alpha(opacity=100)';	
		document[form][id].disabled = false;
	}
	else
	{
		document.getElementById(id).style.opacity = 0.4;
		document.getElementById(id).style.filter = 'alpha(opacity=40)';	
		document[form][id].disabled = true;
	}
}

// ********************************************************************************************
// ********************************************************************************************

// Werte lesen (Browser -> EWIO)
function getData (jObject)	
{
	// default
	SD_TIME = 0;	// keine Zeitangabe	

	// Objekt-Elemente zuweisen
	// SD-Card formatieren
	if (document.form_sdcard.format_sd.checked)	
	{	
		jObject.do_format_sdcard = "ext2";
		// Zeit abhaengig von der Groesse (20s pro GB)
		SD_TIME = (Math.round(jObject.sd_size / 1000000)) * 20;
	}	
	else											
		jObject.do_format_sdcard = "none";

	// Kopieren von Flash auf SD-Card
	if (document.form_sdcard.cp_flash_sd.checked)
	{	
		jObject.do_copy_flash_sd = "true";
		SD_TIME = 15;	// Zeit fuer Kopieren Flash -> SD	
	}	
	else
		jObject.do_copy_flash_sd = "false";

	// Kopieren von SD-Card auf Flash 
	if (document.form_sdcard.cp_sd_flash.checked)	
	{	
		jObject.do_copy_sd_flash = "true";
		SD_TIME = 45;	// Zeit fuer Kopieren SD -> Flash (dauert laenger als Flash -> SD!)	
	}	
	else
		jObject.do_copy_sd_flash = "false";

	// Booten von SD-Card
	if (document.form_sdcard.sd_boot.checked)	
		jObject.do_boot_sdcard = "true";
	else
		jObject.do_boot_sdcard = "false";

	if (SD_TIME > 0)
		sd_setCountdown ();		// CountDown-Timer starten	
	
	return (jObject);
}

// ********************************************************************************************
// ********************************************************************************************
// COUNTDOWN-TIMER

// Timer- Variablen
var id_sd;
var sd_counter;			// aktuelle Zeit
var SD_TIME;			// CountDown-Zeit, in getData() gesetzt!

// Countdown-Message anzeigen, waehrend Daten auf SD-Karte kopiert werden
function sd_setCountdown ()
{
	var headline = '<B>'+ins("mem_mess_wait")+'</B>';
	content =		'<form name="form_sdcpy">'+ 		
					'<div class="pos x0101 textfield">'+ins("mem_mess_countdown")+
					'</div>'+
					'<div class="pos x0401">'+
					'<input type="text" name="countdown" class="textfield_show fattext" size="30" readonly="readonly" value="">'+		
					'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'Info', 400, 140, "window");

	// Countdown-String aktualisieren
	sd_counter = SD_TIME;
	id_sd = setInterval ('sd_countDownCalculator()', 1000);
}

function sd_countDownCalculator ()
{
	var str = ins("mem_mess_waittime") + sd_counter;
	if (document.form_sdcpy.countdown)	
		document.form_sdcpy.countdown.value = str;

	sd_counter--;
	if (sd_counter < 0)
	{
		sd_counter = SD_TIME;	
		clearInterval (id_sd);
	
		// countdown-pad schliessen
		guiPopup.CloseMe("message");

		// Seite neu aufrufen
		initSide();
	}
}

// ********************************************************************************************
// ********************************************************************************************






