/**********************************************************************************************
	JS functions for modbus_config

	Copyright (c) 2014 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		02.2014

***********************************************************************************************/


/*
	Anmerkungen:

	Es werden in jedem Fall Templates geladen, welche die default-Einstellungen (Instanz)
	und die Darstellungsvorschrift (Schema) enthalten.

	Gibt es in der DB eine Zaehlerkonfiguration dazu, dann wird diese gelesen und ausgewertet.
	Die Werte aus dem Template (Instanz) werden damit ueberschrieben.

	Beim Speichern werden die (geaenderten) Werte in die DB geschrieben.

	Ist die Konfiguration dargestellt, werden die Init- sowie die TX-Frames gesendet und die
	Daten aus der Antwort (oder den Antworten) eingefügr.

*/

// ********************************************************************************************

var json_instance = {};		// JSON-Daten
var json_schema = {};		// JSON-Schema

var nameArr = [];			// enthaelt die vom tree uebergebenen Parameter

var counterObj = 0;			// Konfiguration Counter, RX und TX
var channelCntObj;			// Objekt fuer Anzahl der channel
var channel_cnt;			// aktueller channel-Index
var channelArr;				// Array mit allen channel-Objekten

var oStr;					// Aktualisierung Tree
var msgChannel;				// Channel fuer Messagebox-Anzeige
var interval_timeout;		// Timeout fuer Messagebox-Anzeige

var DEBUG_MBCONFIG = 0;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Namen im Header anzeigen
	nameArr = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = nameArr[0];

	if (DEBUG_MBCONFIG)	
		alert ("nameArr = " + nameArr);

	// ChannelArray anlegen		
	channelArr = new Array();

	// Parameter vom EWIO abfragen
	modbus_dataFromEWIO();
}

// ********************************************************************************************
// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************






// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{
	// Button 1s disabeln
	buttonDisabel(1, true);
	setTimeout ("buttonDisabel(1, false)", 1000);

	// Messagebox
	top.messageBox_Wait ();

	// content loeschen
	document.getElementById("content").innerHTML = "";

	// BusAdr ermitteln
	var moduleId = nameArr[1];

	// Laden Konfiguration aus DB
	top.getDataExtended (moduleId, 'modbus_counter', 'top.frame_content.modbus_getCounter_answer(actStr)');
}

// ********************************************************************************************
// Laden Konfiguration aus DB
// Antwort
function modbus_getCounter_answer(actStr)
{
	if (DEBUG_MBCONFIG)	
		alert (actStr);

	// gibt es noch kein Konfigurationsfile, muss ein template geladen werden
	// und default-Werte erzeugt werden
	var template = "";

	if (actStr.indexOf("{") == -1)
	{	
		var source = "modbus_getCounter / create";

		// Erzeugen eines JSON-Konfigurationstemplates
		var actObject = new Object();

		// Gibt es kein Konfigurationsfile,  
		// werden Name, Adresse, Bus, Subbus aus der automatischen Suche voreingestellt

		// Bustyp
		var bType = nameArr[2];
		var subBType = nameArr[3];

		// Objekt fuellen
		actObject.ID = 0;								// Zaehler default
		actObject.BusAdr = nameArr[1];
		actObject.BR = 0;
		actObject.Name = nameArr[0];		

		actObject.Sort = 0;	
		actObject.ZNummer = "";
		actObject.Mandant = "";
		actObject.AbnNr = "";

		actObject.ztype = new Object();					// Zaehlertyp
		actObject.ZTyp_ID = 1;		
		actObject.ztype.Kinds = "Normal";

		actObject.btype = new Object();					// Bustyp
		actObject.btype.Kinds = bType;		
		switch (bType)
		{
			case "Modbus":	actObject.BTyp_ID = 3;		break;
			case "System":	actObject.BTyp_ID = 2;		break;
		}
		
		actObject.busdetails = new Object();			// Busdetails
		actObject.busdetails.Zaehler_ID = 0;
		actObject.busdetails.Text_1 = "/dev/ttyS1";		// busPath 
		actObject.busdetails.Text_2 = subBType; 		// subBus
		actObject.busdetails.Text_3 = nameArr[4];		// Name Template

		actObject.meteringcode = new Object();			// Meteringcode
		actObject.meteringcode.Zaehler_ID = 0;
		actObject.meteringcode.Land = "DE";
		actObject.meteringcode.Betreiber = 123456;
		actObject.meteringcode.Plz = 12345;
		actObject.meteringcode.MePuId = "EXAMPLE0123456789012";

		// Namen des Templates ermitteln
		template = "modbus_" + nameArr[4];
	}
	else
	{
		var source = "modbus_getCounter / load";

		// JSON-String in Objekt wandeln
		var actObject = JSON2.parse(actStr);

		template = "modbus_" + actObject.busdetails.Text_3;
	}

	// Objekt lokal fuer andere Funktionen speichern
	counterObj = actObject;

	if (DEBUG_MBCONFIG)	
	{
		var actStr = JSON2.stringify (actObject, null, 4);
	 	alert (source + "\n" + actStr);
	}

	// Laden Template Instanz	
	top.getDataExtended (template, "configuration", "top.frame_content.modbus_getInstance(actStr)");
}

// ********************************************************************************************
// Laden Instanz	
function modbus_getInstance(actStr)
{
	if (DEBUG_MBCONFIG)	
		alert ("modbus_getInstance: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	json_instance = JSON2.parse(actStr);

	// korrekte Adresse hinzufuegen
	json_instance.device.Address = nameArr[1];

	// Namen des Templates ermitteln
	template = "modbusSchema";

	// Laden schema
	top.getDataExtended (template, "configuration", "top.frame_content.modbus_getSchema(actStr)");
}

// ********************************************************************************************
// Laden schema
function modbus_getSchema(actStr)
{
	if (DEBUG_MBCONFIG)	
		alert ("modbus_getSchema: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	json_schema = JSON2.parse(actStr);
	
	// Daten vom EWIO darstellen
	modbus_displayConfig();
}

// ********************************************************************************************
// Daten vom EWIO darstellen
function modbus_displayConfig()
{
	// $ref innerhalb des Schemas expandieren
	schemaExpanded = expandSchema (json_schema, json_schema);
	// erhaltene Instanz speichern
	json_instance_rcv = JSON.parse(JSON.stringify(json_instance));	

	//	var actString = JSON.stringify (schemaExpanded, null, 4);
	//	alert (actString);

	//	var actString = JSON.stringify (json_instance, null, 4);
	//	alert (actString);

	// Inhalt aufbereiten und darstellen
	setContent ("device", "", "obj", "device");


	// Channel einlesen, um checkboxen zu setzen
	moduleId = nameArr[1];
	top.getDataExtended (moduleId, "modbus_channels", "top.frame_content.modbus_getChannels_answer(actStr)");

}

// ********************************************************************************************
// Antwort: channel einlesen
function modbus_getChannels_answer(actStr)
{

	if (actStr.indexOf("{") == -1)
	{
		// keine channel gespeichert

		// Messagebox schliessen
		top.hideMessageBox();

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		top.document.getElementById("button_2").disabled = false;
		return;
	}	

	if (checkLoginError (actStr))
		return;

	// Objekt im channelArr speichern
	var actObj = JSON2.parse(actStr);
	channelArr = actObj.channel;

	if (DEBUG_MBCONFIG)	
	{
		var objStr = JSON2.stringify (counterObj, null, 4);
		alert ("modbus_getChannels_answer: \n"+objStr);
	}

	// checkboxen von gespeicherten channels aktivieren
	// register mit gespeicherten rec vergleichen
	var k = 0;	
	for (var i=0; i<channelArr.length; i++)
	{	
		var rx = json_instance.device.RX;	
		for (var j=0; j<rx.length; j++)
		{
			if (channelArr[i].Rec == rx[j].register)
			{
				var id_chk = "chk_device/RX/["+j+"]/select";
				// alert (id_chk);
				document.getElementById(id_chk).checked = "checked";
			}
		}
	}

	// Messagebox schliessen
	top.hideMessageBox();

	// Anzahl eingelesener channel merken
	channelCntObj = channelArr.length;

	//alert (document.getElementById("content").innerHTML);
}

// ********************************************************************************************






// ********************************************************************************************
// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button sperren
	disableButton (true);

	// Wartezeit berechnen
	channelWait = 2500 + (channelArr.length * 2500);

	// Anzahl DP abfragen, anschliessend Zaehlerkonfiguration abfragen
	top.getDataExtended ('modbus_config', 'db_max', 'top.frame_content.modbus_getDPMax(actStr)');
}

// ********************************************************************************************
// Pruefen, ob die max. Anzahl DP erreicht ist, wenn ja, keine Speicherung!
function modbus_getDPMax (actStr)
{
	// alert (actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// state der checkboxen ermitteln (wieviele aktiv?) = Anzahl neuer channel
	var selectCnt = 0;
	for (var i=0; i<1024; i++)
	{
		var id_chk = "chk_device/RX/["+i+"]/select";
		if (document.getElementById(id_chk) == undefined)
			break;
		// alert (id_chk);
		if (document.getElementById(id_chk).checked == true)
			selectCnt++;					
	}

	// Differenz zwischen Anzahl der bisherigen und neuer channel ermitteln
	var channelCnt = selectCnt - channelCntObj;	
	// alert ("channelCnt = " + channelCnt + "   channelCntObj = " + channelCntObj + "   selectCnt = " + selectCnt);
	
	// channelCnt = Anzahl jetzt zu speichernder DP
	// jObject.channel.count = Anzahl bisher gespeicherter DP
	// jObject.channel.max = max. Anzahl DP gesamt

	// alert ("channel bisher = " + jObject.channel.count + "   channel neu = " + channelCnt + "   channel max = " + jObject.channel.max);

	var new_DP = jObject.channel.count + channelCnt;
	if ((new_DP > jObject.channel.max) && (jObject.channel.max > 0))
	{
		var diff = new_DP - jObject.channel.max;
		var text = 	ins("mbus_dp_1") + "<B>" + jObject.channel.max + " </B><br>"+
					ins("mbus_dp_2") + "<B>" + jObject.channel.count + " </B><br>"+
					ins("mbus_dp_3") + "<B>" + diff + " </B>!";

		dp_messageBox (ins("mbus_config_error"), text);

		var scroll_area = document.getElementById('content');
		document.getElementById('dp_message').scrollIntoView();

		// Button freigeben
		disableButton();
	}	
	else
	{
		// Speichern Konfiguration in DB
		modbus_writeConfiguration();
	}
}

// ********************************************************************************************
// MessageBox fuer DP-Abfrage
function dp_messageBox(head, text)
{
	var headline =  '<B> '+head+' </B>';
	var content =	'<div class="pos x0101 textfield" id="dp_message"> '+text+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 160, "window");
}


// ********************************************************************************************
// Speichern Konfiguration in DB
function modbus_writeConfiguration()
{

	// ---------------------------------------------------------------------------------------
	// Parameter fuer Zaehler-Konfigurationsfile zusammenstellen

	// Messagebox
	top.messageBox_Wait_ext (ins("mbus_config_message_counter_store"));

	var objStr = JSON2.stringify (counterObj, null, 4);
	if (DEBUG_MBCONFIG)	
		alert ("safe counter: \n" + objStr);

	// Konfigurationsfile Zaehler schreiben
	moduleId = nameArr[1];
	top.setDataExtended (moduleId, "modbus_counter", objStr);


	// ---------------------------------------------------------------------------------------
	// Parameter fuer Channel-Konfigurationsfile zusammenstellen

	// Messagebox Channels
	msgChannel = 0;
	interval_timeout = setInterval ("messageChannel()", 2000);


	var objStr = JSON2.stringify (channelArr, null, 4);

	if (DEBUG_MBCONFIG)	
		alert ("channelArr: \n" + objStr);

	var outObj = new Object();
	outObj.channel = new Array();

	// state der checkboxen ermitteln
	// register mit gespeicherten rec vergleichen
	var k = 0;	
	for (var i=0; i<channelArr.length; i++)
	{	
		var rx = json_instance.device.RX;	
		for (var j=0; j<rx.length; j++)
		{
			if (channelArr[i].Rec == rx[j].register)
			{
				var id_chk = "chk_device/RX/["+j+"]/select";
				// alert (id_chk);
				if (document.getElementById(id_chk).checked == true)
				{
					// channel zum SendeString hinzufuegen
					outObj.channel[k++] = channelArr[i];	
				}
			}
		}
	}

	outStr = JSON2.stringify (outObj, null, 4);	// Object -> String					
	if (DEBUG_MBCONFIG)	
		alert ("safe channels: \n" + outStr);

	// Konfigurationsfile Channel schreiben
	setTimeout ("top.setDataExtended (moduleId, 'modbus_channels', outStr)", 2000);

	// Sind channels ausgewaehlt worden?
	// wenn nicht, dann channelArr zuruecksetzen, damit korrekte Anzeige im Tree
	if (j == 0)
		channelArr.length = 0;

	// ----------------------------------------------------------------------------------------
	// tree aktualisieren
	var newTreeObj = modbus_setTreeData (top.frame_tree.treeDataObj);
	top.frame_tree.treeDataObj = newTreeObj;
	oStr = JSON2.stringify (newTreeObj, null, 0);	// Object -> String

	// neuen tree zum EWIO senden
	setTimeout ("top.frame_tree.shadeTree (1)", channelWait+1000);
	setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", channelWait+2000);

	// Navigation refresh
	setTimeout ("top.frame_tree.tree_getData_mbusConfiguration(oStr)", channelWait+2000);

	// Button freigeben
	setTimeout ("disableButton (false)", channelWait+3000);

	// Message hide
	setTimeout ("top.hideMessageBox()", channelWait+3000);


}

// ********************************************************************************************











// ********************************************************************************************
// Tabs
// ********************************************************************************************
// Parametrierung der optionalen Zaehlerangaben
function counter_tabsOpen ()
{

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab0	
	var config_0 = 	
					'<form name="form_tab0">'+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_config_counter_nr")+': </div>'+
					'<div class="pos x0104"> <input type="text" class="textfield long_200" value="" name="ZNummer"> </div> '+
					'<div class="pos p0103"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_ZNummer()"> </a> </div>'+

					'<div class="pos x0201 textfield"> '+ins("mbus_config_counter_client")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield long_200" value="" name="Mandant"> </div> '+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Mandant()"> </a> </div>'+

					'<div class="pos x0301 textfield"> '+ins("mbus_config_counter_customer")+': </div>'+
					'<div class="pos x0304"> <input type="text" class="textfield long_200" value="" name="AbnNr"> </div> '+
					'<div class="pos p0303"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_AbnNr()"> </a> </div>'+

					'<div class="pos x0501 comment"> '+ins("mbus_config_counter_optional")+' </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="counter_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="counter_tabsClose(0)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab1	
	var config_1 = 	
					'<form name="form_tab1">'+ 		

					'<div class="pos p0003"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_MeteringCode()"> </a> </div>'+
					'<div class="pos x0101 textfield"> '+ins("mbus_config_counter_country")+': </div>'+
					'<div class="pos x0104"> <input type="text" class="textfield long_200" value="" name="Land"> </div> '+
					'<div class="pos x0201 textfield"> '+ins("mbus_config_counter_operator")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield long_200" value="" name="Betreiber"> </div> '+
					'<div class="pos x0301 textfield"> '+ins("mbus_config_counter_plz")+': </div>'+
					'<div class="pos x0304"> <input type="text" class="textfield long_200" value="" name="Plz"> </div> '+
					'<div class="pos x0401 textfield"> '+ins("mbus_config_counter_meas_id")+': </div>'+
					'<div class="pos x0404"> <input type="text" class="textfield long_200" value="" name="MePuId"> </div> '+
					'<div class="pos x0501 comment"> '+ins("mbus_config_counter_optional")+' </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="counter_tabsClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="counter_tabsClose(0)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Register anlegen	

	// erst content anlegen	
	var tabContent = new Array();
	tabContent[0] = config_0;
	tabContent[1] = config_1;
	guiTabs.Content ("config_box", tabContent, tabContent.length, 'Tools', 500, 200, "window", true);
	
	// dann tabs anlegen
	var tabText = new Array();
	tabText[0] = ins("mbus_config_meas_point");		// "Messpunkt"
	tabText[1] = "Meter.-Code";
	guiTabs.Create ("tab", tabText, tabText.length, 'Tools', 500, 200, "window");

	// default-Tab setzen
	guiTabs.Select (0);

	// ---------------------------------------------------------------------------------------
	// Felder aus Konfig-File aktualisieren, wenn vorhanden
	// tab0
	if (counterObj)
	{
		// tab0
		document.form_tab0.ZNummer.value = counterObj.ZNummer;
		document.form_tab0.Mandant.value = counterObj.Mandant;
		document.form_tab0.AbnNr.value = counterObj.AbnNr;

		// tab1
		document.form_tab1.Land.value = counterObj.meteringcode.Land;
		document.form_tab1.Betreiber.value = addLeadingZeros (counterObj.meteringcode.Betreiber, 6); 
		document.form_tab1.Plz.value = addLeadingZeros (counterObj.meteringcode.Plz, 5);
		document.form_tab1.MePuId.value = counterObj.meteringcode.MePuId;
	}
}

// ********************************************************************************************
// Parametrierung der optionalen Zaehlerangaben schliessen
function counter_tabsClose (valid)
{

	top.hideMessageBox();

	if (valid)
	{
		// alert ("Eingaben werden gespeichert ... ");
		// aktualisierte Felder speichern

		// tab1
		// Pruefen Messpunkt Eingaben, 
		// Zaehler-Nummer, max.50 Zeichen, alphanum.+_
		var ret = top.checkInputString (ins("mbus_config_counter_nr"), document.form_tab0.ZNummer.value, "^[A-Za-z0-9_]{0,50}$"); 	
		if (ret == -1)
			return;
		// Mandant, max.50 Zeichen, alphanum.+_ ,
		var ret = top.checkInputString (ins("mbus_config_counter_client"), document.form_tab0.Mandant.value, "^[A-Za-z0-9_ ,]{0,50}$"); 	
		if (ret == -1)
			return;
		// Abn.-Nummer, max.50 Zeichen, alphanum.+_
		var ret = top.checkInputString (ins("mbus_config_counter_customer"), document.form_tab0.AbnNr.value, "^[A-Za-z0-9_]{0,50}$"); 	
		if (ret == -1)
			return;

		counterObj.ZNummer = document.form_tab0.ZNummer.value;
		counterObj.Mandant = document.form_tab0.Mandant.value;
		counterObj.AbnNr = document.form_tab0.AbnNr.value;

		// tab1
		// Pruefen Metring-Code Eingaben	
		var ret = top.checkInputString (ins("mbus_config_counter_country"), document.form_tab1.Land.value, "^[A-Z]{2}$"); 	// Land, 2 Zeichen, Grossbuchstaben
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_operator"), document.form_tab1.Betreiber.value, "^[0-9]{6}$"); 	// Betreiber, 6 Ziffern
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_plz"), document.form_tab1.Plz.value, "^[0-9]{5}$"); 	// PLZ, 5 Ziffern
		if (ret == -1)
			return;
		var ret = top.checkInputString (ins("mbus_config_counter_meas_id"), document.form_tab1.MePuId.value, "^[A-Za-z0-9]{20}$"); 	// Messpunkt-ID, 20 Zeichen
		if (ret == -1)
			return;

		counterObj.meteringcode.Land = document.form_tab1.Land.value;
		counterObj.meteringcode.Betreiber = addLeadingZeros (parseInt(document.form_tab1.Betreiber.value), 6);
		counterObj.meteringcode.Plz = addLeadingZeros (parseInt(document.form_tab1.Plz.value), 5);
		counterObj.meteringcode.MePuId = document.form_tab1.MePuId.value;
	}

	// Tabs schliessen	
	guiTabs.CloseTabs ("tab");
	guiTabs.CloseTabs ("config_box");
}

// ********************************************************************************************
// Parametrierung der Datenpunkte oeffnen
function channel_tabsOpen (path)
{
	// alert ("path = " + path);
	var pathArr = path.split(",");

	// index aus dem path ermitteln
	var index = parseInt(pathArr[2].substring(1));	

	// rec aus dem path ermitteln
	var id_rec = "tab_RX_"+index+"_0";
	var rec = document.getElementById(id_rec).innerHTML;
	// alert (rec);	


	var config_0 = 	'<form name="form_tab0">'+ 		
					'<div class="pos x0101"> '+ins("mbus_config_channel_interval")+' </div>'+
					'<div class="pos x0103">'+
						'<select name="interval" size="1" class="combobox long_100">'+
							'<option value="1"> 1 min </option>'+
							'<option value="5"> 5 min </option>'+
							'<option value="15"> 15 min </option>'+
							'<option value="30"> 30 min </option>'+
							'<option value="60"> 1 h </option>'+
							'<option value="120"> 2 h </option>'+
							'<option value="240"> 4 h </option>'+
							'<option value="360"> 6 h </option>'+
							'<option value="720"> 12 h </option>'+
							'<option value="day"> daily </option>'+
							'<option value="week"> weekly </option>'+
							'<option value="month"> monthly </option>'+
							'<option value="quart"> quarterly </option>'+
							'<option value="half"> half-yearly </option>'+
							'<option value="year"> yearly </option>'+
							'<option value="none"> none </option>'+
							'</select>'+
					'</div>'+
					'<div class="pos p0103">'+
							'<a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_interval()"> </a>'+
					'</div>'+
					
					'<div class="pos x0201 textfield"> '+ins("mbus_config_channel_readout")+': </div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="" name="EAblesung"> </div> '+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_EAblesung()"> </a> </div>'+

					'<div class="pos x0301 textfield"> '+ins("mbus_config_channel_factor")+': </div>'+
					'<div class="pos x0303"> <input type="text" class="textfield long_50" value="" name="Faktor_U"> </div> '+
					'<div class="pos x0305"> <input type="text" class="textfield long_50" value="" name="Faktor_I"> </div> '+
					'<div class="pos p0303"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Faktor()"> </a> </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="channel_tabsClose('+rec+')">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="channel_tabsClose(-1)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Inhalt Tab1	
	var config_1 =	'<form name="form_tab1">'+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_config_channel_obis")+': </div>'+
					'<div class="pos x0104"> <input type="text" class="textfield long_200" value="" name="Obis_ID"> </div> '+
					'<div class="pos p0103"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_Obis()"> </a> </div>'+

					'<div class="pos x0201 textfield"> '+ins("mbus_config_channel_description")+': </div>'+
					'<div class="pos x0204"> <input type="text" class="textfield long_200" value="" name="description"> </div> '+
					'<div class="pos p0203"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_description()"> </a> </div>'+

					'<div class="pos x0301 textfield"> '+ins("mbus_config_channel_edit_unit")+': </div>'+
					'<div class="pos x0304"> <input type="text" class="textfield long_100" value="" name="Einheit_edit"> </div>'+
					'<div class="pos p0303"> <a href="#"><img src="style/info_blue.png" class="icons_little" onclick="info_MEinheit()"> </a> </div>'+

					'<div class="pos x0501 comment"> '+ins("mbus_config_counter_optional")+' </div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="channel_tabsClose('+rec+')">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="channel_tabsClose(-1)">'+
					'</div>';
					'</form>';

	// ---------------------------------------------------------------------------------------
	// Register anlegen	

	// erst content anlegen	
	var tabContent = new Array();
	tabContent[0] = config_0;
	tabContent[1] = config_1;
	guiTabs.Content ("config_box", tabContent, tabContent.length, 'Tools', 500, 200, "window", true);

	// dann tabs anlegen
	var tabText = new Array();
	tabText[0] = "Parameter";
	tabText[1] = "Options";
	guiTabs.Create ("tab", tabText, tabText.length, 'Tools', 500, 200, "window");

	// default-Tab setzen
	guiTabs.Select (0);

	// ---------------------------------------------------------------------------------------
	// Initialisierung durch DB oder durch default-Werte
	if (0)
	{
		// aus DB


	}
	else
	{
		var match = -1;	
		for (var i=0; i<channelArr.length; i++)
		{	
			if (rec == channelArr[i].Rec)	
			{
				match = i;
				break;
			}	
		}

		if (match > -1)
		{
			// bereits im webInterface bearbeitet, aus channelArr uebernehmen
			var len = match;

			// tab0	
			for (var i=0; i<document.form_tab0.interval.length; i++)
			{
				if (document.form_tab0.interval[i].value == channelArr[len].Intervall)
					document.form_tab0.interval.selectedIndex = i;
			}
			document.form_tab0.EAblesung.value = channelArr[len].EAblesung;		
			document.form_tab0.Faktor_U.value = channelArr[len].Faktor_U;
			document.form_tab0.Faktor_I.value = channelArr[len].Faktor_I;

			// tab1
			document.form_tab1.Obis_ID.value = channelArr[len].Obis_ID;
			document.form_tab1.description.value = channelArr[len].ZwTyp;
			document.form_tab1.Einheit_edit.value = channelArr[len].Einheit_edit;
		}
		else
		{
			// default
			// tab0	
			document.form_tab0.interval.selectedIndex = 2;		// Intervall = 15 min

			var time = setTimeToNextInterval (5);				// EA-Zeit = aktuell		
			document.form_tab0.EAblesung.value = getTimeInSQLFormat (time);		

			document.form_tab0.Faktor_U.value = 1;				// Faktor U = 1
			document.form_tab0.Faktor_I.value = 1;				// Faktor I = 1
	
			// tab1
			// description
			var id_dsc = "tab_RX_"+index+"_3";
			document.form_tab1.description.value = document.getElementById(id_dsc).innerHTML;
			// unit			
			var id_unit = "tab_RX_"+index+"_2";
			document.form_tab1.Einheit_edit.value = document.getElementById(id_unit).innerHTML;

		}
	}
}

// ********************************************************************************************
// Parametrierung der Datenpunkte schliessen
function channel_tabsClose (rec)
{
	top.hideMessageBox();
	if (rec == -1)
	{
		guiTabs.CloseTabs ("tab");
		guiTabs.CloseTabs ("config_box");
		return;
	}

	// ---------------------------------------------------------------------------------------
	// Werte speichern ...
	// Werte werden im channelArr gespeichert. Wenn bereits channel konfigueriert waren, dann sind
	// bereits channel im Array belegt. Die neue Konfiguration wird dann angefuegt.

	// Eingaben pruefen
	// Faktor U,I
	var ret = top.checkInputString (ins("mbus_config_channel_factor"), document.form_tab0.Faktor_U.value, "^[0-9\.]{1,50}$"); 	// Faktor_U, 1 - 50 Zeichen, Ziffern
	ret |= top.checkInputString (ins("mbus_config_channel_factor"), document.form_tab0.Faktor_I.value, "^[0-9\.]{1,50}$"); 		// Faktor_I, 1 - 50 Zeichen, Ziffern
	if (ret == -1)
		return;
	// EAblesung
	ret = top.checkDBTimeFormat (ins("mbus_config_channel_readout"), document.form_tab0.EAblesung.value);
	if (ret == -1)
		return;
	// OBIS
	var ret = top.checkInputString (ins("mbus_config_channel_obis"), document.form_tab1.Obis_ID.value, "^[0-9\.\:\*\-]{0,50}$"); 	// OBIS, 1 - 50 Zeichen, Ziffern+.:*-
	if (ret == -1)
		return;
	// Description, 0 - 100 Zeichen, alphanum.+_./=?!%-:,
	var ret = top.checkInputString (ins("mbus_config_channel_description"), document.form_tab1.description.value, "^[A-Za-z0-9_\ \.\/\=?\!\%-:,]{0,100}$"); 	
	if (ret == -1)
		return;
	// Eingabe "Einheit" wird auf Grund der vielen Optionen nicht ueberprueft


	// ---------------------------------------------------------------------------------------
	// wenn Array-Eintrag noch nicht besteht, dann anlegen;
	// andernfalls den zutreffenden channel suchen
	var match = -1;	
	for (var i=0; i<channelArr.length; i++)
	{	
		if (rec == channelArr[i].Rec)	
		{
			match = i;
			break;
		}	
	}
	
	if (match > -1)
	{
		var len = match;
	}
	else	
	{
		var len = channelArr.length;
		channelArr[len] = {};
	}
	// alert (match);

	// tele ermitteln		
	var recArr = [];
	var tele = 0;
	var teleLength = json_instance.device.TX.length;	
	
	for (var k=0; k<teleLength; k++)
	{
		var startReg = json_instance.device.TX[k].start;
		if (k < (teleLength - 1))
		{
			var endReg = json_instance.device.TX[k+1].start;
			if ((rec >= startReg) && (rec < endReg))
			{
				tele = k;						
				break;
			}
		}
		else
		{	
			if (rec >= startReg)
				tele = k;
		}
	}

	// alert (tele);

	// ---------------------------------------------------------------------------------------
	// Werte zuweisen
	channelArr[len].ID = 0;
	channelArr[len].Zaehler_ID = counterObj.ID;					// vom Zaehler uebernommen
	channelArr[len].Obis_ID = document.form_tab1.Obis_ID.value;
	channelArr[len].Tele = tele;								// Zaehlung beginnt bei 0
	channelArr[len].Rec = rec;
	channelArr[len].DIF = "";
	channelArr[len].VIF = "";
	channelArr[len].Faktor_U = document.form_tab0.Faktor_U.value;
	channelArr[len].Faktor_I = document.form_tab0.Faktor_I.value;
	channelArr[len].EAblesung = document.form_tab0.EAblesung.value;
	var i = document.form_tab0.interval.selectedIndex;
	channelArr[len].Intervall = document.form_tab0.interval[i].value;
	channelArr[len].ZwTyp = document.form_tab1.description.value;
	channelArr[len].MEinheit = "";
	channelArr[len].MessTyp = "";
	channelArr[len].Format = "";
	channelArr[len].App = "none";
	var time = new Date();	
	channelArr[len].Aenderung = getTimeInSQLFormat (time);
	channelArr[len].Faktor_edit = "";
	channelArr[len].Einheit_edit = document.form_tab1.Einheit_edit.value;

		
	// ---------------------------------------------------------------------------------------
	// Tabs schliessen	
	guiTabs.CloseTabs ("tab");
	guiTabs.CloseTabs ("config_box");
}

// ********************************************************************************************





// ********************************************************************************************
// Hilfsfunktionen
// ********************************************************************************************
// den naechsten regulaeren Ablesetermin suchen			!!! NUR 15 MIN - 12 H realisiert !!!
function setTimeToNextInterval (interval)
{

	var time = new Date();				// aktuelle Zeit
	var time_ms = time.getTime();		// aktuelle Zeit in Millisekunden

	var interval_ms = interval * 60 * 1000;		// Intervall in ms

	// Berechnung
	var t1 = parseInt (time_ms/interval_ms);
	var t2 = (t1 + 1) * interval_ms;

	var newTime = new Date(t2);	
	// alert ("old = " + getTimeInSQLFormat (time) + "\n" + "new = " + getTimeInSQLFormat (newTime));

	return (newTime);
}

// ********************************************************************************************
// PC- Datum ausgeben
function getTimeInSQLFormat (datum)
{
	var time = new Object();
	
	time.year = setLeadNull (datum.getFullYear()-0);		// Jahreszahl 4-stellig
	time.month = setLeadNull (datum.getMonth()+1-0);		// getMonth() von 0 ... 11
	time.date = setLeadNull (datum.getDate()-0);
	time.hours = setLeadNull (datum.getHours()-0);
	time.minutes = setLeadNull (datum.getMinutes()-0);
	time.seconds = setLeadNull (datum.getSeconds()-0);

	var output = time.year + "-" + time.month + "-" + time.date + " " + 
				 time.hours + ":" + time.minutes + ":" + time.seconds;
	return output;
}

// ********************************************************************************************
// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************
// fuehrende Nullen auffuellen
function addLeadingZeros (number, length)
{
	var num = '' + number;
	while (num.length < length)
		num = '0' + num;
	return num;
}

// ********************************************************************************************
// fuehrende Nullen entfernen
function killLeadingZeros (number)
{
	number = Number(number);
	var num = '' + number;
	return num;
}

// ********************************************************************************************
// Check Antwort auf Login-Error
function checkLoginError (actString)
{
	if (actString.indexOf("LOGIN ERROR") != -1)	
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		top.hideMessageBox();		
		top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		return 1;	
	}
	
	return 0;
}

// ********************************************************************************************
// Button disabel/enabel
function buttonDisabel(number, state)
{
	if (number == 1)
		top.document.getElementById("button_1").disabled = state;

	if (number == 2)
		top.document.getElementById("button_2").disabled = state;
}

// ********************************************************************************************
// Navigation aktualisieren
function modbus_setTreeData (treeObj)
{
	var page = top.tree_getPageName(); 	
	var modbus_id = page[1];

	// configuration aktualisieren
	for (var i=0; i<treeObj.Modbus.configuration.counter.length; i++)
	{
		//alert (mbus_id + "   " + treeObj.MBus.configuration.counter[i].info);

		if (treeObj.Modbus.configuration.counter[i].info == modbus_id)
		{		
			// Name aktualisieren
			treeObj.Modbus.configuration.counter[i].text = nameArr[0];

			// Icons
			if (channelArr.length < 1)
			{
				// Icon gelb fuer konfigurierten Zaehler ohne channel
				treeObj.Modbus.configuration.counter[i].icon = "tools_yellow.gif";
			}
			else
			{
				// Icon gruen fuer konfigurierten Zaehler mit channel
				treeObj.Modbus.configuration.counter[i].icon = "tools_green.gif";
			}		
			break;
		}	
	}

	// neuen Zaehler einfuegen in data, wenn er noch nicht existiert
	var match = 0;	
	for (var i=0; i<treeObj.Modbus.data.counter.length; i++)
	{
		if (treeObj.Modbus.data.counter[i].info == modbus_id)
		{		
			match = 1;	
			break;
		}
	}
	if (match == 0)
	{
		var length = treeObj.Modbus.data.counter.length;
		treeObj.Modbus.data.counter[length] = new Object();
		treeObj.Modbus.data.counter[length].icon = "outbox.gif"; 
		treeObj.Modbus.data.counter[length].text = modbus_id;
		treeObj.Modbus.data.counter[length].info = modbus_id;
		treeObj.Modbus.data.counter[length].target = "modbus_data.htm";
	}

	// data aktualisieren
	for (var i=0; i<treeObj.Modbus.data.counter.length; i++)
	{
		if (treeObj.Modbus.data.counter[i].info == modbus_id)
		{		
			// Name aktualisieren
			treeObj.Modbus.data.counter[i].text = nameArr[0];
			// alert ("gefunden: " + nameArr[0]);

			// hat ein Zaehler keine channel, dann Eintrag bei data entfernen
			if (channelArr.length < 1)
				treeObj.Modbus.data.counter.splice(i, 1);				
		}
	}



	// bei data evtl. vorhandenen "no entry" entfernen, falls Zaehler gefunden wurden
	var length = treeObj.Modbus.data.counter.length;
	if (length > 1)
	{	
		if (treeObj.Modbus.data.counter[0].text == "no entry")
		{
			// Eintrag "no entry" entfernen					
			treeObj.Modbus.data.counter.splice(0, 1);				
		}
	}
	else if (length == 0)
	{
		// Eintrag "no entry" einfuegen
		var length = treeObj.MBus.data.counter.length;
		treeObj.Modbus.data.counter[length] = new Object();
		treeObj.Modbus.data.counter[length].icon = "page.gif"; 
		treeObj.Modbus.data.counter[length].text = "no entry";
		treeObj.Modbus.data.counter[length].info = "no entry";
		treeObj.Modbus.data.counter[length].target = "";
	}

	// Eintraege alphabetisch sortieren
	treeObj.Modbus.configuration.counter = sortEntries (treeObj.Modbus.configuration.counter, "text");
	treeObj.Modbus.data.counter = sortEntries (treeObj.Modbus.data.counter, "text");
	//var oStr = JSON2.stringify (treeObj.MBus.data.counter, null, 4);	// Object -> String
	//alert (oStr);

	return treeObj;
}

// ********************************************************************************************
// Array mit jeweils mehreren Objekten pro Eintrag nach einem Objekt sortieren;
// der Sortierungswert darf nur jeweils einmal vorkommen oder muss 0 sein (diese Eintrage werden nur angehaengt)
function sortEntries (arr, key)
{
	// Um die Eintraege sortiert abzuspeichern, werden die keys in ein Array gepackt und
	// dort sortiert
	var newArr = new Array();
	for (var i=0; i<arr.length; i++)
	{
		// nur Eintraege sortieren, die konfiguriert sind (Icon != rot)
		if (arr[i].icon != "tools_red.gif")
			newArr[newArr.length] = arr[i][key];
	}

	// key alphabetisch sortieren (aufsteigend)
	newArr.sort();

	// entsprechend der Sortierung Eintraege zuweisen
	for (var i=0; i<arr.length; i++)
	{
		for (var j=0; j<arr.length; j++)
		{	
			if (newArr[i] == arr[j][key])
			{
				newArr[i] = arr[j];
				break;
			}
		}
	}	

	// nichtkonfigurierte Eintraege anfuegen (Icon == rot)
	for (var i=0; i<arr.length; i++)
	{
		if (arr[i].icon == "tools_red.gif")
			newArr[newArr.length] = arr[i];
	}

	// sortiertes Array zurueckliefern
	return newArr;
}

// ********************************************************************************************
// Anzeige Fortschritt bei Parameterspeicherung
function messageChannel ()
{
	top.hideMessageBox();
	top.messageBox_Wait_ext ((msgChannel+1)+ins("mbus_config_message_counter_channel"));

	if (msgChannel == (channelArr.length))
	{
		// Messagebox schliessen
		top.hideMessageBox();
		top.messageBox_Wait_ext ("");

		// Anzeige beenden
		clearTimeout (interval_timeout);
	}

	msgChannel += 1;
}	

// ********************************************************************************************
// Button freigeben
function disableButton (state)
{
	// Button sperren/freigeben
	top.document.getElementById("button_1").disabled = state;
	top.document.getElementById("button_2").disabled = state;
}

// ********************************************************************************************
// ********************************************************************************************






// ********************************************************************************************
// INFO
// ********************************************************************************************

// INFO
// counter

function info_ZNummer()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_counternr_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_counternr")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_Mandant()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_client_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_client")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_AbnNr()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_customernr_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_customernr")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_MeteringCode()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_meteringcode_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_meteringcode")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

// ********************************************************************************************

// INFO
// channel

function info_interval()
{
	var headline =  '<B>INFO: '+ins("modbus_config_info_interval_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("modbus_config_info_interval")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 320, "window");
}

function info_EAblesung()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_readout_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_readout")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_Faktor()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_factor_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_factor")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 230, "window");
}

function info_Primaer()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_primaer_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_primaer")+
 					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_Obis()
{
	var headline =  '<B>INFO: '+ins("mbus_config_info_obis_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_obis")+
 					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_description()
{
	var headline =  '<B>INFO: '+ins("modbus_config_info_description_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("modbus_config_info_description")+
 					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

function info_MEinheit()
{
	var headline =  '<B>INFO: '+ins("modbus_config_info_unit_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("modbus_config_info_unit")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 200, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



