/**********************************************************************************************
	JS functions for modbus_data

	Copyright (c) 2014 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		02.2014

***********************************************************************************************/


/*
	Anmerkungen:
	Das Laden der Konfiguration ist zweigeteilt:
	1. Mit dem Aufruf der Seite wird das Konfigurationsfile geladen
	2. Durch Betaetigen "BROWSER <- EWIO" werden die Daten vom Modbus geladen

*/

// ********************************************************************************************

var DEBUG_MBDATA = 0;

var module;							// Modul mit ID fuer RX/TX

//var tele_id;						// ID zur Zuordnung Modbus Anfrage / Antwort
var counterObj;						// lokales Objekt (Zaehler-Konfiguration)
var response_counter = 0;			// Empfangszaehler
var dataSource = "current";			// Datenquelle (aktuell oder gespeichert)

var channelArr;						// Array mit allen channel-Objekten
var channel_cnt;					// aktueller channel

var channelId = 0;					// aktuelle Channel-ID fuer DB
var date = -1;						// aktuelles Datum fuer DB
var paramValid = 0;					// Parameter fuer DB gueltig

var teleMax = 0;
var teleArr = [];					// Array mit gueltigen Telegramm-Nummern
var teleIndex;

var json_instance;


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Namen im Header anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Messagebox
	top.messageBox_Wait ();

	// Tabelle Modbus anzeigen
	document.getElementById("tab_mbus").style.visibility = "visible";
	document.getElementById("tab_db").style.visibility = "hidden";

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	document.form_save.save.disabled = true;

	// Konfiguration einlesen
	var moduleId = top.tree_getPageName()[1];
	top.getDataExtended (moduleId, "modbus_counter", "top.frame_content.modbus_getCounter_answer(actStr)");
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{
	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	document.form_save.save.disabled = true;

	if (dataSource == "current")
	{
		// Daten vom Modbus abfragen
		modbus_getData();
	}
	else
	{
		// gespeicherte Daten abfragen
		db_getData();
	}
}

// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."	
	top.messageBox (ins("mbus_data_button_head"), ins("mbus_data_button_content")); 	
}

// ********************************************************************************************
// ********************************************************************************************
// Auswahl Datenquelle (aktuell / gespeichert)
function setDataSource (source)
{
	// Datenquelle global speichern
	dataSource = source;

	if (source == "current")
	{
		// zusaetzliche Angaben loeschen 
		document.form_stored.style.display = "none";
		
		// Tabellen umschalten
		document.getElementById("tab_mbus").style.visibility = "visible";
		document.getElementById("tab_db").style.visibility = "hidden";

		// Button SAVE
		document.form_save.style.display = "block";
	}

	if (source == "stored")
	{
		// Parameter einblenden
		document.form_stored.style.display = "block";

		// Tabellen umschalten
		document.getElementById("tab_db").style.visibility = "visible";
		document.getElementById("tab_mbus").style.visibility = "hidden";

		// Button SAVE
		document.form_save.style.display = "none";
	}
}

// ********************************************************************************************
// Aufruf der Datenbank-Parametrierung
function setParameter()
{
	// kein Calendar-Module, weil dieses nur aus HTML heraus aufrufbar

	var headline =  '<B>PARAMETER</B>';
	var content =	'<form name="form_param"> '+ 		
					'<div class="pos x0101 textfield"> '+ins("mbus_data_point")+' </div>'+
					'<div class="pos x0103">'+
					'<select name="selectDataPoint" size=1 class="combobox long_200"></select><br>'+
					'</div>'+

					'<div class="pos x0201 textfield"> '+
					'<input type="radio" name="r0" value="0" onclick="showDate(0)"> '+ins("mbus_data_first")+' <br> '+
					'<input type="radio" name="r0" value="-1" checked="checked" onclick="showDate(0)"> '+ins("mbus_data_last")+' <br> '+
					'<input type="radio" name="r0" value="1" onclick="showDate(1)"> '+ins("mbus_data_from")+' '+
					'</div>'+

					'<div class="pos x0403 textfield"> '+
					'<input type="text" class="textfield" value="" name="year" size="4" maxlength="4" style="text-align:center;">-'+
					'<input type="text" class="textfield" value="" name="month" size="2" maxlength="2" style="text-align:center;">-'+
					'<input type="text" class="textfield" value="" name="day" size="2" maxlength="2" style="text-align:center;"> '+
					'<input type="text" class="textfield" value="" name="hours" size="2" maxlength="2" style="text-align:center;">:'+
					'<input type="text" class="textfield" value="" name="minutes" size="2" maxlength="2" style="text-align:center;"> <br> '+
					''+ins("mbus_data_format")+
					'</div>'+

					'<div class="pos x0601 comment"> '+ins("mbus_data_maxvalue")+
					'</div>'+

					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetParam(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetParam(0)">'+
					'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'IO', 450, 230, "window");

	// Controls fuellen
	for (var i=0; i<channelArr.length; i++)
	{
		var str = "Tele "+channelArr[i].Tele+", Rec "+channelArr[i].Rec+": "+channelArr[i].ZwTyp;
		addSelectOption (document.form_param.selectDataPoint, channelArr[i].ID, str);
	}
	
	// Voreinstellungen
	for (var i=0;  i<document.form_param.selectDataPoint.length; i++)
	{
		if (document.form_param.selectDataPoint[i].value == channelId)
			document.form_param.selectDataPoint.selectedIndex = i;
	}

	// alert (date);
	
	if (date == 0)
		document.form_param.r0[0].checked = true;
	else if (date == -1)
		document.form_param.r0[1].checked = true;
	else
	{
		document.form_param.r0[2].checked = true;

		var timestampArr = date.split("|");
		if (timestampArr.length == 2)
		{
			var dateArr = timestampArr[0].split("-");
			if (dateArr.length == 3)
			{
				document.form_param.year.value = dateArr[0];;	
				document.form_param.month.value = dateArr[1];	
				document.form_param.day.value = dateArr[2];	
			}
			var timeArr = timestampArr[1].split(":");
			if (timeArr.length == 3)
			{		
				document.form_param.hours.value = timeArr[0];	
				document.form_param.minutes.value = timeArr[1];	
			}		
		}	
	}

}

// ********************************************************************************************
// Einstellung Datenbank-Parameter auswerten
function fSetParam (valid)
{
	if (valid)
	{
		// Parameter sind gueltig, Variablen global speichern
		// Kanal_ID
		var i = document.form_param.selectDataPoint.selectedIndex;
		channelId = document.form_param.selectDataPoint[i].value;
		var channelText = document.form_param.selectDataPoint[i].text;

		// Zeitpunkt
		for (var i=0; i<document.form_param.r0.length; i++)
		{
			if (document.form_param.r0[i].checked == true)		
				date = parseInt (document.form_param.r0[i].value);
		}
		if (date == 1)
		{
			// Auswerten Zeitfeld		
			var year = document.form_param.year.value;	
			var month = document.form_param.month.value;	
			var day = document.form_param.day.value;	
			var hours = document.form_param.hours.value;	
			var minutes = document.form_param.minutes.value;	

			date = 	year+'-'+month+'-'+day+'|'+hours+':'+minutes+':00';
			var err = checkTimeInput(date);	
			if (err != 0)			
			{	
				// "Hinweis", "Zeiteingabe fehlerhaft: "
				top.messageBox (ins("mbus_data_note_head"), ins("mbus_data_time_error") + err);	
				return;			
			}
		}
	
		// Ueberschrift Tabelle
		// alert ("ID = "+channelId+" date = "+date);
		document.getElementById("channel_param").innerHTML = channelText+"<br>";
		if (date == 0)
			document.getElementById("channel_param").innerHTML += ins("mbus_data_first"); 	// Erste Daten
		else if (date == -1)
			document.getElementById("channel_param").innerHTML += ins("mbus_data_last"); 	// Letzte Daten
		else
		{
			document.getElementById("channel_param").innerHTML += ins("mbus_data_from")+date.split("|"); 	// Daten ab
		}

		paramValid = 1;		// Parameter gueltig	
	}
	
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************







// ********************************************************************************************
// Konfiguration
// ********************************************************************************************
// Antwort auf mbus_getCounter
function modbus_getCounter_answer(actStr)
{
	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		top.hideMessageBox();
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	// JSON-String in Objekt wandeln
	counterObj = JSON2.parse(actStr);

	// Ablauf fortsetzen: Channel einlesen
	var moduleId = top.tree_getPageName()[1];
	top.getDataExtended (moduleId, "modbus_channels", "top.frame_content.modbus_getChannel_answer(actStr)");
}

// ********************************************************************************************
// Antwort: Alle channel einlesen
function modbus_getChannel_answer(actStr)
{
	if (DEBUG_MBDATA)
		alert (actStr);

	// Objekt im channelArr speichern
	var actObj = JSON2.parse(actStr);
	channelArr = actObj.channel;

	// Ablauf fortsetzen: Template einlesen
	var template = "modbus_" + counterObj.busdetails.Text_3;
	top.getDataExtended (template, "configuration", "top.frame_content.modbus_getInstance(actStr)");
}

// ********************************************************************************************
// Laden Instanz	
function modbus_getInstance(actStr)
{
	if (DEBUG_MBDATA)	
		alert ("modbus_getInstance: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	json_instance = JSON2.parse(actStr);

	// Messagebox schliessen
	top.hideMessageBox();

	// Liste fertig, Button freigeben
	top.document.getElementById("button_1").disabled = false;
}

// ********************************************************************************************













// ********************************************************************************************
// Kommunikation Modbus
// ********************************************************************************************
// Daten vom Modbus abrufen
function modbus_getData()
{
	// Messagebox
//	top.messageBox_Wait ();

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_body");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Daten abfragen
	// es werden nur die frames gesendet, die auch konfiguriert sind

	// Max. Anzahl an konfigurierten Telegrammen
	for (var i=0; i<channelArr.length; i++)
	{
		// teleMax auf den maximal vorkommenden frame setzen 
		if (channelArr[i].Tele > teleMax)
			teleMax = channelArr[i].Tele;		
	}
	teleMax++;
	// alert ("Anzahl Frames = " + teleMax);

	// so viele frames abfragen, wie konfiguriert sind
	for (var j=0; j<teleMax; j++)
	{
		// im tele-Array werden die Positionen auf 1 gesetzt, fuer die ein Eintrag vorhanden ist
		teleArr[j] = 0;		

		for (var i=0; i<channelArr.length; i++)
		{
			if (channelArr[i].Tele == j)
			{
				teleArr[j] = 1;
				break;
			}
		}
	}

	// alert ("teleArr = " + teleArr);

	// 1. gueltigen Frame abfragen
	for (var j=0; j<teleMax; j++)
	{
		if (teleArr[j] == 1)
		{		
			modbus_request (j);
			break;	
		}
	}
}

// ********************************************************************************************
// Frame an EWIO senden
function modbus_request (tele)
{

	// alert ("tele = " + tele);
	teleIndex = tele;

	// Messagebox
	top.hideMessageBox();
	top.messageBox_Wait_ext ("FRAME " + teleIndex);
	
	// Modul
	var frame_id = top.calculateRandom (1, 10000);
	module = "modbus_" + frame_id.toString();	

	// Adresse
	var adr = parseInt(counterObj.BusAdr).toString(16);
	adr = adr.toUpperCase();
	adr = addLeadingZeros (adr, 2);

	// Funktion
	var func = json_instance.device.TX[tele].function.toString(16);
	func = func.toUpperCase();
	func = addLeadingZeros (func, 2);

	// Startregister (2 Byte)
	var startReg = json_instance.device.TX[tele].start.toString(16);
	startReg = startReg.toUpperCase();
	startReg = addLeadingZeros (startReg, 4);
	var startReg_0 = startReg.substring(0,2);
	var startReg_1 = startReg.substring(2);

	// Laenge der Daten (2 Byte)
	var length = json_instance.device.TX[tele].length.toString(16);
	length = length.toUpperCase();
	length = addLeadingZeros (length, 4);
	var length_0 = length.substring(0,2);
	var length_1 = length.substring(2);

	// SendeString zusammenstellen
	var sendStr = "00 01 00 00 00 06 " + adr + " " + func + " " + startReg_0 + " " + startReg_1 + " " + length_0 + " " + length_1;  


	// Addressierung Base 1 in TX-frames
	if (json_instance.device.AddressBase == 1)
	{													// Byte 8 und 9 (Register) um 1 verringern
		var txArr = sendStr.split(" ");
		var valueStr = txArr[8] + txArr[9] + "";
		var value = parseInt(valueStr, 16);
		value -= 1;
		valueStr = value.toString(16);
		valueStr = valueStr.toUpperCase();
		valueStr = addLeadingZeros (valueStr, 4);
		txArr[8] = valueStr.substring(0,2);
		txArr[9] = valueStr.substring(2);
		sendStr = "";		
		for (var i=0; i<txArr.length; i++)
			sendStr += txArr[i] + " ";
	}		

	// alert (sendStr);

	// Daten an modbus senden
	top.setDataExtended (module, 'modbus', sendStr);

	// Ergebnis 
	setTimeout ("top.getDataExtended (module, 'modbus', 'top.frame_content.modbus_response(actStr)')", 1000);

}

// ********************************************************************************************
// Antwort vom EWIO holen
function modbus_response(actStr)
{
	// alert (actStr);	

	// eine Zeitlang Telegramm pollen
	var timeout = 5; 	

	// Fehlermeldungen vom webGate
	if (actStr.indexOf('{') == -1)
	{
		// Message filtern		
		actStr = top.getMessage (actStr);

		// keine Antwort vom modbus_gateway
		var wait_time = timeout-response_counter;
		if (response_counter < timeout)		
		{	
			top.hideMessageBox();
			top.messageBox_Wait_ext (ins("mbus_config_message_wait_EWIO") + "<B>" + wait_time.toString() + "</B> sec.");
			setTimeout ("top.getDataExtended (module, 'modbus', 'top.frame_content.modbus_response(actStr)')", 1000);
			modbus_response_counter++;			// 1 Sekunde vergangen
			return;			
		}

		// ModBus-Zaehler hat nicht geantwortet 
		top.hideMessageBox();
		top.messageBox (ins("mbus_data_error_head"), actStr);

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		document.form_save.save.disabled = false;
		return;
	}

	// JSON-String in Objekt wandeln
	try
	{
		actObject = JSON.parse(actStr);
	}
	catch(err)
	{
		var txt = "Error on navigation data occured.\n";
		txt += "Error description: " + err.message + "\n";
		alert (txt);

		//document.write(actStr);	
		return;	
	}

	// alert (actObject.frame + "\n" + actObject.state);

	if (actObject.state != "MODBUS ANSWER - OK")
	{
		// Ausgabe Fehler-Status vom modbus-gateway
		top.hideMessageBox();
		top.messageBox ("RESULT", actObject.state);		

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		document.form_save.save.disabled = false;
		return;
	}

	// Frameinhalt in ByteArray
	var tele_rx_arr = actObject.frame.split(" ");

	// Startadr aus JSON-TX-File entnehmen	
	var start = json_instance.device.TX[teleIndex].start;
	start = parseInt(start);

	// Funktion, Laenge aus JSON-RX-File
	var func = parseInt (tele_rx_arr[7], 16);
	var len = parseInt (tele_rx_arr[8], 16);

	if ((func != 1) && (func != 2))			
		var len = len / 2;	// wenn nicht Func = 01 oder 02, dann 2 Byte = 1 Element

	// alle channel, die einen rec im aktuellen frame haben, ermitteln
	for (var i=0; i<channelArr.length; i++)
	{
		// alert ("func="+func+"\nstart="+start+"\nlen="+len+"\nrec="+channelArr[i].Rec+"\nframe="+actObject.frame);

		// Register aus channelArr im empfangenen frame?
		if ((channelArr[i].Rec >= start) && (channelArr[i].Rec < (start + len)))
		{
			// Wert aus aktuellem frame entnehmen
			if ((func == 1) || (func == 2))			
				var index = 9 + (channelArr[i].Rec - start);			// discrete inputs 8 bit
			else
				var index = 9 + ((channelArr[i].Rec - start) * 2);		// register 16 bit
			// alert ("index " + index);

			// MesswertTyp aus json-instanz ermitteln
			var valType = "";
		
			for (var j=0; j<json_instance.device.RX.length; j++)
			{
				if (json_instance.device.RX[j].register == channelArr[i].Rec) 		
				{
					valType = json_instance.device.RX[j].format;
					// alert ("type = " + valType);				
				}
			}

			// Berechnung des value
			var value = getValueFromModbus (actObject.frame, index, valType);	

			// Faktoren U/I beruecksichtigen
			var faktor_u = channelArr[i].Faktor_U;
			var faktor_i = channelArr[i].Faktor_I;
			value = value * faktor_u * faktor_i;

			// max. 3 Dezimalstellen
			value = value.toFixed(3);	

			// Tabelle fuellen
			fillTable (channelArr[i].Tele, channelArr[i].Rec, channelArr[i].ZwTyp, value, channelArr[i].Einheit_edit);
		}
	}

	// naechsten gueltigen Frame abfragen
	for (var j=teleIndex+1; j<teleMax; j++)
	{
		if (teleArr[j] == 1)
		{		
			modbus_request (j);
			break;	
		}
	}

	// Tabelle beendet
	if (j == teleMax)
	{
		top.hideMessageBox();

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		document.form_save.save.disabled = false;
	}
}

// ********************************************************************************************
// Berechnung des value
function getValueFromModbus (tele_rx_str, index, type)
{	

	var tele_rx_arr = tele_rx_str.split(" ");
	var valueStr = "";
	var value = 0;

//	 alert ("tele_rx = " + tele_rx_arr.toString());	
// 	 alert ("index/type " + index + " /  " + type);
/*
	var temp = "";			
	for (var i=index; i<index+4; i++)	
	{
		if (i < tele_rx_arr.length)
			var temp = temp + tele_rx_arr[i] + " ";			 
	}	
	alert (temp);	
*/


	if (type.indexOf("HEX8") != -1)
	{
		valueStr += tele_rx_arr[index];
		value = valueStr;
	}

	if (type.indexOf("HEX16") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 1] + tele_rx_arr[index];
		value = valueStr;
	}

	if (type.indexOf("HEX32") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 3] + tele_rx_arr[index + 2] + tele_rx_arr[index + 1] + tele_rx_arr[index];
		value = valueStr;
	}

	if (type.indexOf("HEX48") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3] +
						tele_rx_arr[index + 4] + tele_rx_arr[index + 5];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 5] + tele_rx_arr[index + 4] + tele_rx_arr[index + 3] + tele_rx_arr[index + 2] +
						tele_rx_arr[index + 1] + tele_rx_arr[index];
		value = valueStr;
	}

	if (type.indexOf("HEX64") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3] +
						tele_rx_arr[index + 4] + tele_rx_arr[index + 5] + tele_rx_arr[index + 6] + tele_rx_arr[index + 7];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 7] + tele_rx_arr[index + 6] + tele_rx_arr[index + 5] + tele_rx_arr[index + 4] + 
						tele_rx_arr[index + 3] + tele_rx_arr[index + 2] + tele_rx_arr[index + 1] + tele_rx_arr[index];
		value = valueStr;
	}

	if (type.indexOf("INT8") != -1)
	{
		valueStr += tele_rx_arr[index];
		value = parseIntWithSign(valueStr, 16);
	}

	if (type.indexOf("INT16") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 1] + tele_rx_arr[index];
	
		value = parseIntWithSign(valueStr, 16);
	}

	if (type.indexOf("INT32") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 3] + tele_rx_arr[index + 2] + tele_rx_arr[index + 1] + tele_rx_arr[index];
		if (type.indexOf(" B") != -1)
		{
			var typeArr = type.split(" B");
			valueStr += getValueByByteOrder (tele_rx_arr, index, typeArr[1]);
		}
		value = parseIntWithSign(valueStr, 16);
	}

	if (type.indexOf("INT48") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3] +
						tele_rx_arr[index + 4] + tele_rx_arr[index + 5];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 5] + tele_rx_arr[index + 4] + tele_rx_arr[index + 3] + tele_rx_arr[index + 2] + 
						tele_rx_arr[index + 1] + tele_rx_arr[index];
		if (type.indexOf(" B") != -1)
		{
			var typeArr = type.split(" B");
			valueStr += getValueByByteOrder (tele_rx_arr, index, typeArr[1]);
		}
		value = parseIntWithSign(valueStr, 16);
	}

	if (type.indexOf("INT64") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3] +
						tele_rx_arr[index + 4] + tele_rx_arr[index + 5] + tele_rx_arr[index + 6] + tele_rx_arr[index + 7];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 7] + tele_rx_arr[index + 6] + tele_rx_arr[index + 5] + tele_rx_arr[index + 4] + 
						tele_rx_arr[index + 3] + tele_rx_arr[index + 2] + tele_rx_arr[index + 1] + tele_rx_arr[index];
		if (type.indexOf(" B") != -1)
		{
			var typeArr = type.split(" B");
			valueStr += getValueByByteOrder (tele_rx_arr, index, typeArr[1]);
		}
/*
		var temp = "";			
		for (var i=index; i<index+8; i++)	
		{
			if (i < tele_rx_arr.length)
				var temp = temp + tele_rx_arr[i] + " ";			 
		}	
		alert (temp);	
*/
		value = parseIntWithSign(valueStr, 16);
	}

	if (type.indexOf("FLOAT32") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 3] + tele_rx_arr[index + 2] + tele_rx_arr[index + 1] + tele_rx_arr[index];
	
		value = convertHexToFloat32(valueStr, 3);
	}

	if (type.indexOf("FLOAT64") != -1)
	{
		if (type.indexOf("HL") != -1)	
			valueStr += tele_rx_arr[index] + tele_rx_arr[index + 1] + tele_rx_arr[index + 2] + tele_rx_arr[index + 3] +
						tele_rx_arr[index + 4] + tele_rx_arr[index + 5] + tele_rx_arr[index + 6] + tele_rx_arr[index + 7];
		if (type.indexOf("LH") != -1)	
			valueStr += tele_rx_arr[index + 7] + tele_rx_arr[index + 6] + tele_rx_arr[index + 5] + tele_rx_arr[index + 4] +
						tele_rx_arr[index + 3] + tele_rx_arr[index + 2] + tele_rx_arr[index + 1] + tele_rx_arr[index];
	
		value = convertHexToFloat64(valueStr, 3);
	}

	if (type.indexOf("MOD10") != -1)
	{
		if (type.indexOf("64") != -1)	
		{
			valueStr += tele_rx_arr[index + 6] + tele_rx_arr[index + 7];
			var val3 = parseInt(valueStr, 16) * 10000 * 10000 * 10000;
		}
		else // 48
		{	
			var val3 = 0;
		}
		
		valueStr = tele_rx_arr[index + 4] + tele_rx_arr[index + 5];
		var val2 = parseInt(valueStr, 16) * 10000 * 10000;

		valueStr = tele_rx_arr[index + 2] + tele_rx_arr[index + 3];
		var val1 = parseInt(valueStr, 16) * 10000;

		valueStr = tele_rx_arr[index] + tele_rx_arr[index + 1];
		var val0 = parseInt(valueStr, 16);
	
		// Einzelwerte addieren
		//alert (val3 + "  " + val2 + "  " + val1 + "  " + val0);
		value = val0 + val1 + val2 + val3;

		if (type.indexOf("I") != -1)
		{ 
			// sign
			if (value > 0x7FFFFFFFFFFFFFFF)	value = value - 0x10000000000000000;
		}
	}

	//alert ("value " + valueStr + " /  " + value);
	return value;
}

// ********************************************************************************************
// Formataufloesung mit beliebiger Bytefolge
function getValueByByteOrder (tele_rx_arr, index, byteOrder)
{
	var order = byteOrder.split("");	// String -> Array (0123 -> 0|1|2|3)
	var value = "";
	for (var i=0; i<order.length; i++)
	{	
		var x = parseInt(index) + parseInt(order[i]);
		value += tele_rx_arr[x];
	}
	return value;
}

// ********************************************************************************************
// Erweiterung parseInt um die vrozeichenbehaftete Darstellung (=INT)
function parseIntWithSign (string, radix)
{
	// string -> int
	var value = parseInt(string, radix);
	// sign
	if ((string.length == 2) && (value > 0x7F))			value = value - 0x100;
	if ((string.length == 4) && (value > 0x7FFF))		value = value - 0x10000;
	if ((string.length == 8) && (value > 0x7FFFFFFF))	value = value - 0x100000000;
	if ((string.length == 12) && (value > 0x7FFFFFFFFFFF))	value = value - 0x1000000000000;
	if ((string.length == 16) && (value > 0x7FFFFFFFFFFFFFFF))	value = value - 0x10000000000000000;
	return value;
}

// ********************************************************************************************
// Tabellenreihen fuellen
function fillTable (frame, reg, desc, value, unit)
{
	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_mbus_body");

	// neue Zeile
	tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

	// jede 2. Reihe andersfarbig ("Zebratabelle")
	if (tbody.rows.length % 2 == 0)	
		tr.setAttribute ("class", "row_color_odd");
	else
		tr.setAttribute ("class", "row_color_even");

	// 1. Spalte frame
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = frame;				
	td.setAttribute ("class", "td_80");

	// 2. Spalte register
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = reg;
	td.setAttribute ("class", "td_80");

	// 3. Spalte Beschreiber
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = desc; 
	td.setAttribute ("class", "td_250");

	// 4. Spalte Wert
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = value; 
	td.setAttribute ("class", "td_80");

	// 5. Spalte Unit
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = unit; 
	td.setAttribute ("class", "td_80");
}

// ********************************************************************************************
// Kommunikation Datenbank
// ********************************************************************************************
// Daten von der Datenbank holen
function db_getData()
{
	// gueltige Parameter?
	if (!paramValid)
	{
		// "Hinweis", "Bitte waehlen Sie zuerst die Parameter aus."
		top.messageBox (ins("mbus_data_note_head"), ins("mbus_data_parameter"));	
		top.document.getElementById("button_1").disabled = false;
		return;
	}

	// evtl. bereits vorhandene Zeilen in der Tabelle loeschen
	var tbody = document.getElementById("tab_db_body");
	while (tbody.rows.length > 0)
		tbody.deleteRow(0);

	// Anforderung absenden	
	top.getDataExtended (channelId+'_'+date, 'db_data', 'top.frame_content.db_response(actStr)');

	// Messagebox
	top.messageBox_Wait ();

}

// ********************************************************************************************
// Antwort von Datenbank
function db_response(actStr)
{
	var len;

	// alert (actStr);

	// Messagebox schliessen
	top.hideMessageBox();

	if (actStr.indexOf("{") == -1)
		return;	

	// JSON-String in Objekt wandeln
	var actObject = JSON2.parse(actStr);

	// Daten vorhanden?
	var valid = 0;
	if ((actObject.data.channelData.length > 0) && (actObject.data.channelData[0].Kanal_ID != undefined))
		valid = 1;
	if ((actObject.back.channelData.length > 0) && (actObject.back.channelData[0].Kanal_ID != undefined))
		valid = 1;
	if (!valid)
	{
		// "Hinweis", "Es wurden keine Daten gefunden."	
		top.messageBox (ins("mbus_data_note_head"), ins("mbus_data_no"));

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		return;	
	}

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_db_body");

	// back
	for (var i=0; i<actObject.back.channelData.length; i++)
	{
		// neue Zeile
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte lfd Nr.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = i+1;
		td.setAttribute ("class", "td_30");

		// 2. Spalte Kanal_ID.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.back.channelData[i].Kanal_ID;
		td.setAttribute ("class", "td_100");

		// 3. Spalte Zeit	setTableElement ("tab_mbus_id", cnt, 5, jObject.primAdr);

		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.back.channelData[i].Zeit;
		td.setAttribute ("class", "td_180");

		// 4. Spalte Wert
		td = tr.insertCell(tr.cells.length);
		if (checkForDecimalPlaces (actObject.back.channelData[i].Werte))
			td.innerHTML = actObject.back.channelData[i].Werte.toFixed(3);
		else		
			td.innerHTML = actObject.back.channelData[i].Werte;
		td.setAttribute ("class", "td_100");

		// 5. Spalte Flags
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.back.channelData[i].Flags;
		td.setAttribute ("class", "td_100");

		// 6. Spalte DB
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = "back";
		td.setAttribute ("class", "td_60");

		if (date == -1)
		{		
			// scrolle zur letzten eingefuegten Reihe
			var tElement   = tbody.getElementsByTagName("tbody")[0]; 
			var scroll_area = document.getElementById('scroll_1');
			scroll_area.scrollTop = tElement.clientHeight;
		}
	}
	len = i;

	// data
	for (var i=0; i<actObject.data.channelData.length; i++)
	{
		// neue Zeile
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte lfd Nr.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = len+i+1;
		td.setAttribute ("class", "td_30");

		// 2. Spalte Kanal_ID.
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.data.channelData[i].Kanal_ID;
		td.setAttribute ("class", "td_100");

		// 3. Spalte Zeit
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.data.channelData[i].Zeit;
		td.setAttribute ("class", "td_180");

		// 4. Spalte Wert
		td = tr.insertCell(tr.cells.length);
		if (checkForDecimalPlaces (actObject.data.channelData[i].Werte))
			td.innerHTML = actObject.data.channelData[i].Werte.toFixed(3);
		else		
			td.innerHTML = actObject.data.channelData[i].Werte;
		td.setAttribute ("class", "td_100");

		// 5. Spalte Flags
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = actObject.data.channelData[i].Flags;
		td.setAttribute ("class", "td_100");

		// 6. Spalte DB
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = "data";
		td.setAttribute ("class", "td_60");

		if (date == -1)
		{		
			// scrolle zur letzten eingefuegten Reihe
			var tElement   = tbody.getElementsByTagName("tbody")[0]; 
			var scroll_area = document.getElementById('scroll_2');
			scroll_area.scrollTop = tElement.clientHeight;
		}
	}

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;

}

// ********************************************************************************************
// In DB Speichern
// ********************************************************************************************
// Messwerte in DB speichern, Format:
// {"channelData":[{"Kanal_ID":2,"Zeit":"2012-08-07 12:20:00","Werte":116.000000,"Flags":"S;A;P;G;H;I;T"}, ... ]}
function saveValueInDB()
{
	var dbObject = new Object();
	dbObject.channelData = new Array();

	var tbody = document.getElementById("tab_mbus_body");
	for (var i=0; i<tbody.rows.length; i++)
	{
		var mbus_tele = getTableElement ("tab_mbus_body", i, 0);
		var mbus_rec = getTableElement ("tab_mbus_body", i, 1);

		var match = 0;
		var z = 0;	
		for (z=0; z<channelArr.length; z++)
		{
			var db_tele = channelArr[z].Tele;
			var db_rec = channelArr[z].Rec ;

			if ((mbus_tele == db_tele) && (mbus_rec == db_rec))		
			{
				match = 1;
				break;			
			}
		}
		
		if (match)
		{
			//alert (z + "   " + channelArr[z].ID + "   " + db_tele + "   " + db_rec);

			// Object zusammenbauen
			var index = dbObject.channelData.length;
			dbObject.channelData[index] = new Object();

			dbObject.channelData[index].ID = 0;													// ID (Autoincrement)
			dbObject.channelData[index].Kanal_ID = channelArr[z].ID;							// Kanal-ID
			var datum = new Date();			
			var timestamp = getTimeInSQLFormat(datum);
			dbObject.channelData[index].Zeit = timestamp;										// Zeitstempel
			dbObject.channelData[index].Werte = getTableElement ("tab_mbus_body", i, 3);		// Messwert
			dbObject.channelData[index].Flags_ID = setFlags();									// Flags

		}
	}

	var actStr = JSON2.stringify (dbObject, null, 0);	// Object -> String
	// alert (actStr);

	// Anforderung absenden	
	top.setDataExtended ("mbus", "db_send", actStr);		// Modul, Typ, Daten
}

// ********************************************************************************************
// ********************************************************************************************








// ********************************************************************************************
// Hilfs-Funktionen
// ********************************************************************************************
// fuehrende Nullen auffuellen
function addLeadingZeros (number, length)
{
	var num = '' + number;
	while (num.length < length)
		num = '0' + num;
	return num;
}

// ********************************************************************************************
// fuehrende Nullen entfernen
function killLeadingZeros (number)
{
	number = Number(number);
	var num = '' + number;
	return num;
}


// ********************************************************************************************
// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************
// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************
// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Zeiteingabe ueberpruefen
function checkTimeInput(date)
{
	var err = 0;
	var ret = 0;

	var timestampArr = date.split("|");
	if (timestampArr.length == 2)
	{
		// Laengen
		var dateArr = timestampArr[0].split("-");
		if (dateArr.length == 3)
		{
			if (dateArr[0].length != 4)		err = ins("mbus_data_digits_year"); 	// "Anzahl Ziffern / Jahr";	
			if (dateArr[1].length != 2)		err = ins("mbus_data_digits_month");	// "Anzahl Ziffern / Monat";
			if (dateArr[2].length != 2)		err = ins("mbus_data_digits_day");   	// "Anzahl Ziffern / Tag";
		}
		var timeArr = timestampArr[1].split(":");
		if (timeArr.length == 3)
		{		
			if (timeArr[0].length != 2)		err = ins("mbus_data_digits_hour");		// "Anzahl Ziffern / Stunde";
			if (timeArr[1].length != 2)		err = ins("mbus_data_digits_minute");	// "Anzahl Ziffern / Minute";
		}		

		// Inhalt
		ret = checkTimeComponents (dateArr[0], "year");		if (ret) err = ret;
		ret = checkTimeComponents (dateArr[1], "month");	if (ret) err = ret;
		ret = checkTimeComponents (dateArr[2], "day");		if (ret) err = ret;
		ret = checkTimeComponents (timeArr[0], "hours");	if (ret) err = ret;
		ret = checkTimeComponents (timeArr[1], "minutes");	if (ret) err = ret;
	}	

	return err;
}

// ********************************************************************************************
// Zeitkomponenten ueberpruefen
function checkTimeComponents (timeComp, check)
{
	var err = 0;
	switch (check)
	{
		case "year":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1900) || (timeComp-0 > 2100))
							err = "Jahr"; 
						break;
		case "month":	if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 12))
							err = "Monat"; 
						break;
		case "day":		if ((isFinite (timeComp) == false) || (timeComp-0 < 1) || (timeComp-0 > 31))
							err = "Tag"; 
						break;
		case "hours":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 24))
							err = "Stunde"; 
						break;
		case "minutes":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							err = "Minute"; 
						break;
		case "seconds":	if ((isFinite (timeComp) == false) || (timeComp-0 < 0) || (timeComp-0 > 60))
							err = "Sekunde"; 
						break;
	}
	return err;
}

// ********************************************************************************************
// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************
// aktuelle Datum ermitteln
function getDate ()
{
	var datum = new Date();
	var y = setLeadNull (datum.getFullYear()-0);		// Jahreszahl 4stellig
	var m = setLeadNull (datum.getMonth()+1);			// getMonth() von 0 ... 11
	var d = setLeadNull (datum.getDate()-0);			// Tag 1 ... 31
	var date_now = 	y+"-"+m+"-"+d+"|00:00:00";
	return date_now;
}

// ********************************************************************************************
// Datum sichtbar oder unsichtbar
function showDate (show)
{

	if (show)
	{
		// Datum sichtbar
		if (date <= 0)
		{
			// Datum nicht vorhanden, vom PC einlesen	
			var datum = new Date();
			document.form_param.year.value = setLeadNull (datum.getFullYear()-0);	// Jahreszahl 4stellig
			document.form_param.month.value = setLeadNull (datum.getMonth()+1);		// getMonth() von 0 ... 11
			document.form_param.day.value = setLeadNull (datum.getDate()-0);		// Tag 1 ... 31

			document.form_param.hours.value = "00";		
			document.form_param.minutes.value = "00";	
		}
		else
		{
			// Datum vorhanden, aus date ermitteln
			var timestampArr = date.split("|");
			if (timestampArr.length == 2)
			{
				var dateArr = timestampArr[0].split("-");
				if (dateArr.length == 3)
				{
					document.form_param.year.value = dateArr[0];;	
					document.form_param.month.value = dateArr[1];	
					document.form_param.day.value = dateArr[2];	
				}
				var timeArr = timestampArr[1].split(":");
				if (timeArr.length == 3)
				{		
					document.form_param.hours.value = timeArr[0];	
					document.form_param.minutes.value = timeArr[1];	
				}		
			}	
		}
	}	
	else
	{
		// Datum unsichtbar
		document.form_param.year.value = "";
		document.form_param.month.value = "";
		document.form_param.day.value = "";
		document.form_param.hours.value = "";
		document.form_param.minutes.value = "";
	}
}

// ********************************************************************************************
// Check Antwort auf Login-Error
function checkLoginError (actString)
{
	if (actString.indexOf("LOGIN ERROR") != -1)	
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		top.hideMessageBox();		
		top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		return 1;	
	}
	
	return 0;
}

// ********************************************************************************************
// PC- Datum ausgeben
function getTimeInSQLFormat (datum)
{
	var time = new Object();
	
	time.year = setLeadNull (datum.getFullYear()-0);		// Jahreszahl 4-stellig
	time.month = setLeadNull (datum.getMonth()+1-0);		// getMonth() von 0 ... 11
	time.date = setLeadNull (datum.getDate()-0);
	time.hours = setLeadNull (datum.getHours()-0);
	time.minutes = setLeadNull (datum.getMinutes()-0);
	time.seconds = setLeadNull (datum.getSeconds()-0);

	var output = time.year + "-" + time.month + "-" + time.date + " " + 
				 time.hours + ":" + time.minutes + ":" + time.seconds;
	return output;
}

// ********************************************************************************************
// Ermitteln, ob aktuell Sommerzeit ist
function isSummertime ()
{
	var summertime = 0;

	// Feststellung, ob aktuell Sommer-oder Winterzeit ist, erfolgt ueber einen Vergleich der
	// Offsets zu UTC;
	// dazu wird der Offset mit dem eines Monats verglichen, von dem bekannt ist, dass er 
	// Sommer-oder Winterzeit hat 

	// Offset zu UTC vom Januar
	var jan = new Date(2012, 0, 1, 2, 0, 0);	// Datum in Normalzeit
	var offs_winter = jan.getTimezoneOffset();	// Offset zu UTC bei Winterzeit

	// Vergleich des aktuellen Offsets zu UTC mit dem bekannten Offset
	var today = new Date();
	var offs_actual = today.getTimezoneOffset();

	if (offs_actual == offs_winter)		summertime = 0;
	else								summertime = 1;			

	return summertime;
}

// ********************************************************************************************
// Setzen Flags (Standard, nur S/W ermitteln)
// Flags werden auf Standardwerte gesetzt (ausser S/W): S/W A N G N I T
function setFlags ()
{
	// Sommerzeit:  Flags = SANGNIT		Flag-ID = 124
	// Winterzeit:  Flags = WANGNIT		Flag-ID = 60

	if (isSummertime())	flags = 124;
	else				flags = 60;

	return flags;
}

// ********************************************************************************************
// Pruefen, ob eine Zahl Nachkommastellen > 0 hat (1.000 -> 0, 1.123 -> 1)
function checkForDecimalPlaces (num)
{
	var str = num.toString();
	var strArr = str.split(".");
	var nc = parseInt(strArr[1]);
	if (isNaN(nc) || (nc == 0))
		return 0;
	return 1;	
}

// ********************************************************************************************
// maximal erforderliche Anzahl an Telegrammen ermitteln
function getTeleMax ()
{
	var teleMax = 0;
	

	for (var z=0; z<channelArr.length; z++)
	{
		var tele = channelArr[z].Tele - 1;
		if (tele > teleMax)
			teleMax = tele;	
	}

	return teleMax+1;
}

// ********************************************************************************************
// Eingabe hexstr als "46806E4A" (H->L), decimals = Anzahl Nachkommastellen
// Rueckgabe floatingPoint-Value
function convertHexToFloat32 (hexstr, decimals)
{
	var bin = [];
	var binSum = "";
	var sign, expo, mant;
	var floatVal = 0;
	var nul8="00000000";

	if (hexstr.length != 8)
		return 0;
	
	for (var i=0; i<4; i++)
	{
		bin[i] = hexstr.substr(2*i,2);		
		bin[i] = parseInt(bin[i], 16);		
		bin[i] = bin[i].toString(2);		
		bin[i] = nul8 + bin[i];				
		bin[i] = bin[i].substr(bin[i].length-8,8);
		binSum += bin[i];
	}

	sign=parseInt(binSum.charAt(0),2)? -1:1;   					
	expo=parseInt(binSum.substr(1,8),2) - 127;  				
	mant=parseInt(binSum.substr(9,23),2) + 0x800000; 			
	mant = mant.toString(2);

	if (parseInt(binSum.substr(1,8),2) == 0)				
	{
		if (parseInt(binSum.substr(9,23),2) != 0)		
			return 0;
	}
	if (parseInt(binSum.substr(1,8),2) == 255)				
		return 0;
		
    for (i=0; i<mant.length; i+=1)
	{
        floatVal += parseInt(mant[i])? Math.pow(2,expo):0;
        expo--;
    }
	
    floatVal = floatVal*sign;					
	floatVal = floatVal.toFixed(decimals);		
	return floatVal;
}	

// ********************************************************************************************
// Eingabe hexstr als "40D00DC934652280" (H->L), decimals = Anzahl Nachkommastellen
// Rueckgabe floatingPoint-Value
function convertHexToFloat64 (hexstr, decimals)
{
	var bin = [];
	var binSum = "";
	var sign, expo, mant;
	var floatVal = 0;
	var nul8 = "00000000";

	if (hexstr.length != 16)
		return 0;
	
	for (var i=0; i<8; i++)
	{
		bin[i] = hexstr.substr(2*i,2);		
		bin[i] = parseInt(bin[i], 16);		
		bin[i] = bin[i].toString(2);		
		bin[i] = nul8 + bin[i];				
		bin[i] = bin[i].substr(bin[i].length-8,8);
		binSum += bin[i];
	}

	sign=parseInt(binSum.charAt(0),2)? -1:1;   					
	expo=parseInt(binSum.substr(1,11),2) - 1023;  				
	mant=parseInt(binSum.substr(12,52),2) + 0x10000000000000; 	
	mant = mant.toString(2);

	if (parseInt(binSum.substr(1,11),2) == 0)				
	{
		if (parseInt(binSum.substr(12,52),2) != 0)		
			return 0;
	}
	if (parseInt(binSum.substr(1,11),2) == 2047)			
		return 0;
	
    for (i=0; i<mant.length; i+=1)
	{
        floatVal += parseInt(mant[i])? Math.pow(2,expo):0;
        expo--;
    }
	
    floatVal = floatVal*sign;					
	floatVal = floatVal.toFixed(decimals);		
	return floatVal;
}	

// ********************************************************************************************
// ********************************************************************************************



// ********************************************************************************************
// INFO
// ********************************************************************************************

// INFO
// Aktuelle Daten
function info_currentData()
{
	var headline =  '<B>INFO: '+ins("mbus_data_info_currentData_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_data_info_currentData")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 250, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



