/**********************************************************************************************
	JS functions for modbus_rs485

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		02.2014

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_RS485 = 0;
var modbus_response_counter = 0;		// Empfangszaehler

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Namen im Header anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];
	
	// Button freigeben
	buttonDisabel (1, false);
	buttonDisabel (2, false);

	// Parameter vom EWIO abfragen
	modbus_dataFromEWIO();
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{
	// Button 1s disabeln
	buttonDisabel(1, true);
	setTimeout ("buttonDisabel(1, false)", 1000);

	// Laden Instanz	
	top.getDataExtended ("modbusRS485", "configuration", "top.frame_content.modbus_getParameter(actStr)");

}

// ********************************************************************************************
// Parameter vom EWIO laden
function modbus_getParameter(actStr)
{
	if (DEBUG_RS485)	
		alert ("modbus_getInstance: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var param = JSON2.parse(actStr);

	// Einstellungen entsprechend param setzen
	var element = document.getElementById("bitrate");
	for (var i=0; i<element.length; i++)
	{
		if (element[i].value == param.bitrate)
			element.selectedIndex = i;
	}
	var element = document.getElementById("parity");
	for (var i=0; i<element.length; i++)
	{
		if (element[i].value == param.parity)
			element.selectedIndex = i;
	}
	
	document.getElementById("repeat").value = param.answer_repeat;
	document.getElementById("timeout_frame").value = param.answer_timeout_frame;
	document.getElementById("timeout_byte").value = param.answer_timeout_byte;

	if (param.start_modbus_io == true)
		document.getElementById("io").checked = true;
	else
		document.getElementById("io").checked = false;
}

// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button 1s disabeln
	buttonDisabel(2, true);
	setTimeout ("buttonDisabel(2, false)", 1000);

	var param = {};

	var element = document.getElementById("bitrate");
	var i = element.selectedIndex;
	param.bitrate = element[i].value;

	var element = document.getElementById("parity");
	var i = element.selectedIndex;
	param.parity = element[i].value;

	param.answer_repeat = document.getElementById("repeat").value;
	param.answer_timeout_frame = document.getElementById("timeout_frame").value;
	param.answer_timeout_byte = document.getElementById("timeout_byte").value;

	// Eingaben pruefen
	var ret = top.checkInputString (ins("modbus_rs485_repeat"), param.answer_repeat, "^[0-9]{1,2}$"); 	// 1-2 Zeichen, Ziffern
	ret |= checkInputValue (ins("modbus_rs485_repeat"), param.answer_repeat, 0, 10);
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("modbus_rs485_timeout_frame"), param.answer_timeout_frame, "^[0-9]{1,4}$"); 	// 1-4 Zeichen, Ziffern
	ret |= checkInputValue (ins("modbus_rs485_timeout_frame"), param.answer_timeout_frame, 0, 400);
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("modbus_rs485_timeout_byte"), param.answer_timeout_byte, "^[0-9]{1,4}$"); 	// 1-4 Zeichen, Ziffern
	ret |= checkInputValue (ins("modbus_rs485_timeout_byte"), param.answer_timeout_byte, 0, 400);
	if (ret == -1)
		return;



	if (document.getElementById("io").checked == true)
		param.start_modbus_io = true;
	else
		param.start_modbus_io = false;

	// Object -> String
	var actStr = JSON2.stringify (param, null, 4);
	// alert (actStr);

	// Parameter an EWIO senden
	// Die Parameter werden nur in JSON gespeichert, es erfolgt noch keine Konfiguration des Gateways
	top.setDataExtended ("modbusRS485", "configuration", actStr);

	// Modbus-Gateway mit der in JSON gespeicherten Konfiguration laden
	setTimeout ("top.setDataExtended ('modbus_0000', 'modbus_init', '')", 1000);

	// Ergebnis checken
	setTimeout ("top.getDataExtended ('modbus_0000', 'modbus', 'top.frame_content.modbus_response(actStr)')", 2000);

}

// ********************************************************************************************
// Ergebnis checken
function modbus_response(actStr)
{
	// alert (actStr);	
	
	// eine Zeitlang Telegramm pollen
	var timeout = 5; 	

	// Fehlermeldungen vom webGate
	if (actStr.indexOf('{') == -1)
	{
		// Message filtern		
		actStr = top.getMessage (actStr);

		// keine Antwort vom modbus_gateway
		var wait_time = timeout-modbus_response_counter;
		if (modbus_response_counter < timeout)		
		{	
			top.hideMessageBox();
			top.messageBox_Wait_ext (ins("mbus_config_message_wait_EWIO") + "<B>" + wait_time.toString() + "</B> sec.");
			setTimeout ("top.getDataExtended ('modbus_0000', 'modbus', 'top.frame_content.modbus_response(actStr)')", 1000);
			modbus_response_counter++;			// 1 Sekunde vergangen
			return;			
		}

		// ModBus-Zaehler hat nicht geantwortet 
		top.hideMessageBox();
		top.messageBox (ins("mbus_data_error_head"), actStr);
		return;
	}

	// JSON-String in Objekt wandeln
	try
	{
		actObject = JSON.parse(actStr);
	}
	catch(err)
	{
		var txt = "Error on navigation data occured.\n";
		txt += "Error description: " + err.message + "\n";
		alert (txt);

		//document.write(actStr);	
		return;	
	}

	// Ausgabe Status vom modbus-gateway
	top.hideMessageBox();
	top.messageBox ("RESULT", actObject.state);		
}

// ********************************************************************************************
// ********************************************************************************************
// Steuerbyte berechnen (Bitrate, Paritaet)
function getControlByte (bitrate, parity)
{
	// bitrate
	switch (bitrate)
	{
		case "1200":	control = 1;		break;
		case "2400":	control = 2;		break;
		case "4800":	control = 3;		break;
		case "9600":	control = 4;		break;
		case "19200":	control = 5;		break;
		case "38400":	control = 6;		break;
		case "57600":	control = 7;		break;
		case "115200":	control = 8;		break;
	}

	// parity
	switch (parity)
	{
		case "even":	control |= 1 << 4;		break;
		case "odd":		control |= 2 << 4;		break;
		case "none":	control |= 3 << 4;		break;
		case "none_1":	control |= 4 << 4;		break;
	}

	var hexStr = control.toString(16);
	// alert (hexStr);
	return hexStr;
}

// ********************************************************************************************
// Konvertieren Int-String zu Hex-String 
function intStr2hexStr (intStr)
{
	var intVal = parseInt(intStr);
	var hexStr = intVal.toString(16);	
	hexStr = hexStr.toUpperCase();
	hexStr = addLeadingZeros (hexStr, 4);
	var hexStr_0 = hexStr.substring(0,2);
	var hexStr_1 = hexStr.substring(2);

	return (" " + hexStr_0 + " " + hexStr_1);
}

// ********************************************************************************************
// fuehrende Nullen auffuellen
function addLeadingZeros (number, length)
{
	var num = '' + number;
	while (num.length < length)
		num = '0' + num;
	return num;
}

// ********************************************************************************************
// Hilfsfunktionen
// ********************************************************************************************
// Wertebereich pruefen und Ergebnis ausgeben
function checkInputValue (headExt, value, valMin, valMax)
{
	var val = 0;

	if (typeof(value) == "string")		val = parseInt (value);
	else								val = value;

	if (val < valMin)
	{
		top.messageBox ("CHECK INPUT - " + headExt, ins("modbus_rs485_error_min") + valMin);			 
		return -1;
	}

	if (val > valMax)
	{
		top.messageBox ("CHECK INPUT - " + headExt, ins("modbus_rs485_error_max") + valMax);			 
		return -1;
	}
	return 0;
}

// ********************************************************************************************
// Check Antwort auf Login-Error
function checkLoginError (actString)
{
	if (actString.indexOf("LOGIN ERROR") != -1)	
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		top.hideMessageBox();		
		top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		return 1;	
	}
	
	return 0;
}

// ********************************************************************************************
// Button disabel/enabel
function buttonDisabel(number, state)
{
	if (number == 1)
		top.document.getElementById("button_1").disabled = state;

	if (number == 2)
		top.document.getElementById("button_2").disabled = state;
}

// ********************************************************************************************


// ********************************************************************************************
// INFO
// ********************************************************************************************
function info_repeat()
{
	var headline =  '<B>INFO: '+ins("modbus_rs485_info_repeat_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("modbus_rs485_info_repeat")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 160, "window");
}

function info_timeout_frame()
{
	var headline =  '<B>INFO: '+ins("modbus_rs485_info_timeout_frame_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("modbus_rs485_info_timeout_frame")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 180, "window");
}

function info_timeout_byte()
{
	var headline =  '<B>INFO: '+ins("modbus_rs485_info_timeout_byte_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("modbus_rs485_info_timeout_byte")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 180, "window");
}

function info_io()
{
	var headline =  '<B>INFO: '+ins("modbus_rs485_info_io_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("modbus_rs485_info_io")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 400, "window");
}

// ********************************************************************************************
// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************


