/**********************************************************************************************
	JS functions for server_man_download

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		01.2012

***********************************************************************************************/


/*
	Anmerkungen:

	Auswahl von Zeitraum und Datenpunkt fuer Download-File

	BROWSER -> EWIO
	Senden der Angaben zur Erzeugung der Datei,
	Danach Freischalten des Download-Buttons

	BROWSER <- EWIO
	Laden der Seite

*/

// ********************************************************************************************

var DEBUG_MAN_DOWNLOAD = 0;
var download_dp;
var path_database = "/config/usr/database/man";
var date_to;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// aktuelle Zeit in das angegebene control schreiben
	getCurrentDate (document.form_dataFrom.date);
	getCurrentDate (document.form_dataTo.date);
	getCurrentTime (document.form_dataTo.time);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// alert ("get data from EWIO");

	if (actObject.channel == undefined)
		return 0;

	for (var i=0; i<actObject.channel.length; i++)
	{
		// Eintrag in Liste
		addSelectOption (document.form_datapoint.select, actObject.channel[i].ID, actObject.channel[i].ID);
	}

	return 0;
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username == "Administrator") || (top.g_username == "Operator"))
	{
		// Werte ermitteln	
		var changedObject = getParams();
	
		// Download_Box anzeigen
		if (changedObject)		
			waitForDownload();

		return (changedObject);
	}
	else
	{
		top.messageBox_Login ("Administrator / Operator");
		return 0;	
	}
}

// ********************************************************************************************
// Datenpunkt-Auswahl aktiv/deaktiv setzen
function setActivState (state)
{
	if (state)
		document.getElementById("select").style.display = "block";
	else	
		document.getElementById("select").style.display = "none";
}

// ********************************************************************************************






// ********************************************************************************************
// Konfiguration
// ********************************************************************************************

// Parameter fuer Erzeugen des Download-Files zusammenstellen
function getParams()
{
	var obj = new Object();

	// channelId
	// wenn "alle" ausgewaehlt wurde, dann channelId = 0 setzen
	if (document.getElementById("select").style.display == "none")
		obj.channelId = "0";
	else
	{
		var i = document.form_datapoint.select.selectedIndex;
		if (document.form_datapoint.select[i] == undefined)
			return;
		obj.channelId = document.form_datapoint.select[i].value;
	}

	// Datenpunkt lokal speichern
	// auf 3 Ziffern mit 0 auffuellen
	if (obj.channelId == 0)
		download_dp = obj.channelId;	
	else	
	{	
		switch (obj.channelId.length)
		{
			case 1:	download_dp = "00" + obj.channelId;	break;
			case 2:	download_dp = "0" + obj.channelId;	break;
			default:
			case 3:	download_dp = obj.channelId;		break;
		}	
	}

	// from
	var err = 0;
	err |= cal_inputCheck ("from");				// Pruefen Eingabe
	if (!err)
		obj.from = cal_inputConvert ("from");	// Konvertieren in DB-Format

	// to
	date_to = "";
	err |= cal_inputCheck ("to");				// Pruefen Eingabe
	if (!err)
	{
		obj.to = cal_inputConvert ("to");		// Konvertieren in DB-Format
		date_to = convertToFileFormat (obj.to);	// Konvertieren in File-Format
	}

	if (DEBUG_MAN_DOWNLOAD)	
	{
		var objStr = JSON2.stringify (obj, null, 4);	// Object -> String
		alert (objStr);
	}

	if (!err)
		return (obj);
	return 0;
}

// ********************************************************************************************
// ********************************************************************************************
// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}




// ********************************************************************************************
// Download
// ********************************************************************************************

function download()
{ 

	// MessageBox schliessen
	top.hideMessageBox();

	// FileNamen zusammenstellen (Datenpunkt + Datum bis)
	//alert (date_to);
	var dateStr = date_to;

	if (download_dp == "0")
		var filename = path_database + "/" + top.getDeviceName() + "_dp" + download_dp + "_" + dateStr + ".tar.bz2";	
	else
		var filename = path_database + "/" + top.getDeviceName() + "_dp" + download_dp + "_" + dateStr + ".csv";

	var headline =  '<B>DOWNLOAD</B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("man_download_download")+
					'</div> '+

					'<form name="form_download" method="post" action="cgi-bin/getBinFileFromServer.cgi" accept-charset="utf-8"> '+ 		
						'<div class="pos x0301"> '+
							'<input type="submit" class="textfield" value="DOWNLOAD" onclick= "setParameter();"> '+
						'</div> '+
						'<div class="pos x0401 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+
							'<input type="text" name="password" class="hidden" value="">'+
							'<input type="text" name="type" class="hidden" value="fileload_bin">'+
							'<input type="text" name="module" class="hidden" value='+filename+'>'+ 
						'</div> '+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="download_close()">'+
						'</div>';
					'</form>'+

	guiPopup.Show ("message", headline, content, 'IO', 400, 150, "window");

	// Parameter
	// username, password
	// Parameter werden unter setParameter() gesetzt, damit das Passwort im Fall von Cancel nicht verworfen ist
	// und ein Logout bei der naechsten Kommunikation folgt
}

// ********************************************************************************************

// Parameter setzen nach Klick auf Download
function setParameter()
{
	document.form_download.username.value = top.g_username;
	document.form_download.password.value=top.calculatePassword ();
	setTimeout('download_close()', 1000);
}

// ********************************************************************************************

// Einstellung Datenbank-Parameter auswerten
function download_close ()
{
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************

// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	value += "";	// String!	
	return (value);
}

// ********************************************************************************************

// MessageBox zum Warten setzen, Lesen der erzeugten Files anstossen
function waitForDownload ()
{
	top.messageBox_Wait_list ("");
	setTimeout ("getDir()", 2000);	
}

// ********************************************************************************************

// Erzeugte Files lesen
function getDir()
{
	// DIR lesen
	var type = "dir_download";
	var module = path_database;
	var func = "top.frame_content.getDirAnswer(actStr)";
	top.getDataExtended (module, type, func);
}

// ********************************************************************************************

// Antwort DIR 
function getDirAnswer(actStr)
{
	//alert (actStr);

	var listReady = false;

	var oDir = JSON2.parse(actStr);
	var list = "";	

	for (var i=0; i<oDir.files.length; i++)
	{
		list += oDir.files[i] + " ";

		if (download_dp == "0")
		{
			// alle
			if (oDir.files[i].indexOf("_dp0_") != -1)	
				listReady = true;	
		}
		else
		{	
			// Auswahl, nur 1 gueltiges File
			if (oDir.files[i].length > 0)	
				listReady = true;	
		}
	}

	top.hideMessageBox();
	top.messageBox_Wait_list (list);

	if (!listReady)	
		setTimeout ("getDir()", 2000);		// weiter warten	
	else
		setTimeout ("download()", 2000);	// Download-Fenster einblenden	

}

// ********************************************************************************************

// Konvertieren DB-Format in File-Kennzeichnung (2012-11-01|10:15:00 -> 121101_1015)
function convertToFileFormat (db_time)
{
	var file_time = db_time.charAt(2) + db_time.charAt(3) +
					db_time.charAt(5) + db_time.charAt(6) +
					db_time.charAt(8) + db_time.charAt(9) +
					"_" +
					db_time.charAt(11) + db_time.charAt(12) +
					db_time.charAt(14) + db_time.charAt(15);

	return file_time;
}

// ********************************************************************************************






// ********************************************************************************************
// ********************************************************************************************
// Info
function info_download()
{
	var headline =  '<B>INFO: DOWNLOAD</B>';
	content =		'<div class="pos x0101 textfield"> '+ins("man_download_info")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 380, "window");
}

// ********************************************************************************************
// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



