/**********************************************************************************************
	JS functions for start / login

	Copyright (c) 2009 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		07/2010

***********************************************************************************************/


var DEBUG_START = 0;		// Debug
var DEVNAME = "EWIO-M";

// ********************************************************************************************

function initContent()
{
	// Ermitteln des Namens des angewaehlten EWIOs 
	var myText = document.getElementById("headLine");
	if (DEVNAME.length)		myText.innerHTML = DEVNAME;
	else					myText.innerHTML = "EWIO-M";

	top.frame_content.document.form_1.selectStatus.selectedIndex = 2;	// Administrator = default
	login.getLogin();
}

// ********************************************************************************************
// Aktualisierungsfunktionen
function getObjectProperties()
{
	return (0);
}

function setObjectProperties (actObject)
{
}

// ********************************************************************************************
// ********************************************************************************************

// Erzeugung eines pw- Objektes
// Alle Variablen und Funktionen zu diesem Objekt sind innerhalb des Objektes gekapselt

var login = 
{
	user: "",
	pw: "",

	// ========================================================================
	// ========================================================================
	// Ermitteln User aus Combobox
	getLogin: function(object)
	{
		// Evtl. vorhandenes Passwort loeschen	
		top.frame_content.document.form_2.name_20.value = "";

		// get selected index
		var index = top.frame_content.document.form_1.selectStatus.selectedIndex;
		
		// get value
		this.user = top.frame_content.document.form_1.selectStatus[index].text;

		// Text zur Erlaeuterung
		var pwText = top.frame_content.document.comment;		
		switch (this.user)
		{
			case "Standard":
				pwText.innerHTML = ins("start_standard");
				break;
			case "Operator":
				pwText.innerHTML = ins("start_operator");
				break;
			case "Administrator":
				pwText.innerHTML = ins("start_admin");
				break;
		}
	},		

	// ========================================================================
	// Diese Funktion gibt die ermittelten Werte fuer user / password als returnwert
	// (Array) zurueck.

	getLoginValues: function()
	{
		var index = top.frame_content.document.form_1.selectStatus.selectedIndex;
		this.user = top.frame_content.document.form_1.selectStatus[index].text;
		var arr = new Array();
		arr[0] = this.user;
		arr[1] = this.pw;
		return (arr); 
	},
	
	// ========================================================================
	// Ausgabe, ob Login erfolgreich war
	loginSuccess: function(result)
	{
		var success = document.getElementById("loginresult");				// display
		if (result == "LOGIN OK")	
		{
			// OK
			success.innerHTML = ins("start_login_s");
		}
		else
		{
			// error
			success.innerHTML = ins("start_login_e");
		}
	},

	// ========================================================================
	// Passworteingabe auswerten
	pwGet: function (element)
	{
		if (element.value.length < this.pw.length)				// PW teilweise oder ganz geloescht
			this.pw = this.pw.slice(0, element.value.length);

		this.pw += element.value.replace(/\u25CF/g,'');			// Punkte ausschneiden

		var points = '';										// Zeichen durch Punkte ersetzen
		for (var i=0; i<element.value.length; i++)
			points += '\u25CF'; 

		element.value = points;									// Feldinhalt als Punkte setzen
		// console.log (this.pw);
	},

	// ========================================================================
	// Passworteingabe abgeschlossen
	pwReady: function (evt)
	{
		if (evt)
		{
			// ch = 13 -> ReturnTaste gedrueckt
			var ch = evt.which || evt.keyCode;
			if (ch != 13)
				return true;	
			evt.preventDefault();		
		}

		// checkLogin ausloesen
		top.getId();		
	
		return false;	
	}
}

// ********************************************************************************************







// ********************************************************************************************
// Sprach-Auswahl
// ********************************************************************************************
// Sprachfiles ermitteln
function getLanguage ()
{
	// Sprachfiles ermitteln
	getLanguageFiles ("top.frame_content.setLangMessageBox(actStr)");
}

// ********************************************************************************************
// Messagebox erzeugen
function setLangMessageBox (actStr)
{
	var headline =  '<B>SPRACHE / LANGUAGE</B>';
	content =		'<form name="form_lang"> '+ 		
					'<div class="pos x0101 textfield"> Auswahl der Sprache <br> Select Language</div>'+
					'<div class="pos x0104">'+
					'<select name="selectLang" size=1 class="combobox long_150"></select><br>'+
					'</div>'+

					'<div class="pos x0301 comment"> '+
						'Nach dem Aendern der Sprache muessen Sie sich neu einloggen. <br>'+
						'After selecting language you have to login again.'+
					'</div>'+

					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetLang(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetLang(0)">'+
					'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'Tools', 400, 180, "window");


	// alert (actStr);
	var oLang = JSON2.parse(actStr);

	for (var i=0; i<oLang.languages.length; i++)
		addSelectOption (document.form_lang.selectLang, oLang.languages[i].file, oLang.languages[i].text);
}

// ********************************************************************************************

// Sprachauswahl auswerten
function fSetLang (valid)
{
	if (valid)
	{
		// Daten zusammenstellen
		var i = document.form_lang.selectLang.selectedIndex;
		var file = document.form_lang.selectLang[i].value;

		// Daten zum EWIO senden
		setLanguageFile (file);

		// Startseite neu laden
		setTimeout ("top.resetWebinterface ()", 500);
	}
	
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************

// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************



// ********************************************************************************************
// Aufruf CGI-Funktionen
// ********************************************************************************************

// Auswahl der Sprachdatei mittels CGI-Funktion getLanguage.cgi (ohne login)
function getLanguageFiles (func)
{
	var type = "GET_LANG";
	var modulName = "start";
	var parameter = "type="+type+"&"+"module="+modulName;

	// Testausgabe
	if (DEBUG_START)
		alert (	"getLanguageFiles parameter = "+parameter);

	top.jsonFromServer ("getLanguage.cgi",		// Aufzurufende Datei auf cgi-bin 
				parameter,						// username & password & type & module
				func);							// aufzurufende Funktion nach Datenerhalt
}

// ********************************************************************************************

// Setzen der Sprachdatei mittels CGI-Funktion setLanguage.cgi (ohne login)
function setLanguageFile (jStr)
{
	var type = "SET_LANG";
	var modulName = "start";
	var parameter = "type="+type+"&"+"module="+modulName+"&"+"data=";

	// Testausgabe
	if (DEBUG_START)
		alert (	"setLanguageFile parameter = "+parameter);

	top.jsonToServer ("setLanguage.cgi", 		// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module & data
			jStr);								// JSON-Daten als String
}

// ********************************************************************************************
// ********************************************************************************************
