/**********************************************************************************************
	JS functions for wlan

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		09.2012

***********************************************************************************************/


/*

*/

// ********************************************************************************************

var DEBUG_WLAN = 0;
var oWLAN;							// local object configuration
var lastStr;						// letzter empfangener String
var loop;							// Schleifendurchlauf
var LOOP_MAX = 1;					// Anzahl Durchlaeufe

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Namen im Header anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Tabelle 
	document.getElementById("tab_wlan").style.visibility = "hidden";

	// Konfiguration einlesen
	top.document.getElementById("button_1").onclick();
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	if (DEBUG_WLAN)
	{	
		var objStr = JSON2.stringify (actObject, null, 4);
		alert (objStr);
	}

	// Objekt global speichern fuer getObjectProperties()
	oWLAN = actObject;	

	// Umschaltung manuell / automatic, Tabelle und Param sichtbar?
	if (oWLAN.mode == "manually")
	{
		setSearch(true);
		document.form_mode.rDs[0].checked = false;
		document.form_mode.rDs[1].checked = true;
	}	
	else
	{
		setSearch(false);
		document.form_mode.rDs[0].checked = true;
		document.form_mode.rDs[1].checked = false;
	}

	document.form_param_head.ssid.value = oWLAN.ssid;
	document.form_param_head.coding.value = oWLAN.coding;
	document.form_param_head.key.value = oWLAN.key;

	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		// Werte ermitteln	
		var changedObject = getParameter();
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************

// Parameter Browser -> EWIO
function getParameter ()
{

	if (document.form_mode.rDs[0].checked == true)	oWLAN.mode = "auto";
	else											oWLAN.mode = "manually";

	// Header aktualisieren	
	document.form_param_head.ssid.value = oWLAN.ssid;
	document.form_param_head.coding.value = oWLAN.coding;
	document.form_param_head.key.value = oWLAN.key;

	return oWLAN;
}

// ********************************************************************************************

// Netzwerke scannen
function search_wlan (state)
{

	if (state == true)
	{
		var search_state = document.getElementById("search_state");
		search_state.innerHTML = ins("wlan_scan_running"); 			// "Scan laeuft"
		
		// Suche anstossen
		top.setDataExtended ("wlan", "search", "");			// Daten zum EWIO senden

		// Tabelle loeschen
		clearTable ("tab_wlan_body");
		loop = LOOP_MAX;
		lastStr = " ";

		// nach kurzer Zeit Ergebnis abfragen	
		setTimeout ("top.getDataExtended ('wlan', 'search', 'top.frame_content.getSearch_answer(actStr)')", 5000);
	
		// Messagebox
		top.messageBox_Wait();

		// Button sperren
		top.document.getElementById("button_1").disabled = true;
		top.document.getElementById("button_2").disabled = true;
	}	
	else
	{
		var search_state = document.getElementById("search_state");
		search_state.innerHTML = ins("wlan_scan_finished");			// "Scan beendet"

		top.hideMessageBox();

		// Button freigeben
		top.document.getElementById("button_1").disabled = false;
		top.document.getElementById("button_2").disabled = false;
	}
}

// ********************************************************************************************

// Umschaltung
function setSearch (state)
{

	if (state == true)
	{
		// Button sichtbar
		document.form_search.style.display = "block";
		// Tabelle sichtbar
		document.getElementById("tab_wlan").style.visibility = "visible";
		// Scan state sichtbar
		document.getElementById("search_state").style.visibility = "visible";
	}
	else
	{
		// Button unsichtbar
		document.form_search.style.display = "none";
		// Tabelle unsichtbar
		document.getElementById("tab_wlan").style.visibility = "hidden";
		// Scan state unsichtbar
		document.getElementById("search_state").style.visibility = "hidden";
	}
}

// ********************************************************************************************

// Scan-Ergebnis empfangen
function getSearch_answer (actStr)
{
	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	if ((jObject.state == undefined) || (jObject.state == "error"))
	{	
		// alert ("Error: state error or undefined");
		// Scan beendet
		search_wlan(false);		
		return;
	}

	if (jObject.state == "no answer")
	{		
		// Ergebnis erneut abfragen	
		setTimeout ("top.getDataExtended ('wlan', 'search', 'top.frame_content.getSearch_answer(actStr)')", 5000);
		return;	
	}

	// Tabelle erzeugen, wenn File vollstaendig
	createTable(actStr);
}

// ********************************************************************************************

// Tabelle erzeugen
function createTable(actStr)
{

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_wlan_body");
	var tcnt = jObject.wlan.length;

	for (var i=0; i<tcnt; i++)
	{	
		// Element nur eintragen, wenn es noch nicht vorhanden ist
		var entryPresent = checkTableElement ("tab_wlan_body", 0, jObject.wlan[i].ssid);
		if ((entryPresent == 0) || (loop == LOOP_MAX))
		{
			tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

			// jede 2. Reihe andersfarbig ("Zebratabelle")
			if (tbody.rows.length % 2 == 0)	
				tr.setAttribute ("class", "row_color_odd");
			else
				tr.setAttribute ("class", "row_color_even");

			// 1. Spalte NAME
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = jObject.wlan[i].ssid;
			td.setAttribute ("class", "td_150");

			// 2. Spalte MODE
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = jObject.wlan[i].mode;
			td.setAttribute ("class", "td_60");

			// 3. Spalte CODING
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = jObject.wlan[i].coding;
			td.setAttribute ("class", "td_80");

			// 4. Spalte QUALITY 
			td = tr.insertCell(tr.cells.length);
			var graph = "graph_"+i;
			var text = "text_"+i;
			td.innerHTML = 
				'<div class="progress_table_background" style="width:140px;">'+
					'<div id='+graph+' class="progress_table_value" style="width:0%;"></div>'+
					'<div id='+text+' class="progress_title"> 0% </div>'+
				'</div>';
			//var levArr = jObject.wlan[i].quality.split("/");
			//var relUsed = (levArr[0] * 100) / levArr[1];		// prozentualen Anteil berechnen
			//relUsed = Math.round(relUsed);						// auf ganze Zahl runden
			relUsed = parseInt(jObject.wlan[i].quality);
			document.getElementById("graph_"+i).style.width = relUsed + "%";
			document.getElementById("text_"+i).innerHTML = relUsed + "%";
			td.setAttribute ("class", "td_150");

			// 5. Spalte LEVEL 
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = jObject.wlan[i].siglevel;
			td.setAttribute ("class", "td_60");

			// 6. Spalte SELECT 
			td = tr.insertCell(tr.cells.length);
			// Select nur, wenn Mode=Master und Coding=WPA
			if ((jObject.wlan[i].mode.indexOf("Master") != -1) && (jObject.wlan[i].coding.indexOf("WPA") != -1))
				td.innerHTML = '<input type="button" name="config_'+(tbody.rows.length-1)+'" class="textfield_small" value="select" onclick="wlan_configuration('+i+')">';
			else
				td.innerHTML = '<input type="button" name="" class="textfield_small" value="select" style="visibility:hidden">';
			td.setAttribute ("class", "td_80");
			td.setAttribute ("style", "text-align:center;");


			// scrolle zur letzten eingefuegten Reihe
			var tElement   = tbody.getElementsByTagName("tbody")[0]; 
			var scroll_area = document.getElementById('scroll_1');
			scroll_area.scrollTop = tElement.clientHeight;
		}
	}

	if (loop > 1)
	{	
		// weiterer Durchlauf
		// Suche anstossen
		top.setDataExtended ("wlan", "search", "");			// Daten zum EWIO senden

		// nach kurzer Zeit Ergebnis abfragen	
		setTimeout ("top.getDataExtended ('wlan', 'search', 'top.frame_content.getSearch_answer(actStr)')", 2000);

		loop--;
		lastStr = " ";		
		return;
	}

	// Scan beendet
	search_wlan(false);

}

// ********************************************************************************************

// Konfigurationsbox oeffnen
function wlan_configuration (cnt)
{
	// alert ("wlan config "+cnt);

	var headline =  '<B>WLAN-Konfiguration</B>';
	content =		'<form name="form_config">'+ 		
					'<div class="pos x0101 textfield"> '+ins("wlan_ssid")+' </div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="" name="ssid"> </div>'+
					'<div class="pos x0201 textfield"> '+ins("wlan_coding")+' </div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="" name="coding"> </div>'+
					'<div class="pos x0301 textfield"> '+ins("wlan_key")+' </div>'+
					'<div class="pos x0303"> <input type="password" class="textfield long_200" value="" name="key"> </div>'+

					'<div class="pos x0401 textfield"> '+
						'<input type="radio" name="r0" value="0" onclick="changeIPMode(0)"> '+ins("wlan_man")+' <br> '+
						'<input type="radio" name="r0" value="-1" checked="true" onclick="changeIPMode(1)"> '+ins("wlan_auto")+
					'</div>'+
					'</form>'+

					'<form name="form_man" style="padding:10px;">'+
					'<div class="pos x0601"> '+ins("wlan_addr")+' </div>'+
					'<div class="pos x0603">'+
						'<input type="text" class="textfield" value="" name="ip_0" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="ip_1" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="ip_2" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="ip_3" size="3" maxlength="3">'+
					'</div>'+
					'<div class="pos x0701"> '+ins("wlan_subnet")+' </div>'+
					'<div class="pos x0703">'+
						'<input type="text" class="textfield" value="" name="sn_0" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="sn_1" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="sn_2" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="sn_3" size="3" maxlength="3">'+
					'</div>'+
					'<div class="pos x0801"> Gateway: </div>'+
					'<div class="pos x0803">'+
						'<input type="text" class="textfield" value="" name="gw_0" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="gw_1" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="gw_2" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="gw_3" size="3" maxlength="3">'+
					'</div>'+
					'<div class="pos x0901"> DNS-Server: </div>'+
					'<div class="pos x0903">'+
						'<input type="text" class="textfield" value="" name="dns_0" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="dns_1" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="dns_2" size="3" maxlength="3">.'+
						'<input type="text" class="textfield" value="" name="dns_3" size="3" maxlength="3">'+
					'</div>'+

					'</form>'+

					'<form name="form_dhcp" style="padding:10px;">'+
						'<div class="pos x0601"> Hostname: </div>'+
						'<div class="pos x0603">'+
							'<input type="text" class="textfield" value="" name="host" size="20" maxlength="63">'+
						'</div>'+
						'<div class="pos x0701"> Domaine: </div>'+
						'<div class="pos x0703">'+
							'<input type="text" class="textfield" value="" name="domain" size="20" maxlength="253">'+
						'</div>'+
					'</form>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="configurationClose(1)">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="configurationClose(0)">'+
					'</div>';

	guiPopup.Show ("message", headline, content, 'Tools', 400, 310, "window");

	// Werte setzen
	if (oWLAN.dhcp != undefined)
	{
		if (oWLAN.dhcp == true)
			document.form_config.r0[1].checked = true;
		else
			document.form_config.r0[0].checked = true;
	}
	changeIPMode (oWLAN.dhcp);

	document.form_config.ssid.value = trim (getTableElement ("tab_wlan_body", cnt, 0));
	document.form_config.coding.value = trimPre (getTableElement ("tab_wlan_body", cnt, 2)); 	// "WPA";
	document.form_config.key.value = "";


	// IP-Adressen setzen
	var arr_addr = oWLAN.addr.split(".");
	var arr_subnet = oWLAN.subnet.split(".");
	
	if (oWLAN.gateway.length)
		var arr_gateway = oWLAN.gateway.split(".");
	else
	{
		var arr_gateway = new Array();
		for (var i=0; i<4; i++)
			arr_gateway[i] = "";
	}

	if (oWLAN.dnsServer.length)
		var arr_dnsServer = oWLAN.dnsServer.split(".");
	else
	{
		var arr_dnsServer = new Array();
		for (var i=0; i<4; i++)
			arr_dnsServer[i] = "";
	}

	for (var i=0; i<4; i++)		// 4 IP-Segmente
	{
		document.form_man[i].value = arr_addr[i];
		document.form_man[i+4].value = arr_subnet[i];
		document.form_man[i+8].value = arr_gateway[i];
		document.form_man[i+12].value = arr_dnsServer[i];
	}

	// Host und Domaene setzen
	if (oWLAN.hostname != undefined)
		document.form_dhcp.host.value = oWLAN.hostname;
	if (oWLAN.domain != undefined)
		document.form_dhcp.domain.value = oWLAN.domain;
	

}

// ********************************************************************************************

function configurationClose(valid)
{

	if (valid)
	{
		// Einstellungen uebernehmen
		if (document.form_config.r0[0].checked == true)
		{
			oWLAN.dhcp = false;

			// Plausibilitaets-Check
			if (checkIPInput() != 0)	
				return;
		}	
		else	
		{
			oWLAN.dhcp = true;

			// Plausibilitaets-Check
			if (checkDHCPInput() != 0)	
				return;
		}

		// Eingabe pruefen key
		var ret = top.checkInputString ("Schluessel", document.form_config.key.value, "^[A-Za-z0-9_-]{8,63}$"); 	// Schluessel, 8-63 Zeichen, alphanum.+_-
		if (ret == -1)
			return;

		oWLAN.ssid = document.form_config.ssid.value;
		oWLAN.coding = document.form_config.coding.value;
		oWLAN.key = document.form_config.key.value;

		// IP-Adressen ermitteln
		oWLAN.addr = 		document.form_man[0].value+"."+
							document.form_man[1].value+"."+
							document.form_man[2].value+"."+
							document.form_man[3].value;

		oWLAN.subnet = 		document.form_man[4].value+"."+
							document.form_man[5].value+"."+
							document.form_man[6].value+"."+
							document.form_man[7].value;

		oWLAN.gateway = checkForZero(	
							document.form_man[8].value+"."+
							document.form_man[9].value+"."+
							document.form_man[10].value+"."+
							document.form_man[11].value );

		oWLAN.dnsServer = checkForZero(
							document.form_man[12].value+"."+
							document.form_man[13].value+"."+
							document.form_man[14].value+"."+
							document.form_man[15].value );

		// Host und Domaene 
		oWLAN.hostname = document.form_dhcp.host.value;
		oWLAN.domain = document.form_dhcp.domain.value;
	}

	// pad schliessen
	guiPopup.CloseMe("message");
}

// ********************************************************************************************

// Pruefen, ob es in der Tabelle schon einen bestimmten Eintrag gibt
function checkTableElement (table_id, cell, entry)
{ 
	var tbody = document.getElementById(table_id);
	for (var i=0; i<tbody.rows.length; i++)
	{ 
		var result = getTableElement (table_id, i, cell);
		if (result == entry)
			return 1;
	}
	return 0;
}

// ********************************************************************************************

// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************

// Tabelleninhalt loeschen
function clearTable (table_id)
{
	var tbody = document.getElementById(table_id);
	while (tbody.rows.length > 0)
		tbody.deleteRow(0);
}	

// ********************************************************************************************

// Leerzeichen vor und hinter einem Wort entfernen
function trim (str)
{
	str = str.replace (/^\s+/, '').replace (/\s+$/, '');
	return str;
}

// ********************************************************************************************

// Leerzeichen vor einem Wort entfernen
function trimPre (str)
{
	str = str.replace (/^\s+/, '');
	return str;
}

// ********************************************************************************************

// Umschaltung DHCP / statisch
function changeIPMode (dhcp)
{
	if (dhcp)
	{
		document.form_dhcp.style.display = "block";
		document.form_man.style.display = "none";
	}
	else
	{
		document.form_dhcp.style.display = "none";
		document.form_man.style.display = "block";
	}

}

// ********************************************************************************************

// Wenn 4 x nichts eingegeben wurde, dann die verbliebenen 3 Punkte entfernen (-> Leerstring)
function checkForZero (inStr)
{

	var outStr;

	if (inStr == "...")
		outStr = "";
	else
		outStr = inStr;

	return (outStr);
}

// ********************************************************************************************

// Plausibilitaets-Check IP
function checkIPInput()
{
	var errStr = "";
	var networkaddr = new Array();
	var networkaddr_1 = new Array();


	// Pruefen, ob eins der folgenden Felder nicht eine Ziffer zwischen 0 und 255 hat
	// IP-Adresse
	for (var i=0; i<4; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		errStr = ins("ip_msg_err4");
	}		
	// Subnetzmaske
	for (var i=4; i<8; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		errStr = ins("ip_msg_err5");
	}		
	// DNS-Server	
	var testVal = 0;	
	for (var i=8; i<12; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		if (document.form_man[i].value.length == 0)
			testVal++;
		if (testVal == 4)
			return (0);	
		else					
			errStr = ins("ip_msg_err6");
	}		
	// Gateway
	var testVal = 0;	
	for (var i=12; i<4; i++)
	{
		if ((parseInt(document.form_man[i].value) >= 0) && (parseInt(document.form_man[i].value) <= 255))		
			continue;
		if (document.form_man[i].value.length == 0)
			testVal++;
		if (testVal == 4)
			return (0);	
		else					
			errStr = ins("ip_msg_err7");
	}



	// check IP-Adresse und Gateway fuer alle 4 Segmente 
	for (var i=0; i<4; i++)
	{
		// Netzwerkadresse = IP-Adresse & Maske
		networkaddr[i] = parseInt(document.form_man[i].value) & parseInt(document.form_man[i+4].value);

		// Netzwerkadresse = Gateway-Adr. & Maske
		networkaddr_1[i] = parseInt(document.form_man[i+8].value) & parseInt(document.form_man[i+4].value);

		if (networkaddr[i] != networkaddr_1[i])
			errStr = ins("ip_msg_err1");
	}

	// Netzwerk-Adr.(erste Adr., meist 0) und Broadcast-Adr.(letzte Adr., meist 255) duerfen nicht gleich gateway sein
	if (parseInt(document.form_man[8+3].value) == networkaddr[3])
		errStr = ins("ip_msg_err2");

	if (parseInt(document.form_man[8+3].value) == (networkaddr[3] | (parseInt(document.form_man[4+3].value) ^ 255)))
		errStr = ins("ip_msg_err3");

	// Ausgabe Fehlermeldung
	if (errStr.length > 0)
	{
		//alert (errStr)
		top.messageBox (ins("ip_msg_head"), errStr);		
		return (-1);
	}
	
	return (0);
}

// ********************************************************************************************

// Plausibilitaets-Check DHCP
function checkDHCPInput()
{

	// Regeln fuer den Hostname (RFC 952, 1123):
	// Laenge 1 bis 63 Zeichen (realisiert 2-63)
	// zulaessige Zeichen "A-Z a-z 0-9 -"
	// Einschränkungen: "-" nicht als erstes oder letztes Zeichen	

	var muster = /^[A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9]$/;
	var result = muster.test(document.form_dhcp.host.value); 
	// alert (document.form_dhcp.host.value+"   "+result);

	if (result == false)
	{
		top.messageBox (ins("ip_msg_head"), ins("ip_msg_err8"));		
		return (-1);
	}

	// Regeln fuer Domain
	// Laenge zusammen mit Hostname <= 255 Zeichen
	var length = document.form_dhcp.host.value.length + document.form_dhcp.domain.value.length;
	if (length > 255)
	{
		top.messageBox (ins("ip_msg_head"), ins("ip_msg_err9"));		
		return (-1);
	}

	return (0);
}

// ********************************************************************************************




// ********************************************************************************************
// INFO
// ********************************************************************************************

// INFO
// Automatische Konfiguration
function info_config_auto()
{
	var headline =  '<B>INFO: '+ins("wlan_info_auto_head")+' </B>';
	var content =	'<div class="pos x0101 textfield">  '+ins("wlan_info_auto")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 270, "window");
}

// ********************************************************************************************

// Manuelle Konfiguration
function info_config_man()
{
	var headline =  '<B>INFO: '+ins("wlan_info_man_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("wlan_info_man")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 250, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



