#!/bin/sh
# BACnet-Server starten

# Nur einmal starten
if [ `pgrep bacnet-server` ]; then
    exit
fi

# Schleife falls Warmstart
while true; do
    # Solange eines der Skripte mit Aufrufen von modprobe luft, noch nicht starten,
    # weil es beim Zugriff auf nicht vorhandene Kernel-Treiber eine Kernel-Panic geben kann.
    script_list="driver_start.sh\|extDriver_start.sh\|extDriver_stop.sh\|driver_restart_all.sh"
    if proc_list=`ps` ; echo "$proc_list" | grep -q "$script_list"
    then
        sleep 1
        continue
    fi

    # BACnet-Server starten, Argument: Directory der Konfigurations-Dateien
    /config/bin/bacnet-server /config/etc
    Status=$?

    if [ $Status -eq 8 ]; then
        echo "BACnet-Server: Coldstart"
        /sbin/reboot
    elif [ $Status -eq 9 ]; then
        echo "BACnet-Server: Warmstart"
        continue
    elif [ $Status -ge 128 ]; then
        echo "BACnet-Server: Exit with Signal $(($Status - 128))"
    else
        echo "BACnet-Server: Exit with Error $Status"
    fi
    exit
done

