#!/bin/sh

# counter_wrapper = Aufruf-Kontrolle fuer counter_scheduler

# Wird der counter_scheduler erneut aufgerufen, obwohl er die Liste noch nicht abgearbeitet hat
# (zu viele Zaehler oder zu langsam), wird der alte Prozess zu Ende abgearbeitet, der Neue geblockt
# und Fehlermeldung.
# Als Parameter wird die Triggerquelle, der Zeitstempel und der Mode mit uebergeben. 

# Aufruf:	./counter_wrapper.sh source timestamp mode &

# source = timer	Timer is trigger source
# source = sync		SyncPuls is trigger source

# timestamp 		timestamp, form = wddmmyyyyHHMM

# mode = all		average + counter_scheduler	
# mode = average	average only
# mode = scheduler	counter_scheduler only 

# -------------------------------------------------------------------
#Debug-Ausgaben
DEBUG=1

# -------------------------------------------------------------------
if [ $DEBUG -eq 1 ];then
	if [ "$1" == "timer" ];then
		echo timestamp = $2, triggerd by TIMER
	else
		echo timestamp = $2, triggerd by SYNC_PULS
	fi
fi

# -------------------------------------------------------------------
# Pruefen, ob mbus_controller noch laeuft
/config/bin/mbus/mbus_guard.sh 

# -------------------------------------------------------------------
# Wenn counter_scheduler noch laeuft, dann den neuen Aufruf canceln
# Pruefen, ob counter_scheduler laeuft oder nicht
ps | grep counter_scheduler.sh | grep -qv grep 
result=$?

# result = 0 -> counter_scheduler laeuft noch
# result = 1 -> OK, laeuft nicht

start=1
if [ "$result" = "$start" ];then
	/config/bin/counter/counter_scheduler.sh $1 $2 $3 &
else
	if [ $DEBUG -eq 1 ];then
		echo "counter_scheduler is still running, let it run"  
	fi
	# Fehlermeldung in mbusLog (LEVEL_USER)
	/config/bin/counter/counter_setMbusLog counter_wrapper 0 1 "COUNTER: error, too many counter or to slow"
fi


