#!/bin/sh
# Description:
# Treiber fuer EW-Module starten

file_path="/sys/bus/platform/drivers/mct_paa_mux"
json_path="/config/configbase"
slots=6
list="0 1 2 3 4 5"
err="jsonc-error"

bacnet_server_flag=0
modbus_server_flag=0

# Wenn nicht der Bacnet-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ "$2" != "bacnet-server" ]; then
#     echo "Aufruf von extDriver_start.sh nicht aus Bacnet-Server"
    if [ `pgrep bacnet-server` ]; then
        echo "Bacnet-Server stop"
        pkill bacnet-server
        sleep 1
        bacnet_server_flag=1
    fi
# else
#     echo "Aufruf von extDriver_start.sh aus Bacnet-Server"
fi

# Wenn nicht der Modbus-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ -n "`pgrep modbus-gateway`" ]; then
    echo "Modbus-Gateway stop"
    killall modbus-gateway
    sleep 1
    modbus_server_flag=1
fi


# alle laufenden Treiber ermitteln
driver=`lsmod`

# Mit leerem Argument 1 alle Treiber laden und starten
if [ -z "$1" ]; then
    for var in $list
    do
        # alten Treibername ermitteln
        name=`cat /sys/devices/platform/mct_paa_mux.0/paa0.$var/modalias 2> null`
        if [ -n "$name" ]; then

            # Treiber beenden, wenn er bereits laeuft 
            if echo "$driver" | grep -q $name
            then
                modprobe -r $name
                echo $name killed
            fi
        fi
    done

    # Master beenden, wenn er laeuft
    if echo "$driver" | grep -q "mct_paa_master"
    then
        modprobe -r mct_paa_master
        echo mct_paa_master killed
    fi
    # Master wieder laden
    echo start mct_paa_master
    modprobe mct_paa_master slots=$slots command=1
    sleep 2

    # alle Treiber neu laden
    for var in $list
    do
        # neuen Treibername ermitteln
        name=`/config/bin/json/jsonc_getValue $file_path/json oLBus.oSlots[$var].Name string`
        if [ -n "$name" ]; then

            # JSON lesen, JSON string darf keine Leerzeichen, Umbrueche etc enthalten
            content=`/config/bin/json/jsonc_printCompact $json_path/$name.json`

            # Treiber starten
            echo start $name
            if [ "$content" = "$err" ]; then
                modprobe $name command=1
            else
                modprobe $name json="\"$content\""
            fi
        fi
    done

# Den in Argument 1 angegebenen Treiber laden und starten
else
    # Treiber beenden, wenn er bereits laeuft 
    name=$1
    if echo "$driver" | grep -q $name
    then
        modprobe -r $name
        echo $name killed
    fi

    # JSON lesen, JSON string darf keine Leerzeichen, Umbrueche etc enthalten
    content=`/config/bin/json/jsonc_printCompact $json_path/$name.json`

    # Treiber starten
    echo start $name
    if [ "$content" = "$err" ]; then
        modprobe $name command=1
    else
        modprobe $name json="\"$content\""
    fi
fi


# Wenn der Bacnet-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $bacnet_server_flag = 1 ]; then
    echo "Bacnet-Server start"
    /config/bin/bacnet_server_start.sh &
fi

# Wenn der Modbus-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $modbus_server_flag = 1 ]; then
    echo "Modbus-Gateway start"
    /config/bin/modbus_gateway_start.sh &
fi

