#!/bin/sh
# Description:
# Treiber fuer EW-Module stoppen

list="0 1 2 3 4 5"
driver=`lsmod`

bacnet_server_flag=0
modbus_server_flag=0

# Wenn nicht der Bacnet-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ "$2" != "bacnet-server" ]; then
#     echo "Aufruf von extDriver_stop.sh nicht aus Bacnet-Server"
    if [ `pgrep bacnet-server` ]; then
        echo "Bacnet-Server stop"
        pkill bacnet-server
        sleep 1
        bacnet_server_flag=1
    fi
# else
#     echo "Aufruf von extDriver_stop.sh aus Bacnet-Server"
fi

# Wenn nicht der Modbus-Server dies Skript startet, muss er, falls er läuft,
# gestoppt und später wieder gestartet werden. Beim Zugriff auf einen
# nicht vorhandenen Kernel-Treiber kann es sonst eine Kernel-Panic geben.
if [ -n "`pgrep modbus-gateway`" ]; then
    echo "Modbus-Gateway stop"
    killall modbus-gateway
    sleep 1
    modbus_server_flag=1
fi


# Mit leerem Argument 1 alle Treiber beenden
if [ -z "$1" ]; then
    for var in $list
    do
        # Treibername ermitteln
        name=`cat /sys/devices/platform/mct_paa_mux.0/paa0.$var/modalias 2> null`
        if [ -n "$name" ]; then

            # Treiber beenden, wenn er laeuft 
            if echo "$driver" | grep -q $name
            then
                modprobe -r $name
                echo $name killed
            fi
        fi
    done
fi

# Master beenden
if echo "$driver" | grep -q "mct_paa_master"
then
    modprobe -r mct_paa_master
    echo mct_paa_master killed
fi


# Wenn der Bacnet-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $bacnet_server_flag = 1 ]; then
    echo "Bacnet-Server start"
    /config/bin/bacnet_server_start.sh &
fi

# Wenn der Modbus-Server vorhin gestoppt wurde, wird er wieder gestartet.
# Er muss ein Hintergrundprozess werden, damit dieses Skript enden kann.
if [ $modbus_server_flag = 1 ]; then
    echo "Modbus-Gateway start"
    /config/bin/modbus_gateway_start.sh &
fi

