#!/bin/sh

# test mbus applications
# Einstellungen in etc/mbus.conf
# Fuer Ausgaben auf die Konsole muss debug_mbus_control=1 sein


# *******************************************************************
# test_ttyS
# test RX/TX auf einer seriellen Schnittstelle
# Parameter: Nr. ttyS, Sendetext

#/config/bin/mbus/test_ttyS 2 testtext

# *******************************************************************
# *******************************************************************


# mbus_id
# Die MBus-Id muss je nach Geraet angepasst werden!

# bus_path
# Pfade fuer Erweiterungs-Module abhaengig vom Steckplatz!
# allgemein (x = Steckplatz, x = 0 ... 5):
# mct_paa_di4_x 	= /sys/bus/platform/devices/mct_if.01.2-3-x.0/mbus
# mct_paa_di10_x	= /sys/bus/platform/devices/mct_if.01.2-4-x.0/mbus
# mct_paa_do4_x		= /sys/bus/platform/devices/mct_if.01.2-5-x.0/mbus
# mct_paa_to4_x		= /sys/bus/platform/devices/mct_if.01.2-5-x.0/mbus
# mct_paa_dio42_x 	= /sys/bus/platform/devices/mct_if.02.2-6-x.0/mbus
# mct_paa_ao4_x		= /sys/bus/platform/devices/mct_if.04.2-8-x.0/mbus
# mct_paa_ai8_x		= /sys/bus/platform/devices/mct_if.08.2-7-x.0/mbus

# Pfade fuer interne IOs:
# mct_spi_aio 	= /sys/bus/platform/devices/mct_if.08.2-2-0.0/mbus
# mct_spi_dio 	= /sys/bus/platform/devices/mct_if.02.2-1-0.0/mbus
# mct_pin_di_0 	= /sys/bus/platform/devices/mct_if.01.2-0-0.0/mbus
# mct_pin_di_1 	= /sys/bus/platform/devices/mct_if.01.2-0-1.0/mbus
# mct_pin_di_2 	= /sys/bus/platform/devices/mct_if.01.2-0-2.0/mbus
# mct_pin_di_3 	= /sys/bus/platform/devices/mct_if.01.2-0-3.0/mbus

# Pfad fuer MBus:
# /dev/ttyS2

# Beispiel fuer internes Modul
# mbus_id="18177100-SYS-10-14"
# bus_path="/sys/bus/platform/devices/mct_if.02.2-1-0.0/mbus"

# Beispiel fuer Erweiterungsmodul
# mbus_id="18177641-SYS-10-14"
# bus_path="/sys/bus/platform/devices/mct_if.02.2-6-4.0/mbus"

# Beispiel fuer MBus-Modul
# mbus_id="00000264-BTR-2-2"
# bus_path="/dev/ttyS2"

# *******************************************************************


#mbus_id="18177101-SYS-10-14"
#bus_path="/sys/bus/platform/devices/mct_if.02.2-1-0.0/mbus"

#mbus_id="18177204-SYS-10-14"
#bus_path="/sys/bus/platform/devices/mct_if.08.2-2-0.0/mbus"

#mbus_id="00000264-BTR-2-2"
mbus_id="00330814-ABB-2-2"
#mbus_id="10144617-NZR-1-4"
bus_path="/dev/ttyS2"

# *******************************************************************

# slaveSearch
#./mbus_test $bus_path 0 9600 0 SLAVE_SEARCH 0

# Primaeradresse loeschen
#./mbus_test $bus_path 0 9600 $mbus_id RESET_PRIMARY_ADDRESS 0

#Primaeradresse setzen
#./mbus_test $bus_path 0 9600 $mbus_id SET_PRIMARY_ADDRESS 0

# Abfragen Adress-Liste
#./mbus_test $bus_path 0 0 0 GET_ADDRESS_LIST 0

# Reset Adress-Liste (n.b.)
#./mbus_test $bus_path 0 0 0 RESET_ADDRESS_LIST 0

# -------------------------------------------------------------------

# Pruefen, ob Geraet vorhanden ist
#./mbus_test $bus_path 0 9600 $mbus_id CHECK_SEC_ADDRESS 0

# Hallo (SND_NKE)
#./mbus_test $bus_path 0 9600 $mbus_id HALLO 0

# Hallo extended (Datenabfrage OK?)
#./mbus_test $bus_path 0 9600 $mbus_id HALLO_EXT 0

# GetData (REQ_UD2) - JSON
#./mbus_test $bus_path 0 9600 $mbus_id GET_DATA 0

# GetRawData (n.b.) - binary
# Binaer-File, Ausgabe nicht auf Konsole
./mbus_test $bus_path 20 9600 $mbus_id GET_RAW_DATA 0

# GetStructData (n.b.) - DIF / VIF / DAT
./mbus_test $bus_path 30 9600 $mbus_id GET_STRUCT_DATA 0


# -------------------------------------------------------------------

# Baudrate setzen
#./mbus_test $bus_path 0 9600 $mbus_id SET_BAUDRATE 9600

# Freeze
#./mbus_test $bus_path 0 9600 $mbus_id FREEZE_DATA 0

# Control
#./mbus_test $bus_path 0 9600 $mbus_id SND_UD_RESET_CTRL 0xe2

# -------------------------------------------------------------------

# Digital-Ausgaenge von IOs setzen (SND_UD), 1 Byte
# Parameter 0 = alles aus, 1 = Output 1 gesetzt, 2 = Output 2 gesetzt, 3 = Output 1 und 2 gesetzt usw.

#./mbus_test $bus_path 0 9600 $mbus_id SND_UD_CTRL 2


# -------------------------------------------------------------------

# Analog-Ausgaenge von IOs setzen (SND_UD), 2 Byte
# U-Ausgang 0 ... 10V, 10mV-Schritte, Wert = 10 Bit Breite = 2¹° = 1024 Stufen (genau: 0 bis 10,24V)
# I-Ausgang 0 ... 20mA, 10uA-Schritte, Wert = 11 Bit Breite = 2¹¹ = 2048 Stufen (genau: 0 bis 20,48mA)

# Setzen Wert auf 4,00 V (mct_spi_aio)
#mbus_id="18177204-SYS-10-14"
#bus_path="/sys/bus/platform/devices/mct_if.08.2-2-0.0/mbus"
#./mbus_test $bus_path 0 9600 $mbus_id SND_UD_CTRL_U 400

# Setzen Wert auf 18 mA (mct_spi_aio)
#mbus_id="18177206-SYS-10-14"
#bus_path="/sys/bus/platform/devices/mct_if.08.2-2-0.0/mbus"
#./mbus_test $bus_path 0 9600 $mbus_id SND_UD_CTRL_I 1800



# *******************************************************************
# *******************************************************************



