#!/bin/sh
echo Starting HC25 initialization script
PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
NAME="siemens HC25"
DESC="driver modules for HC25"
SCRIPT=/etc/init.d/$NAME
WLOOP=0
d_detect(){
      while [ `lsusb | grep -c ":"` -lt 2 ]
      do sleep 1
	WLOOP=`expr $WLOOP + 1`
	if [ $WLOOP = 120 ]; then
		exit 1
	fi
      done

      lsusb
      case `lsusb | grep -o "0681:[0-9][0-9][0-9][0-9]"` in
            0681:0040)
                  echo found HC25 MdmNet
                  modprobe usbserial vendor=0x0681 product=0x0040
                  sleep 2
                  echo send at^susb
                  echo AT^SUSB="Startup","Mdm" > /dev/ttyUSB0
                  echo AT^SUSB="MdmNet/TO","0" > /dev/ttyUSB0
                  sleep 1
                  echo reset module
                  echo AT+CFUN=1,1 > /dev/ttyUSB0
                  echo remove usb serial
                  rmmod usbserial
                  sleep 2
                  d_detect
            ;;
            0681:0047)
                  echo found HC25 Mdm
                  echo load usbserial kernel module
                  modprobe usbserial vendor=0x0681 product=0x0047
                  echo "HC25 is reachable over /dev/ttyUSB0 (application
port) and /dev/ttyACM0 (modem port)"
            ;;
            0681:0041)
                  echo Hc25 detected as mass storage
                  exit 3
            ;;
            *)
                  echo no HC15 detected 
                  exit 2
            ;;
      esac
}
d_start(){
      case `lsusb | grep -o "1d6b:0001"` in
            1d6b:0001)
      		echo "load kernel modules cdc_acm"
     		modprobe cdc_acm
		d_detect
	    ;;
	    *)
		echo "load kernel modules ohci-hcd"
		modprobe ohci-hcd
	    ;;
      esac

      
}

d_stop(){
      echo "delete kernel modules usbserial and cdc_acm"
      rmmod usbserial 2>/dev/null || true
      rmmod cdc_acm 2>/dev/null || true
}
case $1 in
      start|restart)
            echo "starting $DESC: $NAME"
            d_stop
            sleep 1
            d_start
            echo done;
      ;;
      stop)
            echo "stopping $DESC: $NAME"
            d_stop;
            echo done;
      ;;
      *)
            echo "usage: $SCRIPT {start|stop|restart}" >&2
            exit 1
      ;;
esac
exit 0


