/**********************************************************************************************
	JS functions for bacnet

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 03.2018

***********************************************************************************************/


/*
	Anmerkungen:

	Einige Eintrage werden zwar uebertragen, aber nicht angezeigt.
	(Siehe Projekt_Bacnet-Server_v1.6a.doc, Seite 19.)
	Diese werden im localObj gepspeichert und so gesendet wie empfangen.
	Dazu gehoeren:
	database-revision
	bbmd-bdt 0
	bbmd-bdt 1
	bbmd-fdt 0

*/

// ********************************************************************************************

var localObj = {};

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Titel anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Daten holen
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObj)
{
	// var actString = JSON2.stringify (actObj, null, 4);
	// alert (actString);

	document.f_bacnet_device.instance.value = actObj.device.instance;
	document.f_bacnet_device.object_name.value = actObj.device.object_name;
	document.f_bacnet_device.description.value = actObj.device.description;
	document.f_bacnet_device.location.value = actObj.device.location;

	document.f_bacnet_device.bacnet_ip_udp_port.value = actObj.network_port_0.bacnet_ip_udp_port;
	document.f_bacnet_device.bbmd_ip_address.value = actObj.network_port_0.bbmd_ip_address;
	document.f_bacnet_device.bbmd_ip_udp_port.value = actObj.network_port_0.bbmd_ip_udp_port;
	document.f_bacnet_device.bbmd_time_to_live.value = actObj.network_port_0.bbmd_time_to_live;

	if (actObj.active == "0")	document.f_bacnet_device.bacnet_start.checked = false;
	else						document.f_bacnet_device.bacnet_start.checked = true;

	// Objekt global speichern fuer getObjectProperties()
	localObj = actObj;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		// damit die database_revision aktuell ist, wird 3s nach dem Senden der
		// aktualisierte Stand wieder eingelesen
		setTimeout ("top.document.getElementById('button_1').onclick()", 3000);	

		// Werte ermitteln	
		var changedObject = getChangedValues();
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// Geaenderte Werte fuer den EWIO
function getChangedValues ()
{
	if (localObj.device != undefined)
	{
		localObj.device.instance = document.f_bacnet_device.instance.value;
		localObj.device.object_name = document.f_bacnet_device.object_name.value;
		localObj.device.description = document.f_bacnet_device.description.value;
		localObj.device.location = document.f_bacnet_device.location.value;
		localObj.network_port_0.bacnet_ip_udp_port = document.f_bacnet_device.bacnet_ip_udp_port.value;
		localObj.network_port_0.bbmd_ip_address = document.f_bacnet_device.bbmd_ip_address.value;
		localObj.network_port_0.bbmd_ip_udp_port = document.f_bacnet_device.bbmd_ip_udp_port.value;
		localObj.network_port_0.bbmd_time_to_live = document.f_bacnet_device.bbmd_time_to_live.value;
	}
	if (document.f_bacnet_device.bacnet_start.checked == true)	localObj.active = "1";
	else														localObj.active = "0";
	return (localObj);
}

// ********************************************************************************************
// ********************************************************************************************










