/**********************************************************************************************
	JacaScript Module: Tabs 
	
	Parts of code borrowed from 
		http://www.webmasterworld.com/javascript/3647600.htm
		timur@creativecodedesign.com, http://www.creativecodedesign.com

    Script:	guiTabs.js
    Author:	Ralf Stiawa
    License:	LGPL
    Notes:	Displays Tabs via DHTML
    Usage:	see example below	          

***********************************************************************************************/





// **********************************************************************************************
// **********************************************************************************************

var guiTabs = new function() 
{
	
	// Pfad fuer die Images (Kreuz rechts oben)
	var pathImages = "style/images/";
	
	var self = this;
	var x; 			// The current x position of the user's mouse
	var y; 			// The current y position of the user's mouse
	var xOffSet; 	// The difference between where the x position of the user's mouse is and 
					// where the left side of the div is
	var yOffSet; 	// The difference between where the y position of the user's mouse is and 
					// where the top side of the div is

	var oldIEComp = 1;	// workaround fuer IE6/IE7 (ab IE8 OK, Firefox etc sowieso)

	var nameTab;		// div des tab funktionsweit speichern (fuer this.Select)
	var nameContent;	// div des content funktionsweit speichern (fuer this.Select)
	var numTab;			// Anzahl tabs funktionsweit speichern (fuer this.Select)

	// Style der Tabs	
	var tab_height = 15;	// Tab - Hoehe
	var tab_width = 90;		// Tab - Breite
	var padding_top = 2;	// Innenabstand Tab-Oberkante - Text
	var border = 2;			// Rahmendicke (siehe css-Datei, tab_round / tab_square)

	// --------------------------------------------------------------
	// Create tabs
	this.Create = function (strDivID, tabText, tabNum, strType, iWidth, iHeight, strDragBox)
	{
		// initial position
		var iScreenCenterX; 	
        var iScreenCenterY; 

		// drag & drop
		this.dragbox = strDragBox;
		
		// Popup-Window
		this.width = iWidth;	
		this.height = iHeight;	

		// Popupbox soll nur einmal gestartet werden
		if (document.getElementById(strDivID) != null)
			return;

		// safe name
		self.nameTab = strDivID;	
		self.numTab = tabNum;
		
        // populate browser-specific screen center coordinates
		this.GetScreenCenter(this);						

        var strStyle = 
			"width: " + iWidth + "px;" +
			"height: " + tab_height + "px;" + 
			"left: " + (this.iScreenCenterX - iWidth / 2) + "px;" + 
			"top: "	+ (this.iScreenCenterY - iHeight / 2 - (tab_height + border + padding_top)) + "px;";	
		// create the outer DIV
		this.oPopupDiv = this.CreateDiv(strDivID, "tabbase", strStyle, "");		

		var oTabDiv = new Array();
		for (var i=0; i<tabNum; i++)
		{
			// Tabs hintereinander
			var tabDiff = tab_width + 20;		// Abstand zwischen den linken Kanten zweier Tabs (siehe auch css: tab)					
			var shift = (i * tabDiff) + 10;
			strStyle = 	"margin-left: " + shift + "px;" + 
						"padding-top: " + padding_top + "px;" +
						"width: " + tab_width + "px;" +
						"height: " + tab_height + "px;" +
						"position: fixed";						// position fixed, even if scrolled									
			
			// neues DIV fuer Einzel-Tab erzeugen und Tab beschriften
			var tabdiv = strDivID+i;
			oTabDiv[i] = this.CreateDiv (tabdiv, "tab_square", strStyle, tabText[i]);

			// onclick
			switch (i)
			{
				case 0:	oTabDiv[0].onclick = function() {self.Select(0);};	break;
				case 1:	oTabDiv[1].onclick = function() {self.Select(1);};	break;
				case 2:	oTabDiv[2].onclick = function() {self.Select(2);};	break;
				case 3:	oTabDiv[3].onclick = function() {self.Select(3);};	break;
				case 4:	oTabDiv[4].onclick = function() {self.Select(4);};	break;
				case 5:	oTabDiv[5].onclick = function() {self.Select(5);};	break;
				case 6:	oTabDiv[6].onclick = function() {self.Select(6);};	break;
				case 7:	oTabDiv[7].onclick = function() {self.Select(7);};	break;
				case 8:	oTabDiv[8].onclick = function() {self.Select(8);};	break;
				case 9:	oTabDiv[9].onclick = function() {self.Select(9);};	break;
				default:
					alert ("guiTabs: Fehler, max. 10 Tabs definiert!");		break;
			}
				
			// hover	
			if (oldIEComp)
			{
				oTabDiv[i].onmouseover = function() 
				{
					this.style.color = '#FF0000';    // rot
				};
	
				oTabDiv[i].onmouseout = function() 
				{
					this.style.color = '#046AAC';    // blau
				};
			}
			else
			{
				oTabDiv[i].setAttribute ("onMouseOver", 
								"this.style.color = '#FF0000';");    
		
				oTabDiv[i].setAttribute ("onMouseOut", 
								"this.style.color = '#046AAC';");    
			}

			// tabs in Eltern-DIV einfuegen
			this.oPopupDiv.appendChild(oTabDiv[i]);
		}
	
		// Eltern-DIV in body einfuegen
		document.body.appendChild(this.oPopupDiv);

		// make the outer DIV visible
        this.oPopupDiv.style.visibility = 'visible';	
		
		// Selection verhindern
		this.disableSelection(this.oPopupDiv); 
			
		// alert (document.body.innerHTML);
	}

	// --------------------------------------------------------------
	// Create content
	this.Content = function (strDivID, tabContent, tabNum, strType, iWidth, iHeight, strDragBox, selectable)
	{
		// initial position
		var iScreenCenterX; 	
        var iScreenCenterY; 

		// drag & drop
		this.dragbox = strDragBox;
		
		// Popup-Window
		this.width = iWidth;	
		this.height = iHeight;	

		// safe name
		self.nameContent = strDivID;	

		
		for (var i=0; i<tabNum; i++)
		{
			var id = strDivID + i;
		
			// Popupbox soll nur einmal gestartet werden
			if (document.getElementById(id) != null)
			{
				return;
			}
		
			this.GetScreenCenter(this);						// populate browser-specific screen center coordinates
			var strStyle = "width: " + iWidth + "px; height: " + iHeight + "px;left: "
				+ (this.iScreenCenterX - iWidth / 2) + "px;top: "								// place the box in
				+ (this.iScreenCenterY - iHeight / 2) + "px;"									// the middle of the client region
				+ "position: fixed;";															// fixed, even if scrolled
			this.oPopupDiv = this.CreateDiv(id, "ccPopup", strStyle, "");					// create the outer DIV

			
			var oIcondDiv = this.CreateDiv(null, "ccPopup" + strType + "Icon", null, "&nbsp");	// place the proper icon style
			var oMessageDiv = this.CreateDiv(null, "ccPopupMessage", null, tabContent[i]);			// add message
			
	        this.oPopupDiv.appendChild(oIcondDiv);
			this.oPopupDiv.appendChild(oMessageDiv);
			document.body.appendChild(this.oPopupDiv);
			this.oPopupDiv.style.visibility = 'visible';	// make the outer DIV visible

			// no selection	
			if (!selectable)
				this.disableSelection(this.oPopupDiv); 

			// alert (document.body.innerHTML);
		}	
		
	}
		
	// --------------------------------------------------------------
    // CreateDiv:	creates and returns a DIV object with specified attributes
    // strDivID:	the ID of the DIV being created or null if none
    // strDivClass:	the class of the DIV
    // strDivStyle:	any addional styles for the DIV
    // strDivHTML: 	the inner HTML     
    this.CreateDiv = function(strDivID, strDivClass, strDivStyle, strDivHTML) 
	{
        var oReturnObject = document.createElement('div');
        if (strDivID != null)
		{
			if (oldIEComp)	
				this.SetAttribute (oReturnObject, 'id', strDivID);
			else
	            oReturnObject.setAttribute('id', strDivID);
    	}
	    if (strDivClass != null)
		{
			if (oldIEComp)	
				this.SetAttribute (oReturnObject, 'class', strDivClass);
			else
	            oReturnObject.setAttribute('class', strDivClass);
		}
        if (strDivStyle != null)
		{
			if (oldIEComp)	
				this.SetAttribute (oReturnObject, 'style', strDivStyle);
			else
	            oReturnObject.setAttribute('style', strDivStyle);
		}
        if (strDivHTML)
            oReturnObject.innerHTML = strDivHTML;
        return oReturnObject;
    }

	// --------------------------------------------------------------
    // SetAttribute:   workaround for setAttribute, that has no effect in IE6 / IE7
    this.SetAttribute = function(obj, attribute, value)
	{
		if (attribute == 'style') 
		{
			// special case 'style'
			if (obj.style.setAttribute)
				obj.style.setAttribute ('cssText', value);
			else
				obj.setAttribute (attribute, value);
		}
		else
		{
			// all other
			var newattr = document.createAttribute (attribute);
		    newattr.nodeValue = value;
			obj.setAttributeNode(newattr);
		}
		// alert (attribute+"   "+value);	
	}

	// --------------------------------------------------------------
    // GetScreenCenter:     Code borrowed from http://www.webmasterworld.com/javascript/3647600.htm
    // Attempts to deremine the center of the visible browser area in an browser independ-ish fashion
    this.GetScreenCenter = function(oInstance) 
	{
		var centerX, centerY;			// get the client center
		
		if (oInstance.dragbox == "window") 
		{
			if (window.innerHeight) 
			{
				centerX = window.innerWidth;
				centerY = window.innerHeight;
			} 
			else if (document.documentElement && document.documentElement.clientHeight) 
			{
				centerX = document.documentElement.clientWidth;
				centerY = document.documentElement.clientHeight;
			} 
			else if (document.body) 
			{
				centerX = document.body.clientWidth;
				centerY = document.body.clientHeight;
			}                                                                                  
			oInstance.iScreenCenterX = (centerX / 2);
			oInstance.iScreenCenterY = (centerY / 2);
		}
		else
		{	
			// Bereichsgrenzen = DIV (in zugehoerigem style festgelegt)
			var border = document.getElementById(self.dragbox);
			var border_top = border.offsetTop;
			var border_left = border.offsetLeft;
			var border_bottom = border.offsetHeight + border_top;
			var border_right = border.offsetWidth + border_left;
		
			oInstance.iScreenCenterX = border_left + ((border_right - border_left) / 2);
			oInstance.iScreenCenterY = border_top + ((border_bottom - border_top) / 2);
		}
    }

	// --------------------------------------------------------------
	// Selektieren von Elementen der MessageBox verhindern
	this.disableSelection = function (segment)
	{
		segment.style.cursor = "default";
		// Firefox	
		if (typeof segment.style.MozUserSelect != "undefined")
			segment.style.MozUserSelect = "none";
		// IE
		else if (typeof segment.onselectstart != "undefined") 
			segment.onselectstart = function(){return false};
		// Opera etc.
		else
			segment.onmousedown = function(){return false};
	}	

	// --------------------------------------------------------------
	// select a tab
	this.Select = function (tabSel)
	{
		if ((!self.nameTab) || !(self.nameContent)) 
			return;
		
		// alert ("Select    "+self.nameTab+"   "+self.nameContent+"   "+self.numTab+"   "+tabSel);
		
		for (var i=0; i<self.numTab; i++)
		{
			document.getElementById(self.nameContent + i).style.visibility = 'hidden';
			document.getElementById(self.nameTab + i).style.borderBottomColor = '#046AAC';		// blau
			document.getElementById(self.nameTab + i).style.backgroundColor = '#A2A2A2';		// dunkelgrau
		}
		
		document.getElementById(self.nameContent + tabSel).style.visibility = 'visible';
		document.getElementById(self.nameTab + tabSel).style.borderBottomColor = '#D6D3D6';		// grau
		document.getElementById(self.nameTab + tabSel).style.backgroundColor = '#D6D3D6';		// grau
	}

	// --------------------------------------------------------------
	// close the Tabs
	this.CloseTabs = function (id)
	{
		if (id == self.nameContent)	
		{
			// content
			for (var i=0; i<self.numTab; i++)
			{	
				var node = document.getElementById(id + i);
				node.parentNode.removeChild(node);
			}
		}
		else
		{
			// tab
			var node = document.getElementById(id);
			node.parentNode.removeChild(node);
		}
	}
	
	// --------------------------------------------------------------
	;
}



// ********************************************************************************************







// **********************************************************************************************
// Aufruf - Beispiel
// **********************************************************************************************
/*
function tabs_open ()
{

	// Tabs
	var tabText = new Array();
	tabText[0] = "tab 0";
	tabText[1] = "tab 1";
	guiTabs.Create ("tab", tabText, tabText.length, 'Tools', 500, 200, "popup_area");

	// Inhalt	
	var tabContent = new Array();
	tabContent[0] = "Das ist der Text. <br>" +
					"Und das ist noch mehr Text.<br>" +
	
					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="tabs_close(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="tabs_close(0)">'+
					'</div>';

	tabContent[1] = "Das ist der Text. <br>" +
	
					'<div id="button_position">'+
					'<input type="button" class="button_ok" name="ok" value="OK" onClick="tabs_close(1)">'+
					'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="tabs_close(0)">'+
					'</div>';

	guiTabs.Content ("popup", tabContent, tabContent.length, 'Tools', 500, 200, "popup_area", false);


	// default-Tab setzen
	guiTabs.Select (0);

}

function tabs_close (make)
{
	if (make)
		alert ("hallo, todo something ... ");
		
	// Tabs schliessen	
	guiTabs.CloseTabs ("tab");
	guiTabs.CloseTabs ("popup");
}
*/
// **********************************************************************************************
// **********************************************************************************************

