/**********************************************************************************************

	JS functions for io.htm

	Copyright (c) 2008 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		05/2010

***********************************************************************************************/


/*
	Anmerkungen:
	- Maximale Verschachtelungstiefe von JSON- Objekten = 10
	  (Siehe Fkt. getIO().)
	- Max. Anzahl DIVs (= max. Anzahl belegter Zeilen) siehe MAX_DIVS 
*/

var DEBUG_IO = 0;			// Ausgaben
var MAX_DIVS = 255;			// Max. Anzahl an dynamisch erzeugten DIVs
var localObject;
var io_page;
var json_schema;

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initIO()
{
	// Namen der Page ermitteln
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = io_page = page[0];

	// wenn mct_paa_master, dann gesonderte Anzeige
	if (io_page == "mct_paa_master")
	{	
		top.getDataExtended ("test", "connection", "top.frame_content.setMasterPage(actStr)");
		return;
	}

	// Die Daten fuer json-schema anfordern
	top.getDataExtended (io_page, "schema", "top.frame_content.setSchema(actStr)");
}

// ********************************************************************************************




// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen
function setObjectProperties (actObject)
{
	// Werte setzen	
	setIO (actObject);		

	// Objekt global speichern fuer getObjectProperties()
	localObject = actObject;	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen
function getObjectProperties()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		// wenn mct_paa_master, dann gesonderte Daten senden
		if (io_page == "mct_paa_master")
		{	
			var state = document.getElementById ('id_radio_0').checked;
			var jStr = '{"stop":'+state+'}';			
			top.setDataExtended ("mct_paa_master", "restart", jStr);
			
			// Messagebox setzen
			top.messageBox_Wait();
			setTimeout ("top.hideMessageBox()", 20000);

			// Navigation refreshen	
			setTimeout ("top.frame_tree.shadeTree (1)", 20000);		
			setTimeout ("treeRefresh()", 21000);
			return;
		}

		// Werte ermitteln		
		var changedObject = getIO(localObject);
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************

// Zusaetzliche Daten fr den Seitenaufbau

// JSON-Schema ermitteln
function setSchema (actStr)
{
	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	var obj = JSON2.parse(actStr);

	// $ref innerhalb des Schemas expandieren
	json_schema = expandSchema (obj, obj);

	// Die Eigenschaften der content-page setzen
	top.getData();
}

// ********************************************************************************************
// Schema mit $ref-Objekten expandieren
function expandSchema (oAll, oPart)
{
	
	// durch das gesamte Objekt hangeln und rekursiv alle Elemente ermitteln
	for (var prop in oPart) 
	{
		if (typeof(oPart[prop]) == "object") 
		{
			if (oPart[prop].$ref != undefined)
			{
				// Objekt mit $ref gefunden
				// alert ("Objekt mit property $ref: " + prop);
				
				// Inhalt des Objekts austauschen
				var oReplace = getObject (oAll, oPart[prop].$ref);
				if (oReplace == undefined)
					alert ("kein Replace-Objekt zu " + oPart[prop].$ref + " gefunden");
				else
				{
					oPart[prop] = oReplace;
					// alert (JSON.stringify (oPart, null, 4));
				}
			}
		
			// innerhalb eines Objektes rekursiv weitersuchen
			expandSchema (oAll, oPart[prop]);		
		}
	}
	
	return oPart;
}

// ********************************************************************************************

// Objekt suchen, das durch das element bezeichnet wird
// z.Zt. werden nur Objekte in der Wurzel gesucht
function getObject (obj, element)
{
	// Element aus dem String der Form #.element extrahieren
	var elArr = element.split (".");
	
	// Element im Objekt suchen	
	for (var prop in obj) 
	{
		if (typeof(obj[prop]) == "object") 
		{
			// alert ("prop = " + prop + "\nelement = " + elArr[1]);
			if (prop == elArr[1])
			{
				return (obj[prop]);
			}
		}
	}
}

// ********************************************************************************************







// ********************************************************************************************
// ********************************************************************************************

// Werte fuer IO ermitteln und in JSON-Objekt setzen
function getIO (jObject)
{
	var div;
	var element;
	var eArr;
	var value;
	var name;


	for (var i=0; i<formProp.length; i++)
	{
		// Wenn formName vorhanden ist, dann muss der entsprechende Wert uebernommen werden
		if (formProp[i].formName)
		{
			if (formProp[i].form == "radio")
			{
				name = eval ("document."+formProp[i].formName+".r0");
				for (var j=0; j<formProp[i].validVal.length; j++)
				{
					if (name[j].checked == true)
						value = name[j].value;
				}
			}
		
			if ((formProp[i].form == "simple") ||
				(formProp[i].form == "list"))
			{
				// Value von Form ermitteln
				// alert ("document."+formProp[i].formName+".element");
				name = eval ("document."+formProp[i].formName+".element");
				if (name)
					value = name.value;
				else
				{
					alert ("Fehler beim Lesen von element "+i);	
					return;	
				}
			}	

			// Auswertung string, number, ...
			if (formProp[i].valtype == "number")
			{
				value = parseFloat(value);
				if (isNaN(value))					// Ignorieren, da keine Zahl
					continue;
			}
			else
				value = value+'';

			// Objektelement aus der formProp ermitteln
			element = formProp[i].element;

			// split element to Array
			// element[x] ->element.x
			element = element.replace(/\[/g, ".");	// regular expression, weil mehrfach ersetzen
			element = element.replace(/\]/g, "");	// regular expression, weil mehrfach ersetzen
			eArr = element.split(".");				// e0.e1.e2 -> Array
			
			if (DEBUG_IO)	alert ("element: "+eArr+"   value: "+value);
				
			switch (eArr.length)
			{
				default:
				case 0: break;
				case 1: jObject[eArr[0]+''] = value;	break;
				case 2: jObject[eArr[0]+''][eArr[1]+''] = value;	break;
				case 3: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''] = value;	break;
				case 4: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''][eArr[3]+''] = value;	break;
				case 5: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''][eArr[3]+''][eArr[4]+''] = value;	break;
				case 6: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''][eArr[3]+''][eArr[4]+''][eArr[5]+''] = value;	break;
				case 7: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''][eArr[3]+''][eArr[4]+''][eArr[5]+''][eArr[6]+''] = value;	break;
				case 8: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''][eArr[3]+''][eArr[4]+''][eArr[5]+''][eArr[6]+''][eArr[7]+''] = value;	break;
				case 9: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''][eArr[3]+''][eArr[4]+''][eArr[5]+''][eArr[6]+''][eArr[7]+''][eArr[8]+''] = value;	break;
				case 10: jObject[eArr[0]+''][eArr[1]+''][eArr[2]+''][eArr[3]+''][eArr[4]+''][eArr[5]+''][eArr[6]+''][eArr[7]+''][eArr[8]+''][eArr[9]+''] = value;	break;
			}
		}
	}	
	
	if (DEBUG_IO)	
	{
		var actString = JSON2.stringify (jObject);
		alert (actString);
	}

	// Countdown setzen	
	window.scrollTo(0,0);
	io_setCountdown ();

	return (jObject);
}


// ********************************************************************************************
// ********************************************************************************************
// ********************************************************************************************
// Werte aus dem JSON-Objekt setzen

// Werte fuer IO entsprechend JSON-Objekt setzen
function setIO (jObject)
{

	var actString = JSON2.stringify (jObject);
	// alert (actString);
	var jsObject = JSON2.parse(actString);	
	
	var result = JSONSchema.validate(jsObject, json_schema);

	// Ausertung Ergebnis:
	// result.valid = true		-> OK
	// result.valid = false		-> Fehler-Array, siehe naechste Zeile
	// result.errors[i]. property = ...	result.errors[i].message = ...

	if (DEBUG_IO)	alert ("validation result = "+result.valid);
	var errorStr = "error list:\n\n";
	if (result.valid == false)
	{
		// error list
		var arrAll = getObjectsAsArray(result.errors);
		var	arr = arrAll[0];
		var	val = arrAll[1];

		for (var i=0; i<arr.length; i++)
		{
			errorStr += (arr[i]+":  "+val[i].property+" = "+val[i].message+"\n");
		}
		alert (errorStr);
		return;
	}
		
	
	// CREATE FORMS - ARRAY
/*
	Folgende Eigenschaften werden gespeichert:
	- name			// Objektname, fuer Strukturierung
	- key				// Schluesselwort
	- value			// Wert
	- form			// Art der Form (simple / list / radio),
					// simple = einfaches Feld,  list = ComboBox, radio = Radiobuttons
	- label			// bei form = list: 	sichtbarer Eintrag in der Liste
	- listVal			// bei form = list:	ausgewaehlter Wert aus der Liste
	- validVal			// Voreinstellung gueltiger Werte
	- readOnly			// Wert soll nur lesbar sein
	- maxLength		// Wert darf nur max. Anzahl von angegebenen Zeichen haben
	- maximum		// Wert darf angegebenes Maximum nicht ueberschreiten (R.S. 09.02.11)
	- element			// Objektpfad
	- valtype			// Type des values (string, number, ...)
	- hidden			// true = Element wird nicht dargstellt
*/
	// Ausgabe Tabelle
	if (DEBUG_IO)	
		alert ("Tabelle enthlt "+formProp.length+" Eintraege");
	var buf = "";
	for (var i=0; i< formProp.length; i++)
	{
		buf = "Eintrag "+i+"  ----------------------------------------------------------- \n";
		buf += "name = \t"+formProp[i].name+"\n";
		buf += "key = \t"+formProp[i].key+"\n";
		buf += "value = \t"+formProp[i].value+"\n";
		buf += "form = \t"+formProp[i].form+"\n";
		buf += "label = \t"+formProp[i].label+"\n";
		buf += "listVal = \t"+formProp[i].listVal+"\n";
		buf += "validVal = \t"+formProp[i].validVal+"\n";
		buf += "readOnly = \t"+formProp[i].readOnly+"\n";
		buf += "maxLength = \t"+formProp[i].maxLength+"\n";
		buf += "maximum = \t"+formProp[i].maximum+"\n";
		buf += "element = \t"+formProp[i].element+"\n";
		buf += "valtype = \t"+formProp[i].valtype+"\n";
		buf += "hidden = \t"+formProp[i].hidden+"\n";

		if (DEBUG_IO)	
			alert (buf);
	}
	
	// evtl. vorhandene Forms loeschen
	removeElements (MAX_DIVS);
		
	// Erzeugen der Forms aus den Angaben von formProp
	var cnt = 1;
	var formLen;
	var str = "";
	var insStr = "";
	var radioStr = "";
	var checkStr = "";
	var formName = "";
	var list;
	var radioVertical = true;
	var readOnly = false;

	
	for (var i=0; i<formProp.length; i++)
	{
	
		// hidden element
		if (formProp[i].hidden == true)
			continue;

		// Name, steht einzeln
		if (formProp[i].name)
		{
			str = '<B><U> '+formProp[i].name+' </U></B>';
			addFormElement("p"+setLeadNull(cnt)+"00", str);

			//var position = getObjectPosition (formProp[i].name);
			//alert (position);		
		}

		// key
		if (formProp[i].key)
		{
			// 23.10.09
			// Wenn ein Element im Schema enthalten ist, aber nicht im Objekt,
			// dann ist sein Value nicht definiert;
			// In diesem Fall keine Anzeige!				
			if (formProp[i].value == undefined)
			{	
				continue;
			}

			addFormElement("p"+setLeadNull(cnt)+"00", formProp[i].key);
				
			// value zum key, steht dahinter, abhaengig von form	
			if (formProp[i].form)
			{
				// form "simple" = Input-Feld
				if (formProp[i].form == "simple")
				{
					if (formProp[i].maxLength)
						formLen = formProp[i].maxLength;
					else			
						formLen = "50";

					if (formProp[i].readOnly)
						readOnly = formProp[i].readOnly;
					else			
						readOnly = false;

					if (readOnly == true)
						insStr = "readonly";
					else
						insStr = "";	


					// Konvertieren von float-hex nach float-dezimal				
					if (formProp[i].key == "Size")
					{
						if (formProp[i].value == "32")
							var convertFloatFlag = 1;
						else
							var convertFloatFlag = 0;
					}
					else if ((formProp[i].key == "Value") || (formProp[i].key == "Offset"))
					{
						if (convertFloatFlag)
							formProp[i].value = IEEE754_Hex32ToDez(formProp[i].value, 2);
					}


					formName = "form_"+i;
					str = 	'<form name="'+formName+'"><input '+
							'name="element" class="textfield" value="'+formProp[i].value+
							'" size="'+formLen+'" maxlength="'+formLen+'" '+insStr+'></form>';
					addFormElement("p"+setLeadNull(cnt)+"01", str);
					
					// Registrierung
					formProp[i].formName = formName;

					// Kontrolle
					if (DEBUG_IO)
					{
						var div = document.getElementById("p"+setLeadNull(cnt)+"01");	
						alert ("innerHTML = "+div.innerHTML);
					}
				}
				
				// form "list" = combobox
				else if (formProp[i].form == "list")
				{
					if (formProp[i].readOnly)
						readOnly = formProp[i].readOnly;
					else			
						readOnly = false;
					if (readOnly == true)
						insStr = "disabled";
					else
						insStr = "";	

					formName = "form_"+i;
					str = 	'<form name="'+formName+'">'+
							'<select '+insStr+' name="element" size=1 class="combobox long_330" onChange="checkInput()">'+
							'</select></form>';	
					addFormElement("p"+setLeadNull(cnt)+"01", str);

					// Registrierung
					formProp[i].formName = formName;

					// Listenelemente dynamisch hinzufuegen
					list = eval ("document."+formName+".element");
					list.options.length = 0;
					for (var j=0; j<formProp[i].label.length; j++)
					{
						list.options[list.options.length] = 
						new Option (formProp[i].label[j], formProp[i].listVal[j], false, false);
					
						// Alternativ: addSelectOption (formName, formProp[i].label[j])
						
						if (formProp[i].listVal[j] == formProp[i].value)
							list.selectedIndex = j;
						// alert (formProp[i].listVal[j]+"   "+formProp[i].value+"   "+j);
					}
					
					// Kontrolle
					if (DEBUG_IO)
					{
						var div = document.getElementById("p"+setLeadNull(cnt)+"01");	
						alert ("innerHTML = "+div.innerHTML);
					}
				}				

				// form "radio" = radio buttons
				else if (formProp[i].form == "radio")
				{
					if (radioVertical)	insStr = "<br>";
					else				insStr = "";
					
					radioStr = "";
					for (var j=0; j<formProp[i].validVal.length; j++)
					{	
						// checked?
						if (formProp[i].value == formProp[i].validVal[j])
							checkStr = "checked";
						else
							checkStr = "";
						radioStr += '<input type="radio" name="r0" value="'+formProp[i].validVal[j]+'" '+
									checkStr+'>'+formProp[i].validVal[j]+' '+insStr;
					}
					formName = "form_"+i;
					str = 	'<form name="'+formName+'">'+radioStr+'</form>';
					addFormElement("p"+setLeadNull(cnt)+"01", str);
					
					// Registrierung
					formProp[i].formName = formName;

					// Kontrolle
					if (DEBUG_IO)
					{
						var div = document.getElementById("p"+setLeadNull(cnt)+"01");	
						alert ("innerHTML = "+div.innerHTML);
					}
					
					// Zusaetzliche Reihen einfuegen (<br> benoetigt ca. 1/2 Reihenabstand)
					if (radioVertical)
						cnt += (Math.floor(formProp[i].validVal.length/2) + 1);		
				}
				
				// nichts von allem
				else
				{
					addFormElement("p"+setLeadNull(cnt)+"01", formProp[i].value);
				}
			}
		}
	
		//alert (cnt);
		cnt++;
	}

	// alert (document.body.innerHTML);

}

// ********************************************************************************************

// Ermitteln der Objektposition innerhalb der Hierarchie
// Die Position wird anhand der Struktur des Namens ermittelt:
// Je mehr Strukturelemente enthalten sind, umso weiter wird die Position verschoben
// Funktion kann fuer die Strukturierung der Ausgabe genutzt werden

function getObjectPosition (objName)
{
	var position = 0;

	// Anzahl Punkte und Klammern (Objekte und Arrays)
	for (i=0; i<objName.length; i++)
	{
		if (objName.charAt(i) == ".")	
			position++;

		if (objName.charAt(i) == "[")	
			position++;
	}
	return (position);
}

// ********************************************************************************************

// Ermitteln aller Teilobjekte und Eigenschaften innerhalb eines angegebenen Objektes
// param: Objekt 
// ret: Array mit enthaltenen Teil-Objekten und Eigenschaften
function getObjectsAsArray(obj)
{
	var prop = "";
	var i = 0;
	
	var arr = new Array();
	arr[0] = new Array();
	arr[1] = new Array();
	
	
	// Objekt vorhanden?
	if ( (typeof(obj) == "undefined") || (obj === null) ) 
		return (0);
		
	// Eigenschaft als string
	if (typeof(obj) == "string") 
		return (obj);

	// Eigenschaft als number -> string
	if (typeof(obj) == "number") 
		return (obj+"");

	// Objekt	
	if (typeof(obj) == "object")
	{
		for (prop in obj)
		{
			arr[0][i] = prop; 
			arr[1][i] = obj[prop];
			i++;
		}
	}
	return (arr);	// arr[0] enthaelt objekte, arr[1] enthaelt Eigenschaften
}	

// ********************************************************************************************
// Auswertung von Aenderungen einer ComboBox- Auswahl
function checkInput ()
{
	// nichts zu tun
}

// ********************************************************************************************

// DIVs und Forms werden geloescht
function removeElements (len)
{
	var div;
	var cntDiv = 0;
	var parent;
	
	
	for (var i=1; i<=len; i++)
	{
		// An erster Position stehen DIVs (mit Text)
		div = document.getElementById("p"+setLeadNull(i)+"00");
		if (div != null)
			cntDiv++;
		if (div != null)
		{
			while (div.childNodes.length > 0)
				div.removeChild(div.firstChild);
		}
			
		// An zweiter Position stehen  DIVs und Forms
		div = document.getElementById("p"+setLeadNull(i)+"01");
		if (div != null)
		{
			parent = document.getElementById('myDiv');
			parent.removeChild(div);

			while (div.childNodes.length > 0)
				div.removeChild(div.firstChild);
		}
	}

	if (DEBUG_IO)	
		alert ("Anzahl geloeschter Zeilen (DIVs) = "+(cntDiv-1));
}

// ********************************************************************************************
// ********************************************************************************************

// Dyn. Erzeugen eines HTML-Elements
function addFormElement(divIdName, formStr) 
{
	// alert ("addFormElement "+divIdName+"  "+formStr);

	// Erzeugen eines neuen DIV-Eintrags
	var ni = document.getElementById('myDiv');
	var newdiv = document.createElement('div');

/*
	// so kann bei allen Browsern (ausser bei IE6/7) ein neues Attribut angelegt werden,
	// auch IE8 und folgende verstehen das
	newdiv.setAttribute('id',divIdName);
	newdiv.setAttribute('class','pos '+divIdName);
*/

	// workaround, um auch durch (Sch..-) IE6/7 verstanden zu werden
	var newid = document.createAttribute ('id');
    newid.nodeValue = divIdName;
	newdiv.setAttributeNode(newid);

	var newclass = document.createAttribute ('class');
    newclass.nodeValue = 'pos '+divIdName;
	newdiv.setAttributeNode(newclass);

	// neue Elemente in Seite einfuegen
	newdiv.innerHTML = formStr;	
	ni.appendChild(newdiv);
	// aleternativ: document.body.appendChild(newdiv);
}

// ********************************************************************************************

// Hinzufuegen einer select-option zu einer combobox
function addSelectOption (formName, optionStr)
{
	// alert ("addSelectOption "+formName+"  "+optionStr);

	var selElement = eval ("document."+formName+".select");
	var o; 
	o = document.createElement("OPTION");					// option erzeugen
	o.appendChild (document.createTextNode(optionStr));		// text
	selElement.appendChild(o);								// option anhaengen
}

// ********************************************************************************************
// ********************************************************************************************

// Fuehrende Null setzen (bei zweistelligem Wert, z.B. min, sec etc.)
function setLeadNull (value)
{
	value = (value < 10) ? "0"+value : value;
	return (value);
}

// ********************************************************************************************
// ********************************************************************************************

var int_io = 0;
var io_counter = 5;			// Zeit fuer Countdown


// Countdown-Message anzeigen fuer Konfiguration setzen
function io_setCountdown ()
{

	var headline = '<B>'+ins("io_hd_setConf")+'</B>';
	content =		'<form name="form_setConf">'+ 		
					'<div class="pos x0101 textfield">'+ins("io_wait_setConf")+'</div>'+
					'<div class="pos x0401">'+
					'<input type="text" name="countdown" class="textfield_show" size="30" readonly="readonly" value="">'+		
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Info', 400, 140, "window");

	// Countdown-String aktualisieren
	int_io = setInterval ('io_countDownCalculator()', 1000);
}


function io_countDownCalculator ()
{

	var str = ""+ ins("io_wait_setTimeInSec") + io_counter;
	if (document.form_setConf.countdown)	
		document.form_setConf.countdown.value = str;

	io_counter--;
	if (io_counter < 0)
	{
		io_counter = 5;	
		clearInterval (int_io);
	
		// countdown-pad schliessen
		guiPopup.CloseMe("message");
	}
}

// ********************************************************************************************
// ********************************************************************************************

// Konvertierung eines Float-Wertes in Hex-Darstellung in Dezimal-Notation
function IEEE754_Hex32ToDez (hexstr, n)
{
	var dez,bin1,bin2,bin3,bin4,bin,sign,expo,mant,nul8="00000000";

	bin1=nul8+parseInt(hexstr.substr(0,2),16).toString(2);
	bin2=nul8+parseInt(hexstr.substr(2,2),16).toString(2);
	bin3=nul8+parseInt(hexstr.substr(4,2),16).toString(2);
	bin4=nul8+parseInt(hexstr.substr(6,2),16).toString(2);

	bin1=bin1.substr(bin1.length-8,8);
	bin2=bin2.substr(bin2.length-8,8);
	bin3=bin3.substr(bin3.length-8,8);
	bin4=bin4.substr(bin4.length-8,8);

	bin=bin1+bin2+bin3+bin4;

	sign=parseInt(bin.charAt(0),2);    // Vorzeichen
	expo=parseInt(bin.substr(1,8),2);  // Exponent
	mant=parseInt(bin.substr(9,23),2); // Mantisse

	dez=(1-2*sign)*Math.pow(2,expo-127)*(1+mant/Math.pow(2,23));

	// Runden auf n Stellen hinter dem Komma
	return(dez.toFixed(n));
}

// ********************************************************************************************
// ********************************************************************************************

// Seite fuer mct_paa_master aufbauen
function setMasterPage (actStr)
{

	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;

	// Erzeugen eines neuen DIV-Eintrags mit Beschreibertext
	addElement_div ('myDiv', 'id_desc', 'pos x0200', '');
	add_innerHTML ('id_desc', ins("io_restart_desc"));

	// Erzeugen eines neuen DIV-Eintrags
	addElement_div ('myDiv', 'id_master', '', '');

	// Erzeugen radio-buttons und text
	addElement_radio ('id_master', 'id_radio_0', 'r0', 0, true, 'pos x0401');
	add_text ('id_master', 'STOP', 'pos', 'top:0095px; left:0070px;');
	addElement_radio ('id_master', 'id_radio_1', 'r0', 1, false, 'pos x0501');
	add_text ('id_master', 'START', 'pos', 'top:0120px; left:0070px;');

	// Erzeugen Icon "Info"
	addElement_img ('id_master', 'style/info_blue.png', 'pos x0003 icons_little', ''); 

	// Erzeugen eines neuen DIV-Eintrags mit Kommentar
	addElement_div ('myDiv', 'id_comment', 'pos p1400 comment', '');
	add_innerHTML ('id_comment', ins("io_restart_comment"));

	// alert (document.body.innerHTML);
}

// ********************************************************************************************
// ********************************************************************************************
// DOM-Funktionen

// Dyn. Erzeugen eines HTML-Elements "checkbox"
function addElement_checkbox (parent_id, target_id, checked, class_value) 
{
	// Element erzeugen
	var newdiv = document.createElement("input");

	// Attribute des Elements
	newdiv.setAttribute("type", "checkbox");		
	newdiv.setAttribute("id", target_id);		
	if (checked == true)
		newdiv.setAttribute("checked", "checked"); 
	newdiv.setAttribute("class", class_value);		

	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Dyn. Erzeugen eines HTML-Elements "radio"
function addElement_radio (parent_id, target_id, name, value, checked, class_value) 
{
	// Element erzeugen
	var newdiv = document.createElement("input");

	// Attribute des Elements
	newdiv.setAttribute("type", "radio");	
	newdiv.setAttribute("id", target_id);		
	newdiv.setAttribute("name", name);		
	newdiv.setAttribute("value", value);		
	if (checked == true)
		newdiv.setAttribute("checked", "checked"); 
	newdiv.setAttribute("class", class_value);		

	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Dyn. Erzeugen von Text, z.B. fuer die Verwendung vor / hinter einem Button oder einer Checkbox
function add_text (parent_id, text, class_value, style)
{
	// Element erzeugen
	var textNode = document.createTextNode (text);

	// Attribute koennen nicht direkt auf einen Textknoten angewendet werden
	// -> span nutzen
	var span = document.createElement('span');
	span.style.fontSize = "20px";
	span.appendChild(textNode);
	
	span.setAttribute("class", class_value);
	span.setAttribute("style", style);
	
	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (span);
}

// ********************************************************************************************
// Dyn. Erzeugen eines img-Eintrags
function addElement_img (parent_id, source, class_value, style) 
{
	// Element erzeugen
	var newdiv = document.createElement ("img");

	newdiv.setAttribute ("src", source);		
	newdiv.setAttribute('class', class_value);		
	newdiv.setAttribute('style', style);		

	// Event
	newdiv.onclick=function(){info_restart()};

	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Dyn. Erzeugen eines beliebigen Elements mittels innerHTML
function add_innerHTML (parent_id, content)
{
	var parent = document.getElementById (parent_id);
	parent.innerHTML = content;	

}

// ********************************************************************************************
// Dyn. Erzeugen eines HTML-Elements "div"
function addElement_div (parent_id, target_id, class_value, style) 
{
	// Element erzeugen
	var newdiv = document.createElement ("div");
	
	// Attribute setzen
	newdiv.setAttribute('id', target_id);			
	newdiv.setAttribute('class', class_value);		
	newdiv.setAttribute('style', style);		
		
	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (newdiv);						
}

// ********************************************************************************************
// ********************************************************************************************
// tree aktualisieren
function treeRefresh()
{
	// Laden der Tree-Daten
	var module = "/config/www/tree/treeData.js";
	top.getDataExtended (module, 'fileload', 'top.frame_tree.tree_getData_application(actStr)');
}

// ********************************************************************************************
// ********************************************************************************************
// INFO
function info_restart()
{
	var headline =  '<B>INFO: '+ins("io_info_restart_head")+' </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("io_info_restart")+
 					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 170, "window");
}

// ********************************************************************************************
// INFO schliessen
function info_close()
{
	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



