/**********************************************************************************************

	JS functions for io_data.htm

	Copyright (c) 2010 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		07.2010

***********************************************************************************************/

var DEBUG_DATA = 0;			// Ausgaben
var localObject;
var localConfig;

var intervalEnable = 0;		// Freigabe Intervall

// ********************************************************************************************
// ********************************************************************************************

// Initialisierung beim Start der page: Daten aktualisieren (Aufruf aus data.htm)
function initData()
{
	// Titel setzen	
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Die Eigenschaften der content-page setzen
	top.getData();

}

// ********************************************************************************************

// Konfigurationsdaten einlesen und speichern, Values lesen
function getConfig(actStr)
{
	// alert (actStr);
	localConfig = JSON2.parse(actStr);

	// Werte setzen	
	setData (localObject);

}

// ********************************************************************************************
// ********************************************************************************************

// Aufruf der Aktualisierungsfunktionen aus main.js/getData()/setProperties()
function setObjectProperties (actObject)
{
	// Objekt global speichern fuer getObjectProperties()
	localObject = actObject;		

	// 03.04.2013: Konfigurationsdaten anfordern, um ggf. Maske fuer Handschalter zu lesen 
	var page = top.tree_getPageName(); 	
	top.getDataExtended (page[0], "configuration", "top.frame_content.getConfig(actStr)");

	// Intervalltimer bearbeiten
	if (intervalEnable)
		setIntervalTime();
}

// ********************************************************************************************

// Aufruf der Aktualisierungsfunktionen aus main.js/setData()
function getObjectProperties()
{
	// Nur Administrator/Operator sendet
	if ((top.g_username == "Administrator") ||
		(top.g_username == "Operator"))
	{
		// Werte ermitteln	
		var changedObject = getData(localObject);
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator oder Operator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************

// Werte fuer Daten entsprechend JSON-Objekt setzen
function setData (jObject)
{

	if (DEBUG_DATA)
	{
		var actString = JSON2.stringify (jObject, null, 4);
		alert (actString);
	}

	// -----------------------------------------------------------------------------------------
	// Pruefen, ob Treiber laeuft (="running", 2) oder gestoppt ist; dann Meldung
	if (localConfig.oControl.State != 2)
	{
		add_text ("dataErr", ins("io_data_err"), "resultfield", "font-weight:bold");
		return;
	}

	// -----------------------------------------------------------------------------------------
	// Namen ermitteln und bit/Byte-orientiert unterscheiden 
	var fBit = false;
	if ((jObject.oDriver.indexOf("_d") !== -1) || (jObject.oDriver.indexOf("_t") !== -1))
		fBit = true;

	if (jObject.oDriver.indexOf("mct_pin_di") !== -1)	// Sonderfall mct_pin_di
		fBit = false;

	var outputCnt = 0;		// Zaehler fuer outputs

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("dataTab_out");

	// -----------------------------------------------------------------------------------------
	// Handschalter vorhanden?
	var tHead = document.getElementById("dataTab_head");
	tHead.rows[0].cells[3].style.visibility = "hidden";
	if (localConfig.oDevices != undefined)
	{	
		if (localConfig.oDevices[0].Mask != undefined)
			tHead.rows[0].cells[3].style.visibility = "visible";
	}

	// -----------------------------------------------------------------------------------------
	// Wenn Tabelle bereits besteht, soll nur die 2. Spalte (Wert) aktualisiert werden
	// (z.B. periodisch lesen)
	
	if (DEBUG_DATA)
		alert ("table length = "+tbody.rows.length);

	if (tbody.rows.length > 0)
	{
		var rowCnt = 0;

		for (var i=0; i<255; i++)
		{			   
			// Abbruch, wenn kein device mehr
			if (jObject.oDevices[i] === undefined)
				break;	

			var devName = jObject.oDevices[i].Name;
			if (DEBUG_DATA)
				alert ("devName = "+devName);
			rowCnt++;

			if (fBit)
			{
				for (var j=0; j<255; j++)
				{			   
					// Abbruch, wenn kein value mehr
					if (jObject.oDevices[i].oValues[j] === undefined)
						break;			

					var portValue = jObject.oDevices[i].oValues[j].Value;
					if (DEBUG_DATA)
						alert ("portValue = "+portValue);
					tr = tbody.rows[rowCnt++];		// row
					td = tr.cells[1];				// cell			

					// alert ("row: "+tr.innerHTML+"      cell: "+td.innerHTML);
					td.innerHTML = portValue;
				
					// Handschalter nur bei outputs					
					if ((devName.indexOf("_do") !== -1) || (devName.indexOf("_to") !== -1))
					{
						// Handschalter nur, wenn Mask definiert ist
						if (localConfig.oDevices[0].Mask != undefined)
						{
							td = tr.cells[3];				// cell			
							td.innerHTML = getHandsetValue (outputCnt, localConfig.oDevices[0].Mask); 
							outputCnt++;

							// SET unsichtbar, wenn HANDSET = activ
							if (td.innerHTML == "activ")
							{
								td = tr.cells[2];
								td.style.visibility = "hidden";						
							}
							else
							{
								td = tr.cells[2];
								td.style.visibility = "visible";						
							}
						}
					}
				}
			}		
			else
			{
				var portValue = jObject.oDevices[i].oValue.Value;
				tr = tbody.rows[rowCnt++];		// row
				td = tr.cells[1];				// cell			
				td.innerHTML = portValue;
			}
		}
		return;
	}

	// -----------------------------------------------------------------------------------------
	// Tabelle besteht noch nicht, wird aufgebaut
	if (fBit)
	{
		// bitorientiert, Aufbau mit radiobutton
		if (DEBUG_DATA)
			alert ("Daten bitorientiert");

		for (var i=0; i<255; i++)
		{			   
			// Abbruch, wenn kein device mehr
			if (jObject.oDevices[i] === undefined)
				break;	

			// 1. devName
			var devName = jObject.oDevices[i].Name;
			if (DEBUG_DATA)
				alert ("devName = "+devName);
			tr = tbody.insertRow(tbody.rows.length);		// neue Reihe
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = '<B><U> '+devName+' </U></B>';
		
			// 2. portName, gelesener Wert, Radiobutton
			for (var j=0; j<255; j++)
			{			   
				// Abbruch, wenn kein value mehr
				if (jObject.oDevices[i].oValues[j] === undefined)
					break;			

				// portName
				var portName = jObject.oDevices[i].oValues[j].Name;
				if (DEBUG_DATA)
					alert ("portName = "+portName);

				tr = tbody.insertRow(tbody.rows.length);	// neue Reihe
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = portName;

				// portValue
				var portValue = jObject.oDevices[i].oValues[j].Value;
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = portValue;

				// Radiobutton nur bei outputs
				if ((devName.indexOf("_do") !== -1) || (devName.indexOf("_to") !== -1))
				{
					var inputStr = "";
					
					// workaround fuer Relay2x (3 Stellungen)
					// der maximum-Wert ist im schema angegeben; dieses haben wir fuer diese einfache
					// Seite nicht beruecksichtigt, er wird daher fest eingetragen					
					var cntRadio = jObject.oDevices[i].oValues[j].Size*2;
					if (cntRadio == 4)
						cntRadio = 3;
					for (var k=0; k<cntRadio; k++)
					{	
						// checked?
						var checkStr = "";
						if (k == portValue)
							checkStr = "checked";
						inputStr += '<input type="radio" name="r'+i+j+'" value="'+k+'" '+checkStr+' >'+k;
					}

					td = tr.insertCell(tr.cells.length);
					td.innerHTML = inputStr;

					// Handschalter bei outputs und wenn Mask definiert ist
					if (localConfig.oDevices[0].Mask != undefined)
					{
						td = tr.insertCell(tr.cells.length);
						td.innerHTML = getHandsetValue (outputCnt, localConfig.oDevices[0].Mask); 
						outputCnt++;
			
						// SET unsichtbar, wenn HANDSET = activ
						if (td.innerHTML == "activ")
						{
							td = tr.cells[2];
							td.style.visibility = "hidden";						
						}
						else
						{
							td = tr.cells[2];
							td.style.visibility = "visible";						
						}

					}
				}	
			}
		}
	}
	else
	{
		// Byteorientiert, Aufbau mit Eingabefeldern
		if (DEBUG_DATA)
			alert ("Daten Byteorientiert");

		for (var i=0; i<255; i++)
		{			   
			// Abbruch, wenn kein device mehr
			if (jObject.oDevices[i] === undefined)
				break;	

			// 1. devName
			var devName = jObject.oDevices[i].Name;
			if (DEBUG_DATA)
				alert ("devName = "+devName);
			tr = tbody.insertRow(tbody.rows.length);		// neue Reihe
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = '<B><U> '+devName+' </U></B>';
		
			// 2. portName, gelesener Wert, Eingabefeld
			// portName
			var portName = jObject.oDevices[i].oValue.Name;
			if (DEBUG_DATA)
				alert ("portName = "+portName);
			tr = tbody.insertRow(tbody.rows.length);		// neue Reihe
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = portName;
			
			// portValue
			var portValue = jObject.oDevices[i].oValue.Value;
			td = tr.insertCell(tr.cells.length);
			td.innerHTML = portValue;

			// Eingabefeld nur bei outputs
			if (devName.indexOf("_ao") !== -1)
			{
				var inputStr = '<input name="a'+i+'" class="textfield" size="8">';
				td = tr.insertCell(tr.cells.length);
				td.innerHTML = inputStr;
			}
		}
	}

//	alert (document.body.innerHTML);
}

// ********************************************************************************************

// Werte fuer Daten ermitteln und in JSON-Objekt setzen
function getData (jObject)
{
	// output-Werte in JSON-Objekt einsetzen
	// Namen ermitteln und bit/Byte-orientiert unterscheiden 
	var fBit = false;
	if ((jObject.oDriver.indexOf("_d") !== -1) || (jObject.oDriver.indexOf("_t") !== -1))
		fBit = true;	

	if (jObject.oDriver.indexOf("mct_pin_di") !== -1)	// Sonderfall mct_pin_di
		fBit = false;


	if (fBit)
	{
		// bitorientiert, Auswertung radiobutton
		if (DEBUG_DATA)
			alert ("bitorientiert");

		for (var i=0; i<255; i++)
		{			   
			// Abbruch, wenn kein device mehr
			if (jObject.oDevices[i] === undefined)
				break;	

			var devName = jObject.oDevices[i].Name;
			if (DEBUG_DATA)
				alert ("devName = "+devName);

			for (var j=0; j<255; j++)
			{			   
				// Abbruch, wenn kein value mehr
				if (jObject.oDevices[i].oValues[j] === undefined)
					break;			

				// Radiobutton nur bei outputs
				if ((devName.indexOf("_do") !== -1) || (devName.indexOf("_to") !== -1))
				{
					// Werte einsammeln, Zuordnung ueber den Namen der buttons
					// Zuweisung als int ("number") 
					var portVal = getRadioValue(jObject, i, j);
					jObject.oDevices[i].oValues[j].Value = parseInt(portVal);
					
					if (DEBUG_DATA)
						alert ("Value = "+jObject.oDevices[i].oValues[j].Value);				
				}
			}
		}
	}
	else
	{
		// Byteorientiert, Auswertung Eingabefelder
		if (DEBUG_DATA)
			alert ("Daten Byteorientiert");

		for (var i=0; i<255; i++)
		{			   
			// Abbruch, wenn kein device mehr
			if (jObject.oDevices[i] === undefined)
				break;	

			// 1. devName
			var devName = jObject.oDevices[i].Name;
			if (DEBUG_DATA)
				alert ("devName = "+devName);

			// Eingabefelder nur bei outputs
			if (devName.indexOf("_ao") !== -1)
			{
				// Wert einsammeln, Zuordnung ueber den Namen des Eingabefeldes
				// Zuweisung als string 
				// wenn nichts eingegeben worden ist (""), dann keine Zuweisung				
				var portVal = getEditValue(jObject, i);

				var size = jObject.oDevices[i].oValue.Size;							
				var maxVal = Math.pow(2,size) / 100;		// 2 Nachkommastellen
				var name = jObject.oDevices[i].oValue.Name;				

				// Trennung von VK- und NK-Stellen durch Punkt, nicht durch Komma
				//portVal.replace (/,/i, ".");
				if (portVal.indexOf (",") != -1)			
				{
					top.messageBox 	("Eingabefehler", "" + name + ": <br>" + 
									"Als Dezimaltrennzeichen ist ein Punkt statt eines Kommas zu verwenden.");
				}

				// Wertebereich der Eingabe pruefen
				if ((portVal < 0) || (portVal >= maxVal))
				{
					top.messageBox 	("Eingabefehler", "Wert von " + name + " ausserhalb des zulaessigen Bereichs. <br>" +
									"Zulaessiger Bereich: 0 <= Wert < " + maxVal + " (" + size + " Bit)");
					return 0;
				}

				if (portVal.length > 0)
					jObject.oDevices[i].oValue.Value = portVal;
					
				if (DEBUG_DATA)
					alert ("Value = "+jObject.oDevices[i].oValue.Value);
			}
		}
	}

	if (DEBUG_DATA)
	{
		var actString = JSON2.stringify (jObject, null, 4);
		alert (actString);
	}

	return (jObject);
}

// ********************************************************************************************
// ********************************************************************************************

// Einstellung der Radiobutton ermitteln
// Parameter: Name des Radiobutton
function getRadioValue(jObject, i, j)
{
	var button = eval ('document.getElementsByName("r'+i+j+'")');

	// workaround fuer Relay2x (3 Stellungen)
	// der maximum-Wert ist im schema angegeben; dieses haben wir fuer diese einfache
	// Seite nicht beruecksichtigt, er wird daher fest eingetragen					
	var cntRadio = jObject.oDevices[i].oValues[j].Size*2;
	if (cntRadio == 4)
		cntRadio = 3;
	for (var k=0; k<cntRadio; k++)
	{
		if (button[k].checked == true)
			var value = button[k].value;
		// alert ("checked ="+button[k].checked+"   value = "+button[k].value);
	}
	if (value == undefined)
		return (-1);		

	return (value);
}

// ********************************************************************************************
// Inhalt der Editfelder ermitteln
// Parameter: Name des Editfeldes
function getEditValue(jObject, i)
{
	var edit = eval ('document.getElementsByName("a'+i+'")');
	if (edit[0] !== undefined)
		var value = edit[0].value; 	

	// alert ("name = "+edit[0].name+"   value = "+edit[0].value);	

	if (value == undefined)
		return (-1);		

	return (value);
}

// ********************************************************************************************
// ********************************************************************************************
// Periodisch die Werte vom EWIO holen
var int_id = 0;
function setIntervalTime()
{
	var value = top.document.form_interval.selectInterval.value;

	if (int_id != 0)
		clearInterval (int_id);	

	if (top.document.form_interval.check.checked == true)
		int_id = setInterval ("top.getData()", value * 1000);
	else
		int_id = 0;

}

// ********************************************************************************************
// ********************************************************************************************
// Auswertung der Stellung der Handschalter (binaer codiert)
function getHandsetValue (cnt, mask)
{
	// alert (cnt + "   " + mask);
	var value = (mask >> cnt) & 1;
	if (value == 1)		
		return "activ";
	return "inactiv";
} 

// ********************************************************************************************
// ********************************************************************************************

// Dyn. Erzeugen von Text, z.B. fuer die Verwendung vor / hinter einem Button oder einer Checkbox
function add_text (parent_id, text, class_value, style)
{
	// Element erzeugen
	var textNode = document.createTextNode (text);

	// Attribute koennen nicht direkt auf einen Textknoten angewendet werden
	// -> span nutzen
	var span = document.createElement('span');
	span.style.fontSize = "20px";
	span.appendChild(textNode);
	
	span.setAttribute("class", class_value);
	span.setAttribute("style", style);
	
	// Element in DOM einhaengen
	var parent = document.getElementById (parent_id);
	parent.appendChild (span);
}

// ********************************************************************************************
// ********************************************************************************************


