/**********************************************************************************************

	JS functions for languages

	Copyright (c) 2008 MC Technology GmbH (rstiawa@metz-connect.com)
	Version 1.2		08.2010

***********************************************************************************************/

// =====  language = DEUTSCH  ===== 

/*
	Anmerkungen:
	Diese Datei wird als Sprachdatei eingebunden.
	Fuer jede Sprache wird die jeweilige language.js benoetigt. Sie gilt fuer alle pages.
	
	Konventionen:
	HTML
	- diese Datei muss im Haeder jeder betroffenen HTML-Datei eingebunden werden
	- jedem key wird die Bezeichnung der page vorangestellt (Bsp.: ip_xxx)
	- an Stelle des Textes im HTML wird "<script>lang("ip_key");</script>" eingefuegt, wobei in diesem
	  Beispiel "ip_" fuer die page und "key" fuer den Bezeichner steht.
	
	JS
	- statt dem Text wird die Funnktion 	ins("key");   eingefuegt
	- key dient dabei als Kennung fuer den eigentlichen Text
	- jedem key wird die Bezeichnung der page vorangestellt (Bsp.: ip_xxx)
	
*/



// ********************************************************************************************
// ********************************************************************************************

// Funktion, die waehrend des Parsens der HTML-Seite aufgerufen wird.
// Sie fuegt an den entsprechenden, durch Bezeichner (key)  identifizierten Stellen, den festgelegten Text ein.
function lang(key)
{
	var substitute;

	switch (key)
	{
		// page "start"
		case "start_text":	substitute =
			"Willkommen auf dem EWIO-M!<br><br>"+
			"Bitte loggen Sie sich ein.<br>"+	
			"Je nach Login-Status haben Sie unterschiedliche Rechte auf dem System.<br>";
			break;
		case "start_login": substitute = "LogIn-Status:";		break;
		case "start_pw": 	substitute = "Passwort:";		break;


		// page "info"
		case "info_text":	substitute =
			"Die auf dieser WebSite eingesetzten Technologien erfordern einen modernen Browser. <br><br>"+
			"Einer der folgende Browser sollte verwendet werden: <br>"+
			"- Firefox ab Version 3.0 <br>"+
			"- Internet Explorer ab Version 8.0 <br>"+
			"- Google Chrome ab Version 6.0 (6.0.472.55)<br>"+
			"- Iceweasel (Linux) ab Version 3.0.6 <br><br>"+
			"Diese Browser wurden auf Kompatibilt&auml;t mit dem EWIO-M getestet. <br>"+ 
			"Bei anderen Browsern kann die Funktionalit&auml;t nicht garantiert werden. <br><br>"+
			"Im Internet Explorer muss die Einstellung <br>"+
			"\"Neuere Versionen der gespeicherten Seite suchen: Bei jedem Zugriff auf die (Web-)Seite\" aktiviert sein. <br><br>"+
			"Diese Einstellung ist zu finden unter <br>"+
			"Extras / Internetoptionen / Allgemein / Browserverlauf - Einstellungen<br>";
			break;

		
		// page "devicebase"
		case "dev_name":	substitute = "Ger&auml;tenamen:";	break;
		case "dev_hw":		substitute = "HW-Basis";	break;
		case "dev_number":	substitute = "Seriennummer";	break;
		case "dev_mac":		substitute = "MAC-Adresse";	break;
		case "dev_fw":		substitute = "Firmware-Version";	break;
		case "dev_reboot":	substitute = "Ger&auml;t neu booten";	break;
		case "dev_install":	substitute = "Installieren";		break;
		case "dev_file":	substitute = "Datei";		break;
		case "dev_update":	substitute = "Update wird ausgef&uuml;hrt ... ";		break; 		
		case "dev_installstate":	substitute = "Status der aktuellen Installation:";		break; 		
		case "dev_comment":	substitute = 
			"&Auml;nderungen an dieser Seite sind mit besonderer Vorsicht vorzunehmen.";
			break;


		// page "memory"
		case "mem_drive":	substitute = "Laufwerke";		break;
		case "mem_operations":	substitute = "Aktionen";		break;
		case "mem_data":	substitute = "Daten: ";		break;
		case "mem_sd_memory":	substitute = "Speicher: -";		break;
		case "mem_sd_format":	substitute = "SD-Card formatieren mit ext2";		break;
		case "mem_sd_copy_to_sd":	substitute = "Kopieren UserSpace vom Flash auf SD-Card";		break;
		case "mem_sd_copy_to_flash":	substitute = "Kopieren UserSpace von SD-Card auf den Flash";		break;
		case "mem_sd_boot":	substitute = "K&uuml;nftig von SD-Card booten";		break;
		case "mem_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Aktuelle Daten vom EWIO abfragen <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Aktionen auf dem EWIO ausf&uuml;hren";		
			break;


		// page "pw"
		case "pw_select":	substitute = "Passwort &auml;ndern f&uuml;r:";	break;
		case "pw_pw0":		substitute = "Neues Passwort:";	break;
		case "pw_pw1":		substitute = "Passwort Wiederholung:";		break;
		case "pw_pw_old":		substitute = "Bisheriges Passwort:";		break;
		case "pw_comment":	substitute = 
			"Neue Passw&ouml;rter werden erst g&uuml;ltig, wenn sie zum EWIO gesendet wurden.";
			break;
		
		
		// page "ip"
		case "ip_mode_0":	substitute = "<B>IP-Adresse manuell vergeben</B>"; 	break;
		case "ip_mode_1":	substitute = "<B>IP-Adresse automatisch beziehen (DHCP)</B>"; 	break;
		
		case "ip_addr":		substitute = "IP-Adresse"; 			break;
		case "ip_subnet":	substitute = "Subnetz-Maske"; 		break;
		case "ip_gateway":	substitute = "Standard-Gateway";	break;
		case "ip_dns":		substitute = "DNS-Server";			break;
		case "ip_host":		substitute = "Host-Namen";			break;
		case "ip_domain":	substitute = "Dom&auml;ne";			break;
		case "ip_warning":	substitute = 
			"<B>Achtung: Bei &Auml;nderungen an den IP-Einstellungen kann die Verbindung zum EWIO verloren gehen.<br>"+
			"In diesem Fall m&uuml;ssen Sie sich mit den neuen Einstellungen erneut einloggen!</B>";	
			break;
		case "ip_comment":	substitute = 
			"Bei Fragen zu den Einstellungen wenden Sie sich bitte an Ihren Administrator.";	
			break;

		
		// page "wlan"
		case "wlan_config":	substitute = "Konfiguration:"; 	break;
		case "wlan_auto":	substitute = "automatisch"; 	break;
		case "wlan_man":	substitute = "manuell"; 	break;
		case "wlan_scan":	substitute = "WLAN-Netze scannen"; 	break;
		case "wlan_name":	substitute = "Netzwerkname:"; 	break;
		case "wlan_coding":	substitute = "Schl&uuml;sseltyp:"; 	break;
		case "wlan_key":	substitute = "Schl&uuml;ssel:"; 	break;
		case "wlan_comment":	substitute = 
			"&Auml;nderungen auf dieser Seite sind erst nach einem Reboot wirksam.";	
			break;

		
		// page "time"
		case "time_local":	substitute = "Ortszeit:";		break;
		case "time_cmt":	substitute = 
			"Die angegebene Zeit ist die aktuelle Zeit auf dem EWIO.<br>"+
			"Stellen der Zeit via Timeserver:<br>"+
			"Bei Verwendung von Namen statt IP-Adressen muss \"DHCP\" in den IP-Einstellungen aktiviert sein.";		
			break;
		case "time_set":	substitute = "Zeit stellen:";	break;
		case "time_man":	substitute = "manuell";		break;
		case "time_PC":		substitute = "via PC";		break;
		case "time_server":	substitute = "via Timeserver";		break;
		case "time_tformat":	substitute = "Format: tt.mm.jj hh:mm:ss";		break;
		case "time_tserver":	substitute = "Zeit-Server:";		break;
		case "time_bserver":	substitute = "Backup-Server:";		break;
		case "time_scall":	substitute = "T&auml;gl. Abrufzeit: ";		break;
		case "time_sformat":	substitute = "Format: hh:mm";	break;
		case "time_ipformat":	substitute = 
			"Format: Name oder IP-Adresse, Zeit-Protokoll (TP/NTP)<br>"+
			"Max. 8 Eintr&auml;ge";		break;
		case "checkTimeServer":	substitute = "Zeit sofort abrufen";		break;		

		
		// page "links"
		case "links_list":	substitute = "Liste der bekannten Links:<br><br>";		break;
		case "links_format":	substitute = 
			"Formate: EWIO-Name,Hostname oder IP-Adresse <br>" +
			"Beispiel 1: EWIO_1,http://10.22.0.215 <br>" +
			"Beispiel 2: EWIO_2,http://EWIO-3f47f5 <br>";		break;
		case "links_auto":	substitute = "Automatische Suche benachbarter EWIOs:";	break;
		case "links_disabel":	substitute = "Abgeschaltet";	break;
		case "links_now":	substitute = "Jetzt starten";	break;
		case "links_daily":	substitute = "1 mal t&auml;glich starten (02:00:00 Uhr)";	break;
		case "links_cmt":	substitute = 
			"Bearbeitung der Verbindungen (Links) zu anderen EWIOs.";		
			break;
		

		// page "application"
		case "app_change_name":		substitute = "Namen &auml;ndern";		break;
		case "app_appl_delete":		substitute = "Applikation l&ouml;schen";		break;
		case "app_tools_io":		substitute = "IOs";		break;
		case "app_tools_cycle":		substitute = "Zyklus";		break;
		case "app_cmt":				substitute = 
			"Erstellen Sie eine eigene Applikation durch Vervollst&auml;ndigen dieser Script-Vorlage.";
			break;
		

		// page "log"
		case "log_start_hw":		substitute = "HW zuletzt gestartet:";	break;
		case "log_start_sw":		substitute = "SW zuletzt gestartet:";	break;
		case "log_start_link":		substitute = "Eth-Link stabil seit:";	break;
		case "log_send_mail":		substitute = "eMail senden";	break;
		case "log_last_entry":		substitute = "(letzte Eintr&auml;ge)";	break;
		case "log_send_ftp":		substitute = "Logdatei an FTP-Server senden";	break;
		case "log_delete_now":		substitute = "Logdatei jetzt l&ouml;schen";		break;
		case "log_cmt":				substitute =
			"Die komplette syslog-Datei kann auch per SSH/SCP unter '/config/usr/messages' eingesehen werden.<br>"+
			"Alle Zeitangaben auf dieser Seite erfolgen in GMT (UTC).";	
			break;


		// page "mbus_add_auto"
		case "mbus_add_searchAdr":		substitute = "Suchadresse";		break;
		case "mbus_add_breakSearch":	substitute = "Suche abbrechen";		break;

		case "mbus_add_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Abfrage der MBus-IDs vom EWIO <br>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Markierte Z&auml;hler in die Navigation einf&uuml;gen.";		
			break;

		// page "mbus_remove"
		case "mbus_remove_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Einlesen der Z&auml;hler vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> L&ouml;schen der markierten Z&auml;hler";		
			break;

		// page "mbus_counter_secAddress"
		case "mbus_counter_secAddress_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Einlesen der Z&auml;hler vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Keine Funktion";		
			break;

		// page "mbus_counter_primAddress"
		case "mbus_counter_primAddress_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Einlesen der Z&auml;hler vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Keine Funktion";		
			break;

		// page "mbus_counterlist"
		case "mbus_counterlist_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Lesen der aktuellen Bearbeitungsposition vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Senden der ge&auml;nderten Bearbeitungsposition zum EWIO";		
			break;


		// page "mbus_sync"
		case "mbus_sync_puls":		substitute = "Synchron-Puls verwenden";		break;
		case "mbus_sync_signal":	substitute = "Signalquelle";		break;
		case "mbus_sync_contact":	substitute = "Kontaktart";		break;
		case "mbus_sync_contact_0":	substitute = "offen -> geschlossen";		break;
		case "mbus_sync_contact_1":	substitute = "geschlossen -> offen";		break;
		case "mbus_sync_poll":		substitute = "Abtastrate";		break;
		case "mbus_sync_grid":		substitute = "Synchron-Puls Raster";		break;
		case "mbus_sync_warning":	substitute = 
			"<B>Achtung: Um den Synchronpuls zu nutzen, muss im Men&uuml;punkt <br> "+
			"\"Ger&auml;t/Konfiguration/IO/mct_pin_di_x\" (x=0..3) der Mode auf \"direct\" gestellt sein!</B>";	
			break;
		case "mbus_sync_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Lesen der Synchron-Puls-Einstellungen vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Senden der Synchron-Puls-Einstellungen zum EWIO";		
			break;


		// page "mbus_output"
		case "mbus_output_counter":		substitute = "Z&auml;hlername:";		break;
		case "mbus_output_param":		substitute = "Parameter:";		break;
		case "mbus_output_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Lesen der Parameter f&uuml;r den ausgew&auml;hlten Z&auml;hler <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Laden der Parameter-Datei auf den PC";		
			break;


		// page "mbus_config"
		case "mbus_config_timestamp":		substitute = "Zeitstempel:";		break;
		case "mbus_config_requests":		substitute = "Zugriffe:";		break;
		case "mbus_config_freeze":		substitute = "Freeze-Wert verf&uuml;gbar.";		break;
		case "mbus_config_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Konfiguration des Z&auml;hlers abfragen <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Konfiguration des Z&auml;hlers senden";		
			break;


		// page "mbus_presence"
		case "mbus_presence_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Einlesen der konfigurierten Z&auml;hler vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Keine Funktion";		
			break;


		// page "mbus_messages"
		case "mbus_messages_delete":		substitute = "Datei l&ouml;schen";		break;
		case "mbus_messages_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Ausgabe aktualisieren <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Datei(en) l&ouml;schen, wenn markiert";		
			break;


		// page "mbus_data"
		case "mbus_data_current":		substitute = "Aktuelle Daten";		break;
		case "mbus_data_stored":		substitute = "Gespeicherte Daten";		break;
		case "mbus_data_timestamp":		substitute = "Zeitstempel:";		break;
		case "mbus_data_access":		substitute = "Zugriffe:";		break;
		case "mbus_data_status":		substitute = "Status:";		break;
		case "mbus_data_save":			substitute = "In DB speichern";		break;
		case "mbus_data_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Messwerte des Z&auml;hlers abfragen <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Keine Funktion";		
			break;


		// page server_format
		case "format_headarea":		substitute = "Kopfbereich";		break;
		case "format_dataarea":		substitute = "Datenbereich";		break;
		case "format_timestamp":	substitute = "Zeitstempel";		break;
		case "format_delimiter":	substitute = "Listentrennzeichen";		break;
		case "format_decimal":	substitute = "Dezimaltrennzeichen";		break;
		case "format_line":		substitute = "Zeile ";		break;
		case "mbus_format_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Lesen des konfigurierten Ausgabeformats vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Schreiben des bearbeiteten Ausgabeformats zum EWIO";		
			break;


		// page server_cyclic_type
		case "cyclic_type_supply":		substitute = "Bereitstellungsart";		break;
		case "cyclic_type_time":		substitute = "Zeitraum";		break;
		case "cyclic_type_push":		substitute = "Push - Betrieb";		break;
		case "cyclic_type_poll":		substitute = "Poll - Betrieb (FTP)";		break;
		case "cyclic_type_variant":		substitute = "Sendevariante:";		break;
		case "cyclic_type_single":		substitute = "Datei pro Datenpunkt";		break;
		case "cyclic_type_packed":		substitute = "Dateien gepackt (tar.bz2)";		break;
		case "cyclic_type_delay":		substitute = "Sendeverz&ouml;gerung FTP:";		break;
		case "cyclic_type_delaycontent":	substitute = "Minuten nach Ablauf des Intervalls (1 .. 59)";		break;
		case "cyclic_type_select":	substitute = "Auswahl Intervall:";		break;

		case "cyclic_type_select_quarthour":	substitute = "1/4 Stunde";		break;
		case "cyclic_type_select_hour":	substitute = "Stunde";		break;
		case "cyclic_type_select_day":	substitute = "Tag";		break;
		case "cyclic_type_select_week":	substitute = "Woche";		break;
		case "cyclic_type_select_month":	substitute = "Monat";		break;
		case "cyclic_type_select_quarter":	substitute = "1/4 Jahr";		break;
		case "cyclic_type_select_half":	substitute = "1/2 Jahr";		break;
		case "cyclic_type_select_year":	substitute = "Jahr";		break;
		case "cyclic_type_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Lesen des konfigurierten Ausgabeverfahrens vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Schreiben des bearbeiteten Ausgabeverfahrens zum EWIO";		
			break;


		// page mbus_config_datapoints
		case "mbus_datapoints_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Lesen der konfigurierten Datenpunkte vom EWIO <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Keine Funktion";		
			break;


		// page server_man_download
		case "man_download_datapoint":		substitute = "Datenpunkt:";		break;
		case "man_download_select":		substitute = "Auswahl";		break;
		case "man_download_all":		substitute = "alle";		break;
		case "man_download_from":		substitute = "Daten von:";		break;
		case "man_download_to":		substitute = "Daten bis:";		break;
		case "man_download_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Neu-Laden der Konfigurations-Seite <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Erzeugen der Messwert-Datei f&uuml;r den Download ";		
			break;


		// page param_config
		case "param_config_device":		substitute = "Ger&auml;te-<br>einstellungen";		break;
		case "param_config_app":		substitute = "Applikationen";		break;
		case "param_config_mbus":		substitute = "MBus-/Modbus-<br>Konfiguration";		break;
		case "param_config_info":		substitute = "Ge&auml;nderte Einstellungen auf dem EWIO erst nach reboot wirksam!";		break;
		case "param_config_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Aktuelle Daten vom EWIO abfragen <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Keine Funktion";		
			break;


		// page param_data
		case "param_data_store":	substitute = "Speicherort";		break;
		case "param_data_fill":		substitute = "F&uuml;llstand gesamt";		break;
		case "param_data_back":		substitute = "Back-Datei";		break;
		case "param_data_value":	substitute = "Messwert-Datei";		break;
		case "param_data_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Aktuelle Daten vom EWIO abfragen <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Keine Funktion";		
			break;


		// page modbus_rs485
		case "modbus_rs485_param":	substitute = "Geben Sie hier die Parameter der Modbus-Schnittstelle ein:";		break;
		case "modbus_rs485_bitrate":	substitute = "Bitrate:";		break;
		case "modbus_rs485_parity":		substitute = "Parit&auml;t:";		break;
		case "modbus_rs485_repeat":		substitute = "Wiederholungen max.:";		break;
		case "modbus_rs485_timeout_frame":	substitute = "Timeout Frame / ms:";		break;
		case "modbus_rs485_timeout_byte":	substitute = "Timeout Byte / ms:";		break;
		case "modbus_rs485_io":		substitute = "Abfrage der internen IOs via Modbus";		break;
		case "modbus_rs485_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Parameter der Schnittstelle abfragen <BR>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Parameter der Schnittstelle senden";			break;


		// page modbus_add
		case "modbus_add_param":	substitute = "Geben Sie hier die Parameter des Modbus-Ger&auml;tes ein:";		break;
		case "modbus_add_address":	substitute = "Adresse:";		break;
		case "modbus_add_type":	substitute = "Ger&auml;tetyp:";		break;
		case "modbus_add_name":	substitute = "Ger&auml;tename:";	break;
		case "modbus_add_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Einstellungen zur&uuml;cksetzen. <br>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Z&auml;hler in die Navigation einf&uuml;gen.";		
			break;


		// page bacnet
		case "bacnet_active":	substitute = "BACnet aktiv";		break;
		case "bacnet_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Parameter vom EWIO abfragen. <br>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Parameter zum EWIO senden.";		
			break;

		// weitere ...
		
	}
		
	document.write(substitute);
}
// ********************************************************************************************
// ********************************************************************************************


// Funktion, die aus JavaScript heraus aufgerufen wird.
// Sie fuegt an den entsprechenden, durch Bezeichner (key)  identifizierten Stellen, den festgelegten Text ein.
function ins(key)
{
	var substitute;

	switch (key)
	{

		// tree
		case "tree_config":		substitute = "Konfiguration";		break;
		case "tree_log":		substitute = "Systemzustand";		break;
		case "tree_pw":			substitute = "Passwort";			break;
		case "tree_ip":			substitute = "LAN";					break;
		case "tree_time":		substitute = "Zeiteinstellung";		break;
		case "tree_email":		substitute = "E-Mail";				break;
		case "tree_data":		substitute = "Daten";				break;
		case "tree_app":		substitute = "Applikationen";		break;
		case "tree_device":		substitute = "Ger&auml;t";			break;		
	
		case "tree_devicebase":	substitute = "Ger&auml;tebasis";	break;
		case "tree_memory":		substitute = "Speicher";			break;
		case "tree_general":	substitute = "Allgemein";			break;		
		case "tree_counter":	substitute = "Z&auml;hler";			break;		
		case "tree_connect":	substitute = "Link zu";				break;		
		case "tree_new":		substitute = "Neu";					break;		
		case "tree_consisting":	substitute = "Angelegt";			break;		
		case "tree_io_extended":	substitute = "IO erweitert";	break;		

		case "tree_add_counter":	substitute = "Z&auml;hler hinzuf&uuml;gen";	break;
		case "tree_remove_counter":	substitute = "Z&auml;hler l&ouml;schen";	break;
		case "tree_counter_secAddress":	substitute = "Z&auml;hler Sekund&auml;radresse";	break;
		case "tree_counter_primAddress":	substitute = "Z&auml;hler Prim&auml;radresse";	break;
		case "tree_counterlist":	substitute = "Z&auml;hlerliste";	break;
		case "tree_sync_pulse":	substitute = "Synchron-Puls";		break;
		case "tree_param_output":	substitute = "Parameterausgabe";		break;
		case "tree_tariffs":	substitute = "Tarife HT/NT";		break;
		case "tree_hallo":		substitute = "Hallo";				break;
		case "tree_messages":	substitute = "Nachrichten";			break;
		case "tree_hallo":	substitute = "Hallo";					break;
		case "tree_messages":	substitute = "Nachrichten";			break;

		case "tree_data_server":	substitute = "Datenserver";		break;
		case "tree_data_server_cyclic":	substitute = "zyklisch";	break;
		case "tree_data_server_man":	substitute = "manuell";		break;
		case "tree_format":	substitute = "Abfrageformat";			break;
		case "tree_type":	substitute = "Abfragetyp";				break;
		case "tree_datapoints":	substitute = "Datenpunkte";			break;
		case "tree_file_transfer":	substitute = "Dateitransfer";	break;
		
		case "tree_bacnet_conf":  substitute = "BACnet Konfiguration";  	break;

		
		// AJAX
		case "ajax_getData":	substitute = "Daten werden vom EWIO abgerufen ...";	break;	
		case "ajax_noData":		substitute = "Keine Daten verfuegbar.";		break;	
		case "ajax_getDataReady":	substitute = "Daten wurden empfangen.";	break;	
		case "ajax_sendData":	substitute = "Daten werden an den EWIO gesendet ...";	break;	
		case "ajax_sendDataReady":	substitute = "Daten wurden gesendet.";	break;	
		

		// page "main"
		case "main_mb_login":	substitute = "LogIn - Status nicht ausreichend";		break;
		case "main_mb_admin":	substitute = 
			"Um &Auml;nderungen im EWIO vornehmen zu d&uuml;rfen, "+
			"m&uuml;ssen Sie als eingeloggt sein als ";		break;
		case "main_mb_errMsg":	substitute = "Nachricht vom EWIO";		break;
		case "main_mb_errLogin":	substitute = 
			"Login Fehler <br>"+
			"Sie wurden vom System ausgeloggt.<br>"+
			"Bitte loggen Sie sich erneut ein.";		break;
		case "main_mb_wait":	substitute = "Bitte warten ...";   	break; 
		case "main_mb_waittext":	substitute = 
			"<br>"+ 	
			"Daten werden vom / zum EWIO &uuml;bertragen.<br>"+
			"Dieser Vorgang kann einige Sekunden dauern.";   	
			break; 
		case "main_mb_waitlist":	substitute = 
			"<br>"+ 	
			"Eine Datei / Dateiliste wird erstellt.<br>"+
			"Dieser Vorgang kann einige Sekunden dauern.";   	
			break; 
		case "main_input_length":	substitute = 
			"Eingabe fehlerhaft.<br>"+ 	
			"Genaue Anzahl einzugebender Zeichen: ";
			break; 
		case "main_input_minlength":	substitute = 
			"Eingabe fehlerhaft.<br>"+ 	
			"Mindestanzahl einzugebender Zeichen: ";
			break; 
		case "main_input_maxlength":	substitute = 
			"Eingabe fehlerhaft.<br>"+ 	
			"Maximalzahl einzugebender Zeichen: ";
			break; 
		case "main_input_char":	substitute = 
			"Eingabe fehlerhaft.<br>"+ 	
			"Es d&uuml;rfen nur folgende Zeichen eingegeben werden: <br>";
			break; 
		case "main_input_char_fail":	substitute = 
			"Eingabe fehlerhaft.<br>"+ 	
			"Es wurde ein ung&uuml;ltiges Zeichen eingegeben.";
			break; 
		case "main_input_timeformat":	substitute = 
			"Eingabe fehlerhaft.<br>"+ 	
			"Die Eingabe muss genau dem DB-Zeitformat entsprechen: yyyy-mm-dd HH:MM:SS <br><br>"+
			"Beispiel: <br>"+
			"2012-06-01 10:15:00 = 1. Juni 2012, 10.15 Uhr";	
			break; 
		case "main_error_abort":	substitute = 
			"Die Verbindung zum EWIO ist abgebrochen. <br>" +
			"Bitte loggen Sie sich erneut ein.";	
			break; 


		// page "start"
		case "start_standard":	substitute =
			"Status 'Standard': <br>"+
			"In diesem Status k&ouml;nnen Einstellungen und Daten nur gelesen werden.";
			break;
		case "start_operator":	substitute = 
			"Status 'Operator': <br>"+
			"Der Operator hat begrenzte Zugriffsm&ouml;glichkeiten.";
			break;
		case "start_admin":		substitute = 
			"Status 'Administrator': <br>"+
			"In diesem Status k&ouml;nnen s&auml;mtliche Einstellungen vorgenommen werden.";
			break;
		case "start_login_s":	substitute = "LogIn erfolgreich";	break;
		case "start_login_e":	substitute = "Passwort fehlerhaft";	break;


		// page "browser"
		case "browser_check":	substitute =
			"Die &Uuml;berpr&uuml;fung Ihres Browsers hat ergeben:\n\n";
			break;
		case "browser_unknown":	substitute =
			"Sie verwenden einen nicht unterst&uuml;tzten Browser.\n"+
			"Die Funktionsf&auml;higkeit der webSeiten kann daher nicht garantiert werden.\n\n";
			break;
		case "browser_ie_old":	substitute =
			"Sie verwenden einen veralteten Browser.\n"+
			"Sie ben&ouml;tigen Internet Explorer ab Version 7.0. \n\n";
			break;
		case "browser_ff_old":	substitute =
			"Sie verwenden einen veralteten Browser.\n"+
			"Sie ben&ouml;tigen Firefox ab Version 3.0. \n\n";
			break;
		case "browser_no_dom":	substitute =
			"DOM wird nicht unterst&uuml;tzt.\n"+
			"Bitte benutzen Sie einen aktuellen Browser. \n\n";
			break;
		case "browser_no_ajax":	substitute =
			"AJAX wird nicht unterst&uuml;tzt.\n"+
			"Bitte benutzen Sie einen aktuellen Browser. \n\n";
			break;


		// page "devicebase"
		case "dev_devicename":	substitute = "Neuer Name erst nach einem reboot wirksam.";		break;
		case "dev_msg_nameErr":	substitute = 
			"G&uuml;ltig sind nur alphanumerische Zeichen und '_','-'.<br>"+
			"Die Anzahl ist auf max. 255 Zeichen begrenzt.";		break;
		case "dev_cancel":		substitute = "Abbrechen";		break;
		case "dev_install_1":	substitute = '"Die Installation ist abgeschlossen."';		break;
		case "dev_install_2":	substitute = '"Sie wird erst nach einem Reboot wirksam."';		break;
		case "dev_install_err":	substitute = "Update wurde nicht installiert.";		break;
		case "dev_waitsend":	substitute = "Bitte warten ...  Die ausgew&auml;hlte Datei wird geladen.";		break;
		case "dev_text":		substitute = 
			"Die Datei wurde erfolgreich geladen.<br>"+
			"Nach dem Click auf den Button muss das Update noch installiert werden.<br>";		break;
		case "dev_reboot":			substitute = "Reboot wird ausgef&uuml;hrt ...";		break; 		
		case "dev_waitreboot":		substitute = 
			"Bitte warten ... <br>"+
			"Sie werden automatisch erneut verbunden.";		break; 		
		case "dev_waitrebootinsec":	substitute = "Wartezeit in Sekunden: ";		break;
		case "dev_copy_SD":			substitute = "Ausgew&auml;hlter Vorgang l&auml;uft ...";		break; 		
		case "dev_wait_copy":		substitute = 
			"Bitte warten ... <br>"+
			"Das Formatieren bzw. das Kopieren der Daten kann bis zu zwei Minuten dauern (4GB). <br>"+
			"Die &Auml;nderungen werden erst nach einem reboot wirksam.";	break; 		
		case "dev_file":	substitute = "Datei";		break;
		case "dev_component":	substitute = "Komponente:";		break;
		case "dev_sd_options":	substitute = "SD-Card Optionen";		break;
		case "dev_sd_available":	substitute = "SD-Card vorhanden: ";		break;
		case "dev_sd_formatted":	substitute = "SD-Card formatiert: ";		break;
		case "dev_sd_bootmedium":	substitute = "Es wurde gebootet von: ";		break;
		case "dev_sd_config":	substitute = "Progr.-Daten auf SD-Card: ";		break;
		case "dev_sd_boot":		substitute = "K&uuml;nftig von SD-Card booten";		break;
		case "dev_sd_copy":		substitute = "Jetzt Progr.-Daten vom Flash auf SD-Card kopieren"; 	break;
		case "dev_sd_format":		substitute = "Jetzt SD-Card formatieren"; 	break;
		case "dev_sd_attention":	substitute = "Achtung: Gespeicherte Daten werden &uuml;berschrieben!"; 	break;
		case "dev_no":		substitute = "nein";		break;
		case "dev_yes":		substitute = "ja";		break;
		case "dev_update_error":	substitute = "Fehler: Update kann nur bei installierter SD-Karte durchgef&uuml;hrt werden!"; 	break;
		case "dev_msg_head":	substitute = "Eingabefehler";	break; 
		case "dev_msg_error":	substitute = 
			"Es wurde keine oder eine falsche Datei ausgew&auml;hlt.<br>"+
			"W&auml;hlen Sie eine Datei mit dem gefordeten Namen aus!";		break;


		// page "memory"
		case "mem_bootmedia":	substitute = "Bootmedium: ";		break;
		case "mem_sdcard":	substitute = "nicht vorhanden";		break;
		case "mem_userspace":	substitute = "UserSpace vorhanden";		break;
		case "mem_no_userspace":	substitute = "Kein UserSpace vorhanden";		break;
		case "mem_all":		substitute = "Gesamt: ";		break;
		case "mem_used":	substitute = " / Belegt: ";		break;
		case "mem_sd_memory":	substitute = "Speicher: -";		break;
		case "mem_note":	substitute = "Hinweis";		break;
		case "mem_mess_no_sd":	substitute = "Abbruch:<BR> Keine SD-Card vorhanden.";		break;
		case "mem_mess_overwrite":	substitute = "Achtung:<BR> Eventuell gespeicherte Daten auf der SD-Card werden &uuml;berschrieben.";		break;
		case "mem_mess_sd_used":	substitute = "Abbruch:<BR> Auf die SD_Card kann nicht kopiert werden, da sie aktuell in Benutzung ist.";		break;
		case "mem_mess_sd_free":	substitute = "Abbruch:<BR> Freier Speicher auf der SD_Card nicht ausreichend.";		break;
		case "mem_mess_sd_format":	substitute = "Abbruch:<BR> SD-Card ist nicht mit ext2 formatiert.";		break;
		case "mem_mess_sd_stored":	substitute = "Achtung:<BR> Eventuell gespeicherte Daten auf der SD-Card werden &uuml;berschrieben.";		break;
		case "mem_mess_flash_used":	substitute = "Abbruch:<BR> Auf den Flash kann nicht kopiert werden, da er aktuell in Benutzung ist.";		break;
		case "mem_mess_flash_free":	substitute = "HINWEIS", "Abbruch:<BR> Freier Speicher auf dem Flash nicht ausreichend.";		break;
		case "mem_mess_flash_format":	substitute = "Abbruch:<BR> SD-Card ist nicht formatiert.";		break;
		case "mem_mess_flash_stored":	substitute = "Achtung:<BR> Eventuell gespeicherte Daten auf dem Flash werden &uuml;berschrieben.";		break;
		case "mem_mess_sd_no_userspace":	substitute = "Booten von SD-Card nicht m&ouml;glich. <BR>Kein UserSpace vorhanden.";		break;
		case "mem_mess_wait":	substitute = "Bitte warten ...";		break;
		case "mem_mess_countdown":	substitute = 
				"Die &Auml;nderungen werden auf dem EWIO ausgef&uuml;hrt.<br><br>"+
				"Nach Ablauf der Zeit wird der aktuelle Status automatisch angezeigt.<br>";			
				break;
		case "mem_mess_waittime":	substitute = "Wartezeit in Sekunden: ";		break;

			
		// page "pw"
		case "pw":			substitute = "Passwort";	break;
		case "pw_OK":		substitute = "Eingabe OK";	break;
		case "pw_error_again":	substitute = "Fehler: Passwort Wiederholung";	break;
		case "pw_error_min":	substitute = "Fehler: min. 2 Zeichen";	break;
		case "pw_error_max":	substitute = "Fehler: max. 16 Zeichen";	break;
		case "pw_error_char":	substitute = "Fehler: nur AlphaNumeric und '_'";	break;
		case "pw_error_old":	substitute = "Fehler: Bisheriges Passwort fehlt";	break;
		

		// page "ip"
		case "ip_msg_head":		substitute = "Eingabefehler";	break;
		case "ip_msg_err1":		substitute = "Gatewayadresse passt nicht zum Netzwerk.";	break;
		case "ip_msg_err2":		substitute = "Gatewayadresse darf nicht gleich der Netzwerkadresse sein.";	break;
		case "ip_msg_err3":		substitute = "Gatewayadresse darf nicht gleich der Broadcastadresse sein.";	break;
		case "ip_msg_err4":		substitute = "Alle Segmente der IP-Adresse m&uuml;essen Ziffern im Bereich zwischen 0 und 255 enthalten.";	break;
		case "ip_msg_err5":		substitute = "Alle Segmente der Subnetz-Maske m&uuml;essen Ziffern im Bereich zwischen 0 und 255 enthalten.";	break;
		case "ip_msg_err6":		substitute = 
			"Alle Segmente der DNS-Server-Adresse m&uuml;essen Ziffern im Bereich zwischen 0 und 255 enthalten.<br>"+
			"Kein DNS-Server: alle Elemente leer lassen.";	break;
		case "ip_msg_err7":		substitute = 
			"Alle Segmente des Standard-Gateway m&uuml;essen Ziffern im Bereich zwischen 0 und 255 enthalten.<br>"+
			"Kein Standard-Gateway: alle Elemente leer lassen.";	break;
		case "ip_msg_err8":		substitute = 
			"G&uuml;ltige Zeichen: 'A-Z', 'a-z', '0-9', '-'<br>"+
			"F&uuml;r Hostnamen max. 63 Zeichen, '-' nicht am Anfang oder Ende.";	break;
		case "ip_msg_err9":		substitute = 
			"F&uuml;r Hostnamen + Dom&auml;ne d&uuml;rfen insgesamt nicht mehr als 255 Zeichen eingegeben werden.";	break;


		// page "wlan"
		case "wlan_ssid":		substitute = "Netzwerkname:";	break;
		case "wlan_coding":		substitute = "Schl&uuml;sselart:";	break;
		case "wlan_key":		substitute = "Schl&uuml;ssel:";	break;
		case "wlan_man":		substitute = "IP-Adresse manuell vergeben";	break;
		case "wlan_auto":		substitute = "IP-Adresse automatisch beziehen (DHCP)";	break;
		case "wlan_addr":		substitute = "IP-Adresse:";	break;
		case "wlan_subnet":		substitute = "Subnetz-Maske:";	break;
		case "wlan_scan_running":	substitute = "Scan l&auml;uft";	break;
		case "wlan_scan_finished":	substitute = "Scan beendet";	break;
		case "wlan_info_auto_head":	substitute = "AUTOMATISCHE KONFIGURATION";	break; 
		case "wlan_info_auto":		substitute = 
			"Es werden nacheinander folgende Verbindungsversuche unternommen: <br>"+
			"1. Verbinden mit einem WLAN-Netz mit DHCP mit der SSID \"ewio_m_d\" <br> "+
			"2. Verbinden mit einem WLAN-Netz mit statischer IP-Vergabe und der SSID \"ewio_m_s\" <br> "+
			"3. Verbinden mit einem PC als ad-hoc-Verbindung mit der SSID \"ewio_m\" (Client) <br> "+
			"4. Erzeugen eines ad-hoc-Netzes mit der SSID \"ewio-m\" (Host) <br><br>"+
			"Als Schl&uuml;ssel ist in jedem Fall \"riabtrmcqtech\" festgelegt.<br><br>"+
			"Dr&uuml;cken Sie \"BROWSER->EWIO\", um die Einstellungen im EWIO zu speichern.<br>"+
			"Die Einstellungen werden nach dem n&auml;chsten Reboot g&uuml;ltig.";	
			break;
		case "wlan_info_man_head":	substitute = "MANUELLE KONFIGURATION";	break; 
		case "wlan_info_man":		substitute = 
			"Dr&uuml;cken Sie \"START\", um die vorhandenen WLAN-Netze zu scannen. <br>"+
			"Netze mit geringem Quality-Niveau werden m&ouml;glicherweise nicht bei jedem Scan erfasst. "+									
			"In diesem Fall muss der Scan wiederholt werden.<br>"+
			"Der EWIO-M kann Netzen hinzugef&uuml;gt werden, welche im Master-Mode arbeiten und WPA-Verschl&uuml;sselt sind. <br>"+
			"Mittels \"select\" w&auml;hlen Sie ein Netz aus und f&uuml;gen die IP-Konfiguration hinzu.<br><br>"+
			"Dr&uuml;cken Sie \"OK\" und danach \"BROWSER->EWIO\", um die Einstellungen im EWIO zu speichern.<br>"+
			"Die Einstellungen werden nach dem n&auml;chsten Reboot g&uuml;ltig.";	
			break;

			
		// page "time"
		case "time_newtime":	substitute = "Zeit stellen";	break;
		case "time_newlist":	substitute = "Serverliste bearbeiten";	break;
		case "time_tz":		substitute = "Zeitzone setzen";	break;
		case "time_hd_setTime":	substitute = "Zeit wird gesetzt ... ";	break;
		case "time_wait_setTime":	substitute = "Bitte warten ... <br>"+
			"Es dauert einen Moment, bis die Zeit im EWIO gesetzt ist.";		break;  	
		case "time_wait_setTimeInSec":	substitute = "Wartezeit in Sekunden: ";		break;


		// page "links"
		case "dev_links_head":	substitute = "Eingabefehler EWIO-Name";	break; 
		case "dev_links_nameErr":	substitute = 
			"G&uuml;ltig sind nur alphanumerische Zeichen und '_'.<br>"+
			"Fehlerhafter Name: ";		break;


		// page "application"
		case "app_config":		substitute = "Konfiguration %E4ndern";	break;		// Button
		case "app_cancel":		substitute = "Abbrechen";		break;
		case "app_mb_name":		substitute = "Name der Applikation fehlerhaft";		break;
		case "app_mb_othername":	substitute = 
			"Der Name \"newApplication\" ist nur eine Vorlage.\n"+
			"Bitte w&auml;hlen Sie einen eigenen Namen.";			break;											
		case "app_mb_char":		substitute = 
			"Der Namen darf nur folgende Zeichen beinhalten:\n"+
			"A-Z, a-z, 0-9, _";			break;											
		case "app_mb_login":	substitute = "LogIn - Status nicht ausreichend";		break;
		case "app_mb_admin":	substitute = 
			"Um den EWIO zu starten oder stoppen, "+
			"m&uuml;ssen Sie als Administrator oder Operator eingeloggt sein.";		break;	

		case "app_change_cycle":	substitute = "Zykluszeit &auml;ndern";	break;										
		case "app_cycle_time":		substitute = "Zykluszeit in ms";	break;
		case "app_port_rw":			substitute = "IO-Port lesen oder schreiben";	break;
		case "app_out_console":		substitute = "Ausgabe";		break;
		case "app_port_type":		substitute = "Portzugriff";		break;
		case "app_read":			substitute = "lesen";		break;
		case "app_write":			substitute = "schreiben";		break;
		case "app_port_select":		substitute = "IO-Port";		break;
		
		case "app_sensor":			substitute = "Sensordaten konvertieren";	break;
		case "app_sensor_type":		substitute = "Sensortyp";	break;
		case "app_sensor_temp":		substitute = "Temperatur";	break;
		case "app_sensor_out":		substitute = "Ausgabe";	break;

		case "app_email_from":		substitute = "Absender";	break;
		case "app_email_to":		substitute = "Empf&auml;nger";	break;
		case "app_email_user":		substitute = "Username";	break;
		case "app_email_pass":		substitute = "Passwort";	break;
		case "app_email_subject":	substitute = "Betreff";		break;
		case "app_email_text":		substitute = "Text";		break;
		

		//page "log"
		case "log_email_from":		substitute = "Absender";	break;
		case "log_email_to":		substitute = "Empf&auml;nger";	break;
		case "log_email_user":		substitute = "Username";	break;
		case "log_email_pass":		substitute = "Passwort";	break;
		case "log_email_subject":	substitute = "Betreff";		break;
		case "log_email_text":		substitute = "Text";		break;
		case "log_email_head":		substitute = "Inhalt Alarm-eMail ";		break;
		case "log_ftp_sendnow":		substitute = "jetzt senden";		break;
		case "log_ftp_senddaily":	substitute = "t&auml;gl. senden";		break;
		case "log_button_content":		substitute = "Inhalt";	break;
		case "log_button_config_mail":		substitute = "Konfiguration eMail";	break;
		case "log_button_config_ftp":		substitute = "Konfiguration FTP";	break;
		case "log_delete_after_send":		substitute = "Logdatei nach dem Senden l&ouml;schen";	break;
		case "log_ftp_wait":		substitute = "Die Wartezeit betr&auml;gt ca. 5s.";	break;


		//page io
		case "io_hd_setConf":	substitute = "Konfiguration wird gesetzt ... ";	break;
		case "io_wait_setConf":	substitute = "Bitte warten ... <br>"+
			"Es dauert einen Moment, bis die Konfiguration im EWIO gesetzt ist.";		break;  	
		case "io_wait_setTimeInSec":	substitute = "Wartezeit in Sekunden: ";		break;
		case "io_restart_desc":  substitute =
			"Bevor Sie physische &Auml;nderungen an den Erweiterungsmodulen vornehmen, m&uuml;ssen Sie diese stoppen.<br>"+
			"Nach erfolgter &Auml;nderung starten Sie diese dann erneut.";		break;
		case "io_restart_comment":	substitute = 
			"<span class=\"button_comment\">EWIO -> BROWSER</span> Keine Funktion<br>"+
			"<span class=\"button_comment\">BROWSER -> EWIO</span> Ausgw&auml;hlte Funktion ausf&uuml;hren.";		break;
		case "io_info_restart_head":	substitute = "IO-TREIBER RESTART";		break;
		case "io_info_restart":	substitute = 
			"&Auml;nderungen an den Erweiterungsmodulen k&ouml;nnen nicht bei laufendem Treiber vorgenommen werden.<br> "+
			"Daher ist es unbedingt erforderlich, vor &Auml;nderungen an der Anzahl oder der Adressierung von Erweiterungsmodulen "+
			"den Treiber zu stoppen.<br>"+
			"Nach Ausf&uuml;hrung der Arbeiten muss der Treiber wieder gestartet werden.<br>"+
			"Dr&uuml;cken Sie dazu \"BROWSER -> EWIO\".<br>"+
			"Der Vorgang dauert jeweils ca. 20s.";		break;


		//page io_data
		case "io_data_err":	substitute = 
			"Treiber ist angehalten. Bitte Konfiguration checken.";		break;


		// page "mbus_add_auto"
		case "mbus_add_breakSearch":	substitute = "Suche abbrechen";		break;
		case "mbus_add_searchOn":	substitute = "Suche l&auml;uft";		break;
		case "mbus_add_searchOff":	substitute = "Suche beendet";		break;
		case "mbus_add_searchBreak":	substitute = "Suche abgebrochen";		break;
		case "mbus_add_mess_prim":	substitute = "Prim&auml;radressen nicht benutzter Z&auml;hler werden resettet.";		break;
		case "mbus_add_mess_prim_of":	substitute = "Resette Prim&auml;radresse von <br><b>";		break;
		case "mbus_add_info_bus":	substitute = 
			"Fuer Ger&auml;te, welche direkt am MBus angeschlossen sind, w&auml;hlen Sie \"MBus\". <br><br>"+
			"Sollen IOs des EWIO-M als MBus-Ger&auml;te genutzt werden, w&auml;hlen Sie \"System\" "+
			"und den zu den IOs geh&ouml;renden Treiber aus. <br>"+
			"Bitte beachten Sie, dass die Treiber vorher gestartet sein m&uuml;ssen.";
			break;


		// page "mbus_remove"
		case "mbus_remove_mb_waitlist":	substitute = "Z&auml;hler mit den folgenden Adressen wurden gel&ouml;scht:";	break; 


		// page "mbus_counter_secAddress"
		case "mbus_counter_secAdr_old":	substitute = "Bisherige Sekund&auml;radresse: ";	break; 
		case "mbus_counter_secAdr_new":	substitute = "Neue Sekund&auml;radresse: ";	break; 
		case "mbus_counter_secAdr_invalid":	substitute = "Sekund&auml;radresse ung&uuml;ltig.";	break; 
		case "mbus_counter_secAdr_exist":	substitute = 
			"Sekund&auml;radresse bereits vorhanden.<br>Trotzdem fortfahren?";	break; 


		// page "mbus_counter_primAddress"
		case "mbus_counter_primAdr_old":	substitute = "Bisherige Prim&auml;radresse: ";	break; 
		case "mbus_counter_primAdr_new":	substitute = "Neue Prim&auml;radresse: ";	break; 
		case "mbus_counter_primAdr_valid":	substitute = "Zul&auml;ssige Zeichen sind 1 ... 249.";	break; 
		case "mbus_counter_primAdr_exist":	substitute = 
			"Prim&auml;radresse bereits vorhanden.<br>Bitte w&auml;hlen Sie eine andere Adresse.";	break; 


		// page "mbus_counterlist"
		case "mbus_counterlist_error":	substitute = "Eingabefehler";		break;
		case "mbus_counterlist_number":	substitute = 
			" ist ungueltig.<br>"+
			"Die Position muss eine Zahl zwischen 1 und 250 oder leer sein.";		break;
		case "mbus_counterlist_multiple":	substitute = 
			" ist in der Liste mehrfach enthalten.<br>"+
			"Sie darf nur einmal vorkommen.";		break;
		case "mbus_counterlist_note_head":		substitute = "HINWEIS";	break; 
		case "mbus_counterlist_no":		substitute = "Es wurden keine Z&auml;hler gefunden.";	break; 
		case "mbus_counterlist_info_position":	substitute = 
			"Durch die Position wird festgelegt, in welcher Reihenfolge die Z&auml;hler bei der "+
			"zyklischen Abfrage ausgelesen werden. <br>"+ 
			"Durch &Auml;nderung der Zuordnung der Position zu einer Busadresse kann diese Reihenfolge ge&auml;ndert werden.<br><br>"+
			"Die Angabe f&uuml;r die Position muss im Bereich von 1 ... 250 liegen und darf nur einmal vorkommen.<br><br>"+
			"Ist das Eingabefeld leer, wird dieser Z&auml;hler nicht abgefragt.";				
			break;


		// page "mbus_sync"
		case "mbus_sync_error":	substitute = "Konfigurationsfehler";		break;
		case "mbus_sync_error_config":	substitute = "Die gew&auml;hlte Signalquelle ist bereits als Z&auml;hler-Eingang konfiguriert.";		break;
		case "mbus_sync_info_head_sync":		substitute = "SYNCHRON-PULS";	break; 
		case "mbus_sync_info_sync":		substitute = 
			"Bei Verwendung eines Synchron-Pulses wird die Messwertabfrage nicht mehr durch die Zeitsteuerung "+
			"des EWIO-M, sondern durch diesen Synchron-Puls ausgel&ouml;st. <br><br> "+
			"Vorraussetzung: <br> "+
			"Im Men&uuml;punkt \"Ger&auml;t/Konfiguration/IO/mct_pin_di_x\" (x=0..3) muss der Mode auf \"direct\" gestellt sein. <br><br> "+
			"&Auml;nderungen auf dieser Seite werden erst nach einem Reboot wirksam. ";	 
			break;
		case "mbus_sync_info_head_polling":		substitute = "ABTASTRATE";	break; 
		case "mbus_sync_info_polling":		substitute = 
			"Einstellung der Abtastrate zur Erkennung des Synchron-Pulses. <br><br>"+
			"Die Abtastrate ist so zu w&auml;hlen, dass der Synchron-Puls sicher erkannt wird. <br>"+
			"Dazu sollte sie nicht gr&ouml;sser als die halbe L&auml;nge des Synchron-Pulses sein. <br>"+
			"Sie sollte aber auch nicht kleiner als n&ouml;tig sein, da dies nur zu einer unn&ouml;tigen Belastung des Systems f&uuml;hrt. <br><br>"+
			"Beispiel: <br>"+ 
			"Puls = 9s erfordert Abtastrate von 4.5s ";
			break;


		// page "mbus_output"
		case "mbus_output_info_head":		substitute = "PARAMETERAUSGABE";	break; 
		case "mbus_output_info":		substitute = 
			"Zusammenfassung der Parameter eines Z&auml;hlers in Textform.<br><br>"+
			"Per Download k&oumlnnen die Parameter als Datei auf den PC heruntergeladen werden. <br>"+
			"Diese kann dann mit einem Editor-Programm wie zum Beispiel Notepad++ ge&ouml;ffnet "+
			"und ausgedruckt werden. ";			
			break;


		// page "mbus_config"
		case "mbus_config_counter":	substitute = "Konfiguration Z%E4hler";	break;		// Button
		case "mbus_config_error":	substitute = "Konfigurationsfehler";	break;
		case "mbus_config_error_no_br":	substitute = "Es wurde keine Baudrate ausgew&auml;hlt.";	break;
		case "mbus_config_error_no_bus":	substitute = "Es wurde kein Bus ausgew&auml;hlt.";	break;
		case "mbus_config_error_sync":	substitute = "Der ausgew&auml;hlte Port wird bereits als Synchronpuls-Eingang verwendet";		break;
		case "mbus_config_err":	substitute = "Fehler";	break;
		case "mbus_config_err_noanswer":	substitute = "Der Z&auml;hler hat nicht geantwortet.";	break;
		case "mbus_config_err_invalid":		substitute = "Antwort vom Z&auml;hler fehlerhaft.<br>" +
														 "(zu grosse Leitungsl&auml;nge, gleiche Prim&auml;radressen, ...)";	break;
		case "mbus_config_err_unknown":	substitute = "Ein unbekannter Fehler ist aufgetreten.";		break;
		case "mbus_config_standard":	substitute = "Standard MBus-Z&auml;hler";		break;
		case "mbus_config_extended_info":	substitute = "Zus&auml;tzliche Informationen";		break;

		case "mbus_config_meas_point":	substitute = "Messpunkt";		break;
		case "mbus_config_counter_type":	substitute = "Z&auml;hlertyp:";		break;
		case "mbus_config_addr_primary":	substitute = "Prim&auml;radressierung";		break;
		case "mbus_config_counter_nr":	substitute = "Z&auml;hler-Nummer";		break;
		case "mbus_config_counter_client":	substitute = "Mandant";		break;
		case "mbus_config_counter_customer":	substitute = "Abnehmer-Nummer";		break;
		case "mbus_config_counter_optional":	substitute = "Die Angaben dieser Registerkarte sind optional.";		break;
		case "mbus_config_counter_country":	substitute = "Land";		break;
		case "mbus_config_counter_plz":	substitute = "PLZ";		break;
		case "mbus_config_counter_operator":	substitute = "Betreiber";		break;
		case "mbus_config_counter_meas_id":	substitute = "Messpunkt-ID";		break;

		case "mbus_config_channel_interval":	substitute = "Intervall:";		break;
		case "mbus_config_channel_readout":		substitute = "Auslesung ab";		break;
		case "mbus_config_channel_factor":	substitute = "Faktor U, I";		break;
		case "mbus_config_channel_app":		substitute = "Applikation:";		break;
		case "mbus_config_channel_mtype":			substitute = "Messtyp";		break;
		case "mbus_config_channel_mtype_normal":	substitute = "Normal";		break;
		case "mbus_config_channel_mtype_average":	substitute = "Mittelwert";		break;
		case "mbus_config_channel_initial_count":	substitute = "Anfangs-Z&auml;hlerstand";		break;
		case "mbus_config_channel_initial_pulse":	substitute = "Anfangs-Impulsstand";		break;
		case "mbus_config_channel_pulsperunit":		substitute = "Impulse / Einheit";		break;
		case "mbus_config_channel_edit_unit":		substitute = "Einheit";		break;
		case "mbus_config_channel_edit_factor":		substitute = "Faktor";		break;
		case "mbus_config_channel_primaer":		substitute = "Prim&auml;rz&auml;hler:";		break;
		case "mbus_config_channel_primaer_yes":		substitute = "ja";		break;
		case "mbus_config_channel_primaer_no":		substitute = "nein";	break;
		case "mbus_config_channel_sensor":		substitute = "Sensortyp:";		break;
		case "mbus_config_channel_resistor":		substitute = "Widerstandswert";		break;
		case "mbus_config_channel_offset":		substitute = "Temp.-Offset";		break;
		case "mbus_config_channel_obis":		substitute = "OBIS Kennzahl";		break;
		case "mbus_config_channel_description":		substitute = "Beschreibung";		break;
		case "mbus_config_channel_no_param":	substitute = "Keine weiteren Parameter.";   	break; 

		case "mbus_config_channel_input_error":	substitute = "Eingabefehler";   	break; 
		case "mbus_config_channel_config_error":	substitute = "Konfigurationsfehler";   	break; 
		case "mbus_config_channel_input_delimeter":	substitute = "Dezimaltrenner muss als Punkt angegeben werden.";   	break; 
		case "mbus_config_channel_input_startpuls":	substitute = "Warnung: Der Taster am S0/M-Converter wurde nicht bet&auml;tigt. "+
			 "Daher ist der Anfangsimpulsstand m&ouml;glicherweise nicht korrekt.";		break;
		case "mbus_config_message_note":	substitute = "HINWEIS";   	break; 
		case "mbus_config_message_mp":		substitute = 
			"Sie haben keine Daten fuer Messpunkte abgerufen <br>" +
			"(Button: EWIO -> BROWSER). <br><br>" +
			"Wenn Sie fortfahren, werden eventuell bereits gespeicherte Messpunkt-Daten gel&ouml;scht.";		
			break;
		case "mbus_config_message_wait":	substitute = "Bitte warten ...";   	break; 
		case "mbus_config_message_wait_EWIO":	substitute = "Warte auf Antwort vom EWIO, noch max. ";   	break; 
		case "mbus_config_message_wait_MBus":	substitute = "Warte auf Antwort vom MBus, noch max. ";   	break; 
		case "mbus_config_message_counter_store":	substitute = "Z&auml;hler-Parameter werden gespeichert.";   	break; 
		case "mbus_config_message_counter_channel":	substitute = ". Datenpunkt wird gespeichert.";   	break; 
		case "mbus_config_message_counter_set_prim":	substitute = "Prim&auml;radresse wird gesetzt.";   	break; 
		case "mbus_config_message_counter_reset_prim":	substitute = "Prim&auml;radresse wird zur&uuml;ckgesetzt.";   	break; 

		case "mbus_config_info_bus":		substitute = 
			"Fuer Ger&auml;te, welche direkt am MBus angeschlossen sind, w&auml;hlen Sie \"MBus\". <br><br>"+
			"Sollen IOs des EWIO-M als MBus-Ger&auml;te genutzt werden, w&auml;hlen Sie \"System\" "+
			"und den zu den IOs geh&ouml;renden Treiber aus. <br>"+
			"Bitte beachten Sie, dass die Treiber vorher gestartet sein m&uuml;ssen.";
			break;
		case "mbus_config_info_devicename_head":	substitute = "GER&Auml;TENAME";	break; 
		case "mbus_config_info_devicename":	substitute = 
			"Festlegung des Namens, unter welchem der Z&auml;hler im System gespeichert wird. <br>"+
			"Als Voreinstellung wird f&uuml;r den Namen die Bus-ID verwendet. <br><br>"+					
			"Bei &Auml;nderung gelten fuer den Namen folgende Bedingungen: <br>"+					
			"Zeichen von A...Z, a...z, 0...9 ,-_ ";	
			break; 
		case "mbus_config_info_mbusid_head":	substitute = "MBUS-ID";	break; 
		case "mbus_config_info_mbusid":	substitute = 
			"Die MBus-ID ist eine eindeutige Adresse eines Z&auml;hlers oder Moduls am MBus. <br>"+
			"Sie wird durch den Hersteller vergeben und kann (in der Regel) nicht ge&auml;ndert werden.";
			break; 
		case "mbus_config_info_devicetype_head":	substitute = "Z&Auml;HLERTYP";	break; 
		case "mbus_config_info_devicetype":	substitute = 
			"Voreingestellt ist der \"Standard MBus-Z&auml;hler\". <br><br>"+
			"Handelt es sich bei dem angeschlossenen Ger&auml;t um einen 4fach S0/M-Converter von BTR "+
			"oder einen internen S0-Eingang (S01-S04), stellen Sie \"4xS0/M-Converter, DIx/S0x\" ein. <br><br>"+					
			"Handelt es sich um einen 4fach T/M-Converter von BTR oder einen internen Analogeingang (AI1, AI2),"+ 
			"stellen Sie \"4xT/M-Converter, AIx\" ein.";				
			break; 
		case "mbus_config_info_primary_head":	substitute = "PRIM&Auml;R-ADRESSIERUNG";	break; 
		case "mbus_config_info_primary":	substitute = 
			"Dem Z&auml;hler kann eine Prim&auml;r-Adresse zugewiesen werden. <br>"+
			"Dadurch wird die Auslesung der Z&auml;hler beschleunigt, weil weniger Telegramme pro Abfrage ben&ouml;tigt werden."; 					
			break; 
		case "mbus_config_info_client_head":	substitute = "MANDANT";	break; 
		case "mbus_config_info_client":	substitute = 
			"Hier ist eine Unterscheidung nach organisatorischen Gesichtspunkten m&ouml;glich, z.B. verschiedene Kunden.";				
			break; 
		case "mbus_config_info_counternr_head":	substitute = "Z&Auml;HLERNUMMER";	break; 
		case "mbus_config_info_counternr":	substitute = 
			"Hier kann die Z&auml;hlernummer des abgefragten Z&auml;hlers eingetragen werden.";					
			break; 
		case "mbus_config_info_customernr_head":	substitute = "ABNEHMERNUMMER";	break; 
		case "mbus_config_info_customernr":	substitute = 
			"Hier ist eine Unterscheidung nach organisatorischen Gesichtspunkten m&ouml;glich, z.B. verschiedene Datenauswerter.";					
			break; 
		case "mbus_config_info_meteringcode_head":	substitute = "METERING-CODE";	break; 
		case "mbus_config_info_meteringcode":	substitute = 
			"Der Meteringcode ist eine weltweit eindeutige Kennzeichnung einer Messstelle. <br>"+					
			"Er dient der eindeutigen Kennzeichnung in grossen Netzen und "+
			"setzt sich aus verschiedenen Komponenten zusammen: <br> "+
			"Land = z.B. DE fuer Deutschland (2 alphanumerische Zeichen) <br> "+
			"Betreiber = Netzbetreiber-Identifikation (6 Ziffern) <br> "+
			"PLZ = Postleitzahl (5 Ziffern) <br> "+
			"Messpunkt-ID = Z&auml;hlpunktnummer (20 alphanumerische Zeichen)";					
			break; 
		case "mbus_config_info_interval_head":	substitute = "INTERVALL";	break; 
		case "mbus_config_info_interval":	substitute = 
			"Festlegung des Intervalls, in welchem die Z&auml;hler zyklisch ausgelesen werden. <br><br>"+
			"Folgende Werte sind m&ouml;glich: <br>"+
			"1 min <br>"+					
			"5 min (00:00, 00:05, 00:10, ... ) <br>"+					
			"15 min (00:00, 00:15, 00:30, 00:45, 01:00, ... ) <br>"+					
			"30 min (00:00, 00:30, 01:00, ... ) <br>"+
			"1 h (00:00, 01:00, 02:00, ... ) <br>"+
			"2 h (00:00, 02:00, 04:00, ... ) <br>"+
			"4 h (00:00, 04:00, 08:00, ... ) <br>"+
			"6 h (00:00, 06:00, 12:00, ... ) <br>"+
			"12 h (00:00, 12:00, ... ) <br>"+
			"t&auml;glich (00:00) <br>"+
			"w&ouml;chentlich (Montags 00:00) <br>"+
			"monatlich (1.1. 00:00, 1.2. 00:00, ...) <br>"+
			"viertelj&auml;hrlich (1.1. 00:00, 1.4. 00:00, ...) <br>"+
			"halbj&auml;hrlich (1.1. 00:00, 1.7. 00:00, ...) <br>"+
			"j&auml;hrlich (1.1.2000 00:00, 1.1.2001 00:00, ...) <br>"+
			"nicht (keine zyklische Auslesung) <br>";
			break;
		case "mbus_config_info_readout_head":	substitute = "AUSLESUNG AB";	break; 
		case "mbus_config_info_readout":	substitute = 
			"Der Z&auml;hler wird nicht vor dem eingetragenen Termin ausgelesen. <br><br>"+
			"Der erste tats&auml;chliche Ablesetermin h&auml;ngt von der Konfiguration des Parameters \"Intervall\" ab.";
			break;
		case "mbus_config_info_factor_head":	substitute = "FAKTOR";	break; 
		case "mbus_config_info_factor":	substitute = 
			"In manchen F&auml;llen muss das Messergebnis mit einem Faktor multipliziert werden, "+
			"z.B. wenn ein Vorteiler am Z&auml;hler angeschlossen ist. <br><br>"+	
			"Geben Sie in einem solchen Fall hier den Faktor U (Spannungsteiler) bzw. Faktor I (Stromteiler) an. <br>"+
			"Aus den beiden Faktoren und dem Messwert wird dann der endg&uuml;ltige Wert berechnet und in die Datenbank geschrieben. <br><br>"+
			"In allen anderen F&auml;llen belassen Sie die Faktoren auf 1.";
			break;
		case "mbus_config_info_app_head":	substitute = "APPLIKATION";	break; 
		case "mbus_config_info_app":	substitute = 
			"Auswahl der Applikation, welche auf die ausgelesenen Daten angewendet werden soll. <br>"+
			"Wird \"none\" ausgew&auml;hlt, wird keine Applikation angewendet. <br><br>"+					
			"Bitte beachten: <br>"+
			"Damit eine Applikation ausgef&uuml;hrt werden kann, muss sie im Ordner \"Applikationen\" gestartet worden sein.<br><br>"+
			"Details: <br>"+					
			"Die Applikation erh&auml;lt als Parameter den Namen der MBus-Datei, welche die Messwerte enth&auml;lt "+
			"sowie die Nummer des interessierenden Datenpunkts. <br>"+
			"Nach der Bearbeitung durch die Applikation wird die ge&auml;nderte MBus-Datei erneut gelesen und der "+
			"Messwert in der Datenbank gespeichert. ";
			break;
		case "mbus_config_info_mtype_head":	substitute = "MESSTYP";	break; 
		case "mbus_config_info_mtype":	substitute = 
			"Auswahl des Typs der Messung. <br>"+
			"Folgende Typen sind m&ouml;glich: <br><br>"+
			"\"Normal\" - <br>"+
			"Der originale Messwert wird verwendet. <br><br>"+					
			"\"Mittelwert\" - <br>"+
			"Der Messwert wird jede Minute abgefragt. <br>"+
			"Nach Ablauf des Intervalls wird aus den abgefragten Messwerten ein Mittelwert gebildet und dieser in der Datenbank gespeichert.";
			break;
		case "mbus_config_info_counterstart_head":	substitute = "ANFANGS-Z&Auml;HLERSTAND";	break; 
		case "mbus_config_info_counterstart":	substitute = 
			"Tragen Sie hier den Z&auml;hlerstand ein, der auf dem Z&auml;hler angezeigt wird. <br> "+
			"Die Anzahl der eingetragenen Nachkommastellen wird auch bei der Speicherung der Messwerte ber&uuml;cksichtigt. <br><br> "+
			"Hintergrund: <br> "+ 
			"Um &Uuml;bereinstimmung zwischen den gespeicherten Werten und der Anzeige auf dem Z&auml;hler zu erzielen, "+ 
			"muss dieser Wert bei der Berechnung addiert werden: <br><br> "+
			"Z&auml;hlerstand =  <br>"+
			"((Gesamtimpulsstand - Anfangsimpulsstand) / ImpulsProEinheit) + Anfangsz&auml;hlerstand ";					
			break;
		case "mbus_config_info_pulsstart_head":	substitute = "ANFANGS-IMPULSSTAND";	break; 
		case "mbus_config_info_pulsstart":	substitute = 
			"Dieses Feld wird automatisch ausgef&uuml;llt. Es ist nicht &auml;nderbar. <br><br> "+
			"Hintergrund: <br> "+ 
			"Bei diesem Wert handelt es sich um den Impulsstand, welcher der S0/M-Converter beim Einbau bereits gespeichert hatte. <br>"+
			"Aus Sicherheitsgr&uuml;nden lassen sich die S0/M-Converter nicht zur&uuml;cksetzen. <br>"+
			"Daher muss dieser Betrag von den neu dazukommenden Impulsen abgezogen werden. <br>"+
			"Wird \"Check !!\" angezeigt, dann wurde am S0/M-Converter die Installationstaste nicht gedr&uuml;ckt. <br>" +
			"In diesem Fall ist zu pr&uuml;fen, ob der Anfangsimpulsstand noch korrekt ist.";					
			break;
		case "mbus_config_info_pulsperunit_head":	substitute = "IMPULSE / EINHEIT";	break; 
		case "mbus_config_info_pulsperunit":	substitute = 
			"Geben Sie hier an, wie viele Pulse/Einheit der Z&auml;hler an seiner S0-Schnittstelle ausgibt. ";
			break;
		case "mbus_config_info_factorEdit_head":	substitute = "FAKTOR";	break; 
		case "mbus_config_info_factorEdit":	substitute = 
			"Tragen Sie hier den Faktor ein, mit welchem die Messwerte mutipliziert werden sollen. <br> "+
			"Als Ausgangswert wird der vom MBus im Parameter \"UNIT\" gelieferte Faktor eingetragen. <br>"+
			"Soll der Messwert mit diesem Faktor multipliziert in der Datenbank abgespeichert werden, "+
			"muss die entsprechende Applikation (\"factor_include\") ausgew&auml;hlt werden.";
			break;
		case "mbus_config_info_unit_head":	substitute = "EINHEIT";	break; 
		case "mbus_config_info_unit":	substitute = 
			"Tragen Sie hier die Einheit ein, die den gespeicherten Werten zugeordnet werden soll. <br>"+
			"Das k&ouml;nnen kWh, m3 oder eine beliebige andere Maszeinheit sein. <br>"+
			"Als Ausgangswert wird die vom MBus im Parameter \"UNIT\" gelieferte Einheit eingetragen. <br><br>"+
			"Da speziell S0/M-Converter nur Impulse messen, muss hier die Einheit manuell angegeben werden. ";
			break;
		case "mbus_config_info_primaer_head":	substitute = "PRIM&Auml;RZ&Auml;HLER";	break; 
		case "mbus_config_info_primaer":	substitute = 
			"Auswahl, ob es sich bei dem betreffenden Z&auml;hler um einen Prim&auml;rz&auml;hler handelt. <br>"+
			"Prim&auml;rz&auml;hler sind elektronische Z&auml;hler, die bei der Darstellung des Z&auml;hlerstandes "+
			"die Wandlerfaktoren mit einbeziehen. <br><br> "+
			"nein: Anzeige ohne Wandlerfaktoren <br>"+
			"ja: Anzeige unter Einschluss der Wandlerfaktoren <br><br>"+
			"Die Anzeige erfolgt unter \"MBus/Daten/Z&aumlhler\", <br>\"Aktuelle Daten\". ";			
			break;
		case "mbus_config_info_sensor_head":	substitute = "SENSORTYP";	break; 
		case "mbus_config_info_sensor":	substitute = 
			"Die Listbox enth&auml;lt alle anschliessbaren Temperatursensoren. <br> "+
			"W&auml;hlen Sie denjenigen aus, welcher auch an den Eing&auml;ngen angeschlossen wurde. <br>"+
			"Alternativ kann auch der Widerstandwert ausgew&auml;hlt werden. <br><br>"+
			"Der so ausgew&auml;hlte Messwert wird in Tele 1, Rec 3 ausgegeben. <br>"+					
			"Die eingestellte Listennummer wird (mit 0 beginnend) in Tele 1, Rec 4 angezeigt. <br><br>"+					
			"Hintergrund: <br> "+ 
			"Der T/M-Converter misst den Widerstandswert der Sensoren und wandelt diesen entsprechend der "+
			"ausgew&auml;hlten Kennlinie in einen Temperaturwert um. ";
			break;
		case "mbus_config_info_offset_head":	substitute = "TEMPERATUR-OFFSET";	break; 
		case "mbus_config_info_offset":	substitute = 
			"Eingabe eines Offset-Wertes in 1/10&deg;C-Schritten. <br> "+
			"Damit l&auml;sst sich der gemessene Wert um einen geringen Betrag korrigieren. <br><br> "+					
			"Der Korrekturwert erscheint nach der Konfiguration im Tele 1, Rec 5. <br> "+					
			"Beispiel: <br>"+
			"Eingabe: 0.5 -> Messwert + 0,5 &deg;C <br> "+
			"Eingabe: -0.5 -> Messwert - 0,5 &deg;C <br><br> "+
			"Unabh&auml;ngig davon gibt es auch die M&ouml;glichkeit der automatischen Leitungsl&auml;ngen-Kompensation.<br>"+		
			"(Siehe dazu auch den Beipackzettel zum Converter.) <br>"+
			"Ein dort eingestellter Wert wird in Tele 1, Rec 2 angezeigt. <br><br> "+
			"Hintergrund: <br> "+ 
			"Der eingegebene Korrekturwert wird im T/M-Converter zum Messwert hinzugef&uuml;gt. ";					
			break;
		case "mbus_config_info_obis_head":	substitute = "OBIS - KENNZAHL";	break; 
		case "mbus_config_info_obis":	substitute = 
			"&Uuml;ber die OBIS-Kennzahl kann ein Messwert identifiziert werden. <br>"+
			"Bei Bedarf tragen Sie hier die zu diesem Messwert passende OBIS-Kennzahl ein. <br><br>"+
			"Beispiel: 1-0:1.8.0*255";
			break;
		case "mbus_config_info_description_head":	substitute = "Beschreibung";	break; 
		case "mbus_config_info_description":	substitute = 
			"Mit Hilfe dieses Eintrags kann die Funktion eines Datenpunktes detaillierter beschrieben werden.<br>"+
			"Als Ausgangswert wird die vom MBus im Parameter \"DESCRIPTION\" gelieferte Bezeichnung eingetragen.";
			break;
		case "mbus_config_info_freeze_head":	substitute = "FREEZE";	break; 
		case "mbus_config_info_freeze_0":	substitute = "Aktueller Wert: ";	break;
		case "mbus_config_info_freeze_1":	substitute = "Freeze-Wert: ";	break;
		case "mbus_config_info_freeze_2":	substitute = 
			"Hintergrund: <br>"+
			"Ein Freeze-Wert ist ein Wert, der zu einem bestimmten Zeitpunkt \"eingefroren\" wird. <br><br>"+
			"Beispiel: <br>"+
			"Zu einem festgelegten Zeitpunkt (Intervall-Zeitpunkt) sollen alle Z&auml;hler abgefragt werden. <br>"+ 					
			"Da die Z&auml;hler nacheinander abgefragt werden, liegt der tats&auml;chliche Zeitpunkt der Auslesung mehr oder weniger "+
			"hinter dem Intervall-Zeitpunkt. <br>"+
			"Um diese Verz&ouml;gerung zu vermeiden, wird zum Intervall-Zeitpunkt ein \"Freeze\"-Kommando "+
			"gesendet, worauf alle Z&auml;hler mit diesem Feature den Messwert exakt zu diesem Zeitpunkt speichern.";
			break;
		case "mbus_dp_1":	substitute = "Die Gesamtzahl der Datenpunkte ist begrenzt auf: ";	break;
		case "mbus_dp_2":	substitute = "Bisher bereits gespeicherte Datenpunkte: ";	break;
		case "mbus_dp_3":	substitute = 
			"Die Speicherung der jetzt vorgemerkten Datenpunkte w&uuml;rde die Gesamtzahl der Datenpunkte &uuml;berschreiten.<br><br>"+
			"Bitte reduzieren Sie die vorgemerkten Datenpunkte um ";	break;


		// page "mbus_presence"
		case "mbus_presence_button_head":	substitute = "HINWEIS";	break; 
		case "mbus_presence_button_content":		substitute = 
			"Der Button \"BROWSER -> EWIO\" hat hier keine Funktion.";		break; 
		case "mbus_presence_error_head":	substitute = "FEHLER";	break; 
		case "mbus_presence_error_content":		substitute = 
			"Der Z&auml;hler hat nicht geantwortet.";		break; 


		// page "mbus_data"
		case "mbus_data_note_head":		substitute = "HINWEIS";	break; 
		case "mbus_data_error_head":	substitute = "FEHLER";	break; 
		case "mbus_data_button_content":		substitute = 
			"Der Button \"BROWSER -> EWIO\" hat hier keine Funktion.";		break; 
		case "mbus_data_point":	substitute = "Datenpunkt";	break;
		case "mbus_data_first":	substitute = "Erste Daten";	break;
		case "mbus_data_last":	substitute = "Letzte Daten";	break;
		case "mbus_data_from":	substitute = "Daten ab ";	break;
		case "mbus_data_format":	substitute = "Format: jjjj-mm-tt HH:MM";	break;
		case "mbus_data_maxvalue":	substitute = "Es werden max. 24 Messwerte/DB ausgegeben.";	break;
		case "mbus_data_time_error":	substitute = "Zeiteingabe fehlerhaft: ";	break;
		case "mbus_data_counter_error":	substitute = "Der Z&auml;hler hat nicht geantwortet";	break;
		case "mbus_data_no_answer":	substitute = "Keine Antwort vom EWIO.";	break;
		case "mbus_data_error_answer":	substitute = 
			"Antwort vom Z&auml;hler fehlerhaft <br> "+
			"(zu grosse Leitungsl&auml;nge, gleiche Prim&auml;radressen).";		break;
		case "mbus_data_unknown_error":	substitute = "Ein unbekannter Fehler ist aufgetreten.";	break;
		case "mbus_data_parameter":	substitute = "Bitte w&auml;hlen Sie zuerst die Parameter aus.";	break;
		case "mbus_data_no":	substitute = "Es wurden keine Daten gefunden.";	break;

		case "mbus_data_digits_year":	substitute = "Anzahl Ziffern / Jahr";	break;
		case "mbus_data_digits_month":	substitute = "Anzahl Ziffern / Monat";	break;
		case "mbus_data_digits_day":	substitute = "Anzahl Ziffern / Tag";	break;
		case "mbus_data_digits_hour":	substitute = "Anzahl Ziffern / Stunde";	break;
		case "mbus_data_digits_minute":	substitute = "Anzahl Ziffern / Minute";	break;
		case "mbus_data_digits_second":	substitute = "Anzahl Ziffern / Sekunde";break;
	
		case "mbus_data_time_format":	substitute = "Formatfehler";	break;
		case "mbus_data_time_year":	substitute = "Jahr";	break;
		case "mbus_data_time_month":	substitute = "Monat";	break;
		case "mbus_data_time_day":	substitute = "Tag";	break;
		case "mbus_data_time_hour":	substitute = "Stunde";	break;
		case "mbus_data_time_minute":	substitute = "Minute";	break;
		case "mbus_data_time_second":	substitute = "Sekunde";	break;
		case "mbus_data_time_process":	substitute = "Daten werden berechnet.";	break;

		case "mbus_data_info_currentData_head":	substitute = "AKTUELLE DATEN";	break; 
		case "mbus_data_info_currentData":	substitute = 
			"Auslesen der aktuellen Daten direkt vom MBus. <br><br>"+
			"Unter \"VALUE\" wird der vom MBus gelesene Messwert angezeigt. <br> "+
			"Ist der betreffende Z&auml;hler ein Prim&auml;rz&auml;hler (\"PRIM CTR\" = ja), "+
			"enth&auml;lt der Messwert bereits eventuell vorhandene Wandlerfaktoren. <br>"+
			"Damit entspricht der \"VALUE\" der Anzeige auf dem Z&auml;hler.<br><br>"+
			"Ist der betreffende Z&auml;hler kein Prim&auml;rz&auml;hler (\"PRIM CTR\" = nein), "+
			"werden eventuell vorhandene Wandlerfaktoren nicht in den \"VALUE\" eingerechnet. <br><br>"+			
			"In der Spalte \"CALCULATE\" wird der (durch Wandlerfaktoren und Applikation) berechnete Messwert angezeigt, "+
			"wie er in der Datenbank abgespeichert werden kann (mittels Button \"SAFE\"). ";
			break;


		//page server_format
		case "format_head_metering_point":	substitute = "Metering Code";	break;
		case "format_head_counter_number":	substitute = "Zaehlernummer";	break;
		case "format_head_client":	substitute = "Mandant";	break;
		case "format_head_customer_number":	substitute = "Abnehmer-Nummer";	break;
		case "format_head_counter_name":	substitute = "Zaehlername";	break;
		case "format_head_obis_code":	substitute = "OBIS-Kennzahl";	break;
		case "format_head_data_point":	substitute = "Datenpunkt";	break;
		case "format_head_unit":	substitute = "Einheit (MBUS)";	break;
		case "format_head_mbusid":	substitute = "MBus-ID";	break;
		case "format_head_prim_counter":	substitute = "Primaerzaehler";	break;
		case "format_head_factor_u":	substitute = "Faktor U";	break;
		case "format_head_factor_i":	substitute = "Faktor I";	break;
		case "format_head_s0m_start_counter":	substitute = "S0/M-Anfangs-Z-St";	break;
		case "format_head_s0m_start_impuls":	substitute = "S0/M-Anfangs-I-St";	break;
		case "format_head_s0m_pulsPerUnit":	substitute = "S0/M-Puls/Einheit";	break;
		case "format_head_change":	substitute = "Letzte Aenderung";	break;
		case "format_head_description":	substitute = "Beschreibung";	break;
		case "format_head_factor_edit":	substitute = "Faktor (EDIT)";	break;
		case "format_head_unit_edit":	substitute = "Einheit (EDIT)";	break;
		case "format_head_application":	substitute = "Applikation";	break;
		case "format_data_timestamp":	substitute = "Zeitstempel";	break;
		case "format_data_value":	substitute = "Messwert";	break;
		case "format_data_flags":	substitute = "Flags";	break;
		case "format_timestamp_one":	substitute = "Datum/Zeit zusammen";	break;
		case "format_timestamp_two":	substitute = "Datum/Zeit getrennt";	break;
		case "format_sep_semicolon":	substitute = "Semikolon";	break;
		case "format_sep_comma":	substitute = "Komma";	break;
		case "format_sep_space":	substitute = "Leerzeichen";	break;
		case "format_sep_tab":	substitute = "Tabulator";	break;
		case "format_sep_cat":	substitute = "Verkettungszeichen";	break;
		case "format_sep_point":	substitute = "Punkt";	break;
		case "format_time_date":	substitute = "Datum";	break;
		case "format_time_time":	substitute = "Zeit";	break;

	
		//page server_cyclic_type
		case "cyclic_type_config":		substitute = "Konfiguration";		break;
		case "cyclic_type_descr_0":		substitute = "Letzte Viertelstunde, z.B. 00:01 - 00:15";		break;
		case "cyclic_type_descr_1":		substitute = "Letzte Stunde, 00:01 - lfd. Stunde, 00:00";		break;
		case "cyclic_type_descr_2":		substitute = "Vortag, 00:01 - Heute, 00:00";		break;
		case "cyclic_type_descr_3":		substitute = "Mo letzter Woche, 00:01 - Mo lfd. Woche, 00:00";		break;
		case "cyclic_type_descr_4":		substitute = "1. Tag des Vormonats, 00:01 - 1. Tag des lfd. Monats, 00:00";		break;
		case "cyclic_type_descr_5":		substitute = "1. Tag des Vor-Quartals, 00:01 - 1. Tag des lfd. Quartals, 00:00";		break;
		case "cyclic_type_descr_6":		substitute = "1. Tag des Vor-Halbjahres, 00:01 - 1. Tag des lfd. Halbjahres, 00:00";		break;
		case "cyclic_type_descr_7":		substitute = "1.1. des Vorjahres, 00:01 - 1.1. des lfd. Jahres, 00:00";		break;

		case "cyclic_type_ftp_server":		substitute = "Server";		break;
		case "cyclic_type_ftp_username":	substitute = "Username";	break;
		case "cyclic_type_ftp_password":	substitute = "Passwort";	break;
		case "cyclic_type_ftp_port":		substitute = "Port";		break;
		case "cyclic_type_ftp_wait":		substitute = "Die Wartezeit betr&auml;gt ca. 10s.";	break;

		case "cyclic_type_info_push_head":	substitute = "PUSH-BETRIEB";	break; 
		case "cyclic_type_info_push":	substitute = 
			"Im Push-Betrieb sendet der EWIO von sich aus Messwertdateien an einen oder zwei FTP-Server. <br>"+
			"Zus&auml;tzlich k&ouml;nnen die Messwertdateien auch an bis zu zwei email-Adressen gesendet werden. <br>"+
			"Dabei k&ouml;nnen sowohl die Dateien zu den einzelnen Datenpunkten (.cvs), als auch eine gepackte Datei (.tar.bz2), "+
			"welche die einzelnen csv-Dateien beinhaltet, gesendet werden. <br>"+
			"Das tar-Format kann mit einem handels&uuml;blichen Programm, wie z.B. \"7-Zip\" entpackt werden. <br>"+
			"Nach dem Entpacken stehen die Messwertdateien wieder im csv-Format zur Verf&uuml;gung. <br><br>"+
			"Namenskonventionen: <br>"+
			"name_dpx_yymmdd_hhmm.csv, wobei name fuer den Ger&auml;tenamen, x fuer den Datenpunkt und yymmdd_hhmm fuer das End-Datum steht.";		
			break;

		case "cyclic_type_info_poll_head":	substitute = "POLL-BETRIEB";	break; 
		case "cyclic_type_info_poll":	substitute = 
			"Im Poll-Betrieb k&ouml;nnen Messwertdateien per FTP-Client vom EWIO abgeholt werden. <br>"+
			"Als Client kann ein spezielles Programm, z.B. \"Filezilla\" oder auch ein web-Browser genutzt werden (\"ftp://(ip-adr)/usr/database/interval\"). <br>"+
			"Als Login-Parameter m&uuml;ssen verwendet werden: <br>"+
			"Username: root <br>"+
			"Passwort: (Passwort fuer das Linux-System) <br><br>"+
			"Der Pfad zu den Messwertdateien ist \"(config)/usr/database/interval\". <br>"+
			"Es stehen sowohl die Dateien zu den einzelnen Datenpunkten (.cvs) zur Verf&uuml;gung, als auch eine gepackte Datei (.tar.bz2), "+
			"welche die einzelnen csv-Dateien beinhaltet. <br>"+
			"Das tar-Format kann mit einem handels&uuml;blichen Programm, wie z.B. \"7-Zip\" entpackt werden. <br>"+
			"Nach dem Entpacken stehen die Messwertdateien wieder im csv-Format zur Verf&uuml;gung. <br><br>"+
			"Namenskonventionen: <br>"+
			"name_dpx_yymmdd_hhmm.csv, wobei name fuer den Ger&auml;tenamen, x fuer den Datenpunkt und yymmdd_hhmm fuer das End-Datum steht. <br>"+			
			"Die Dateien werden nach jedem abgelaufenen Intervall neu erzeugt und stehen bis zum Beginn des n&auml;chsten Intervalls zur Verf&uuml;gung. "+
			"Danach werden sie gel&ouml;scht. ";
			break;


		//page mbus_config_datapoints
		case "mbus_datapoints_note_head":		substitute = "HINWEIS";	break; 
		case "mbus_datapoints_no":		substitute = "Es wurden keine Datenpunkte gefunden.";	break; 
		case "mbus_datapoints_button_content":		substitute = 
			"Der Button \"BROWSER -> EWIO\" hat hier keine Funktion.";		break; 
		case "mbus_datapoints_info_head":	substitute = "DATENPUNKTLISTE";		break; 
		case "mbus_datapoints_info":	substitute = 
			"Diese Liste gibt einen &Uuml;berblick &uuml;ber alle vorhandenen Datenpunkte. <br>"+ 
			"Die Datenpunkte adressieren die konfigurierten Messwerte. <br> "+
			"Durch ihre Angabe ist eine Zuordnung der Ausgabedateien zu den Messwerten m&ouml;glich. <br><br> "+
			"Durch Angabe eines Datenpunktes k&ouml;nnen auch &uuml;ber die counter-API "+ 
			"Messwerte gesetzt oder gelesen werden.";
			break;


		// page server_man_download
		case "man_download_download":	substitute = 
			"Die Messwert-Datei wurde mit den angegebenen Parametern angelegt. <br> "+
			"Sie kann jetzt per DOWNLOAD abgerufen werden.";
			break;
		case "man_download_info":	substitute = 
			"Messwertdateien zu einzelnen oder auch allen Datenpunkten k&ouml;nnen hier per Download auf dem PC abgespeichert werden. <br>"+
			"Das verwendete Datenformat ist csv (\"comma separated values\"), "+
			"welches direkt von Programmen zur Tabellenkalkulation ausgewertet werden kann. <br><br>"+
			"Eventuell notwendige &Auml;nderungen am Format k&ouml;nnen unter \"Datenserver/manuell/Abfrageformat\" vorgenommen werden. <br><br>"+					
			"Werden alle Dateien ausgew&auml;hlt, erfolgt der Download als gepackte Datei im tar.bz2-Format. <br>"+
			"Dieses Format kann mit einem handels&uuml;blichen Programm, wie z.B. \"7-Zip\" entpackt werden. <br>"+
			"Nach dem Entpacken stehen die Messwertdateien wieder im csv-Format zur Verf&uuml;gung. <br><br>"+
			"Namenskonventionen: <br>"+
			"name_dpx_yymmdd_hhmm.csv, wobei name f&uuml;r den Ger&auml;tenamen, x f&uuml;r den Datenpunkt und yymmdd_hhmm f&uuml;r das End-Datum steht.";			
			break;


		// page calendar
		case "calendar_month":	substitute = 
			['Januar', 'Februar', 'Maerz', 'April', 'Mai', 'Juni', 'Juli', 'August', 'September', 'Oktober', 'November', 'Dezember'];
			break;
		case "calendar_days":	substitute = 
			['So', 'Mo', 'Di', 'Mi', 'Do', 'Fr', 'Sa'];
			break;
		case "calendar_note_head":		substitute = "HINWEIS";	break; 
		case "calendar_error_input":	substitute = "Zeiteingabe fehlerhaft: ";	break; 
		case "calendar_error_incomplete_date":	substitute = "Datum unvollst&auml;ndig";	break; 
		case "calendar_error_digits_day":	substitute = "Anzahl Ziffern / Tag";	break; 
		case "calendar_error_digits_month":	substitute = "Anzahl Ziffern / Monat";	break; 
		case "calendar_error_digits_year":	substitute = "Anzahl Ziffern / Jahr";	break; 
		case "calendar_error_incomplete_time":	substitute = "Zeit unvollst&auml;ndig";	break; 
		case "calendar_error_digits_hour":	substitute = "Anzahl Ziffern / Stunde";	break; 
		case "calendar_error_digits_minute":	substitute = "Anzahl Ziffern / Minute";	break; 
		case "calendar_error_year":	substitute = "Jahr";	break; 
		case "calendar_error_month":	substitute = "Monat";	break; 
		case "calendar_error_day":	substitute = "Tag";	break; 
		case "calendar_error_hour":	substitute = "Stunde";	break; 
		case "calendar_error_minute":	substitute = "Minute";	break; 
		case "calendar_error_second":	substitute = "Sekunde";	break; 


		// page param_config
		case "param_config_note_head":		substitute = "HINWEIS";	break; 
		case "param_config_button_content":		substitute = 
			"Der Button \"BROWSER -> EWIO\" hat hier keine Funktion.";		break; 
		case "param_config_download":		substitute = "Mit Click auf DOWNLOAD wird die ausgewaehlte Datei vom EWIO kopiert.";	break; 
		case "param_config_download_mbus":	substitute = "Mit Click auf DOWNLOAD wird die MBus-/Modbus-Konfigurations-Datei vom EWIO kopiert.";	break; 
		case "param_config_upload_conf":	substitute = "Mit Click auf UPLOAD wird die ausgew&auml;hlte Konfiguration auf den EWIO geladen.";	break; 
		case "param_config_upload_app":	substitute = "Mit Click auf UPLOAD wird die ausgew&auml;hlte Applikation auf den EWIO geladen.";	break; 
		case "param_config_upload_mbus":	substitute = "Mit Click auf UPLOAD wird die ausgew&auml;hlte MBus-/Modbus-Konfiguration auf den EWIO geladen.";	break; 


		// page param_data
		case "param_data_note_head":		substitute = "HINWEIS";	break; 
		case "param_data_button_content":		substitute = 
			"Der Button \"BROWSER -> EWIO\" hat hier keine Funktion.";		break; 
		case "param_data_all":		substitute = "Gesamt: ";		break;
		case "param_data_used":	substitute = " / Belegt: ";		break;
		case "param_data_comp":	substitute = " (komprimiert)";		break;
		case "param_data_download_back":	substitute = "Mit Click auf DOWNLOAD wird die Back-Datei vom EWIO kopiert.";	break; 
		case "param_data_download_value":	substitute = "Mit Click auf DOWNLOAD wird die Messwert-Datei vom EWIO kopiert.";	break; 
		case "param_data_upload_back":	substitute = "Mit Click auf UPLOAD wird die ausgew&auml;hlte Back-Datei auf den EWIO geladen.";	break; 
		case "param_data_upload_value":	substitute = "Mit Click auf UPLOAD wird die ausgew&auml;hlte Messwert-Datei auf den EWIO geladen.";	break; 
		case "param_data_info_head":	substitute = "F&Uuml;LLSTAND";		break; 
		case "param_data_info":	substitute = 
			"Anzeige des F&uuml;llstandes der Datenbank im gew&auml;hlten Speicherbereich. <br> "+
			"Ist die Messwert-Datei gef&uuml;llt, wird sie automatisch zur Back-Datei umgewandelt. <br>"+
			"Eine bereits bestehende Back-Datei wird dabei &uuml;berschrieben. ";
			break;



		// page modbus_rs485
		case "modbus_rs485_repeat":	substitute = "Wiederholung";	break; 
		case "modbus_rs485_timeout_frame":	substitute = "Timeout Frame";	break; 
		case "modbus_rs485_timeout_byte":	substitute = "Timeout Byte";	break; 
		case "modbus_rs485_error_min": 	substitute = 
			"Eingabe fehlerhaft.<br>"+
			"Der eingegebene Wert darf nicht kleiner sein als: <br>";		break; 
		case "modbus_rs485_error_max": 	substitute = 
			"Eingabe fehlerhaft.<br>"+
			"Der eingegebene Wert darf nicht gr&ouml;sser sein als: <br>";		break; 
		case "modbus_rs485_info_repeat_head":	substitute = "WIEDERHOLUNGEN";	break; 
		case "modbus_rs485_info_repeat":	substitute = 
			"Anzahl der Wiederholungen, falls ein Modbus-Ger&auml;t nicht auf eine Anfrage antwortet. <br><br>"+
			"Der Wertebereich ist 0 ... 10. <br>"+
			"Die Grundeinstellung ist 2 (f&uuml;r bis zu 3 Wiederholungen)";	break;				
		case "modbus_rs485_info_timeout_frame_head":	substitute = "TIMEOUT FRAME";	break; 
		case "modbus_rs485_info_timeout_frame":	substitute = 
			"Timeout in Millisekunden, welches an der Modbus/RTU-Schnittstelle f&uuml;r die Antwort eines Modbus-Ger&auml;ts vorgesehen ist. <br>"+
			"Es beinhaltet die Zeit vom Ende des Kommandos bis zum Beginn der Antwort des Modbus-Ger&auml;ts. <br><br>"+
			"Der Wertebereich ist 0 ... 400 ms. <br>"+
			"Die Grundeinstellung ist 100 ms.";	break;		
		case "modbus_rs485_info_timeout_byte_head":	substitute = "TIMEOUT BYTE";	break; 
		case "modbus_rs485_info_timeout_byte":	substitute = 
			"Timeout in Millisekunden, welches an der Modbus/RTU-Schnittstelle f&uuml;r die Zeit zwischen den Bytes einer Antwort vorgesehen ist. <br>"+
			"Es beinhaltet Verz&ouml;gerungen, welche vom Modbus-Ger&auml;t oder durch das Betriebssystem verursacht werden. <br><br>"+
			"Der Wertebereich ist 0 ... 400 ms. <br>"+
			"Die Grundeinstellung ist 100 ms.";	break;		
		case "modbus_rs485_info_io_head":	substitute = "ABFRAGE INTERNE IOS";	break; 
		case "modbus_rs485_info_io":	substitute = 
			"Die im EWIO-M enthaltenen internen IOs sowie die eventuell vorhandenen IOs in Erweiterungsmodulen k&ouml;nnen &uuml;ber Modbus/TCP abgefragt werden.<br>"+
			"Durch Aktivierung der Checkbox werden die modbus-gateways f&uuml;r diese IOs gestartet. <br>"+
			"Die Ports f&uuml;r die Addressierung setzen sich zusammen aus den Port-Nummern dieser Module f&uuml;r Modbus/RTU + 8000. <br><br>"+
			"Zuweisungen:<br>"+
			"mct_pin_di_0: port = 8200 <br>"+
			"mct_pin_di_1: port = 8201 <br>"+
			"mct_pin_di_2: port = 8202 <br>"+
			"mct_pin_di_3: port = 8203 <br>"+
			"mct_spi_dio: port = 8210 <br>"+
			"mct_spi_aio: port = 8220 <br>"+
			"mct_paa_di4: port = 81[slot]3 <br>"+
			"mct_paa_di10: port = 81[slot]4 <br>"+
			"mct_paa_do4: port = 81[slot]5 <br>"+
			"mct_paa_dio42: port = 81[slot]6 <br>"+
			"mct_paa_ai8: port = 81[slot]7 <br>"+
			"mct_paa_ao4: port = 81[slot]8 <br><br>"+
			"Hinweis: [slot] = Adresse des Steckplatzes";		break;


		// page modbus_config
		case "modbus_config_info_description_head":	substitute = "Beschreibung";	break; 
		case "modbus_config_info_description":	substitute = 
			"Mit Hilfe dieses Eintrags kann die Funktion eines Datenpunktes detaillierter beschrieben werden.";
			break;
		case "modbus_config_info_unit_head":	substitute = "EINHEIT";	break; 
		case "modbus_config_info_unit":	substitute = 
			"Tragen Sie hier die Einheit ein, die den gespeicherten Werten zugeordnet werden soll. <br>"+
			"Das k&ouml;nnen kWh, m3 oder eine beliebige andere Maszeinheit sein.";
			break;
		case "modbus_config_info_interval_head":	substitute = "INTERVALL";	break; 
		case "modbus_config_info_interval":	substitute = 
			"Festlegung des Intervalls, in welchem die Z&auml;hler zyklisch ausgelesen werden. <br><br>"+
			"Folgende Werte sind m&ouml;glich: <br>"+
			"5 min (00:00, 00:05, 00:10, ... ) <br>"+					
			"15 min (00:00, 00:15, 00:30, 00:45, 01:00, ... ) <br>"+					
			"30 min (00:00, 00:30, 01:00, ... ) <br>"+
			"1 h (00:00, 01:00, 02:00, ... ) <br>"+
			"2 h (00:00, 02:00, 04:00, ... ) <br>"+
			"4 h (00:00, 04:00, 08:00, ... ) <br>"+
			"6 h (00:00, 06:00, 12:00, ... ) <br>"+
			"12 h (00:00, 12:00, ... ) <br>"+
			"t&auml;glich (00:00) <br>"+
			"w&ouml;chentlich (Montags 00:00) <br>"+
			"monatlich (1.1. 00:00, 1.2. 00:00, ...) <br>"+
			"viertelj&auml;hrlich (1.1. 00:00, 1.4. 00:00, ...) <br>"+
			"halbj&auml;hrlich (1.1. 00:00, 1.7. 00:00, ...) <br>"+
			"j&auml;hrlich (1.1.2000 00:00, 1.1.2001 00:00, ...) <br>"+
			"nicht (keine zyklische Auslesung) <br>";
			break;


		// weitere ...
	}		
	
	return (substitute);	
}

// ********************************************************************************************
// ********************************************************************************************


