/**********************************************************************************************

	JS functions for links window

	Copyright (c) 2009 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		08.2010

***********************************************************************************************/


/*
	Anmerkungen:
	
*/

// ********************************************************************************************

var DEBUG_LINKS = 0;	// Ausgaben

var linkObj;			// geaendertes tree-Element
var oStr;				// Aktualisierung Tree

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initLinks()
{
	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();
	
	// Namen der Page ermitteln
	document.getElementById("headLine").innerHTML = 
	getFilenameFromPath (top.frame_content.location.href);
	
	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen
function setObjectProperties (actObject)
{
	// Werte setzen	
	setLinks (actObject);	
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen
function getObjectProperties()
{
	// Nur Administrator sendet
	if (top.g_username == "Administrator")
	{
		// Werte ermitteln	
		var changedObject = linkObj = getLinks();
		return (changedObject);
	}
	else
	{
		// MessageBox
		top.messageBox_Login ("Administrator");
		return;	
	}
}

// ********************************************************************************************
// ********************************************************************************************
// Werte fuer IO ermitteln und in JSON-Objekt setzen
function getLinks ()
{
	var objStr = "";

	// Da die Laenge der Liste im Browser veraendert werden kann, muss das JSON-Objekt neu
	// zusammengebaut werden.

	// Liste
	// Umwandeln der einzelnen Stringelemente in die JSON- Struktur
	var linkStr = document.form_1.list.value;
	var listArr = linkStr.split("\n");				// Eintrag

	var listLength = listArr.length;				// Laenge der Liste im Browser
	var lineArr;									// Elemente einer Zeile
	var ipArr;										// Elemente einer IP-Adresse
	var index;
	var ret;

	
	// JSON-Objekt zusammenbauen: links
	var actObject = new Object();
	actObject.links = new Array(); 
	
	for (i=0; i<listLength; i++)
	{	
		if (listArr[i].length == 0)
			break;	

		// <cr> am Zeilenende beseitigen
		index = listArr[i].indexOf("\n");			
		if (index != -1)
			listArr[i] = listArr[i].substring(0, index);	
		index = listArr[i].indexOf("\r");			
		if (index != -1)
			listArr[i] = listArr[i].substring(0, index);	
		
		// Zeile zerlegen
		lineArr = listArr[i].split(",");
		if (lineArr.length != 2)
		{
			if (DEBUG_LINKS)	alert ("Syntax-Fehler in Zeile "+i);
			continue;
		}

		// EWIO-Namen checken
		ret = checkEWIOName(lineArr[0]);
		if (ret == -1)
			return (0);

		// EWIO-Name
		actObject.links[i] = new Object();
		actObject.links[i].name = lineArr[0];

		// Hostname oder IP-Adresse
		actObject.links[i].host_or_ip = lineArr[1];
 	}

	if (DEBUG_LINKS)	
	{
		var objStr = JSON2.stringify (actObject, null, 4);	// Object -> String
		alert (objStr);
	}

	return (actObject);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte aus dem JSON-Objekt setzen

// Werte fuer IO entsprechend JSON-Objekt setzen
function setLinks (jObject)
{
	// Einstellungen enstsprechend JSON- Objekt setzen
	// Link-Liste darstellen
	var linkStr = "";
	for (var i=0; i<jObject.links.length; i++)
	{
		linkStr += jObject.links[i].name+",";			// EWIO-Name
		linkStr += jObject.links[i].host_or_ip;			// Hostname oder IP-Adresse
		if (i<jObject.links.length-1)		linkStr += "\n";
	}

	document.form_1.list.value = linkStr;
}

// ********************************************************************************************
// ********************************************************************************************

// EWIO-Namen Input-Check
function checkEWIOName(nameStr)
{
	// Regeln fuer Geraetenamen:
	// zulaessige Zeichen "A-Z a-z 0-9 _"
	// Laenge 1 bis 255 Zeichen

	var muster = /^[A-Za-z0-9_]{1,255}$/;
	var result = muster.test(nameStr); 
	alert (nameStr+"   "+result);

	if (result == false)
	{
		top.messageBox (ins("dev_links_head"), ins("dev_links_nameErr")+nameStr);		
		return (-1);
	}
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************

// tree aktualisieren
function treeRefresh()
{

	var newLinks = new Array();
	
	// Aktualisieren tree-Element
	if (linkObj.links.length == 0)
	{
		// kein Element
		newLinks[0] = new Object();
		newLinks[0].icon = "page.gif";
		newLinks[0].text = "no entry";
		newLinks[0].target = "";
	}

	for (var i=0; i<linkObj.links.length; i++)
	{
		newLinks[i] = new Object();
		newLinks[i].icon = "page.gif";
		newLinks[i].text = linkObj.links[i].name;
		newLinks[i].target = linkObj.links[i].host_or_ip;
	}

	// tree-Element in tree einfuegen
	var newTreeObj = top.frame_tree.treeDataObj;
	newTreeObj.Links.connect_to = newLinks;

	oStr = JSON2.stringify (newTreeObj, null, 0);	// Object -> String

	// neuen tree zum EWIO senden
	top.frame_tree.shadeTree (1);
	setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", 1000);

	// Navigation refresh
	setTimeout ("top.frame_tree.tree_getData_links(oStr)", 1000);
}

// ********************************************************************************************
// ********************************************************************************************


