/**********************************************************************************************

	JS functions for main window

	Copyright (c) 2009-2010 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 1.2		07/2010

***********************************************************************************************/



// ********************************************************************************************

// DEBUG
var DEBUG_LOGIN 	= 0;
var DEBUG_PARAM 	= 0;
var DEBUG_JSON 		= 0;
var DEBUG_AJAX		= 0;

// Intervall bei IO-Daten
var intervalEnable = 0;		// Freigabe Intervall

// STYLE
var STYLE_LOAD		= 0;

// upload
var g_upload = "";

// mbus
var mbus_path = "/dev/ttyS2";


// ********************************************************************************************
// INITIALISIERUNG
// ********************************************************************************************

function initMain()
{
	// Event-Handler an Buttons koppeln; 
	// notwendig, damit aus den content-pages per event auf getData() zugegriffen werden kann
	document.getElementById("button_1").onclick = getData;
	document.getElementById("button_2").onclick = setData; 
}

// ********************************************************************************************
// LOGIN
// ********************************************************************************************

var STATIC_TAN = 0;		// alt, keine TAN-Aenderung
var SESSION_TAN = 1;	// 1 = eine TAN pro Session / 0 = eine TAN pro Uebertragung 

var g_username = "-";
var g_password = "";
var g_id = "";

// ********************************************************************************************

// Login: ID erfragen
function getId()
{

	messageBox_Wait ();

	var arr = top.frame_content.login.getLoginValues();
	
	var ret = checkInputString (ins("pw"), arr[1], "^[A-Za-z0-9_]{2,16}$");
	if (ret == -1)
		return;

	g_username = arr[0];
	g_password = arr[1];

	if (STATIC_TAN)
	{
		checkLogin();
		return;
	}

	var pw = MD5(g_password);
	if (SESSION_TAN)	
		var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type=session_id"+"&"+"module=login";
	else
		var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type=id"+"&"+"module=login";
	if (DEBUG_LOGIN)	alert ("getid()-Parameter = "+parameter);

	jsonFromServer ("getParamFromServer.cgi",	// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module
			"getIdResult(actStr)");				// aufzurufende Funktion nach Datenerhalt
}

// getId() - Ergebnisfunktion
function getIdResult(actString)
{
	g_id = getMessage (actString);

	// Login: Authentifizierung durchfhren
	checkLogin();
}

// ********************************************************************************************

// Login: Authentifizierung durchfuehren 
function checkLogin ()
{
	var pw = MD5(g_password + g_id);
	var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type=login"+"&"+"module=login";
	if (DEBUG_LOGIN)
	{	
		alert (	"Username = "+g_username+
				"\nPasswort = "+g_password+
				"\nSID = "+g_id+
				"\nTAN = "+pw+
				"\n\ncheckLogin()-Parameter = "+parameter);
	}	


	jsonFromServer ("getParamFromServer.cgi",	// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module
			"getLoginResult(actStr)");			// aufzurufende Funktion nach Datenerhalt

}

// checkLogin() - Ergebnisfunktion
function getLoginResult(actString)
{
	hideMessageBox();

	var loginresult = getMessage (actString);

	// Ergebnis etzen
	top.frame_content.login.loginSuccess (loginresult);
	setLoginState (loginresult);

	if (DEBUG_LOGIN)	
		alert ("login Ergebnis: "+loginresult);
}

// ********************************************************************************************

var login_timeout = 30;		// default 30 min
var login_countdown;		
var intervalId;


// Setzen globale LOGIN-Variablen und footer
function setLoginState (result)
{
	var footer_login = document.getElementById("footer_login");	// footer
	if (result == "LOGIN OK")	
	{
		// Timeout fuer Login ueberwachen
		timeoutStart();
		timeoutReset();

		// Laden der Tree-Daten
		var module = "/config/www/tree/treeData.js";
		getDataExtended (module, 'fileload', 'getNavigation_answer(actStr)');

		// Anzeige unterdruecken, bis Daten geladen sind
		top.frame_tree.document.getElementById("treepos").style.visibility = "hidden";
		top.frame_tree.document.getElementById("load").style.visibility = 'visible';

		// tree freigeben
		top.frame_tree.document.getElementById("treepos").style.display = "block";
	}	
	else
	{	
		g_username = "-";
		g_password = "";	

		// tree unsichtbar
		top.frame_tree.document.getElementById("treepos").style.display = "none";
		document.getElementById("treerefresh").style.display = "none";
	}
	footer_login.innerHTML = "LogIn: "+g_username;	

}

// ********************************************************************************************
// Antwort Navigation laden
function getNavigation_answer(actStr)
{
	// Navigation aufbauen
	top.frame_tree.tree_getData(actStr);	

	// Gertenamen holen
	getDataExtended ('devicebase', 'configuration', 'setLoginState_answer(actStr)');
}

// ********************************************************************************************

// Antwort - Geraetenamen holen
function setLoginState_answer(actStr)
{
//	alert (actStr);

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// Geraetenamen in Tree setzen
	frame_tree.setDeviceName (jObject.devicename);

	// aktuelle IP-Adresse holen
	getDataExtended ('/config/etc/network/ip_connect.txt', 'fileload', 'getCurrentIP_answer(actStr)');

}

// ********************************************************************************************

// Ermitteln der aktuellen IP-Adresse und der Schnittstelle (LAN/WLAN)
function getCurrentIP_answer(actStr)
{
	var text = getMessage (actStr);
	// alert (text);

	if (text.indexOf("ERROR") != -1)	
		return;	

	// Ausgabe
	var footer_ip = document.getElementById("footer_ip");	
	footer_ip.innerHTML = text; 
}

// ********************************************************************************************

function getDeviceName ()
{
	// Geraetenamen in Tree lesen
	var name = frame_tree.getDeviceName ();
	return name;
}

// ********************************************************************************************

// Timeout-Zeit fuer Login setzen
function timeoutStart()
{
//	intervalId = setInterval ("timeoutStep()", 1000 * 10);	// Test: 1 Step = 10s
	intervalId = setInterval ("timeoutStep()", 1000 * 60);	// 1 Step = 1min
}

// ********************************************************************************************

// Timeout initialisieren und 1x ausfhren
function timeoutReset()
{
	if (typeof(intervalId) != "undefined") 
	{
		login_countdown = login_timeout;
		timeoutStep();
	}
}

// ********************************************************************************************

// Timeout bearbeiten;
// Anzeige der Zeit bis zum Neustart der page
function timeoutStep()
{
	var footer_timeout = document.getElementById("footer_timeout");	
	value = (login_countdown < 10) ? "0"+login_countdown : login_countdown;	
	footer_timeout.innerHTML = "Timeout: 00:"+value;

	if (login_countdown == 0)
		resetWebinterface ();

	login_countdown--;
}

// ********************************************************************************************

// Detektieren einer Bewegung auf dem Screen
function checkActivation()
{

}

// ********************************************************************************************
// Navigation
// ********************************************************************************************

// Tree neu laden
function tree_refresh()
{
	// Daten neu anfordern
//	top.frame_tree.shadeTree (1);
	var module = "/config/www/tree/treeData.js";
	top.getDataExtended (module, "fileload", "top.frame_tree.tree_getData(actStr)");
}

// ********************************************************************************************

// Ermitteln der mittels Navigation ausgewaehlten Seite
function tree_getPageName ()
{
	return top.frame_tree.treePageName;
}

// ********************************************************************************************

// Setzen der ausgewaehlten Seite (z.B. durch neue applications)
function tree_setPageName (name)
{
	top.frame_tree.treePageName[0] = name;
}

// ********************************************************************************************
// ********************************************************************************************

// Password mit TAN berechnen
function calculatePassword ()
{
	if (STATIC_TAN)
	{	
		var pw = MD5(g_password);
		return (pw);
	}

	if (SESSION_TAN)
	{
		// g_id beibehalten, pw verschluesseln
		var pw = MD5(g_password + g_id);
		if (DEBUG_LOGIN)	alert ("SID = "+g_id+"   pw = "+pw);
		return (pw);
	}

	// Session-ID inkrementieren und als neue TAN verwenden
	var id = parseInt(g_id, 16);		// string -> hex-int
	id++;
	var idStr = "0x"+id.toString(16);	// hex-int -> string
	idStr = idStr.substring(2);			// "0x" ausblenden	

	// password mit TAN md5-verschluesseln
	var pw = MD5(g_password+idStr);
	
	// fuer naechste Transaktion speichern
	g_id = idStr;

	if (DEBUG_LOGIN)	alert ("SID = "+g_id+"   pw = "+pw);
	return (pw);
}

// ********************************************************************************************

// Zufallszahl zwischen minVal und maxVal ermitteln
function calculateRandom (minVal, maxVal)
{

	var randomVal = minVal + (maxVal * (Math.random()));		
	randomVal = Math.round(randomVal);
	return (randomVal);
}

// ********************************************************************************************
// LOGOUT
// ********************************************************************************************

// LOGOUT-Anforderung senden
function setLogout ()
{
	// Button fuer 1s disabeln
	document.getElementById("button_3").disabled = true;
	setTimeout ('buttonRelease("button_3")', 1000); 	

	// Timeout-Intervall abbrechen
	clearInterval (intervalId);

	var pw = calculatePassword ();
	var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type=logout"+"&"+"module=login";
	jsonFromServer ("getParamFromServer.cgi",	// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module
			"getLogoutResult(actStr)");			// aufzurufende Funktion nach Datenerhalt
}

// setLogout() - Ergebnisfunktion
function getLogoutResult(actString)
{
	var logoutresult = getMessage (actString);
	if (DEBUG_LOGIN)	alert ("logout Ergebnis: "+logoutresult);

	// Darstellung zuruecksetzen
	// Start-Seite neu aufrufen	
	top.window.location.href = top.window.location.href;

	// tree unsichtbar
	top.frame_tree.document.getElementById("treepos").style.display = "none";
	document.getElementById("treerefresh").style.display = "none";
}

// ********************************************************************************************

// Reset des webInterface
function resetWebinterface ()
{
		// Seite neu aufrufen	
		top.window.location.href = top.window.location.href;

		// tree unsichtbar
		top.frame_tree.document.getElementById("treepos").style.display = "none";
		document.getElementById("treerefresh").style.display = "none";
}

// ********************************************************************************************






// ********************************************************************************************
// MessageBox
// ********************************************************************************************

// Messagebox aufrufen
function messageBox (headline, text)
{
	var content = 	text+
					'<div id="single_button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="hideMessageBox()">'+
					'</div>';

	guiPopup.Show ("login_message", headline, content, 'Info', 400, 110, "popup_area");
}

// ********************************************************************************************

// Messagebox fuer nicht ausreichenden Loginstatus aufrufen
function messageBox_Login (logState)
{
	var headline = ins("main_mb_login");
	var text = ins("main_mb_admin");
		text += logState + ".";
	var content = 	text+
					'<div id="single_button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="hideMessageBox()">'+
					'</div>';

	guiPopup.Show ("login_message", headline, content, 'Info', 400, 110, "popup_area");
}

// ********************************************************************************************

// Messagebox "Bitte warten ..."
function messageBox_Wait ()
{
	var headline = ins("main_mb_wait");
	var content = ins("main_mb_waittext");	
	guiPopup.Show ("login_message", headline, content, 'Loading', 400, 90, "popup_area");
}

// ********************************************************************************************

// Messagebox "Bitte warten ..." mit Zusatztext
function messageBox_Wait_ext (text)
{
	var headline = ins("main_mb_wait");
	var content = ins("main_mb_waittext") + "<br><br>" + text;	
	guiPopup.Show ("login_message", headline, content, 'Loading', 400, 130, "popup_area");
}

// ********************************************************************************************

// Messagebox "Bitte warten ..." mit Fileliste
function messageBox_Wait_list (text)
{
	var headline = ins("main_mb_wait");
	var content = ins("main_mb_waitlist") + '<br><br>' + 	
		'<textarea id="scroll_1" class="textfield long_250" rows="5">'+text+'</textarea>';

	guiPopup.Show ("login_message", headline, content, 'Loading', 400, 200, "popup_area");

	// scrolle zur letzten eingefuegten Reihe
	var scroll_area = document.getElementById('scroll_1');
	scroll_area.scrollTop = scroll_area.scrollHeight;
}

// ********************************************************************************************

// MessageBox beenden
function hideMessageBox()
{
	// close
	guiPopup.CloseMe("login_message");
}

// ********************************************************************************************
// ********************************************************************************************

function buttonRelease (buttonName)
{
	document.getElementById(buttonName).disabled = false;
}

// ********************************************************************************************



// ********************************************************************************************
// Input Check
// ********************************************************************************************

// Pruefen des Eingabestrings
// headExt		= String zur Kennzeichnung des Eingabefeldes ("CHECK INPUT - Eingabefeld") 
// inputStr 	= zu pruefende Eingabe
// validChar 	= regExp-String ohne "/"
// Return		0 = OK / -1 = Fehler

function checkInputString (headExt, inputStr, validChar)
{
	// Bestehende Messageboxen schliessen
	hideMessageBox();	

	// Check Laengen
	// Laengenangaben aus regExp-String extrahieren
	var len_0 = validChar.indexOf('{') + 1;
	var len_1 = validChar.indexOf('}');
	var len = validChar.slice(len_0, len_1);
	
	if (len.indexOf(',') == -1)
	{
		// nur eine Laengenangabe
		if (inputStr.length != len)
		{
			messageBox ("CHECK INPUT - " + headExt, ins("main_input_length") + len);			 
			return -1;	
		}
	}
	else
	{
		// Min- und Max-Laenge	
		var lenArr = len.split(',');
	
		// Vgl. Min-Laenge
		if (inputStr.length < lenArr[0])
		{
			messageBox ("CHECK INPUT - " + headExt, ins("main_input_minlength") + lenArr[0]);			 
			return -1;	
		}

		// Vgl. Max-Laenge
		if (inputStr.length > lenArr[1])
		{
			messageBox ("CHECK INPUT - " + headExt, ins("main_input_maxlength") + lenArr[1]);			 
			return -1;
		}
	}

	// Check Inhalt
	// String in RegExp wandeln
	var myRegExp = new RegExp(validChar);
	// alert (myRegExp);

	// gueltige Zeichen fuer Anzeige extrahieren
	var chr_0 = validChar.indexOf('[') + 1;
	var chr_1 = validChar.indexOf(']');
	var chrStr = validChar.slice(chr_0, chr_1);

	// Test auf Gueltigkeit
	var result = myRegExp.test(inputStr); 
	if (result == false)
	{
		messageBox ("CHECK INPUT - " + headExt, ins("main_input_char") + chrStr);			 
		return -1;
	}

	// alert ("check OK");	
	return 0;
}

// ********************************************************************************************

// Zeiteingabe im DB-Format ueberpruefen (2012-08-13 10:30:00)
function checkDBTimeFormat (headExt, inputStr)
{

	// date & time in DB-Fotmat
	var myRegExp = new RegExp("^(19|20)\\d\\d-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01]) ([01][0-9]|[2][0-4]):([0-5][0-9]):([0-5][0-9])$");

	// Test
	// alert (inputStr + "\n" + myRegExp);

	var result = myRegExp.test(inputStr); 
	if (result == false)
	{
		var content =	'<div class="pos x0101 textfield">' +ins("main_input_timeformat")+ 
						'</div>' +
						'<div id="single_button_position">'+
						'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="hideMessageBox()">'+
						'</div>';

		guiPopup.Show ("login_message", "CHECK INPUT - " + headExt, content, 'Info', 400, 150, "popup_area");
		return -1;
	}
	return 0;
}

// ********************************************************************************************




// ********************************************************************************************
// Datenaufbereitung fuer AJAX
// ********************************************************************************************

// Daten EWIO -> Browser
function getData()
{
	var modulName;
	var type;

	// evtl. geoeffnete Messageboxen schliessen
	//hideMessageBox();

	// Login-Timeout aktualisieren
	timeoutReset();

	// Allgemein: 
	// modulName = Namen der HTML-Seite, type = Konfiguration 
	modulName = getFilenameFromPath (top.frame_content.location.href);
//	modulName = URL_cutExtension (modulName);

	type = "configuration";

	// alert ("modulName = "+modulName);

	// ----------------------------------------------------------------------------------------
	// Spezialfaelle:
	// bei Login abbrechen 
	if (modulName == "start")
		return;


	// ----------------------------------------------------------------------------------------
	// MBus: abweichende Bearbeitung
	if (modulName.indexOf("mbus_") !== -1)
	{
		top.frame_content.mbus_dataFromEWIO();
		return;
	}

	// ----------------------------------------------------------------------------------------
	// Modbus: abweichende Bearbeitung
	if (modulName.indexOf("modbus_") !== -1)
	{
		top.frame_content.modbus_dataFromEWIO();
		return;
	}

	// Button fuer 1s disabeln
	document.getElementById("button_1").disabled = true;
	setTimeout ('buttonRelease("button_1")', 1000); 	
	document.getElementById("button_2").disabled = true;
	setTimeout ('buttonRelease("button_2")', 1000); 	

	// ----------------------------------------------------------------------------------------
	// param_config: Aufbau der Seite mit Directories von configbase und applicbase
	if (modulName == "param_config")
	{	
		top.frame_content.param_dataFromEWIO();
		return;
	}

	// ----------------------------------------------------------------------------------------
	// param_data: Aufbau der Seite mit Angaben zu Filegroessen
	if (modulName == "param_data")
	{	
		top.frame_content.param_dataFromEWIO();
		return;
	}

	// ----------------------------------------------------------------------------------------
	// Applikationen: modulName = Applikationsname, type = Applikation
	if (modulName == "application")
	{	
		modulName = tree_getPageName()[0];
		type = "application";	
	}

	// IOs: modulName = Drivername, type = Konfiguration
	if (modulName == "io")
	{	
		modulName = tree_getPageName()[0];
		type = "configuration";
	}

	// Values: modulName = Drivername, type = Values
	if (modulName == "io_data")
	{	
		modulName = tree_getPageName()[0];
		type = "values";	
	}

	// wenn es sich um Values handelt, dann Interval-Button einblenden
	if ((type == "values") && (intervalEnable))
		document.form_interval.style.display = "block";
	else	
		document.form_interval.style.display = "none";

	// Format: modulName = format-name, type = Konfiguration
	if (modulName == "server_format")
	{	
		modulName = tree_getPageName()[1];		// value aus "info" im tree
		type = "configuration";
	}

	// ----------------------------------------------------------------------------------------

	// AJAX
	var pw = calculatePassword ();
	var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type="+type+"&"+"module="+modulName;
		
	// Testausgabe
	if (DEBUG_PARAM)
	{
		alert (	"getData():"+
				"\nwebside = "+top.frame_content.location.href+
				"\nmodule = "+modulName+
				"\n\nparameter = "+parameter);
	}

	jsonFromServer ("getParamFromServer.cgi",	// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module
			"getDataResult(actStr)");			// aufzurufende Funktion nach Datenerhalt
}

// ********************************************************************************************

// Funktion wird nach Datenerhalt von getData() aus aufgerufen
function getDataResult(actString)
{
	if (DEBUG_JSON)	
		alert ("EWIO -> Browser: \n"+actString);

	// Load-Image deaktivieren
	document.form_load.style.display = "none";

	// kein JSON, also Fehlermeldung
	if (actString.indexOf("{") == -1)
	{
		if (actString.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			messageBox (ins("main_mb_errMsg"), getMessage (actString));
		}
		return;
	}
	
	// JSON wird als String vom Server empfangen -> zu Object wandeln
	var actObject = JSON2.parse(actString);
	
	// Die Eigenschaften der jeweils im iFrame geladenen content-page setzen
	top.frame_content.setObjectProperties (actObject);
}

// ********************************************************************************************
// Anfordern zusaetzlicher Daten
function getDataExtended (modulName, type, func)
{
	var pw = calculatePassword ();
	var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type="+type+"&"+"module="+modulName;

	// Testausgabe
	if (DEBUG_PARAM)
	{
		alert (	"getDataExtended():"+
				"\nmodule = "+modulName+
				"\nfunction = "+func+
				"\n\nparameter = "+parameter);
	}

	jsonFromServer ("getParamFromServer.cgi",	// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module
			func);								// aufzurufende Funktion nach Datenerhalt
}

// ********************************************************************************************
// Anfordern zusaetzlicher Daten mit gleichem PW (Wiederholung)
function getDataExtendedRepeat (modulName, type, func)
{
	
	var pw = MD5(g_password+g_id);
	var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type="+type+"&"+"module="+modulName;

	// Testausgabe
	if (DEBUG_PARAM)
	{
		alert (	"getDataExtended():"+
				"\nmodule = "+modulName+
				"\nfunction = "+func+
				"\n\nparameter = "+parameter);
	}

	jsonFromServer ("getParamFromServer.cgi",	// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module
			func);								// aufzurufende Funktion nach Datenerhalt
}

// ********************************************************************************************

// Daten Browser -> EWIO
function setData()
{
	var modulName;
	var type;


	// Login-Timeout aktualisieren
	timeoutReset();

	// ----------------------------------------------------------------------------------------
	// Allgemein: 
	// modulName = Namen der HTML-Seite, type = Konfiguration 
	modulName = getFilenameFromPath (top.frame_content.location.href);
	type = "configuration";


	// ----------------------------------------------------------------------------------------
	// MBus: abweichende Bearbeitung
	if (modulName.indexOf("mbus_") !== -1)
	{
		top.frame_content.mbus_dataToEWIO();
		return;
	}	

	// ----------------------------------------------------------------------------------------
	// Modbus: abweichende Bearbeitung
	if (modulName.indexOf("modbus_") !== -1)
	{
		top.frame_content.modbus_dataToEWIO();
		return;
	}	

	// Button fuer 1s disabeln
	document.getElementById("button_2").disabled = true;
	setTimeout ('buttonRelease("button_2")', 1000); 	

	// ----------------------------------------------------------------------------------------
	// Parametertransfer: abweichende Bearbeitung
	if (modulName.indexOf("param_") !== -1)
	{
		top.frame_content.param_dataToEWIO();
		return;
	}	

	// ----------------------------------------------------------------------------------------
	// Objekt laden:
	// Die Eigenschaften der jeweils im iFrame geladenen content-page ermitteln
	var actObject = top.frame_content.getObjectProperties();
	if (typeof actObject != "object")
		return;

	// Object in einen String wandeln (client -> server)
	// Parameter: Objekt, Replacer, Space (Space = Anzahl Leerzeichen fuer Einrueckung)
	var actString = JSON2.stringify (actObject, null, 4);
	if (DEBUG_JSON)	
		alert ("Browser -> EWIO: \n"+actString);

	// ----------------------------------------------------------------------------------------
	// Spezialfaelle:
	// Applikationen: modulName = Applikationsname, type = Applikation
	if (modulName == "application")
	{	
		modulName = tree_getPageName()[0];
		type = "application";	
	}

	// IOs: modulName = Drivername, type = Konfiguration
	if (modulName == "io")
	{	
		modulName = tree_getPageName()[0];
		type = "configuration";
	}

	// Values: modulName = Drivername, type = Values
	if (modulName == "io_data")
	{	
		modulName = tree_getPageName()[0];
		type = "values";	
	}
	
	// Format: modulName = format-name, type = Konfiguration
	if (modulName == "server_format")
	{	
		modulName = tree_getPageName()[1];		// value aus "info" im tree
		type = "configuration";
	}

	// ----------------------------------------------------------------------------------------

	// test
	//jsonToServer ("environment.cgi", actString);

	// AJAX
	var pw = calculatePassword ();
	var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type="+type+"&"+"module="+modulName+"&"+"data=";

	// Testausgabe
	if (DEBUG_PARAM)
	{
		alert (	"setData():"+
				"\nwebside = "+top.frame_content.location.href+
				"\nmodule = "+modulName+
				"\n\nparameter = "+parameter);
	}

	jsonToServer (	"setParamToServer.cgi", // Aufzurufende Datei auf cgi-bin 
			parameter,						// username & password & type & module & data
			actString);						// JSON-Daten


	// Tree aktualisieren ?
	if (modulName == "links")
		top.frame_content.treeRefresh();		

	if (type == "application")
		top.frame_content.treeRefresh();		
}

// ********************************************************************************************
// Anfordern zusaetzlicher Daten
function setDataExtended (modulName, type, jStr)
{
	var pw = calculatePassword ();
	var parameter = "username="+g_username+"&"+"password="+pw+"&"+"type="+type+"&"+"module="+modulName+"&"+"data=";

	// Testausgabe
	if (DEBUG_PARAM)
	{
		alert (	"setDataExtended():"+
				"\nmodule = "+modulName+
				"\ntype = "+type+
				"\n\ndata = "+jStr);
	}

	jsonToServer (	"setParamToServer.cgi", 	// Aufzurufende Datei auf cgi-bin 
			parameter,							// username & password & type & module & data
			jStr);								// JSON-Daten als String

}

// ********************************************************************************************
// ********************************************************************************************

// Aus einem Pfadnamen den Filenamen ohne Extension gewinnen
function getFilenameFromPath (path)
{
	var length = path.length;					// Gesamtlaenge des Pfades
	var index = path.lastIndexOf("/");			// letztes Auftreten von "/"
	if (index != -1)
		var nameWithExt = path.substring(index+1, length);	// z.B. ip.htm
	else	
		var nameWithExt = path;

	index = nameWithExt.indexOf(".");			// ersten Punkt suchen
	var name = nameWithExt.substring(0, index);		// z.B. ip
	return (name);
}

// ********************************************************************************************

// Nicht-JSON-Antwort ermitteln
function getMessage (actString)
{
/*
	// result steht hinter dem Haeder nach Leerzeile
	// Unterscheidung CRLF (WIN) oder LF (Linux)
	if (actString.indexOf("\r\n\r\n") == -1)
		var msg = actString.split("\n\n");		
	else	
		var msg = actString.split("\r\n\r\n");		

	var ret = msg[1];
*/	
	// NEU
	var ret = actString;

	return (ret);
}

// ********************************************************************************************






// ********************************************************************************************
// AJAX
// ********************************************************************************************

// Neue Daten vom Server abrufen
function jsonFromServer (cgiFile, modul, func)
{
	// Load-Image aktivieren
	if (STYLE_LOAD)
		document.form_load.style.display = "block";

	//Status-Anzeige aktualisieren
	var footer_ajax = document.getElementById("footer_ajax");		

	// AJAX: Daten werden vom Server abgerufen ...
	footer_ajax.innerHTML = "AJAX: "+ins("ajax_getData");
  
	// File  via AJAX abrufen
	var myAjax = new Ajax();
	myAjax.method = "GET";
	myAjax.url = "cgi-bin/"+cgiFile;
   	myAjax.params = modul; 
	
	// --------------------------------------------------------------------
	// AJAX starten
	myAjax.doRequest();

	// Verarbeitung der Response
	myAjax.onSuccess = function(txt,xml) 
	{ 
		// Kontrolle: empfangene Daten
		if (DEBUG_AJAX)	alert ("from Server:\n"+txt);
			
		if (txt == "")	
		{
			//Status-Anzeige aktualisieren
			// AJAX: Keine Daten verfuegbar.
			footer_ajax.innerHTML = "AJAX: "+ins("ajax_noData");

			// Load-Image deaktivieren
			document.form_load.style.display = "none";
			return;
		}
		
		//Status-Anzeige aktualisieren
		// AJAX: Daten wurden empfangen.
		footer_ajax.innerHTML = "AJAX: "+ins("ajax_getDataReady");

		// JSON-String aus der Antwort extrahieren und speichern
		var index = txt.indexOf("{");			// erstes "{" suchen
		var actStr = txt.substring(index, txt.length);	// bis zum Ende
		
		// Ausfuehren einer Funktion nach Abschluss der Uebertragung, wenn angegeben
		eval(func);

		// Load-Image deaktivieren
		document.form_load.style.display = "none";
		
		// Login-Error?
		// "Die Verbindung zum EWIO-M ist unterbrochen. Bitte loggen Sie sich erneut ein."
		if (txt.indexOf("LOGIN ERROR") != -1)
			messageBox ("LOGIN ERROR", 	ins("main_error_abort")); 
	}
	
	// Fehler bei bertragung der Dateiinhalts
	myAjax.onError = ajaxErrorHandler;
}

// ********************************************************************************************
// Neuen Daten  an den Server senden und dort speichern
function jsonToServer (cgiFile, modul, data)
{
	// Load-Image aktivieren
	if (STYLE_LOAD)
		document.form_load.style.display = "block";

	//Status-Anzeige aktualisieren
	var footer_ajax = document.getElementById("footer_ajax");	

	// AJAX: Daten werden an den Server gesendet ...
	footer_ajax.innerHTML = "AJAX: "+ins("ajax_sendData");

	
	// file via AJAX aufrufen und dabei neuen Dateninhalt bergeben (POST)
	var myAjax = new Ajax();
	myAjax.method = "POST";
	myAjax.url = "cgi-bin/"+cgiFile;
	myAjax.params = modul+data; 	

	// --------------------------------------------------------------------
	// AJAX starten
	myAjax.doRequest();

	// Response war erfolgreich
	myAjax.onSuccess = function(txt,xml) 
	{
		//Status-Anzeige aktualisieren
		//AJAX: Daten wurden gesendet.
		footer_ajax.innerHTML = "AJAX: "+ins("ajax_sendDataReady");

		// Load-Image deaktivieren
		document.form_load.style.display = "none";
	}
  
	// Fehler bei Kommunikation zw. Client und Server
	myAjax.onError = ajaxErrorHandler;
}

// ********************************************************************************************
// Allgemeine Funktion fr alle Fehlerfaelle
function ajaxErrorHandler(msg)
{
	//Fehler als Meldungsfenster anzeigen
	//alert(msg);
  
	//Fehler in Statusanzeige schreiben 
	var footer_ajax = document.getElementById("footer_ajax");	// Statusanzeige
	footer_ajax.innerHTML = msg;

	// Load-Image deaktivieren
	document.form_load.style.display = "none";
}

// ********************************************************************************************
// Ausgabe: "in Bearbeitung"
function underConstruction ()
{
	// shadow
	top.frame_content.document.body.style.opacity = 0.4;
	top.document.getElementById("frame_content").style.filter = 'alpha(opacity=40)';	// IE hack

	// text
	var newdiv = top.frame_content.document.createElement ("div");
	newdiv.setAttribute("id", "temp");			
	newdiv.setAttribute("class", "pos p0701");
	newdiv.setAttribute("style", "font-size:24px; color:#FF0000; font-weight:bold");
	top.frame_content.document.body.appendChild (newdiv);	

	var element = top.frame_content.document.getElementById ("temp");
	element.innerHTML = "UNDER CONSTRUCTION";	

}

// ********************************************************************************************



// ********************************************************************************************
// ********************************************************************************************


