/**********************************************************************************************
	JS functions for mbus_presence

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		08.2011

***********************************************************************************************/

/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;			// Test
var counterListObj;			// lokales Objekt fuer Counter-Konfig
var mbusObject;				// lokales Objekt fuer MBus-Zaehler

var tele_id;				// Telegramm-ID
var response_counter = 0;	// Empfangszaehler

var cnt;					// Zaehler fuer Abfrage counter-Konfiguration
var cntMax;					// Anzahl Konfigurationen
var abortHallo = 0;			// Hallo abbrechen


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;

	// Messagebox
	top.messageBox_Wait();

	// counterlist anfordern
	top.getDataExtended ("mbus_presence", "counter_list", "top.frame_content.mbus_getCounterList(actStr)");

}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."
	top.messageBox (ins("mbus_presence_button_head"), ins("mbus_presence_button_content")); 		
}


// ********************************************************************************************
// ********************************************************************************************

// Antwort
function mbus_getCounterList(actStr)
{
	// Messagebox schliessen
	top.hideMessageBox();

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// Eintraege aufsteigend sortieren
	jObject.counter = sortEntries (jObject.counter, "Sort");

	// lokal speichern
	counterListObj = jObject;

	// zu den MBus-Ids in counterListObj die jeweilige Konfiguration lesen
	// und in der Tabelle mit dem Ergebnis speichern
	cnt = 0;
	cntMax = counterListObj.counter.length;	
	
	if (DEBUG_DATA)	
		alert (counterListObj.counter[cnt].BusAdr);	
	
	top.getDataExtended (counterListObj.counter[cnt].BusAdr, "counter", "top.frame_content.mbus_getCounter_answer(actStr)");

}

// ********************************************************************************************

// Antwort: Konfiguration eines einzelnen Zaehlers
function mbus_getCounter_answer(actStr)
{
	if (DEBUG_DATA)	
		alert (actStr);

	// wenn keine weiteren counter -> Abbruch
	if (actStr == "{}")
		return;

	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// Tabelleneintrag anfuegen
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

	// jede 2. Reihe andersfarbig ("Zebratabelle")
	if (tbody.rows.length % 2 == 0)	
		tr.setAttribute ("class", "row_color_odd");
	else
		tr.setAttribute ("class", "row_color_even");

	// 1. Spalte Position
	if (jObject.Sort == 0)
		jObject.Sort = "";
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = jObject.Sort;
	td.setAttribute ("class", "td_30");

	// 2. Spalte Name
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = jObject.Name;
	td.setAttribute ("class", "td_150");

	// 3. Spalte Sec-Adr
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = jObject.BusAdr;
	td.setAttribute ("class", "td_150");

	// 4. Spalte Bus
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = jObject.btype.Kinds;
	td.setAttribute ("class", "td_50");

	// 5. Spalte Baudrate
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = jObject.BR;
	td.setAttribute ("class", "td_50");

	// 6. Spalte Primaeradresse
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = "";
	td.setAttribute ("class", "td_60");

	// 7. Spalte Result
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = "";
	td.setAttribute ("class", "td_80");

	// scrolle zur letzten eingefuegten Reihe
	var tElement   = tbody.getElementsByTagName("tbody")[0]; 
	var scroll_area = document.getElementById('scroll_1');
	scroll_area.scrollTop = tElement.clientHeight;

	// Kommunikation MBus starten
	sendHallo (jObject);
}


// ********************************************************************************************
// Kommunikation MBus
// ********************************************************************************************

// Hallo
function sendHallo (counterObj)
{
	var actObject = new Object();

	actObject.bus = counterObj.busdetails.Text_1; 
	tele_id = top.calculateRandom (1, 10000);
	actObject.id = tele_id.toString();	
	actObject.br = counterObj.BR + "";			
	actObject.secAdr = counterObj.BusAdr;
	actObject.command = "HALLO_EXT";
	actObject.param = "1";					

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

	// Empfangstelegramm(e) Slave -> Master lesen, Daten anfordern via mbus_response()
	setTimeout ("top.getDataExtended ('mbus_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 3000);

	mbusObject = actObject;
}

// ********************************************************************************************

// Antworttelegramme  Slave -> Master auf Hallo
function mbus_response(actStr)
{

	// eine Zeitlang Telegramm pollen
	if (mbusObject.BR == 300)		var timeout = 62;	// in sec
	else							var timeout = 32;	// in sec

	response_counter += 2;			// 2 Sekunden vergangen
	if (response_counter < timeout)		
	{
		if (actStr.indexOf('{') == -1)
		{	
			// keine Antwort vom EWIO
			// erneute Abfrage mit gleichem PW
			setTimeout ("top.getDataExtendedRepeat ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 2000);
			return;
		}
	
		if (actStr.indexOf("no answer") != -1)
		{
			// keine Antwort vom MBus
			// erneute Abfrage regulaer
			setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 2000);
			return;
		}
	}
	else
	{
		// timeout erreicht
		response_counter = 0;
		top.hideMessageBox();
		// "Fehler", "Der Zaehler hat nicht geantwortet."
			top.messageBox (ins("mbus_presence_error_head"), ins("mbus_presence_error_content")); 		
		return;
	}

	// alert ("respone-counter = " + response_counter);
	response_counter = 0;

	// JSON-String in Objekt wandeln
	var actObject = JSON2.parse(actStr);

	// Tabelle fuellen
	fillTable (actObject);
}

// ********************************************************************************************









// ********************************************************************************************
// ********************************************************************************************

// Array mit jeweils mehreren Objekten pro Eintrag nach einem Objekt sortieren;
// der Sortierungswert darf nur jeweils einmal vorkommen oder muss 0 sein (diese Eintraege werden nur angehaengt)
function sortEntries (arr, key)
{

	// Um die Eintraege sortiert abzuspeichern, werden die keys in ein Array gepackt und
	// dort sortiert
	var newArr = new Array();
	for (var i=0; i<arr.length; i++)
	{
		// nur Eintraege ungleich 0 sortieren
		if (arr[i][key] != 0)
			newArr[newArr.length] = arr[i][key];
	}

	// key numerisch sortieren (aufsteigend)
	newArr.sort(function(a,b){return a-b;});

	// entsprechend der Sortierung Eintraege zuweisen
	for (var i=0; i<arr.length; i++)
	{
		for (var j=0; j<arr.length; j++)
		{	
			if (newArr[i] == arr[j][key])
			{
				newArr[i] = arr[j];
				break;
			}
		}
	}	

	// Eintraege mit 0 anfuegen
	for (var i=0; i<arr.length; i++)
	{
		if (arr[i][key] == 0)
			newArr[newArr.length] = arr[i];
	}

	// sortiertes Array zurueckliefern
	return newArr;
}

// ********************************************************************************************

// Tabelle mit fehlenden Eintraegen fuellen
function fillTable (jObject)
{
	//	alert (jObject.primAdr+"   "+jObject.ack_response);	

	// Fehlende Spalten in Tabelle fuellen
	setTableElement ("tab_mbus_id", cnt, 5, jObject.primAdr);
	setTableElement ("tab_mbus_id", cnt, 6, jObject.ack_response);

	// Abbruch?
	if (abortHallo)
		cnt = cntMax - 1;

	// Empfangsfile loeschen
	actStr = '{"id":"'+tele_id+'"}';
	top.setDataExtended ("mbus", "mbus_remove", actStr);		// Daten zum EWIO senden

	// naechster Zaehler
	cnt++;
	if (cnt < cntMax)	
		setTimeout ('top.getDataExtended (counterListObj.counter[cnt].BusAdr, "counter", "top.frame_content.mbus_getCounter_answer(actStr)")', 500);
	else
	{	
		// Liste fertig, Button freigeben
		top.document.getElementById("button_1").disabled = false;
		abortHallo = 0;	
	}
}

// ********************************************************************************************

// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// Den Value einer Zelle in der Tabelle setzen
function setTableElementValue (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].value = value;
}

// ********************************************************************************************
// ********************************************************************************************

function breakHallo()
{
	abortHallo = 1;
}

// ********************************************************************************************



