/**********************************************************************************************
	JS functions for mbus_primAddress

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		06.2013

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;

var counterListObj;			// Objekt mit der Auflistung der vorhandenen Zaehler
var counterObj;				// Objekt mit den Parametern der vorhandenen Zaehler
var mbusObject;				// lokales Objekt fuer MBus-Zaehler (TX)


var cnt;					// Zaehler fuer Abfrage counter-Konfiguration
var cntMax;					// Anzahl Konfigurationen
var cntChange;				// Nummer der geaenderten Tabellenzeile
var tele_id;				// Telegramm-ID
var response_counter = 0;	// Empfangszaehler
var abortHallo = 0;			// Hallo abbrechen


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	counterObj = new Array();
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function mbus_dataFromEWIO()
{
	// Button disabeln
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// alle konfigurierten Zähler auflisten
	// counterlist anfordern
	top.getDataExtended ("mbus_primAddress", "counter_list", "top.frame_content.mbus_getCounterList(actStr)");

	// Messagebox
	top.messageBox_Wait();
}

// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function mbus_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."
	top.messageBox (ins("mbus_presence_button_head"), ins("mbus_presence_button_content")); 		
}

// ********************************************************************************************
// ********************************************************************************************
// Antwort
function mbus_getCounterList(actStr)
{
	// Messagebox schliessen
	top.hideMessageBox();

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// Eintraege aufsteigend sortieren
	jObject.counter = sortEntries (jObject.counter, "Sort");

	// lokal speichern
	counterListObj = jObject;

	// zu den MBus-Ids in counterListObj die jeweilige Konfiguration lesen
	// und in der Tabelle mit dem Ergebnis speichern
	cnt = 0;
	cntMax = counterListObj.counter.length;	
	
	if (DEBUG_DATA)	
		alert (counterListObj.counter[cnt].BusAdr);	
	
	top.getDataExtended (counterListObj.counter[cnt].BusAdr, "counter", "top.frame_content.mbus_getCounter_answer(actStr)");

}

// ********************************************************************************************
// Antwort: Konfiguration eines einzelnen Zaehlers
function mbus_getCounter_answer(actStr)
{
	if (DEBUG_DATA)	
		alert (actStr);

	// wenn keine weiteren counter -> Abbruch
	if (actStr == "{}")
		return;

	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// lokal speichern
	counterObj[counterObj.length] = jObject;

	// Tabelleneintrag anfuegen
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

	// jede 2. Reihe andersfarbig ("Zebratabelle")
	if (tbody.rows.length % 2 == 0)	
		tr.setAttribute ("class", "row_color_odd");
	else
		tr.setAttribute ("class", "row_color_even");

	// Hoehe ausreichend fuer Button
	tr.setAttribute ("style", "height:35px");

	// 1. Spalte Name
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = jObject.Name;
	td.setAttribute ("class", "td_150");

	// 2. Spalte Bus-ID
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = jObject.BusAdr;
	td.setAttribute ("class", "td_150");

	// 3. Spalte Primary Address
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = "";
	td.setAttribute ("class", "td_150");

	// 4. Spalte Checkbox
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = "";
	td.setAttribute ("class", "td_100");
	td.setAttribute ("style", "text-align:center;");

	// scrolle zur letzten eingefuegten Reihe
	var tElement   = tbody.getElementsByTagName("tbody")[0]; 
	var scroll_area = document.getElementById('scroll_1');
	scroll_area.scrollTop = tElement.clientHeight;

	// Kommunikation MBus starten
	sendHallo (jObject);
}

// ********************************************************************************************
// ********************************************************************************************
// Primaeradresse konfigurieren
function primAddress_configuration (cnt)
{
	var adr = getTableElement ("tab_mbus_id", cnt, 2);
	cntChange = cnt;

	var headline =  '<B>CHANGE PRIMARY ADDRESS</B>';
	var content =	'<form name="form_prim"> '+ 		

					'<div class="pos x0101 textfield"> '+ins("mbus_counter_primAdr_old")+'</div>'+
					'<div class="pos x0105 textfield"> '+
						'<input type="text" class="textfield" value="'+adr+'" name="prim_old" readonly="readonly" size="3" maxlength="3" style="text-align:center;">'+
					'</div>'+
					
					'<div class="pos x0201 textfield"> '+ins("mbus_counter_primAdr_new")+'</div>'+
					'<div class="pos x0205 textfield"> '+
						'<input type="text" class="textfield" value="" name="prim_new" size="3" maxlength="3" style="text-align:center;">'+
					'</div>'+

					'<div id="button_position">'+
						'<input type="button" class="button_ok" name="ok" value="OK" onClick="fSetParam(1,'+cnt+')">'+
						'<input type="button" class="button_cancel" name="cancel" value="Cancel" onClick="fSetParam(0,'+cnt+')">'+
					'</div>'+

					'</form>';

	guiPopup.Show ("message", headline, content, 'IO', 450, 150, "window");

}

// ********************************************************************************************
// Primaeradresse setzen
function fSetParam (valid, cnt)
{
	if (valid)
	{
		// Parameter sind gueltig
		var primaryNew = document.form_prim.prim_new.value;

		// Eingabe pruefen (1 ... 249)
		if ((isNaN(parseInt(primaryNew))) ||
			((parseInt(primaryNew) < 1) || (parseInt(primaryNew) > 249)))
		{
			top.messageBox ("CHECK INPUT - Primary Address", ins("mbus_counter_primAdr_valid"));			
			return;
		}	

		// Pruefen, ob eingegebene Primäradresse schon vorhanden ist
		var tbody = document.getElementById("tab_mbus_id");
		for (var i=0; i<tbody.rows.length; i++)
		{
			if (getTableElement ("tab_mbus_id", i, 2) == parseInt(primaryNew))
			{
				top.messageBox ("CHECK INPUT - Primary Address", ins("mbus_counter_primAdr_exist"));			
				return;
			}	
		}

		// Primaeradresse setzen
		setPrimaryAddress (cnt, primaryNew);

		// Primaeradresse in primary.json speichern
		setTimeout ("top.getDataExtended ('/config/configbase/primary.json', 'fileload', 'top.frame_content.mbus_modifyPrimaryAdr(actStr)')", 8000);
	}
	
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************
// configbase/primary.json aktualisieren
function mbus_modifyPrimaryAdr(actStr)
{
	// geaenderten Tabelleneintrag ermitteln
	var cnt = cntChange;

	// neue Daten setzen
	var actObject = JSON2.parse(actStr);
	actObject.counter[cnt].secAdr = getTableElement ("tab_mbus_id", cnt, 1);
 	actObject.counter[cnt].primAdr = getTableElement ("tab_mbus_id", cnt, 2);
	
	// neue Daten senden
	actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ('/config/configbase/primary.json', 'fileload', actStr);
}

// ********************************************************************************************








// ********************************************************************************************
// ********************************************************************************************
// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************
// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************
// Array mit jeweils mehreren Objekten pro Eintrag nach einem Objekt sortieren;
// der Sortierungswert darf nur jeweils einmal vorkommen oder muss 0 sein (diese Eintraege werden nur angehaengt)
function sortEntries (arr, key)
{
	// Um die Eintraege sortiert abzuspeichern, werden die keys in ein Array gepackt und
	// dort sortiert
	var newArr = new Array();
	for (var i=0; i<arr.length; i++)
	{
		// nur Eintraege ungleich 0 sortieren
		if (arr[i][key] != 0)
			newArr[newArr.length] = arr[i][key];
	}

	// key numerisch sortieren (aufsteigend)
	newArr.sort(function(a,b){return a-b;});

	// entsprechend der Sortierung Eintraege zuweisen
	for (var i=0; i<arr.length; i++)
	{
		for (var j=0; j<arr.length; j++)
		{	
			if (newArr[i] == arr[j][key])
			{
				newArr[i] = arr[j];
				break;
			}
		}
	}	

	// Eintraege mit 0 anfuegen
	for (var i=0; i<arr.length; i++)
	{
		if (arr[i][key] == 0)
			newArr[newArr.length] = arr[i];
	}

	// sortiertes Array zurueckliefern
	return newArr;
}

// ********************************************************************************************
// Tabelle mit fehlenden Eintraegen fuellen
function fillTable (jObject)
{
	//	alert (jObject.primAdr+"   "+jObject.ack_response);	

	// Fehlende Spalten in Tabelle fuellen
	setTableElement ("tab_mbus_id", cnt, 2, jObject.primAdr);
	if (jObject.primAdr != "NO")
		setTableElement ("tab_mbus_id", cnt, 3, '<input type="button" name="" class="textfield_small" value="CHANGE" onclick="primAddress_configuration('+cnt+')">');

	// Abbruch?
	if (abortHallo)
		cnt = cntMax - 1;

	// Empfangsfile loeschen
	actStr = '{"id":"'+tele_id+'"}';
	top.setDataExtended ("mbus", "mbus_remove", actStr);		// Daten zum EWIO senden

	// naechster Zaehler
	cnt++;
	if (cnt < cntMax)	
	{
		// naechste Abfrage
		setTimeout ('top.getDataExtended (counterListObj.counter[cnt].BusAdr, "counter", "top.frame_content.mbus_getCounter_answer(actStr)")', 500);
	}
	else
	{	
		// Liste fertig, Button freigeben
		top.document.getElementById("button_1").disabled = false;
		abortHallo = 0;	
	}
}

// ********************************************************************************************
// Abbruch der Abfrage
function breakHallo()
{
	abortHallo = 1;
}

// ********************************************************************************************
// ********************************************************************************************




// ********************************************************************************************
// Kommunikation MBus
// ********************************************************************************************

// Hallo
function sendHallo (counterObj)
{
	var actObject = new Object();

	actObject.bus = counterObj.busdetails.Text_1; 
	tele_id = top.calculateRandom (1, 10000);
	actObject.id = tele_id.toString();	
	actObject.br = counterObj.BR + "";			
	actObject.secAdr = counterObj.BusAdr;
	actObject.command = "HALLO_EXT";
	actObject.param = "1";					

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

	// Empfangstelegramm(e) Slave -> Master lesen, Daten anfordern via mbus_response()
	setTimeout ("top.getDataExtended ('mbus_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 3000);

	mbusObject = actObject;
}

// ********************************************************************************************
// Antworttelegramme  Slave -> Master auf Hallo
function mbus_response(actStr)
{

	// eine Zeitlang Telegramm pollen
	if (mbusObject.BR == 300)		var timeout = 62;	// in sec
	else							var timeout = 32;	// in sec

	response_counter += 2;			// 2 Sekunden vergangen
	if (response_counter < timeout)		
	{
		if (actStr.indexOf('{') == -1)
		{	
			// keine Antwort vom EWIO
			// erneute Abfrage mit gleichem PW
			setTimeout ("top.getDataExtendedRepeat ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 2000);
			return;
		}
	
		if (actStr.indexOf("no answer") != -1)
		{
			// keine Antwort vom MBus
			// erneute Abfrage regulaer
			setTimeout ("top.getDataExtended ('mbus_data_'+tele_id, 'mbus', 'top.frame_content.mbus_response(actStr)')", 2000);
			return;
		}
	}
	else
	{
		// timeout erreicht
		response_counter = 0;
		top.hideMessageBox();
		// "Fehler", "Der Zaehler hat nicht geantwortet."
			top.messageBox (ins("mbus_presence_error_head"), ins("mbus_presence_error_content")); 		
		return;
	}

	// alert ("respone-counter = " + response_counter);
	response_counter = 0;

	// JSON-String in Objekt wandeln
	var actObject = JSON2.parse(actStr);

	// Tabelle fuellen
	fillTable (actObject);
}

// ********************************************************************************************
// Primaeradresse setzen
function setPrimaryAddress (cnt, primaryAdr)
{
	// alert (cnt + "   " + primaryAdr);

	var actStr = JSON2.stringify (counterObj[cnt], null, 4);	// Object -> String
	// alert (actStr);

	var actObject = new Object();
	actObject.bus = counterObj[cnt].busdetails.Text_1; 
	actObject.id = "0";
	actObject.br = counterObj[cnt].BR + "";			
	actObject.secAdr = counterObj[cnt].BusAdr;
	actObject.command = "SET_PRIMARY_ADDRESS_MANUAL";
	actObject.param = primaryAdr + "";					

	var actStr = JSON2.stringify (actObject, null, 4);	// Object -> String
	top.setDataExtended ("mbus", "mbus", actStr);		// Daten zum EWIO senden (Telegramm Master->Slave)

	// Anzeige
	top.hideMessageBox();
	top.messageBox_Wait_ext (ins("mbus_config_message_counter_set_prim"));
	setTimeout ("top.hideMessageBox()", 10000);

	// Tabelle aktualisieren
	setTableElement ("tab_mbus_id", cnt, 2, primaryAdr);
}

// ********************************************************************************************

// ********************************************************************************************
// ********************************************************************************************





