/**********************************************************************************************
	JS functions for modbus_add

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		02.2014

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_ADD = 0;


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Namen im Header anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];

	// Daten einlesen
	modbus_dataFromEWIO();
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************

// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{
	// Button 1s disabeln
	buttonDisabel(1, true);
	setTimeout ("buttonDisabel(1, false)", 1000);

	// Ablauf Konfiguration starten: Busliste einlesen, danach DeviceType-Liste
	modbus_getBusList();

	// Adresse und Geraetenamen reset
	document.getElementById("address").value = "";
	document.getElementById("name").value = "";

}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button 1s disabeln
	buttonDisabel(2, true);
	setTimeout ("buttonDisabel(2, false)", 1000);

	// Baumstruktur aktualisieren
	treeUpdate ();
}

// ********************************************************************************************
// ********************************************************************************************






// ********************************************************************************************
// Konfiguration einlesen
// ********************************************************************************************
// verfuegbare Busse auflisten
function modbus_getBusList ()
{
	top.getDataExtended ("mbus_config", "bus_list", "top.frame_content.modbus_getBusList_answer(actStr)");
}

// ********************************************************************************************
// Antwort
function modbus_getBusList_answer(actStr)
{
	if (DEBUG_ADD)	
		alert ("modbus_getBusList_answer: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// evtl. bereits vorhandene Select-Eintraege loeschen
	document.form_modbus.subBus.options.length = 0;
	
	for (var i=0; i<jObject.bus_driver.length; i++)
	{
		// Namen zerlegen
		var nameArr = jObject.bus_driver[i].split('.');

		// filtern Bus = 2 (MBus)
		if (nameArr[2].slice(0,1) != 2)	
			continue;

		// Bus-Namen ermitteln
		var busname="";		
		switch (nameArr[2].slice(2,3))		
		{
			case "0":	busname = "mct_pin_di_";		break;
			case "1":	busname = "mct_spi_dio";		break;
			case "2":	busname = "mct_spi_aio";		break;
			case "3":	busname = "mct_paa_di4_";		break;
			case "4":	busname = "mct_paa_di10_";		break;
			case "5":	busname = "mct_paa_do4/to4_";	break;
			case "6":	busname = "mct_paa_dio42_";		break;
			case "7":	busname = "mct_paa_ai8_";		break;
			case "8":	busname = "mct_paa_ao4_";		break;
		}

		// Slotplatz ermitteln
		if (busname.lastIndexOf("_") == (busname.length-1))		
			busname += nameArr[2].slice(4,5)

		// Instanz ermitteln
		if (nameArr[3] != "0")		
			busname += " " + nameArr[3]

		// Eintrag in Liste
		addSelectOption (document.form_modbus.subBus, jObject.bus_path+"/"+jObject.bus_driver[i]+"/mbus", busname);
	}	

	// Ablauf fortsetzen: Geraetetypliste einlesen
	modbus_getDeviceTypeList();
}

// ********************************************************************************************
// Geraetetypen-Liste einlesen
function modbus_getDeviceTypeList()
{
	top.getDataExtended ("modbus_config", "deviceType_list", "top.frame_content.modbus_getDeviceTypeList_answer(actStr)");
}

// ********************************************************************************************
// Antwort
function modbus_getDeviceTypeList_answer (actStr)
{
	if (DEBUG_ADD)	
		alert ("modbus_getDeviceTypeList_answer: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// evtl. bereits vorhandene Select-Eintraege loeschen
	document.getElementById("type").options.length = 0;

	// Geraetetypen in ein Array einfuegen, Array alphabetisch sortieren
	var typeArr = [];
	for (var i=0; i<jObject.deviceTypes.length; i++)
	{
		var device = jObject.deviceTypes[i].replace(/modbus_/g, "").replace(/.json/g, "");
		typeArr[typeArr.length] = device;
	}
	typeArr.sort();

	// Eintrag in Liste
	for (var i=0; i<typeArr.length; i++)
		addSelectOption (document.getElementById("type"), typeArr[i], typeArr[i]);
}

// ********************************************************************************************
// checken, welcher bus ausgewaehlt wurde; 
// wenn modbus gewaehlt wurde, dann subbus-Selection deaktivieren
function checkBusSelection()
{
	var i = document.form_modbus.modbus.selectedIndex;
	var bus = document.form_modbus.modbus[i].value;
	if (bus == "Modbus")
	{
		document.form_modbus.subBus.style.visibility ="hidden";	
	}
	else
	{
		document.form_modbus.subBus.style.visibility ="visible";	
	}
}

// ********************************************************************************************
// Zaehler in Tree speichern
function treeUpdate ()
{
	// tree aktualisieren
	var newTreeObj = modbus_setTreeData (top.frame_tree.treeDataObj);
	if (newTreeObj == -1)
		return;	

	oStr = JSON2.stringify (newTreeObj, null, 0);	// Object -> String

	// neuen tree zum EWIO senden
	top.frame_tree.shadeTree (1);
	setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", 1000);

	// Navigation refresh
	setTimeout ("top.frame_tree.tree_getData_mbusConfiguration(oStr)", 1000);

	// Button enabeln	
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************

// Antwort
function modbus_setTreeData (treeObj)
{

	// Bus und SubBus ermitteln
	var i = document.form_modbus.modbus.selectedIndex;
	var search_bus = document.form_modbus.modbus[i].value;
	if  (search_bus == "System")
	{
		var i = document.form_modbus.subBus.selectedIndex;
		var search_subBus = document.form_modbus.subBus[i].text;		
	}
	else
		var search_subBus = 0;		

	// Adresse
	var address = document.getElementById("address").value;
	if (address.length == 0)
	{			
		// Bitte Adresse angeben		
		top.messageBox (ins("modbus_add_head"), ins("modbus_add_address"));
		return -1;	
	}			

	// Geraetetyp
	var i = document.getElementById("type").selectedIndex;
	var type = document.getElementById("type").options[i].value;

	// Name
	var name = document.getElementById("name").value;
	if (name.length == 0)
	{			
		// Bitte Geraetenamen angeben		
		top.messageBox (ins("modbus_add_head"), ins("modbus_add_name"));
		return -1;	
	}			

	// wenn der Eintrag schon existiert, dann nicht anlegen
	for (var j=0; j<treeObj.Modbus.configuration.counter.length; j++)	
	{
		if (treeObj.Modbus.configuration.counter[j].info == address)
		{			
			// Adresse bereits vorhanden: " + address			
			top.messageBox (ins("modbus_add_head"), ins("modbus_add_address_is") + address);
			return -1;	
		}			
	}

	var length = treeObj.Modbus.configuration.counter.length;
	treeObj.Modbus.configuration.counter[length] = new Object();
	treeObj.Modbus.configuration.counter[length].icon = "tools_red.gif"; 
	treeObj.Modbus.configuration.counter[length].text = name;
	treeObj.Modbus.configuration.counter[length].info = address;
	treeObj.Modbus.configuration.counter[length].info_1 = search_bus;
	treeObj.Modbus.configuration.counter[length].info_2 = search_subBus;
	treeObj.Modbus.configuration.counter[length].info_3 = type;
	treeObj.Modbus.configuration.counter[length].target = "modbus_config.htm";

	// evtl. vorhandenen "no entry" entfernen, falls Zaehler gefunden wurden
	var length = treeObj.Modbus.configuration.counter.length;
	if (length > 1)
	{	
		if (treeObj.Modbus.configuration.counter[0].text == "no entry")
		{
			// Eintrag "no entry" entfernen					
			treeObj.Modbus.configuration.counter.splice(0, 1);				
		}
	}

	return treeObj;
}

// ********************************************************************************************









// ********************************************************************************************
// Hilfsfunktionen
// ********************************************************************************************
// Check Antwort auf Login-Error
function checkLoginError (actString)
{
	if (actString.indexOf("LOGIN ERROR") != -1)	
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		top.hideMessageBox();		
		top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		return 1;	
	}
	
	return 0;
}

// ********************************************************************************************

// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// Button disabel/enabel
function buttonDisabel(number, state)
{
	if (number == 1)
		top.document.getElementById("button_1").disabled = state;

	if (number == 2)
		top.document.getElementById("button_2").disabled = state;
}

// ********************************************************************************************



// ********************************************************************************************
// INFO
// ********************************************************************************************
// INFO
// counter

function info_bus()
{
	var headline =  '<B>INFO: BUS </B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("mbus_config_info_bus")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 500, 160, "window");
}

// ********************************************************************************************
// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************



