/**********************************************************************************************
	JS functions for modbus_presence

	Copyright (c) 2014 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		02.2014

***********************************************************************************************/

/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;			// Test
var counterListObj;			// lokales Objekt fuer Counter-Konfig

var response_counter = 0;	// Empfangszaehler

var cnt;					// Zaehler fuer Abfrage counter-Konfiguration
var cntMax;					// Anzahl Konfigurationen
var abortHallo = 0;			// Hallo abbrechen

var counterObj;				// lokales Objekt (Zaehler-Konfiguration)

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Button freigeben
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{

	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_mbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Button disabeln
	top.document.getElementById("button_1").disabled = true;

	// Messagebox
	top.messageBox_Wait();

	// counterlist anfordern
	top.getDataExtended ("modbus_presence", "counter_list", "top.frame_content.modbus_getCounterList(actStr)");

}

// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."
	top.messageBox (ins("mbus_presence_button_head"), ins("mbus_presence_button_content")); 		
}


// ********************************************************************************************
// ********************************************************************************************
// Antwort
function modbus_getCounterList(actStr)
{
	// Messagebox schliessen
	top.hideMessageBox();

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);

	// Eintraege aufsteigend sortieren
	jObject.counter = sortEntries (jObject.counter, "Sort");

	// lokal speichern
	counterListObj = jObject;

	// zu den Modbus-Ids in counterListObj die jeweilige Konfiguration lesen
	// und in der Tabelle mit dem Ergebnis speichern
	cnt = 0;
	cntMax = counterListObj.counter.length;	
	
	if (DEBUG_DATA)	
		alert (counterListObj.counter[cnt].BusAdr);	
	
	top.getDataExtended (counterListObj.counter[cnt].BusAdr, "counter", "top.frame_content.modbus_getCounter_answer(actStr)");

}

// ********************************************************************************************
// Antwort: Konfiguration eines einzelnen Zaehlers
function modbus_getCounter_answer(actStr)
{
	if (DEBUG_DATA)	
		alert (actStr);

	// wenn keine weiteren counter -> Abbruch
	if (actStr == "{}")
		return;

	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var jObject = JSON2.parse(actStr);
	counterObj = jObject;				// global


	// Ablauf fortsetzen: Template einlesen
	var template = "modbus_" + counterObj.busdetails.Text_3;
	top.getDataExtended (template, "configuration", "top.frame_content.modbus_getInstance(actStr)");
}

// ********************************************************************************************
// Antwort: JSON-Instanz lesen
function modbus_getInstance(actStr)
{
	if (DEBUG_DATA)	
		alert ("modbus_getInstance: \n"+actStr);

	if (checkLoginError (actStr))
		return;

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	json_instance = JSON2.parse(actStr);



	// Tabelleneintrag anfuegen
	var tr, td;
	var tbody = document.getElementById("tab_mbus_id");

	tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

	// jede 2. Reihe andersfarbig ("Zebratabelle")
	if (tbody.rows.length % 2 == 0)	
		tr.setAttribute ("class", "row_color_odd");
	else
		tr.setAttribute ("class", "row_color_even");

	// 1. Spalte Position
	if (counterObj.Sort == 0)
		counterObj.Sort = "";
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = counterObj.Sort;
	td.setAttribute ("class", "td_30");

	// 2. Spalte Name
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = counterObj.Name;
	td.setAttribute ("class", "td_150");

	// 3. Spalte BusAdr
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = counterObj.BusAdr;
	td.setAttribute ("class", "td_100");

	// 4. Spalte Bus
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = counterObj.btype.Kinds;
	td.setAttribute ("class", "td_100");

	// 5. Spalte Result
	td = tr.insertCell(tr.cells.length);
	td.innerHTML = "";
	td.setAttribute ("class", "td_80");

	// scrolle zur letzten eingefuegten Reihe
	var tElement   = tbody.getElementsByTagName("tbody")[0]; 
	var scroll_area = document.getElementById('scroll_1');
	scroll_area.scrollTop = tElement.clientHeight;

	// Kommunikation Modbus starten
	sendHallo ();
}


// ********************************************************************************************
// Kommunikation Modbus
// ********************************************************************************************
// Hallo
function sendHallo ()
{
	// Modul
	var frame_id = top.calculateRandom (1, 10000);
	module = "modbus_" + frame_id.toString();	

	// Adresse
	var adr = parseInt(counterObj.BusAdr).toString(16);
	adr = adr.toUpperCase();
	adr = addLeadingZeros (adr, 2);

	// Funktion
	var func = json_instance.device.TX[0].function.toString(16);
	func = func.toUpperCase();
	func = addLeadingZeros (func, 2);

	// Startregister (2 Byte)
	var startReg = json_instance.device.TX[0].start.toString(16);
	startReg = startReg.toUpperCase();
	startReg = addLeadingZeros (startReg, 4);
	var startReg_0 = startReg.substring(0,2);
	var startReg_1 = startReg.substring(2);

	// Laenge der Daten (2 Byte)
	var length = json_instance.device.TX[0].length.toString(16);
	length = length.toUpperCase();
	length = addLeadingZeros (length, 4);
	var length_0 = length.substring(0,2);
	var length_1 = length.substring(2);

	// SendeString zusammenstellen
	var sendStr = "00 01 00 00 00 06 " + adr + " " + func + " " + startReg_0 + " " + startReg_1 + " " + length_0 + " " + length_1;  

	// Addressierung Base 1 in TX-frames
	if (json_instance.device.AddressBase == 1)
	{													// Byte 8 und 9 (Register) um 1 verringern
		var txArr = sendStr.split(" ");
		var valueStr = txArr[8] + txArr[9] + "";
		var value = parseInt(valueStr, 16);
		value -= 1;
		valueStr = value.toString(16);
		valueStr = valueStr.toUpperCase();
		valueStr = addLeadingZeros (valueStr, 4);
		txArr[8] = valueStr.substring(0,2);
		txArr[9] = valueStr.substring(2);
		sendStr = "";		
		for (var i=0; i<txArr.length; i++)
			sendStr += txArr[i] + " ";
	}		

	// alert (sendStr);

	// Daten an modbus senden
	top.setDataExtended (module, 'modbus', sendStr);

	// Ergebnis 
	setTimeout ("top.getDataExtended (module, 'modbus', 'top.frame_content.modbus_response(actStr)')", 1000);
}

// ********************************************************************************************
// Antworttelegramme auf Hallo
function modbus_response(actStr)
{
	// alert (actStr);	
	
	// eine Zeitlang Telegramm pollen
	var timeout = 5; 	

	// Fehlermeldungen vom webGate
	if (actStr.indexOf('{') == -1)
	{
		// Message filtern		
		actStr = top.getMessage (actStr);

		// keine Antwort vom modbus_gateway
		var wait_time = timeout-response_counter;
		if (modbus_response_counter < timeout)		
		{	
			top.hideMessageBox();
			top.messageBox_Wait_ext (ins("mbus_config_message_wait_EWIO") + "<B>" + wait_time.toString() + "</B> sec.");
			setTimeout ("top.getDataExtended (module, 'modbus', 'top.frame_content.modbus_response(actStr)')", 1000);
			modbus_response_counter++;			// 1 Sekunde vergangen
			return;			
		}

		// ModBus-Zaehler hat nicht geantwortet 
		top.hideMessageBox();
		top.messageBox (ins("mbus_data_error_head"), actStr);
		return;
	}

	// JSON-String in Objekt wandeln
	try
	{
		actObject = JSON.parse(actStr);
	}
	catch(err)
	{
		var txt = "Error on navigation data occured.\n";
		txt += "Error description: " + err.message + "\n";
		alert (txt);

		//document.write(actStr);	
		return;	
	}

	// alert ("respone-counter = " + response_counter);
	response_counter = 0;

	// JSON-String in Objekt wandeln
	var actObject = JSON2.parse(actStr);

	// Tabelle fuellen
	fillTable (actObject);
}

// ********************************************************************************************









// ********************************************************************************************
// ********************************************************************************************

// Array mit jeweils mehreren Objekten pro Eintrag nach einem Objekt sortieren;
// der Sortierungswert darf nur jeweils einmal vorkommen oder muss 0 sein (diese Eintraege werden nur angehaengt)
function sortEntries (arr, key)
{

	// Um die Eintraege sortiert abzuspeichern, werden die keys in ein Array gepackt und
	// dort sortiert
	var newArr = new Array();
	for (var i=0; i<arr.length; i++)
	{
		// nur Eintraege ungleich 0 sortieren
		if (arr[i][key] != 0)
			newArr[newArr.length] = arr[i][key];
	}

	// key numerisch sortieren (aufsteigend)
	newArr.sort(function(a,b){return a-b;});

	// entsprechend der Sortierung Eintraege zuweisen
	for (var i=0; i<arr.length; i++)
	{
		for (var j=0; j<arr.length; j++)
		{	
			if (newArr[i] == arr[j][key])
			{
				newArr[i] = arr[j];
				break;
			}
		}
	}	

	// Eintraege mit 0 anfuegen
	for (var i=0; i<arr.length; i++)
	{
		if (arr[i][key] == 0)
			newArr[newArr.length] = arr[i];
	}

	// sortiertes Array zurueckliefern
	return newArr;
}

// ********************************************************************************************
// Tabelle mit fehlenden Eintraegen fuellen
function fillTable (jObject)
{
	// Fehlende Spalte in Tabelle fuellen
	if (jObject.state == "MODBUS ANSWER - OK")
		setTableElement ("tab_mbus_id", cnt, 4, "OK");
	else
		setTableElement ("tab_mbus_id", cnt, 4, "ERROR");

	// Abbruch?
	if (abortHallo)
		cnt = cntMax - 1;

	// naechster Zaehler
	cnt++;
	if (cnt < cntMax)	
		top.getDataExtended (counterListObj.counter[cnt].BusAdr, "counter", "top.frame_content.modbus_getCounter_answer(actStr)");
	else
	{	
		// Liste fertig, Button freigeben
		top.document.getElementById("button_1").disabled = false;
		abortHallo = 0;	
	}
}

// ********************************************************************************************
// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// Den Value einer Zelle in der Tabelle setzen
function setTableElementValue (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].value = value;
}

// ********************************************************************************************
// Check Antwort auf Login-Error
function checkLoginError (actString)
{
	if (actString.indexOf("LOGIN ERROR") != -1)	
	{
		// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
		top.hideMessageBox();		
		top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		return 1;	
	}
	
	return 0;
}

// ********************************************************************************************
// fuehrende Nullen auffuellen
function addLeadingZeros (number, length)
{
	var num = '' + number;
	while (num.length < length)
		num = '0' + num;
	return num;
}

// ********************************************************************************************
// ********************************************************************************************

function breakHallo()
{
	abortHallo = 1;
}

// ********************************************************************************************



