/**********************************************************************************************
	JS functions for modbus_remove

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		05.2011
	Version 0.2		11.2015

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_DATA = 0;

var counterObj;			// lokales Objekt zur Speicherung der zu loeschenden Zaehler
var oStr;				// Objekt zur Aktualisierung Tree


// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel anzeigen
	var name = top.tree_getPageName();
	document.getElementById("headLine").innerHTML = name[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************
// Werte setzen
function setData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// Werte lesen
function getData (jObject)
{
	// nicht verwendet
}

// ********************************************************************************************
// ********************************************************************************************
// Button: Daten EWIO -> BROWSER
function modbus_dataFromEWIO()
{
	// Ergebnis-Tabelle loeschen
	var tab = document.getElementById("tab_modbus_id");
	while (tab.rows.length > 0)
		tab.deleteRow(0);

	// Konfigurierte und Nicht-Konfigurierte Zaehler aus der Navigation ermitteln
	modbus_getCounterFromTree ();
}

// ********************************************************************************************
// Button: Daten BROWSER -> EWIO
function modbus_dataToEWIO()
{
	// nur Administrator/Operator darf Zaehler loeschen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	// Button disabel
	top.document.getElementById("button_1").disabled = true;
	top.document.getElementById("button_2").disabled = true;

	// markierte Zaehler aus der configbase loeschen
	modbus_setCounterList ();	
}


// ********************************************************************************************
// ********************************************************************************************
// Konfigurierte und Nicht-Konfigurierte Zaehler aus der Navigation ermitteln
function modbus_getCounterFromTree ()
{
	var counter = top.frame_tree.treeDataObj.Modbus.configuration.counter;

	var list = {};
	list.counter = [];	

	for (var i=0; i<counter.length; i++)
	{
		list.counter[i] = {};
		list.counter[i].Icon = counter[i].icon; 
		list.counter[i].BusAdr = counter[i].info; 
		list.counter[i].Name = counter[i].text; 
	}

	// var objStr = JSON2.stringify (list, null, 4);	// Object -> String
	// alert (objStr);

	// Tabelle
	var tr, td;
	var tbody = document.getElementById("tab_modbus_id");
	var jObject = list;

	for (var i=0; i<1000; i++)
	{			   
		// Abbruch, wenn kein Eintrag mehr
		if (jObject.counter[i] === undefined)
			break;	

		var cnt = i+1;
		tr = tbody.insertRow(tbody.rows.length);		// neue Reihe

		// jede 2. Reihe andersfarbig ("Zebratabelle")
		if (tbody.rows.length % 2 == 0)	
			tr.setAttribute ("class", "row_color_odd");
		else
			tr.setAttribute ("class", "row_color_even");

		// 1. Spalte Name
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.counter[i].Name;
		td.setAttribute ("class", "td_200");
		// Schriftfarbe blau (gespeichert) oder rot (ungespeichert)
		if (jObject.counter[i].Icon == "tools_red.gif")
			td.setAttribute ("style", "Color:#FF0000;");

		// 2. Spalte Bus-ID
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = jObject.counter[i].BusAdr;
		td.setAttribute ("class", "td_200");
		// Schriftfarbe blau (gespeichert) oder rot (ungespeichert)
		if (jObject.counter[i].Icon == "tools_red.gif")
			td.setAttribute ("style", "Color:#FF0000;");

		// 3. Spalte Checkbox
		td = tr.insertCell(tr.cells.length);
		td.innerHTML = '<input name="check_'+i+'" type="checkbox">'; 
		td.setAttribute ("class", "td_100");
		td.setAttribute ("style", "text-align:center;");
	}
}

// ********************************************************************************************
// ********************************************************************************************
// markierte Eintraege aus der counter.json loeschen
function modbus_setCounterList ()
{
	counterObj = new Object();
	counterObj.counter = new Array();
	cntToRemove = 0;

	for (var i=0; i<255; i++)
	{	
		// Eintrag vorhanden?
		var table = document.getElementById ("tab_modbus_id");
		if (table.rows[i] === undefined)
			break;					

		// Checkbox aktiv?	
		var check = eval ('document.getElementsByName("check_'+i+'")');
		if ((check[0] !== undefined) && (check[0].checked == true))
		{
			// alert ("entry "+ i +" checked");

			// keine roten (nichtkonfigurierten) Eintraege listen
			var color = getTableElementColor ("tab_modbus_id", i, 0);
			// alert (color);			
			if (color == "Color:#FF0000;")
				continue;

			// Modbus-ID ermitteln
			var modbus_id = getTableElement ("tab_modbus_id", i, 1);
			counterObj.counter[counterObj.counter.length] = modbus_id;
		
			cntToRemove++;
		}		
	}

	var objStr = JSON2.stringify (counterObj, null, 4);	// Object -> String
	// alert (objStr);

	// counter.json senden
	top.setDataExtended ("modbus_remove", "counter_remove", objStr);	

	// Zählerliste anfordern, um Fortschritt zu ermitteln
	setTimeout ("top.getDataExtended ('modbus_remove', 'counter_list', 'top.frame_content.getChangedCounterList(actStr)')", 1000);

	// Messagebox
	top.messageBox_Wait();
}

// ********************************************************************************************
// Ermitteln, welche Zaehler aktuell bereits geloescht worden sind
function getChangedCounterList(actStr)
{
	//	alert (actStr);

	// Anzahl zu loeschender Eintraege
	var cntToRemove = counterObj.counter.length;

	// Geloeschte Eintraege
	var cntIsRemoved = 0;

	// Liste fuer die Ausgabe erstellen
	var listReady = false;
	var list = "";	
	var oChangedList = JSON2.parse(actStr);

	// indexOf-Vergleich hier nicht moeglich, weil die Adresse beim Modbus eine
	// einfache Ziffer ist, die auch sonst auftreten koennte
	for (var j=0; j<counterObj.counter.length; j++)
	{
		var match = 0;
		for (var i=0; i<oChangedList.counter.length; i++)
		{
			// alert (oChangedList.counter[i].BusAdr + "  " + counterObj.counter[j]);		
		
			if (oChangedList.counter[i].BusAdr == counterObj.counter[j])
			{
				match = 1;
				break;			
			}
		}
		if (!match)
		{
			// Zaehler in Liste nicht mehr enthalten		
			list += counterObj.counter[j] + " \n";
			cntIsRemoved++;			
		}	
	}

	// alert ("to remove / removed = " + cntToRemove + " / " + cntIsRemoved);

	if (cntToRemove == cntIsRemoved)	
		listReady = true;

	top.hideMessageBox();
	messageBox_wait_remove (list);

	if (!listReady)	
		setTimeout ("top.getDataExtended ('modbus_remove', 'counter_list', 'top.frame_content.getChangedCounterList(actStr)')", 2000);
	else
		setTimeout ("modifyNavigation()", 3000);			// fertig, Navigation aktualisieren	
}

// ********************************************************************************************
// tree aktualisieren
function modifyNavigation ()
{

		top.hideMessageBox();

		// ----------------------------------------------------------------------------------------
		// tree aktualisieren
		// tree lesen 
		var module = "/config/www/tree/treeData.js";
		top.getDataExtended (module, "fileload", "top.frame_content.modbus_getTreeData(actStr)");
}

// ********************************************************************************************
// tree aktualisieren - Antwort
function modbus_getTreeData(actStr)
{

	// wenn kein JSON -> Abbruch
	if (actStr.indexOf("{") == -1)
		return;

	// JSON-String in Objekt wandeln
	var treeObj = JSON2.parse(actStr);


	for (var i=0; i<255; i++)
	{	
		// Eintrag vorhanden?
		var table = document.getElementById ("tab_modbus_id");
		if (table.rows[i] === undefined)
			break;					

		// Checkbox aktiv?	
		var check = eval ('document.getElementsByName("check_'+i+'")');
		if ((check[0] !== undefined) && (check[0].checked == true))
		{
			// alert ("entry "+ i +" checked");

			// Modbus-ID ermitteln
			var modbus_id = getTableElement ("tab_modbus_id", i, 1);

			// den Eintrag mit dieser modbus-id aus configuration loeschen
			for (var j=0; j<treeObj.Modbus.configuration.counter.length; j++)
			{
				if (treeObj.Modbus.configuration.counter[j].info == modbus_id)
				{
					// Eintrag in configuration entfernen
					// alert ("entfernt aus configuration: " + modbus_id);
					treeObj.Modbus.configuration.counter.splice(j, 1);					
					break;
				}
			}

			// den Eintrag mit dieser modbus-id aus data loeschen
			for (var j=0; j<treeObj.Modbus.data.counter.length; j++)
			{
				if (treeObj.Modbus.data.counter[j].info == modbus_id)
				{
					// Eintrag in data entfernen					
					// alert ("entfernt aus data: " + modbus_id);
					treeObj.Modbus.data.counter.splice(j, 1);					
					break;
				}
			}

		}		
	}

	// wenn kein Eintrag mehr im Segment vorhanden ist, dann einen dummy-Eintrag erzeugen
	if (treeObj.Modbus.configuration.counter.length == 0)	
	{
		treeObj.Modbus.configuration.counter[0] = new Object();
		treeObj.Modbus.configuration.counter[0].icon = "page.gif"; 
		treeObj.Modbus.configuration.counter[0].text = "no entry";
		treeObj.Modbus.configuration.counter[0].info = "no entry";
		treeObj.Modbus.configuration.counter[0].target = "";
	}
	if (treeObj.Modbus.data.counter.length == 0)	
	{
		treeObj.Modbus.data.counter[0] = new Object();
		treeObj.Modbus.data.counter[0].icon = "page.gif"; 
		treeObj.Modbus.data.counter[0].text = "no entry";
		treeObj.Modbus.data.counter[0].info = "no entry";
		treeObj.Modbus.data.counter[0].target = "";
	}

	// tree aktualisieren
	top.frame_tree.treeDataObj = treeObj;


	// neuen tree zum EWIO senden
	top.frame_tree.shadeTree (1);
	oStr = JSON2.stringify (treeObj, null, 0);	// Object -> String
	setTimeout ("top.setDataExtended ('/config/www/tree/treeData.js', 'fileload', oStr)", 1000);

	// Navigation refresh
	setTimeout ("top.frame_tree.tree_getData_mbusConfiguration(oStr)", 1000);

	// Button enabel
	top.document.getElementById("button_1").disabled = false;
	top.document.getElementById("button_2").disabled = false;
}

// ********************************************************************************************
// ********************************************************************************************
// Eine Zelle in der Tabelle setzen
function setTableElement (table_id, row, cell, value)
{
	var parent = document.getElementById (table_id);
	parent.rows[row].cells[cell].innerHTML = value;
}

// ********************************************************************************************
// Eine Zelle in der Tabelle lesen
function getTableElement (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].innerHTML;
	return (result);
}

// ********************************************************************************************
// Die Textfarbe einer Zelle in der Tabelle lesen
function getTableElementColor (table_id, row, cell)
{
	var table = document.getElementById (table_id);
	var result = table.rows[row].cells[cell].getAttribute ("style", "Color");
	return (result);
}

// ********************************************************************************************
// ********************************************************************************************

// Messagebox "Bitte warten ..." mit Fileliste und Loeschen-Text
function messageBox_wait_remove (text)
{
	var headline = ins("main_mb_wait");
	var content = ins("mbus_remove_mb_waitlist") + '<br><br>' + 	
		'<textarea id="scroll_1" class="textfield long_250" rows="5">'+text+'</textarea>';

	top.guiPopup.Show ("login_message", headline, content, 'Loading', 400, 200, "popup_area");

	// scrolle zur letzten eingefuegten Reihe
	var scroll_area = document.getElementById('scroll_1');
	scroll_area.scrollTop = scroll_area.scrollHeight;
}

// ********************************************************************************************









