/**********************************************************************************************
	JS functions for param_config

	Copyright (c) 2012 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		03.2012

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_PARAM_CONFIG = 0;

var oDirConfig;		// object dir config
var oDirApp;		// object dir application

var path_param = "/config/bin/db/parameter_121030.sqlite";

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = "Transfer " + page[0];
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nicht verwendet
	return (0);
}

// ********************************************************************************************
// ********************************************************************************************

// Werte lesen (EWIO -> Browser)
function param_dataFromEWIO (jObject)
{
	// DIR configbase
	var type = "dir_download";
	var module = "/config/configbase";
	var func = "top.frame_content.getDirConfig(actStr)";
	top.getDataExtended (module, type, func);
}

// ********************************************************************************************

// Button: Daten BROWSER -> EWIO
function param_dataToEWIO()
{
	// nicht verwendet, Message
	// "Hinweis", "Der Button \"BROWSER -> EWIO\" hat hier keine Funktion."	
	top.messageBox (ins("param_config_note_head"), ins("param_config_button_content")); 	
}

// ********************************************************************************************
// ********************************************************************************************
// Antwort DIR configbase
function getDirConfig(actStr)
{
	// kein JSON, also Fehlermeldung
	if (actStr.indexOf("{") == -1)
	{
		top.hideMessageBox();
		if (actStr.indexOf("LOGIN ERROR") != -1)	
		{
			// Wenn login-timeout abgelaufen ist, dann Fehlermeldung und Abbruch
			top.messageBox (ins("main_mb_errMsg"), ins("main_mb_errLogin")); 
		}
		else
		{
			// kein JSON, Ausgabe Fehlermeldung vom EWIO in MessageBox
			top.messageBox (ins("main_mb_errMsg"), top.getMessage (actStr));
		}
		return;
	}

	oDirConfig = JSON2.parse(actStr);

	// DIR applicbase
	var type = "dir_download";
	var module = "/config/applicbase";
	var func = "top.frame_content.getDirApp(actStr)";
	top.getDataExtended (module, type, func);
}

// ********************************************************************************************
// Antwort DIR applicbase
function getDirApp(actStr)
{
	oDirApp = JSON2.parse(actStr);
}

// ********************************************************************************************
// ********************************************************************************************

function setDeviceConfig(state)
{
	if (state == "select")
		document.form_deviceSelector.device.style.visibility ="visible";	
	else
		document.form_deviceSelector.device.style.visibility ="hidden";	
}

// ********************************************************************************************

function setAppConfig(state)
{
	if (state == "select")
		document.form_appSelector.app.style.visibility ="visible";	
	else
		document.form_appSelector.app.style.visibility ="hidden";	
}

// ********************************************************************************************
// ********************************************************************************************

// Hinzufuegen eines Eintrags innerhalb der Select-Box
function addSelectOption (parent, value, text)
{
	// Element erzeugen
	var newdiv = document.createElement("option");
	newdiv.setAttribute("value", value);	

	// Textinhalt		
	var textNode = document.createTextNode (text);
	newdiv.appendChild (textNode);

	// Element in SelectBox einfuegen
	parent.appendChild (newdiv);
}

// ********************************************************************************************
// ********************************************************************************************


// ********************************************************************************************
// Download
// ********************************************************************************************

// Download fuer Textdateien (Files < 128kByte)
function download_txt (type)
{ 
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	var headline =  '<B>DOWNLOAD</B>';
	var content =	'<form name="form_selector">'+
						'<div class="pos x0101">'+					
							'<select name="select" size="1" class="combobox long_125" onclick="changeSelect()"> </select>'+
						'</div> '+
					'</form>'+
					'<div class="pos x0201 textfield"> '+ins("param_config_download")+
					'</div> '+
					'<form name="form_download" method="post" action="cgi-bin/getTxtFileFromServer.cgi" accept-charset="utf-8">'+ 		
						'<div class="pos x0301 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+
							'<input type="text" name="password" class="hidden" value="">'+
							'<input type="text" name="type" class="hidden" value="fileload">'+
							'<input type="text" name="module" class="hidden" value="">'+
						'</div> '+
						'<div class="pos x0305"> '+
							'<input type="submit" class="textfield" value="DOWNLOAD" onclick= "setDownloadKey();message_timeout(1)"> '+
						'</div> '+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="message_close()">'+
						'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'IO', 400, 150, "window");

	// SelectBox fuellen, value setzen
	switch (type)
	{
		case "device":	
			for (var i=0; i<oDirConfig.files.length; i++)
				addSelectOption (document.form_selector.select, oDirConfig.files[i], oDirConfig.files[i]);
			document.form_download.module.value = "/config/configbase/";	
			document.form_download.module.value += document.form_selector.select[0].value;
			break;

		case "app": 
			for (var i=0; i<oDirApp.files.length; i++)
				addSelectOption (document.form_selector.select, oDirApp.files[i], oDirApp.files[i]);
			document.form_download.module.value = "/config/applicbase/";	
			document.form_download.module.value += document.form_selector.select[0].value;
			break;
	}
}

// ********************************************************************************************

// Download fuer Nicht-Text-Dateien (Filegroesse beliebig)   
function download_bin (type)
{ 
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	var headline =  '<B>DOWNLOAD</B>';
	var content =	'<div class="pos x0101 textfield"> '+ins("param_config_download_mbus")+
					'</div> '+
					'<form name="form_download" method="post" action="cgi-bin/getBinFileFromServer.cgi" accept-charset="utf-8"> '+ 		
						'<div class="pos x0301 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+
							'<input type="text" name="password" class="hidden" value="">'+
							'<input type="text" name="type" class="hidden" value="fileload_bin">'+
							'<input type="text" name="module" class="hidden" value="">'+
						'</div> '+
						'<div class="pos x0305"> '+
							'<input type="submit" class="textfield" value="DOWNLOAD" onclick= "setDownloadKey();message_timeout(5);loadingIconDownload();"> '+
						'</div> '+
						'<div class="pos top" id="form_download_icon" style="top:85px; left:360px;"> </div>'+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="message_close()">'+
						'</div>';
					'</form>'+

	guiPopup.Show ("message", headline, content, 'IO', 400, 150, "window");

	// path
	document.form_download.module.value = path_param;;
}

// ********************************************************************************************

// Nach Aenderung select das neu ausgewaehlte File an den vorhandenen Pfad anhaengen
function changeSelect()
{
	// Pfad in seine Bestandteile zerlegen
	var valArr = document.form_download.module.value.split("/");
	document.form_download.module.value = "";

	// neuen Filenamen ermitteln und die letzte Position des Pfades damit ersetzen
	var i = document.form_selector.select.selectedIndex;
	valArr[valArr.length-1] = document.form_selector.select[i].value;
	
	// Pfad mit neuem Filenamen zusammenbauen
	for (var i=0; i<valArr.length; i++)
	{
		document.form_download.module.value += valArr[i];
		if (i < (valArr.length - 1))	
			document.form_download.module.value += '/';
	}	
}

// ********************************************************************************************
// ********************************************************************************************




// ********************************************************************************************
// Upload
// ********************************************************************************************

// Upload fuer Textdateien (Files < 128kByte)
function upload_txt (type)
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	if (type == "device")		var target = ins("param_config_upload_conf");
	if (type == "app")			var target = ins("param_config_upload_app");

	var headline =  '<B>UPLOAD</B>';
	content =		'<div class="pos x0101 textfield"> '+target+
					'</div> '+ 		
					'<form name="form_upload" method="post" action="cgi-bin/setTxtFileToServer.cgi" enctype="multipart/form-data" onsubmit="return afterSubmit">'+
						'<div class="pos x0301 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+		
							'<input type="text" name="password" class="hidden" value="">'+	
							'<input type="text" name="type" class="hidden" value="">'+
							'<input type="text" name="module" class="hidden" value="">'+
							'<input type="file" name='+type+' accept="text/*" maxlength="130000" class="textfield" size="40"><br><br>'+
						'</div>'+
						'<div class="pos x0401"> <input type="submit" class="textfield" value="UPLOAD" onclick="setUploadKey();"> </div>'+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="message_close()">'+
						'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'Tools', 450, 180, "window");

	// type, module
	document.form_upload.type.value = "fileload";
	if (type == "device")		document.form_upload.module.value = "/config/configbase";
	if (type == "app")			document.form_upload.module.value = "/config/applicbase";

}

// ********************************************************************************************

// Upload fuer Nicht-Text-Dateien (Filegroesse beliebig)   
function upload_bin (type)
{ 
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username != "Administrator") && (top.g_username != "Operator"))
	{
		top.messageBox_Login ("Administrator / Operator");
		return;
	}

	var headline =  '<B>UPLOAD</B>';
	content =		'<div class="pos x0101 textfield"> '+ins("param_config_upload_mbus")+
					'</div> '+ 		
					'<form name="form_upload" method="post" action="cgi-bin/setBinFileToServer.cgi" accept-charset="utf-8" enctype="multipart/form-data" onsubmit="return afterSubmit">'+
						'<div class="pos x0301 textfield">'+
							'<input type="text" name="username" class="hidden" value="">'+		
							'<input type="text" name="password" class="hidden" value="">'+	
							'<input type="text" name="type" class="hidden" value="">'+
							'<input type="text" name="module" class="hidden" value="">'+
							'<input type="file" name='+type+' accept="text/*" class="textfield" size="40"><br><br>'+
						'</div>'+
						'<div class="pos x0401"> <input type="submit" class="textfield" value="UPLOAD" onclick="setUploadKey();loadingIconUpload()"> </div>'+
						'<div class="pos top" id="form_upload_icon" style="top:110px; left:140px;"> </div>'+
						'<div id="single_button_position">'+
							'<input type="button" class="single_button_ok" name="cancel" value="Cancel" onClick="message_close()">'+
						'</div>'+
					'</form>';

	guiPopup.Show ("message", headline, content, 'Tools', 450, 180, "window");

	// type, module
	document.form_upload.type.value = "fileload_bin";
	document.form_upload.module.value = "/config/bin/db";
}

// ********************************************************************************************

// Username und Passwort fuer Transaktion setzen
function setUploadKey ()
{
	// Parameter
	// username, password
	document.form_upload.username.value = top.g_username;
	var pw = top.calculatePassword ();
	document.form_upload.password.value = pw;
}

function setDownloadKey ()
{
	// Parameter
	// username, password
	document.form_download.username.value = top.g_username;
	var pw = top.calculatePassword ();
	document.form_download.password.value = pw;
}

// ********************************************************************************************

// nach dem submit ausfuehren
function afterSubmit ()
{
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************

function loadingIconUpload()
{
	document.getElementById("form_upload_icon").style.backgroundImage = "url('style/loading_18.gif')";
	document.getElementById("form_upload_icon").style.backgroundRepeat = "no-repeat";
}

// ********************************************************************************************

function loadingIconDownload()
{
	document.getElementById("form_download_icon").style.backgroundImage = "url('style/loading_18.gif')";
	document.getElementById("form_download_icon").style.backgroundRepeat = "no-repeat";
}

// ********************************************************************************************

// Message schliessen
function message_close ()
{
	// MessageBox schliessen
	guiPopup.CloseMe ("message");
}

// ********************************************************************************************

// Message entfernen nach Klick auf Download
function message_timeout (sec)
{
	setTimeout('message_close()', sec*1000);
}

// ********************************************************************************************
// ********************************************************************************************













