/**********************************************************************************************
	JS functions for server_cyclic_type

	Copyright (c) 2011 MCQ TECH GmbH (rstiawa@metz-connect.com)
	Version 0.1		11.2011

***********************************************************************************************/


/*
	Anmerkungen:

*/

// ********************************************************************************************

var DEBUG_CYCLIC_TYPE = 0;
var oType;				// lokales Objekt

// ********************************************************************************************
// ********************************************************************************************
// Initialisierung beim Start der page: Daten aktualisieren
function initSide()
{
	// Intervall ausblenden
	top.document.form_interval.style.display = "none";

	// Nach dem Aufbau der page sollen die Felder mit den Eigenschaften des Objekts gefuellt werden
	top.document.getElementById("button_1").onclick();

	// Titel setzen
	var headLine = document.getElementById("headLine");		
	var page = top.tree_getPageName(); 	
	headLine.innerHTML = page[0];

	// Button Sprache
	document.form_push.ftp_1_conf.value = ins("cyclic_type_config");
	document.form_push.ftp_2_conf.value = ins("cyclic_type_config");
	document.form_push.email_1_conf.value = ins("cyclic_type_config");
	document.form_push.email_2_conf.value = ins("cyclic_type_config");
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (EWIO-> Browser)
function setObjectProperties (actObject)
{
	oType = actObject;		// merken

	// Darstellung aktualisieren
	document.getElementById("push").checked = actObject.push;	
	document.getElementById("poll").checked = actObject.poll;
	document.form_push.ftp_1.checked = actObject.push_ftp_1;
	document.form_push.ftp_2.checked = actObject.push_ftp_2;
	document.form_push.email_1.checked = actObject.push_email_1;
	document.form_push.email_2.checked = actObject.push_email_2;
	if (actObject.push_sendType == "single")
		document.form_push.radio_0[0].checked = true;
	else
		document.form_push.radio_0[1].checked = true;
	document.form_push.sendDelay.value = actObject.push_sendDelay;
	setSelectValue (actObject.interval);

	// Konfigurationsbereich aktivieren / deaktivieren	
	setActivState ("form_push", document.getElementById("push").checked);

	return (0);
}

// ********************************************************************************************
// Aufruf der Aktualisierungsfunktionen (Browser -> EWIO)
function getObjectProperties()
{
	// nur Administrator/Operator darf Aenderungen vornehmen
	if ((top.g_username == "Administrator") || (top.g_username == "Operator"))
	{
		// MessageBox fuer Wartezeit
		top.messageBox_Wait_ext (ins("cyclic_type_ftp_wait"));
		setTimeout ("top.hideMessageBox()", 10000);

		// Werte ermitteln	
		oType.push 				= document.getElementById("push").checked;
		oType.poll				= document.getElementById("poll").checked;
		oType.push_ftp_1		= document.form_push.ftp_1.checked;
		oType.push_ftp_2		= document.form_push.ftp_2.checked;
		oType.push_email_1		= document.form_push.email_1.checked;
		oType.push_email_2		= document.form_push.email_2.checked;
		for (var i=0; i<document.form_push.radio_0.length; i++)
		{
			if (document.form_push.radio_0[i].checked == true)
				oType.push_sendType = document.form_push.radio_0[i].value;
		}
		oType.push_sendDelay	= document.form_push.sendDelay.value;
	 	oType.interval = getSelectValue ();
		return (oType);
	}
	else
	{
		top.messageBox_Login ("Administrator / Operator");
		return 0;	
	}
}

// ********************************************************************************************
// Konfigurations-Boxen
// ********************************************************************************************
// Konfiguration von FTP
function setConfig_ftp (name)
{
	var ret_func = "closeConfig_ftp('"+name+"')";

	var headline =  '<B> FTP </B>';
	content =		'<form name="form_ftp">'+ 		
					'<div class="pos x0101 textfield">Server</div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="" name="server"> </div>'+
					'<div class="pos x0201 textfield">Username</div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="" name="username"> </div>'+
					'<div class="pos x0301 textfield">' + ins("cyclic_type_ftp_password") + '</div>'+
					'<div class="pos x0303"> <input type="password" class="textfield long_200" value="" name="password"> </div>'+

					'<div class="pos x0401 textfield"> SSL (FTPS) </div>'+
					'<div class="pos x0403"> <input type="checkbox" name="ssl"> </div>'+

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick='+ret_func+'>'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Tools', 400, 200, "window");


	// Einstellungen setzen: ftp
	document.form_ftp.server.value = oType[name].server;
	document.form_ftp.username.value = oType[name].username;
	document.form_ftp.password.value = oType[name].password;
	document.form_ftp.ssl.checked = oType[name].ssl;					// true / false

}

// ********************************************************************************************
// Konfiguration FTP-Parameter schliessen
function closeConfig_ftp (name)
{
	// Eingaben pruefen
	var ret = top.checkInputString (ins("cyclic_type_ftp_server"), document.form_ftp.server.value, "^[A-Za-z0-9_\.\/-]{0,250}$"); 	// 0 - 250 Zeichen, alphanum.+_./-
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("cyclic_type_ftp_username"), document.form_ftp.username.value, "^[A-Za-z0-9_\.\/-]{0,250}$"); 	// 0 - 250 Zeichen, alphanum.+_./-
	if (ret == -1)
		return;
/*
	var ret = top.checkInputString (ins("cyclic_type_ftp_password"), document.form_ftp.password.value, "^[A-Za-z0-9_\.\/\=?\!\%-]{0,50}$"); 	// 0 - 50 Zeichen, alphanum.+_./=?!%-
	if (ret == -1)
		return;
*/
	// mehr Sonderzeichen im Passwort
	// es sind alle Zeichen gueltig, die im JSON erlaubt sind (z.B. kein ")
	var teststr = '{"test":"'+document.form_ftp.password.value+'"}';
	try
	{
		var test = JSON.parse(teststr);
	}
	catch(err)
	{
		top.messageBox ("CHECK INPUT - " + ins("cyclic_type_ftp_password"), ins("main_input_char_fail"));			 
		return;	
	}

	// Einstellungen uebernehmen: ftp
	oType[name].server = document.form_ftp.server.value;
	oType[name].username = document.form_ftp.username.value;
	oType[name].password = document.form_ftp.password.value;
	oType[name].ssl = document.form_ftp.ssl.checked;					// true / false

	// pad schliessen
	guiPopup.CloseMe("message");
}

// ********************************************************************************************
// Konfiguration von email
function setConfig_email (name)
{
	var ret_func = "closeConfig_email('"+name+"')";

	var headline =  '<B>eMail</B>';
	content =		'<form name="form_email">'+ 		
					'<div class="pos x0101 textfield">'+ins("log_email_from")+'</div>'+
					'<div class="pos x0103"> <input type="text" class="textfield long_200" value="from@mailserver.de" name="from"> </div>'+
					'<div class="pos x0201 textfield">'+ins("log_email_to")+'</div>'+
					'<div class="pos x0203"> <input type="text" class="textfield long_200" value="to@somewhere.de" name="to"> </div>'+
					'<div class="pos x0301 textfield"> SSL </div>'+
					'<div class="pos x0303"> <input type="checkbox" name="ssl"> </div>'+
					'<div class="pos x0401 textfield"> MailServer </div>'+
					'<div class="pos x0403"> <input type="text" class="textfield long_200" value="mailserver" name="server"> </div>'+
					'<div class="pos x0501 textfield">'+ins("log_email_user")+'</div>'+
					'<div class="pos x0503"> <input type="text" class="textfield long_200" value="username" name="username"> </div>'+
					'<div class="pos x0601 textfield">'+ins("log_email_pass")+'</div>'+
					'<div class="pos x0603"> <input type="password" class="textfield long_200" value="password" name="password"> </div>'+

					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick='+ret_func+'>'+
					'</div>'+
					'</form>';
	
	guiPopup.Show ("message", headline, content, 'Tools', 400, 250, "window");


	// Einstellungen setzen: email
	document.form_email.from.value = oType[name].from;
	document.form_email.to.value = oType[name].to;
	document.form_email.server.value = oType[name].server;
	document.form_email.username.value = oType[name].username;
	document.form_email.password.value = oType[name].password;
	document.form_email.ssl.checked = oType[name].ssl;					// true / false
}

// ********************************************************************************************
// Konfiguration email-Parameter schliessen
function closeConfig_email (name)
{
	// Eingaben pruefen
	var ret = top.checkInputString (ins("log_email_from"), document.form_email.from.value, "^[A-Za-z0-9@_\.-]{0,50}$"); 	// 6 - 50 Zeichen, alphanum.+_.-@
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("log_email_to"), document.form_email.to.value, "^[A-Za-z0-9@_\.-]{0,50}$"); 	// 6 - 50 Zeichen, alphanum.+_.-@
	if (ret == -1)
		return;
	var ret = top.checkInputString ("MailServer", document.form_email.server.value, "^[A-Za-z0-9\:_\.-]{0,50}$"); 	// 1 - 50 Zeichen, alphanum.+_.-:
	if (ret == -1)
		return;
	var ret = top.checkInputString (ins("log_email_user"), document.form_email.username.value, "^[A-Za-z0-9@_\.-]{0,50}$"); 	// 6 - 50 Zeichen, alphanum.+_.-@
	if (ret == -1)
		return;
/*
	var ret = top.checkInputString (ins("log_email_pass"), document.form_email.password.value, "^[A-Za-z0-9_\.\/\=?\!\%-]{0,50}$"); 	// 0 - 50 Zeichen, alphanum.+_./=?!%-
	if (ret == -1)
		return;
*/
	// mehr Sonderzeichen im Passwort
	// es sind alle Zeichen gueltig, die im JSON erlaubt sind (z.B. kein ")
	var teststr = '{"test":"'+document.form_email.password.value+'"}';
	try
	{
		var test = JSON.parse(teststr);
	}
	catch(err)
	{
		top.messageBox ("CHECK INPUT - " + ins("log_email_pass"), ins("main_input_char_fail"));			 
		return;	
	}

	// Einstellungen uebernehmen: email
	oType[name].from = document.form_email.from.value;
	oType[name].to = document.form_email.to.value;
	oType[name].server = document.form_email.server.value;
	oType[name].username = document.form_email.username.value;
	oType[name].password = document.form_email.password.value;
	oType[name].ssl = document.form_email.ssl.checked;					// true / false

	// pad schliessen
	guiPopup.CloseMe("message");
}

// ********************************************************************************************





// ********************************************************************************************
// Bereiche activ / deactiv
// ********************************************************************************************
// Alle Elemente, welche in einer angegebenen Form gruppiert sind, werden aktiv oder deaktiv dargestellt
function setActivState (form, activ)
{
	// Bereich
	if (activ)
	{
		document[form].style.opacity = 1;
		document[form].style.filter = 'alpha(opacity=100)';
	}
	else
	{
		document[form].style.opacity = 0.4;
		document[form].style.filter = 'alpha(opacity=40)';
	}

	// Elemente
	if (activ)
	{	
		// Checkboxen enabeln
		// Button abhaengig von ihrem vorherigen Zustand setzen
		for (var i=0; i<7; i++)
		{ 
			document[form][i].disabled = false;
			document[form][i].onclick();
		}	
	}
	else
	{
		// alle Elemente disabeln
		for (var i=0; i<document[form].length; i++) 
			document[form][i].disabled = true;
	}
}

// ********************************************************************************************
// Select-Box
// ********************************************************************************************
// Setzen SelectBox auf Value
function setSelectValue (value)
{
	// Beschreiber zu den Intervallen
	var descr = new Array();
	descr[0] = ins("cyclic_type_descr_0");  // "Letzte Viertelstunde, 00:01 - lfd. Stunde, 00:00"
	descr[1] = ins("cyclic_type_descr_1");  // "Letzte Stunde, 00:01 - lfd. Stunde, 00:00"
	descr[2] = ins("cyclic_type_descr_2");  // "Vortag, 00:01 - Heute, 00:00"
	descr[3] = ins("cyclic_type_descr_3"); 	// "Mo letzter Woche, 00:01 - Mo lfd. Woche, 00:00"
	descr[4] = ins("cyclic_type_descr_4");	// "1. Tag des Vormonats, 00:01 - 1. Tag des lfd. Monats, 00:00"
	descr[5] = ins("cyclic_type_descr_5");	// "1. Tag des Vor-Quartals, 00:01 - 1. Tag des lfd. Quartals, 00:00"
	descr[6] = ins("cyclic_type_descr_6");	// "1. Tag des Vor-Halbjahres, 00:01 - 1. Tag des lfd. Halbjahres, 00:00"
	descr[7] = ins("cyclic_type_descr_7");  // "1.1. des Vorjahres, 00:01 - 1.1. des lfd. Jahres, 00:00"


	// Vergleich des value ueber die Anzahl der Eintraege auf Uebereinstimmung
	for (var i=0; i<document.form_select_query.selectInterval.length; i++)
	{
		if (document.form_select_query.selectInterval[i].value == value)
		{
			document.form_select_query.selectInterval.selectedIndex = i;
			document.getElementById("query_time").innerHTML = descr[i];
		}
	}
}

// ********************************************************************************************
// Selectbox setzen
function getSelectValue ()
{
	var i = document.form_select_query.selectInterval.selectedIndex;
	var value = document.form_select_query.selectInterval[i].value;		
	return (value);
}

// ********************************************************************************************
// Selectbox lesen
function checkSelect ()
{
	var val = getSelectValue();
	setSelectValue (val);			// description setzen
}

// ********************************************************************************************
// ********************************************************************************************
// Info

function info_push()
{
	var headline =  '<B>INFO: '+ins("cyclic_type_info_push_head")+' </B>';
	content =		'<div class="pos x0101 textfield"> '+ins("cyclic_type_info_push")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 400, 350, "window");
}

// ********************************************************************************************

function info_poll()
{
	var headline =  '<B>INFO: '+ins("cyclic_type_info_poll_head")+' </B>';
	content =		'<div class="pos x0101 textfield"> '+ins("cyclic_type_info_poll")+
					'</div>' +
					'<div id="button_position">'+
					'<input type="button" class="single_button_ok" name="ok" value="OK" onClick="info_close()">'+
					'</div>';
	
	guiPopup.Show ("info", headline, content, 'Info', 600, 380, "window");
}

// ********************************************************************************************

// INFO schliessen
function info_close()
{

	// pad schliessen
	guiPopup.CloseMe("info");
}

// ********************************************************************************************
// ********************************************************************************************







